"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QPlaceSearchReply(QPlaceReply):
    """
    https://doc.qt.io/qt-5/qplacesearchreply.html

    **Detailed Description**

    See **Discovery/Search**  for an example on how to use a search reply.

    **See also** **QPlaceSearchRequest**  and **QPlaceManager** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchreply.html#QPlaceSearchReply

        **QPlaceSearchReply::QPlaceSearchReply(QObject * parent = nullptr)**

        Constructs a search reply with a given **parent**.
        """
        ...

    def setNextPageRequest(self, next: "QPlaceSearchRequest") -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchreply.html#setNextPageRequest

        **[protected] void QPlaceSearchReply::setNextPageRequest(const
        QPlaceSearchRequest & next )**

        Sets the next page of search results request to **next**.

        **See also** **nextPageRequest** ().
        """
        ...

    def setPreviousPageRequest(self, previous: "QPlaceSearchRequest") -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchreply.html#setPreviousPageRequest

        **[protected] void QPlaceSearchReply::setPreviousPageRequest(const
        QPlaceSearchRequest & previous )**

        Sets the previous page of search results request to **previous**.

        **See also** **previousPageRequest** ().
        """
        ...

    def setRequest(self, request: "QPlaceSearchRequest") -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchreply.html#setRequest

        **[protected] void QPlaceSearchReply::setRequest(const
        QPlaceSearchRequest & request )**

        Sets the search **request** used to generate this reply.

        **See also** **request** ().
        """
        ...

    def setResults(self, results: typing.Iterable[QPlaceSearchResult]) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchreply.html#setResults

        **[protected] void QPlaceSearchReply::setResults(const
        QList<QPlaceSearchResult> & results )**

        Sets the list of search **results**.

        **See also** **results** ().
        """
        ...

    def nextPageRequest(self) -> "QPlaceSearchRequest":
        """
        https://doc.qt.io/qt-5/qplacesearchreply.html#nextPageRequest

        **QPlaceSearchRequest QPlaceSearchReply::nextPageRequest() const**

        Returns a place search request which can be used to request the next
        page of search results. An empty place search request is returned if
        there is no next page of results.

        **See also** **previousPageRequest** () and **setNextPageRequest** ().
        """
        ...

    def previousPageRequest(self) -> "QPlaceSearchRequest":
        """
        https://doc.qt.io/qt-5/qplacesearchreply.html#previousPageRequest

        **QPlaceSearchRequest QPlaceSearchReply::previousPageRequest() const**

        Returns a place search request which can be used to request the previous
        page of search results. An empty place search request is returned if
        there is no previous page of results.

        **See also** **nextPageRequest** () and **setPreviousPageRequest** ().
        """
        ...

    def request(self) -> "QPlaceSearchRequest":
        """
        https://doc.qt.io/qt-5/qplacesearchreply.html#request

        **QPlaceSearchRequest QPlaceSearchReply::request() const**

        Returns the search request that was used to generate this reply.

        **See also** **setRequest** ().
        """
        ...

    def results(self) -> typing.List[QPlaceSearchResult]:
        """
        https://doc.qt.io/qt-5/qplacesearchreply.html#results

        **QList<QPlaceSearchResult> QPlaceSearchReply::results() const**

        Returns a list of search results;

        **See also** **setResults** ().
        """
        ...

    def type(self) -> QPlaceReply.Type:
        """
        https://doc.qt.io/qt-5/qplacesearchreply.html#type

        **[override virtual] QPlaceReply::Type QPlaceSearchReply::type() const**

        Reimplements: **QPlaceReply::type** () const.

        Returns the type of reply.
        """
        ...
