"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
import datetime
from PyQt5.QtLocation import *


class QPlaceReview(QPlaceContent):
    """
    https://doc.qt.io/qt-5/qplacereview.html

    **Detailed Description**

    Each QPlaceReview has a number of properties such as a title, text, date of
    submission and rating; in addition to those properties inherited from
    **QPlaceContent** .

    Note: The Places API only supports reviews as 'retrieve-only' objects.
    Submitting reviews to a provider is not a supported use case.

    **See also** **QPlaceContent**  and **QPlaceEditorial** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacereview.html#QPlaceReview

        **QPlaceReview::QPlaceReview()**

        Constructs a new review object.
        """
        ...

    @typing.overload
    def __init__(self, other: QPlaceContent) -> None:
        """
        https://doc.qt.io/qt-5/qplacereview.html#QPlaceReview-1

        **QPlaceReview::QPlaceReview(const QPlaceContent & other )**

        Constructs a copy of **other** , otherwise constructs a default review
        object.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QPlaceReview") -> None:
        """
        https://doc.qt.io/qt-5/qplacereview.html#QPlaceReview

        **QPlaceReview::QPlaceReview()**

        Constructs a new review object.
        """
        ...

    def setTitle(self, data: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacereview.html#setTitle

        **void QPlaceReview::setTitle(const QString & title )**

        Sets the **title** of the review.

        **See also** **title** ().
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacereview.html#title

        **QString QPlaceReview::title() const**

        Returns the title of the review.

        **See also** **setTitle** ().
        """
        ...

    def setReviewId(self, identifier: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacereview.html#setReviewId

        **void QPlaceReview::setReviewId(const QString & identifier )**

        Sets the **identifier** of the review.

        **See also** **reviewId** ().
        """
        ...

    def reviewId(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacereview.html#reviewId

        **QString QPlaceReview::reviewId() const**

        Returns the review's identifier.

        **See also** **setReviewId** ().
        """
        ...

    def setRating(self, data: float) -> None:
        """
        https://doc.qt.io/qt-5/qplacereview.html#setRating

        **void QPlaceReview::setRating(qreal rating )**

        Sets the review's **rating** of the place.

        **See also** **rating** ().
        """
        ...

    def rating(self) -> float:
        """
        https://doc.qt.io/qt-5/qplacereview.html#rating

        **qreal QPlaceReview::rating() const**

        Returns this review's rating of the place.

        **See also** **setRating** ().
        """
        ...

    def setLanguage(self, data: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacereview.html#setLanguage

        **void QPlaceReview::setLanguage(const QString & language )**

        Sets the **language** of the review. Typically this would be a language
        code in the 2 letter ISO 639-1 format.

        **See also** **language** ().
        """
        ...

    def language(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacereview.html#language

        **QString QPlaceReview::language() const**

        Returns the language of the review. Typically this would be a language
        code in the 2 letter ISO 639-1 format.

        **See also** **setLanguage** ().
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacereview.html#setText

        **void QPlaceReview::setText(const QString & text )**

        Sets **text** of the review.

        **See also** **text** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacereview.html#text

        **QString QPlaceReview::text() const**

        Returns a textual description of the place.

        Depending on the provider the text could be rich (HTML based) or plain
        text.

        **See also** **setText** ().
        """
        ...

    def setDateTime(
        self, dt: typing.Union[QtCore.QDateTime, datetime.datetime]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qplacereview.html#setDateTime

        **void QPlaceReview::setDateTime(const QDateTime & dateTime )**

        Sets the date and time that the review was submitted to **dateTime**.

        **See also** **dateTime** ().
        """
        ...

    def dateTime(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-5/qplacereview.html#dateTime

        **QDateTime QPlaceReview::dateTime() const**

        Returns the date and time that the review was submitted.

        **See also** **setDateTime** ().
        """
        ...
