"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtLocation import *


class QPlaceResult(QPlaceSearchResult):
    """
    https://doc.qt.io/qt-5/qplaceresult.html

    **Detailed Description**

    The **PlaceResult**  holds the distance to the place from the center of the
    search request, an instance of the place and an indication of whether the
    result is sponsored or **organic** .

    The intended usage is that a **QPlaceSearchResult**  can be converted into a
    QPlaceResult like so:

    if (result.type() == **QPlaceSearchResult** ::PlaceResult) {
    **QPlaceResult**  placeResult = result;
            **qDebug** () <<
    placeResult.place().name();
            **qDebug** () <<
    placeResult.place().location().coordinate();
            **qDebug** () <<
    placeResult.distance();
        }

    The implementation is handled in such a way that object slicing is not an
    issue.

    **See also** **QPlaceSearchResult** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplaceresult.html#QPlaceResult

        **QPlaceResult::QPlaceResult()**

        Constructs a new place result object.
        """
        ...

    @typing.overload
    def __init__(self, other: QPlaceSearchResult) -> None:
        """
        https://doc.qt.io/qt-5/qplaceresult.html#QPlaceResult-1

        **QPlaceResult::QPlaceResult(const QPlaceSearchResult & other )**

        Constructs a copy of **other** if possible, otherwise constructs a
        default place result.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QPlaceResult") -> None:
        """
        https://doc.qt.io/qt-5/qplaceresult.html#QPlaceResult

        **QPlaceResult::QPlaceResult()**

        Constructs a new place result object.
        """
        ...

    def setSponsored(self, sponsored: bool) -> None:
        """
        https://doc.qt.io/qt-5/qplaceresult.html#setSponsored

        **void QPlaceResult::setSponsored(bool sponsored )**

        Sets whether the result is a **sponsored** result or not.

        **See also** **isSponsored** ().
        """
        ...

    def isSponsored(self) -> bool:
        """
        https://doc.qt.io/qt-5/qplaceresult.html#isSponsored

        **bool QPlaceResult::isSponsored() const**

        Returns true if the result is a sponsored result.

        **See also** **setSponsored** ().
        """
        ...

    def setPlace(self, place: QPlace) -> None:
        """
        https://doc.qt.io/qt-5/qplaceresult.html#setPlace

        **void QPlaceResult::setPlace(const QPlace & place )**

        Sets the **place** that this result refers to.

        **See also** **place** ().
        """
        ...

    def place(self) -> QPlace:
        """
        https://doc.qt.io/qt-5/qplaceresult.html#place

        **QPlace QPlaceResult::place() const**

        Returns the place of the search result.

        **See also** **setPlace** ().
        """
        ...

    def setDistance(self, distance: float) -> None:
        """
        https://doc.qt.io/qt-5/qplaceresult.html#setDistance

        **void QPlaceResult::setDistance(qreal distance )**

        Set the **distance** of the search result's place from a search center.

        **See also** **distance** ().
        """
        ...

    def distance(self) -> float:
        """
        https://doc.qt.io/qt-5/qplaceresult.html#distance

        **qreal QPlaceResult::distance() const**

        Returns the distance of the place to the search center. This field is
        only relevant provided the search request contained a search area with a
        search center. Otherwise, the distance is NaN indicating an undefined
        distance. The default value for distance is NaN.

        **See also** **setDistance** ().
        """
        ...
