"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QPlaceReply(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qplacereply.html

    **Detailed Description**

    The QPlaceReply and each of its specialized subclasses manage the state and
    results of their corresponding operations. The QPlaceReply itself is used
    for operations that have no results, that is, it only necessary to know if
    the operation succeeded or failed.

    The **finished** () signal can be used to monitor the progress of an
    operation. Once an operation is complete, the **error** () and
    **errorString** () methods provide information on whether the operation
    completed successfully. If successful, the reply will contain the results
    for that operation, that is, each subclass will have appropriate functions
    to retrieve the results of an operation.

    **See also** **QPlaceManager** .
    """

    class Type(int):
        Reply: QPlaceReply = ...
        DetailsReply: QPlaceReply = ...
        SearchReply: QPlaceReply = ...
        SearchSuggestionReply: QPlaceReply = ...
        ContentReply: QPlaceReply = ...
        IdReply: QPlaceReply = ...
        MatchReply: QPlaceReply = ...

    class Error(int):
        NoError: QPlaceReply = ...
        PlaceDoesNotExistError: QPlaceReply = ...
        CategoryDoesNotExistError: QPlaceReply = ...
        CommunicationError: QPlaceReply = ...
        ParseError: QPlaceReply = ...
        PermissionsError: QPlaceReply = ...
        UnsupportedError: QPlaceReply = ...
        BadArgumentError: QPlaceReply = ...
        CancelError: QPlaceReply = ...
        UnknownError: QPlaceReply = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qplacereply.html#QPlaceReply

        **QPlaceReply::QPlaceReply(QObject * parent = nullptr)**

        Constructs a reply object with a given **parent**.
        """
        ...

    def setError(self, error: "QPlaceReply.Error", errorString: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacereply.html#setError

        **[protected] void QPlaceReply::setError(QPlaceReply::Error error ,
        const QString & errorString )**

        Sets the **error** and **errorString** of the reply. This function does
        not cause the **QPlaceReply::error** (**QPlaceReply::Error** , const
        **QString**  &**errorString** ) signal to be emitted.

        **See also** **error** ().
        """
        ...

    def setFinished(self, finished: bool) -> None:
        """
        https://doc.qt.io/qt-5/qplacereply.html#setFinished

        **[protected] void QPlaceReply::setFinished(bool finished )**

        Sets the status of whether the reply is **finished** or not. This
        function does not cause the **finished** () signal to be emitted.

        **See also** **finished** ().
        """
        ...

    def abort(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacereply.html#abort

        **[virtual slot] void QPlaceReply::abort()**

        Cancels the operation immediately.

        **See also** **aborted** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacereply.html#errorString

        **QString QPlaceReply::errorString() const**

        Returns the error string of the reply. The error string is intended to
        be used by developers only and is not fit to be displayed to an end
        user.

        If no error has occurred, the string is empty.
        """
        ...

    def type(self) -> "QPlaceReply.Type":
        """
        https://doc.qt.io/qt-5/qplacereply.html#type

        **[virtual] QPlaceReply::Type QPlaceReply::type() const**

        Returns the type of the reply.
        """
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-5/qplacereply.html#isFinished

        **bool QPlaceReply::isFinished() const**

        Return true if the reply has completed.
        """
        ...

    @property
    def aborted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacereply.html#aborted

        **[signal] void QPlaceReply::aborted()**

        This signal is emitted when the operation has been cancelled.

        This function was introduced in Qt 5.9.

        **See also** **abort** ().
        """
        ...

    @property
    def contentUpdated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacereply.html#contentUpdated

        **[signal] void QPlaceReply::contentUpdated()**

        This signal is emitted when this reply has updated content available.
        Depending on the plugin, this signal may never be emitted or emitted
        multiple times before **QPlaceReply::finished** () is emitted, as some
        backends are able to return the requested content asynchronously and
        incrementally.

        **Note:** Do not delete or **deleteLater**  this reply object in the
        slot connected to this signal. Do it only upon **QPlaceReply::finished**
        .
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacereply.html#error

        **QPlaceReply::Error QPlaceReply::error() const**

        Returns the error code.

        **See also** **setError** ().
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacereply.html#finished

        **[signal] void QPlaceReply::finished()**

        This signal is emitted when this reply has finished processing.

        If **error** () equals **QPlaceReply::NoError**  then the processing
        finished successfully.

        This signal and **QPlaceManager::finished** () will be emitted at the
        same time.

        **Note:** Do not delete this reply object in the slot connected to this
        signal. Use **deleteLater** () instead.

        **See also** **setFinished** ().
        """
        ...
