"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QPlaceManager(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qplacemanager.html

    **Detailed Description**

    The following table gives an overview of the functionality provided by the
    QPlaceManager

    FunctionalityDescription
    Searching for placesUsing set of parameters such
    as a search term and search area, relevant places can be returned to the
    user.
    CategoriesPlaces can be classified as belonging to different
    categories. The manager supports access to these categories.
    Search term
    suggestionsGiven a partially complete search term, a list of potential
    search terms can be given.
    RecommendationsGiven an existing place, a set
    of similar recommended places can be suggested to the user.
    Rich
    ContentRich content such as images, reviews etc can be retrieved in a paged
    fashion.
    Place or Category managementPlaces and categories may be saved
    and removed. It is possible for notifications to be given when this happens.
    LocalizationDifferent locales may be specified to return place data in
    different languages.

    **Obtaining a QPlaceManager Instance**

    Creation of a QPlaceManager is facilitated by the **QGeoServiceProvider** .
    See **Initializing a manager**  for an example on how to create a manager.

    **Asynchronous Interface**

    The QPlaceManager class provides an abstraction of the datastore which
    contains place information. The functions provided by the QPlaceManager and
    primarily asynchronous and follow a request-reply model. Typically a request
    is given to the manager, consisting of a various set of parameters and a
    reply object is created. The reply object has a signal to notify when the
    request is done, and once completed, the reply contains the results of the
    request, along with any errors that occurred, if any.

    An asynchronous request is generally handled as follows:

    //1) Make an appropriate request
        **QPlaceSearchRequest**  searchRequest;
    searchRequest.setSearchTerm("ice cream");
    searchRequest.setSearchArea(**QGeoCircle** (**QGeoCoordinate** (12.34,
    56.78)));

        //2) Use the manager to initiate a request and retrieve a
    reply object
        **QPlaceSearchReply**  * searchReply =
    manager->search(searchRequest);

        //3) Connect the reply object to a
    slot which is invoked upon operation completion
        connect(searchReply,
    SIGNAL(finished()), this, SLOT(processSearchReply()));
            ...
    ...
        //4) Have the slot appropriately process the results of the
    operation
        void processSearchReply() {
            if (searchReply->error()
    == **QPlaceReply** ::NoError) {
                foreach (const
    **QPlaceSearchResult**  &result, searchReply->results()) {
    if (result.type() == **QPlaceSearchResult** ::PlaceResult)
    **qDebug** () << "Title:" << result.title();
                }
            }
    //5) Discard the rely object when done.
            searchReply->deleteLater();
    searchReply = 0;
        }

    See **Common Operations**  for a list of examples demonstrating how the
    QPlaceManger is used.

    **Category Initialization**

    Sometime during startup of an application, the **initializeCategories** ()
    function should be called to setup the categories. Initializing the
    categories enables the usage of the following functions:

    * **QPlaceManager::childCategories** ()
      * **QPlaceManager::category** ()
    * **QPlaceManager::parentCategoryId** ()
      *
    **QPlaceManager::childCategoryIds** ();

    If the categories need to be refreshed or reloaded, the
    **initializeCategories** () function may be called again.
    """

    def matchingPlaces(self, request: "QPlaceMatchRequest") -> "QPlaceMatchReply":
        """
        https://doc.qt.io/qt-5/qplacemanager.html#matchingPlaces

        **QPlaceMatchReply *QPlaceManager::matchingPlaces(const
        QPlaceMatchRequest & request ) const**

        Returns a reply which contains a list of places which correspond/match
        those specified in the **request**. The places specified in the request
        come from a different manager.
        """
        ...

    def compatiblePlace(self, place: QPlace) -> QPlace:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#compatiblePlace

        **QPlace QPlaceManager::compatiblePlace(const QPlace & original )**

        Returns a pruned or modified version of the **original** place which is
        suitable to be saved into this manager.

        Only place details that are supported by this manager is present in the
        modified version. Manager specific data such as the place id, is not
        copied over from the **original**.
        """
        ...

    def setLocales(self, locale: typing.Iterable[QtCore.QLocale]) -> None:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#setLocales

        **void QPlaceManager::setLocales(const QList<QLocale> & locales )**

        Set the list of preferred **locales**.

        **See also** **locales** ().
        """
        ...

    def setLocale(self, locale: QtCore.QLocale) -> None:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#setLocale

        **void QPlaceManager::setLocale(const QLocale & locale )**

        Convenience function which sets the manager's list of preferred locales
        to a single **locale**.
        """
        ...

    def locales(self) -> typing.List[QtCore.QLocale]:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#locales

        **QList<QLocale> QPlaceManager::locales() const**

        Returns a list of preferred locales. The locales are used as a hint to
        the manager for what language place and category details should be
        returned in.

        If the first specified locale cannot be accommodated, the manager falls
        back to the next and so forth. Some manager backends may not support a
        set of locales which are rigidly defined. An arbitrary example is that
        some places in France could have French and English localizations, while
        certain areas in America may only have the English localization
        available. In this example, the set of supported locales is context
        dependent on the search location.

        If the manager cannot accommodate any of the preferred locales, the
        manager falls back to using a supported language that is backend
        specific.

        Support for locales may vary from provider to provider. For those that
        do support it, by default, the global default locale is set as the
        manager's only locale.

        For managers that do not support locales, the locale list is always
        empty.

        **See also** **setLocales** ().
        """
        ...

    def childCategories(self, parentId: str = ...) -> typing.List[QPlaceCategory]:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#childCategories

        **QList<QPlaceCategory> QPlaceManager::childCategories(const QString &
        parentId = QString()) const**

        Returns a list of categories that are children of the category
        corresponding to **parentId**. If **parentId** is empty, all the top
        level categories are returned.
        """
        ...

    def category(self, categoryId: str) -> QPlaceCategory:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#category

        **QPlaceCategory QPlaceManager::category(const QString & categoryId )
        const**

        Returns the category corresponding to the given **categoryId**.
        """
        ...

    def childCategoryIds(self, parentId: str = ...) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#childCategoryIds

        **QStringList QPlaceManager::childCategoryIds(const QString & parentId =
        QString()) const**

        Returns the child category identifiers of the category corresponding to
        **parentId**. If **parentId** is empty then all top level category
        identifiers are returned.
        """
        ...

    def parentCategoryId(self, categoryId: str) -> str:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#parentCategoryId

        **QString QPlaceManager::parentCategoryId(const QString & categoryId )
        const**

        Returns the parent category identifier of the category corresponding to
        **categoryId**.
        """
        ...

    def initializeCategories(self) -> QPlaceReply:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#initializeCategories

        **QPlaceReply *QPlaceManager::initializeCategories()**

        Initializes the categories of the manager.

        See **Using Categories**  for an example of usage.
        """
        ...

    def removeCategory(self, categoryId: str) -> QPlaceIdReply:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#removeCategory

        **QPlaceIdReply *QPlaceManager::removeCategory(const QString &
        categoryId )**

        Removes the category corresponding to **categoryId** from the manager.

        See **Removing a category**  for an example of usage.
        """
        ...

    def saveCategory(
        self, category: QPlaceCategory, parentId: str = ...
    ) -> QPlaceIdReply:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#saveCategory

        **QPlaceIdReply *QPlaceManager::saveCategory(const QPlaceCategory &
        category , const QString & parentId = QString())**

        Saves a **category** that is a child of the category specified by
        **parentId**. An empty **parentId** means **category** is saved as a top
        level category.

        See **Saving a category**  for an example of usage.
        """
        ...

    def removePlace(self, placeId: str) -> QPlaceIdReply:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#removePlace

        **QPlaceIdReply *QPlaceManager::removePlace(const QString & placeId )**

        Removes the place corresponding to **placeId** from the manager.

        See **Removing a place cpp**  for an example of usage.
        """
        ...

    def savePlace(self, place: QPlace) -> QPlaceIdReply:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#savePlace

        **QPlaceIdReply *QPlaceManager::savePlace(const QPlace & place )**

        Saves a specified **place**.

        See **Saving a place cpp**  for an example of usage.
        """
        ...

    def searchSuggestions(
        self, request: "QPlaceSearchRequest"
    ) -> "QPlaceSearchSuggestionReply":
        """
        https://doc.qt.io/qt-5/qplacemanager.html#searchSuggestions

        **QPlaceSearchSuggestionReply *QPlaceManager::searchSuggestions(const
        QPlaceSearchRequest & request ) const**

        Requests a set of search term suggestions according to the parameters
        specified in **request**. The **request** can hold the incomplete search
        term, along with other data such as a search area to narrow down
        relevant results.

        See **Search Suggestions**  for an example of usage.
        """
        ...

    def search(self, query: "QPlaceSearchRequest") -> "QPlaceSearchReply":
        """
        https://doc.qt.io/qt-5/qplacemanager.html#search

        **QPlaceSearchReply *QPlaceManager::search(const QPlaceSearchRequest &
        request ) const**

        Searches for places according to the parameters specified in
        **request**.

        See **Discovery/Search**  for an example of usage.
        """
        ...

    def getPlaceContent(self, request: QPlaceContentRequest) -> QPlaceContentReply:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#getPlaceContent

        **QPlaceContentReply *QPlaceManager::getPlaceContent(const
        QPlaceContentRequest & request ) const**

        Retrieves content for a place according to the parameters specified in
        **request**.

        See **Fetching Rich Content**  for an example of usage.
        """
        ...

    def getPlaceDetails(self, placeId: str) -> QPlaceDetailsReply:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#getPlaceDetails

        **QPlaceDetailsReply *QPlaceManager::getPlaceDetails(const QString &
        placeId ) const**

        Retrieves a details of place corresponding to the given **placeId**.

        See **Fetching Place Details**  for an example of usage.
        """
        ...

    def managerVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#managerVersion

        **int QPlaceManager::managerVersion() const**

        Returns the manager version.
        """
        ...

    def managerName(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#managerName

        **QString QPlaceManager::managerName() const**

        Returns the name of the manager
        """
        ...

    @property
    def categoryAdded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#categoryAdded

        **[signal] void QPlaceManager::categoryAdded(const QPlaceCategory &
        category , const QString & parentId )**

        This signal is emitted if a **category** has been added to the manager's
        datastore. The parent of the **category** is specified by **parentId**.

        This signal is only emitted by managers that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...

    @property
    def categoryRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#categoryRemoved

        **[signal] void QPlaceManager::categoryRemoved(const QString &
        categoryId , const QString & parentId )**

        This signal is emitted when the category corresponding to **categoryId**
        has been removed from the manager's datastore. The parent of the removed
        category is specified by **parentId**.

        This signal is only emitted by managers that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...

    @property
    def categoryUpdated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#categoryUpdated

        **[signal] void QPlaceManager::categoryUpdated(const QPlaceCategory &
        category , const QString & parentId )**

        This signal is emitted if a **category** has been modified in the
        manager's datastore. The parent of the modified category is specified by
        **parentId**.

        This signal is only emitted by managers that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...

    @property
    def dataChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#dataChanged

        **[signal] void QPlaceManager::dataChanged()**

        This signal is emitted by the manager if there are large scale changes
        to its underlying datastore and the manager considers these changes
        radical enough to require clients to reload all data.

        If the signal is emitted, no other signals will be emitted for the
        associated changes.

        This signal is only emitted by managers that support the
        QPlaceManager::NotificationsFeature.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#error

        **[signal] void QPlaceManager::error(QPlaceReply * reply ,
        QPlaceReply::Error error , const QString & errorString = QString())**

        This signal is emitted when an error has been detected in the processing
        of **reply**. The **QPlaceManager::finished** () signal will probably
        follow.

        The error will be described by the error code **error**. If
        **errorString** is not empty it will contain a textual description of
        the error meant for developers and not end users.

        This signal and **QPlaceReply::error** () will be emitted at the same
        time.

        **Note:** Do not delete the **reply** object in the slot connected to
        this signal. Use **deleteLater** () instead.
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#finished

        **[signal] void QPlaceManager::finished(QPlaceReply * reply )**

        This signal is emitted when **reply** has finished processing.

        If reply->**error** () equals **QPlaceReply::NoError**  then the
        processing finished successfully.

        This signal and **QPlaceReply::finished** () will be emitted at the same
        time.

        **Note:** Do not delete the **reply** object in the slot connected to
        this signal. Use **deleteLater** () instead.
        """
        ...

    @property
    def placeAdded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#placeAdded

        **[signal] void QPlaceManager::placeAdded(const QString & placeId )**

        This signal is emitted if a place has been added to the manager engine's
        datastore. The particular added place is specified by **placeId**.

        This signal is only emitted by managers that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...

    @property
    def placeRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#placeRemoved

        **[signal] void QPlaceManager::placeRemoved(const QString & placeId )**

        This signal is emitted if a place has been removed from the manager's
        datastore. The particular place that has been removed is specified by
        **placeId**.

        This signal is only emitted by managers that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...

    @property
    def placeUpdated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanager.html#placeUpdated

        **[signal] void QPlaceManager::placeUpdated(const QString & placeId )**

        This signal is emitted if a place has been modified in the manager's
        datastore. The particular modified place is specified by **placeId**.

        This signal is only emitted by managers that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...
