"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtPositioning
from PyQt5 import QtCore
from PyQt5.QtLocation import *
from PyQt5 import sip


class QPlace(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qplace.html

    **Detailed Description**

    A place is a point of interest, it could be a favorite restaurant, a park or
    someone's home. A QPlace object represents a place by acting as a container
    for various information about that place.

    This information can be divided into 2 broad classifications

    * Details
      * Rich content

    The place details consist of properties of the place, such as the name,
    location, contact information and so on. When a place is returned during a
    search, these details are filled in. Sometimes in order to save bandwidth,
    there are further details about the place that can be retrieved on an
    individual place by place basis, if the user is interested. The
    **QPlace::detailsFetched** () function can be queried to see if all
    available details have been fetched, and if not,
    **QPlaceManager::getPlaceDetails** () can be used to retrieve them.
    Precisely which details are populated during a search and which need to be
    fetched individually may vary from provider to provider. See **plugin
    documentation**  for more details.

    The rich content of a place consists of items such as images, reviews and
    editorials. Potentially there may be many rich content items, so they are
    treated separately from the place details. They can be retrieved in a paged
    fashion via **QPlaceManager::getPlaceContent** (). If necessary, the content
    may be assigned to a place so it can act as a convenient container.

    **Contact Information**

    The contact information of a place is based around a common set of **contact
    types** . To retrieve all the phone numbers of a place, one would do:

    if (place.contactTypes().contains(**QPlaceContactDetail** ::Phone)) {
    foreach (const **QPlaceContactDetail**  &number,
    place.contactDetails(**QPlaceContactDetail** ::Phone))
    **qDebug** () << number.label() << ":" << number.value();
        }

    The contact types are string values by design to allow for providers to
    introduce new contact types.

    For convenience there are a set of functions which return the value of the
    first contact detail of each type.

    * **QPlace::primaryPhone** ()
      * **QPlace::primaryEmail** ()
      *
    **QPlace::primaryWebsite** ()
      * **QPlace::primaryFax** ()

    **Extended Attributes**

    Places may have additional attributes which are not covered in the formal
    API. Similar to contacts attributes are based around a common set of
    **attribute types** . To retrieve an extended attribute one would do:

    if (place.extendedAttributeTypes().contains(**QPlaceAttribute**
    ::OpeningHours))
            **qDebug** () <<
    place.extendedAttribute(**QPlaceAttribute** ::OpeningHours).text();

    The attribute types are string values by design to allow providers to
    introduce new attribute types.

    **Content**

    The QPlace object is only meant to be a convenient container to hold rich
    content such as images, reviews and so on. Retrieval of content should
    happen via **QPlaceManager::getPlaceContent** ().

    The content is stored as a **QPlaceContent::Collection**  which contains
    both the index of the content, as well as the content itself. This enables
    developers to check whether a particular item has already been retrieved and
    if not, then request that content.

    **Attribution**

    Places have a field for a rich text attribution string. Some providers may
    require that the attribution be shown when a place is displayed to a user.

    **Categories**

    Different categories may be assigned to a place to indicate that the place
    is associated with those categories. When saving a place, the only
    meaningful data is the category id, the rest of the category data is
    effectively ignored. The category must already exist before saving the place
    (it is not possible to create a new category, assign it to the place, save
    the place and expect the category to be created).

    **Saving Caveats**

    The Places API is currently designed for only saving **core** details.
    Saving rich content like images and reviews or details like supplier and
    rating is not a supported use case. Typically a manager will generally
    ignore these fields upon save and may produce a warning message if they are
    populated.

    The Places API only supports saving of the following **core details** :

    * name
      * place id
      * location
      * contact details
      * icon
      * categories
    (tag-like names to describe a place)
      * visibility scope

    It is possible that providers may only support a subset of these. See the
    **plugin documentation**  for more details.

    Saving of properties such as the rating, extended attributes, images,
    reviews, editorials and supplier is explicitly not supported by the Places
    API.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#QPlace

        **QPlace::QPlace()**

        Constructs an empty place object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPlace") -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#QPlace-1

        **QPlace::QPlace(const QPlace & other )**

        Constructs a copy of **other**.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qplace.html#isEmpty

        **bool QPlace::isEmpty() const**

        Returns a boolean indicating whether the all the fields of the place are
        empty or not.
        """
        ...

    def setVisibility(self, visibility: QLocation.Visibility) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setVisibility

        **void QPlace::setVisibility(QLocation::Visibility visibility )**

        Sets the visibility of the place to **visibility**.

        **See also** **visibility** ().
        """
        ...

    def visibility(self) -> QLocation.Visibility:
        """
        https://doc.qt.io/qt-5/qplace.html#visibility

        **QLocation::Visibility QPlace::visibility() const**

        Returns the visibility of the place.

        The default visibility of a new place is set to QtLocatin::Unspecified
        visibility. If a place is saved with unspecified visibility the backend
        chooses an appropriate default visibility to use when saving.

        **See also** **setVisibility** ().
        """
        ...

    def removeContactDetails(self, contactType: str) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#removeContactDetails

        **void QPlace::removeContactDetails(const QString & contactType )**

        Removes all the contact details of a given **contactType**.

        The **contactType** is no longer returned when **QPlace::contactTypes**
        () is called.
        """
        ...

    def appendContactDetail(
        self, contactType: str, detail: "QPlaceContactDetail"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#appendContactDetail

        **void QPlace::appendContactDetail(const QString & contactType , const
        QPlaceContactDetail & detail )**

        Appends a contact **detail** of a specified **contactType**.

        See **QPlaceContactDetail**  for a list of common **contact types** .
        """
        ...

    def setContactDetails(
        self, contactType: str, details: typing.Iterable["QPlaceContactDetail"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setContactDetails

        **void QPlace::setContactDetails(const QString & contactType ,
        QList<QPlaceContactDetail> details )**

        Sets the contact **details** of a specified **contactType**.

        If **details** is empty, then the **contactType** is removed from the
        place such that it is no longer returned by **QPlace::contactTypes** ().

        See **QPlaceContactDetail**  for a list of common **contact types** .

        **See also** **contactDetails** ().
        """
        ...

    def contactDetails(self, contactType: str) -> typing.List["QPlaceContactDetail"]:
        """
        https://doc.qt.io/qt-5/qplace.html#contactDetails

        **QList<QPlaceContactDetail> QPlace::contactDetails(const QString &
        contactType ) const**

        Returns a list of contact details of the specified **contactType**.

        See **QPlaceContactDetail**  for a list of common **contact types** .

        **See also** **setContactDetails** ().
        """
        ...

    def contactTypes(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qplace.html#contactTypes

        **QStringList QPlace::contactTypes() const**

        Returns the type of contact details this place has.

        See **QPlaceContactDetail**  for a list of common **contact types** .
        """
        ...

    def removeExtendedAttribute(self, attributeType: str) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#removeExtendedAttribute

        **void QPlace::removeExtendedAttribute(const QString & attributeType )**

        Remove the attribute of **attributeType** from the place.

        The attribute will no longer be listed by
        **QPlace::extendedAttributeTypes** ()
        """
        ...

    def setExtendedAttribute(
        self, attributeType: str, attribute: "QPlaceAttribute"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setExtendedAttribute

        **void QPlace::setExtendedAttribute(const QString & attributeType ,
        const QPlaceAttribute & attribute )**

        Assigns an **attribute** of the given **attributeType** to a place. If
        the given **attributeType** already exists in the place, then it is
        overwritten.

        If **attribute** is a default constructed **QPlaceAttribute** , then the
        **attributeType** is removed from the place which means it will not be
        listed by **QPlace::extendedAttributeTypes** ().

        **See also** **extendedAttribute** ().
        """
        ...

    def extendedAttribute(self, attributeType: str) -> "QPlaceAttribute":
        """
        https://doc.qt.io/qt-5/qplace.html#extendedAttribute

        **QPlaceAttribute QPlace::extendedAttribute(const QString &
        attributeType ) const**

        Returns the exteded attribute corresponding to the specified
        **attributeType**. If the place does not have that particular attribute
        type, a default constructed QPlaceExtendedAttribute is returned.

        **See also** **setExtendedAttribute** ().
        """
        ...

    def extendedAttributeTypes(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qplace.html#extendedAttributeTypes

        **QStringList QPlace::extendedAttributeTypes() const**

        Returns the types of extended attributes that this place has.
        """
        ...

    def setDetailsFetched(self, fetched: bool) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setDetailsFetched

        **void QPlace::setDetailsFetched(bool fetched )**

        Sets whether the details of this place have been **fetched** or not.

        **See also** **detailsFetched** ().
        """
        ...

    def detailsFetched(self) -> bool:
        """
        https://doc.qt.io/qt-5/qplace.html#detailsFetched

        **bool QPlace::detailsFetched() const**

        Returns true if the details of this place have been fetched, otherwise
        returns false.

        **See also** **setDetailsFetched** ().
        """
        ...

    def primaryWebsite(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qplace.html#primaryWebsite

        **QUrl QPlace::primaryWebsite() const**

        Returns the primary website of the place. This convenience function
        accesses the first contact detail of the **website type** . If no
        websites exist, then an empty string is returned.
        """
        ...

    def primaryEmail(self) -> str:
        """
        https://doc.qt.io/qt-5/qplace.html#primaryEmail

        **QString QPlace::primaryEmail() const**

        Returns the primary email address for this place. This convenience
        function accesses the first contact detail of the **email type** . If no
        email addresses exist, then an empty string is returned.
        """
        ...

    def primaryFax(self) -> str:
        """
        https://doc.qt.io/qt-5/qplace.html#primaryFax

        **QString QPlace::primaryFax() const**

        Returns the primary fax number for this place. This convenience function
        accesses the first contact detail of the **fax type** . If no fax
        details exist, then an empty string is returned.
        """
        ...

    def primaryPhone(self) -> str:
        """
        https://doc.qt.io/qt-5/qplace.html#primaryPhone

        **QString QPlace::primaryPhone() const**

        Returns the primary phone number for this place. This accesses the first
        contact detail of the **phone number type** . If no phone details exist,
        then an empty string is returned.
        """
        ...

    def setPlaceId(self, identifier: str) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setPlaceId

        **void QPlace::setPlaceId(const QString & identifier )**

        Sets the **identifier** of the place.

        **See also** **placeId** ().
        """
        ...

    def placeId(self) -> str:
        """
        https://doc.qt.io/qt-5/qplace.html#placeId

        **QString QPlace::placeId() const**

        Returns the identifier of the place. The place identifier is only
        meaningful to the **QPlaceManager**  that generated it and is not
        transferable between managers. The place identifier is not guaranteed to
        be universally unique, but unique for the manager that generated it.

        **See also** **setPlaceId** ().
        """
        ...

    def setName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setName

        **void QPlace::setName(const QString & name )**

        Sets the **name** of the place.

        **See also** **name** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qplace.html#name

        **QString QPlace::name() const**

        Returns the name of the place.

        **See also** **setName** ().
        """
        ...

    def setTotalContentCount(self, type: "QPlaceContent.Type", total: int) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setTotalContentCount

        **void QPlace::setTotalContentCount(QPlaceContent::Type type , int
        totalCount )**

        Sets the **totalCount** of content objects of the given **type**.

        **See also** **totalContentCount** ().
        """
        ...

    def totalContentCount(self, type: "QPlaceContent.Type") -> int:
        """
        https://doc.qt.io/qt-5/qplace.html#totalContentCount

        **int QPlace::totalContentCount(QPlaceContent::Type type ) const**

        Returns the total count of content objects of the given **type**. This
        total count indicates how many the manager/provider should have
        available. (As opposed to how many objects this place instance is
        currently assigned).

        A negative count indicates that the total number of items is unknown. By
        default the total content count is set to 0.

        **See also** **setTotalContentCount** ().
        """
        ...

    def insertContent(
        self, type: "QPlaceContent.Type", content: typing.Dict[int, "QPlaceContent"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#insertContent

        **void QPlace::insertContent(QPlaceContent::Type type , const
        QPlaceContent::Collection & content )**

        Adds a collection of **content** of the given **type** to the place. Any
        index in **content** that already exists is overwritten.
        """
        ...

    def setContent(
        self, type: "QPlaceContent.Type", content: typing.Dict[int, "QPlaceContent"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setContent

        **void QPlace::setContent(QPlaceContent::Type type , const
        QPlaceContent::Collection & content )**

        Sets a collection of **content** for the given **type**.

        **See also** **content** ().
        """
        ...

    def content(self, type: "QPlaceContent.Type") -> typing.Dict[int, "QPlaceContent"]:
        """
        https://doc.qt.io/qt-5/qplace.html#content

        **QPlaceContent::Collection QPlace::content(QPlaceContent::Type type )
        const**

        Returns a collection of content associated with a place. This collection
        is a map with the key being the index of the content object and value
        being the content object itself.

        The **type** specifies which kind of content is to be retrieved.

        **See also** **setContent** ().
        """
        ...

    def setIcon(self, icon: "QPlaceIcon") -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setIcon

        **void QPlace::setIcon(const QPlaceIcon & icon )**

        Sets the **icon** of the place.

        **See also** **icon** ().
        """
        ...

    def icon(self) -> "QPlaceIcon":
        """
        https://doc.qt.io/qt-5/qplace.html#icon

        **QPlaceIcon QPlace::icon() const**

        Returns the icon of the place.

        **See also** **setIcon** ().
        """
        ...

    def setAttribution(self, attribution: str) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setAttribution

        **void QPlace::setAttribution(const QString & attribution )**

        Sets the **attribution** string of the place.

        **See also** **attribution** ().
        """
        ...

    def attribution(self) -> str:
        """
        https://doc.qt.io/qt-5/qplace.html#attribution

        **QString QPlace::attribution() const**

        Returns a rich text attribution string of the place. Note, some
        providers may have a requirement where the attribution must be shown
        whenever a place is displayed to an end user.

        **See also** **setAttribution** ().
        """
        ...

    def setSupplier(self, supplier: "QPlaceSupplier") -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setSupplier

        **void QPlace::setSupplier(const QPlaceSupplier & supplier )**

        Sets the supplier of this place to **supplier**.

        **See also** **supplier** ().
        """
        ...

    def supplier(self) -> "QPlaceSupplier":
        """
        https://doc.qt.io/qt-5/qplace.html#supplier

        **QPlaceSupplier QPlace::supplier() const**

        Returns the supplier of this place.

        **See also** **setSupplier** ().
        """
        ...

    def setRatings(self, ratings: "QPlaceRatings") -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setRatings

        **void QPlace::setRatings(const QPlaceRatings & rating )**

        Sets the aggregated **rating** of the place.

        **See also** **ratings** ().
        """
        ...

    def ratings(self) -> "QPlaceRatings":
        """
        https://doc.qt.io/qt-5/qplace.html#ratings

        **QPlaceRatings QPlace::ratings() const**

        Returns an aggregated rating of the place.

        **See also** **setRatings** ().
        """
        ...

    def setLocation(self, location: QtPositioning.QGeoLocation) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setLocation

        **void QPlace::setLocation(const QGeoLocation & location )**

        Sets the **location** of the place.

        **See also** **location** ().
        """
        ...

    def location(self) -> QtPositioning.QGeoLocation:
        """
        https://doc.qt.io/qt-5/qplace.html#location

        **QGeoLocation QPlace::location() const**

        Returns the location of the place.

        **See also** **setLocation** ().
        """
        ...

    def setCategories(self, categories: typing.Iterable["QPlaceCategory"]) -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setCategories

        **void QPlace::setCategories(const QList<QPlaceCategory> & categories
        )**

        Sets the **categories** that this place belongs to.

        **See also** **categories** ().
        """
        ...

    def setCategory(self, category: "QPlaceCategory") -> None:
        """
        https://doc.qt.io/qt-5/qplace.html#setCategory

        **void QPlace::setCategory(const QPlaceCategory & category )**

        Sets a single **category** that this place belongs to.
        """
        ...

    def categories(self) -> typing.List["QPlaceCategory"]:
        """
        https://doc.qt.io/qt-5/qplace.html#categories

        **QList<QPlaceCategory> QPlace::categories() const**

        Returns categories that this place belongs to.

        **See also** **setCategories** ().
        """
        ...
