"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import PyQt5.sip
from PyQt5 import QtPositioning
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QGeoRoutingManager(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qgeoroutingmanager.html

    **Detailed Description**

    The **calculateRoute** () and **updateRoute** () methods function
    **QGeoRouteReply**  objects, which manage these operations and report on the
    result of the operations and any errors which may have occurred.

    The **calculateRoute** () function is used to find a route (or routes) that
    follows a set of waypoints and matches various other criteria. The
    **QGeoRouteRequest**  class is used to specify this information.

    If supportsRouteUpdates() returns true then the QGeoRoutingManager supports
    updating route information based on position updates. This will cause the
    travel time and distance estimates to be updated, and any QGeoRouteSegments
    already traversed to be removed from the route.

    The updates can be triggered with the **updateRoute** () function, which
    makes use of the **QGeoPositionInfo**  instances emitted as position updates
    by **QGeoPositionInfoSource** .

    Instances of QGeoRoutingManager can be accessed with
    **QGeoServiceProvider::routingManager** ().

    A small example of the usage of QGeoRoutingManager and QGeoRouteRequests
    follows:

    class MyRouteHandler : public **QObject**
        {
            Q_OBJECT
    public:
            MyRouteHandler(QGeoRoutingManager *routingManager,
    const **QGeoCoordinate**  &origin,
                           const
    **QGeoCoordinate**  &destination) {

                **QGeoRouteRequest**
    request(origin, destination);

                // The request defaults to
    the fastest route by car, which is
                // equivalent to:
    // request.setTravelMode(QGeoRouteRequest::CarTravel);
                //
    request.setRouteOptimization(QGeoRouteRequest::FastestRoute);
    request.setAvoidFeatureTypes(**QGeoRouteRequest** ::AvoidTolls);
    request.setAvoidFeatureTypes(**QGeoRouteRequest** ::AvoidMotorPoolLanes);
    **QGeoRouteRequest** ::AvoidFeaturesTypes avoidableFeatures =
    routingManager->supportedAvoidFeatureTypes();

                if
    (!(avoidableFeatures & request.avoidFeatureTypes())) {
                    //
    ... inform the user that the routing manager does not
                    //
    provide support for avoiding tolls and/or motor pool lanes ...
    return;
                }

                **QGeoRouteReply**  *reply =
    routingManager->calculateRoute(request);

                if
    (reply->isFinished()) {
                    if (reply->error() ==
    **QGeoRouteReply** ::NoError) {
                        routeCalculated(reply);
    } else {
                        routeError(reply, reply->error(),
    reply->errorString());
                    }
                    return;
    }

                connect(routingManager,
    SIGNAL(finished(**QGeoRouteReply** *)),
                        this,
    SLOT(routeCalculated(**QGeoRouteReply** *)));
    connect(routingManager,
                        SIGNAL(error(**QGeoRouteReply**
    *,**QGeoRouteReply** ::Error,**QString** )),
                        this,
    SLOT(routeError(**QGeoRouteReply** *,**QGeoRouteReply** ::Error,**QString**
    )));
            }

        private slots:
            void
    routeCalculated(**QGeoRouteReply**  *reply)
            {
                // A route
    request can ask for several alternative routes ...
                if
    (reply->routes().size() != 0) {

                    // ... but by default
    it will only get a single route
                    **QGeoRoute**  route =
    reply->routes().at(0);

                    //... now we have to make use of
    the route ...
                }

                reply->deleteLater();
            }
    void routeError(**QGeoRouteReply**  *reply, **QGeoRouteReply** :Error error,
    const **QString**  &errorString)
            {
                // ... inform the
    user that an error has occurred ...
                reply->deleteLater();
    }
        };
    """

    def measurementSystem(self) -> QtCore.QLocale.MeasurementSystem:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#measurementSystem

        **QLocale::MeasurementSystem QGeoRoutingManager::measurementSystem()
        const**

        Returns the measurement system used by this manager.

        If **setMeasurementSystem** () has been called then the value returned
        by this function may be different to that returned by **locale**
        ().**measurementSystem()** . In which case the value returned by this
        function is what will be used by the manager.

        **See also** **setMeasurementSystem** () and **setLocale** ().
        """
        ...

    def setMeasurementSystem(self, system: QtCore.QLocale.MeasurementSystem) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#setMeasurementSystem

        **void
        QGeoRoutingManager::setMeasurementSystem(QLocale::MeasurementSystem
        system )**

        Sets the measurement system used by this manager to **system**.

        The measurement system can be set independently of the locale. Both
        **setLocale** () and this function set the measurement system. The value
        set by the last function called will be used.

        **See also** **measurementSystem** (), **locale** (), and **setLocale**
        ().
        """
        ...

    def locale(self) -> QtCore.QLocale:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#locale

        **QLocale QGeoRoutingManager::locale() const**

        Returns the locale used to hint to this routing manager about what
        language to use for addresses and instructions.

        **See also** **setLocale** ().
        """
        ...

    def setLocale(self, locale: QtCore.QLocale) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#setLocale

        **void QGeoRoutingManager::setLocale(const QLocale & locale )**

        Sets the locale to be used by this manager to **locale**.

        If this routing manager supports returning addresses and instructions in
        different languages, they will be returned in the language of
        **locale**.

        The locale used defaults to the system locale if this is not set.

        **See also** **locale** ().
        """
        ...

    def supportedManeuverDetails(self) -> QGeoRouteRequest.ManeuverDetails:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#supportedManeuverDetails

        **QGeoRouteRequest::ManeuverDetails
        QGeoRoutingManager::supportedManeuverDetails() const**

        Returns the levels of detail for navigation maneuvers which can be
        requested by this manager.
        """
        ...

    def supportedSegmentDetails(self) -> QGeoRouteRequest.SegmentDetails:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#supportedSegmentDetails

        **QGeoRouteRequest::SegmentDetails
        QGeoRoutingManager::supportedSegmentDetails() const**

        Returns the levels of detail for routing segments which can be requested
        with this manager.
        """
        ...

    def supportedRouteOptimizations(self) -> QGeoRouteRequest.RouteOptimizations:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#supportedRouteOptimizatio
        ns

        **QGeoRouteRequest::RouteOptimizations
        QGeoRoutingManager::supportedRouteOptimizations() const**

        Returns the route optimizations supported by this manager.
        """
        ...

    def supportedFeatureWeights(self) -> QGeoRouteRequest.FeatureWeights:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#supportedFeatureWeights

        **QGeoRouteRequest::FeatureWeights
        QGeoRoutingManager::supportedFeatureWeights() const**

        Returns the weightings which this manager can apply to different
        features during route planning.
        """
        ...

    def supportedFeatureTypes(self) -> QGeoRouteRequest.FeatureTypes:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#supportedFeatureTypes

        **QGeoRouteRequest::FeatureTypes
        QGeoRoutingManager::supportedFeatureTypes() const**

        Returns the types of features that this manager can take into account
        during route planning.
        """
        ...

    def supportedTravelModes(self) -> QGeoRouteRequest.TravelModes:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#supportedTravelModes

        **QGeoRouteRequest::TravelModes
        QGeoRoutingManager::supportedTravelModes() const**

        Returns the travel modes supported by this manager.
        """
        ...

    def updateRoute(
        self, route: QGeoRoute, position: QtPositioning.QGeoCoordinate
    ) -> QGeoRouteReply:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#updateRoute

        **QGeoRouteReply *QGeoRoutingManager::updateRoute(const QGeoRoute &
        route , const QGeoCoordinate & position )**

        Begins the process of updating **route** based on the current position
        **position**.

        A **QGeoRouteReply**  object will be returned, which can be used to
        manage the routing operation and to return the results of the operation.

        This manager and the returned **QGeoRouteReply**  object will emit
        signals indicating if the operation completes or if errors occur.

        If supportsRouteUpdates() returns false an
        **QGeoRouteReply::UnsupportedOptionError**  will occur.

        Once the operation has completed, **QGeoRouteReply::routes**  can be
        used to retrieve the updated route.

        The returned route could be entirely different to the original route,
        especially if **position** is far away from the initial route. Otherwise
        the route will be similar, although the remaining time and distance will
        be updated and any segments of the original route which have been
        traversed will be removed.

        The user is responsible for deleting the returned reply object, although
        this can be done in the slot connected to
        **QGeoRoutingManager::finished** (), **QGeoRoutingManager::error** (),
        **QGeoRouteReply::finished** () or **QGeoRouteReply::error** () with
        **deleteLater** ().
        """
        ...

    def calculateRoute(self, request: QGeoRouteRequest) -> QGeoRouteReply:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#calculateRoute

        **QGeoRouteReply *QGeoRoutingManager::calculateRoute(const
        QGeoRouteRequest & request )**

        Begins the calculation of the route specified by **request**.

        A **QGeoRouteReply**  object will be returned, which can be used to
        manage the routing operation and to return the results of the operation.

        This manager and the returned **QGeoRouteReply**  object will emit
        signals indicating if the operation completes or if errors occur.

        Once the operation has completed, **QGeoRouteReply::routes**  can be
        used to retrieve the calculated route or routes.

        If **request** includes features which are not supported by this
        manager, as reported by the methods in this manager, then a
        **QGeoRouteReply::UnsupportedOptionError**  will occur.

        The user is responsible for deleting the returned reply object, although
        this can be done in the slot connected to
        **QGeoRoutingManager::finished** (), **QGeoRoutingManager::error** (),
        **QGeoRouteReply::finished** () or **QGeoRouteReply::error** () with
        **deleteLater** ().
        """
        ...

    def managerVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#managerVersion

        **int QGeoRoutingManager::managerVersion() const**

        Returns the version of the engine which implements the behaviour of this
        routin manager.

        The combination of **managerName** () and managerVersion() should be
        unique amongst the plugin implementations.
        """
        ...

    def managerName(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#managerName

        **QString QGeoRoutingManager::managerName() const**

        Returns the name of the engine which implements the behaviour of this
        routing manager.

        The combination of managerName() and **managerVersion** () should be
        unique amongst the plugin implementations.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#error

        **[signal] void QGeoRoutingManager::error(QGeoRouteReply * reply ,
        QGeoRouteReply::Error error , QString errorString = QString())**

        This signal is emitted when an error has been detected in the processing
        of **reply**. The **QGeoRoutingManager::finished** () signal will
        probably follow.

        The error will be described by the error code **error**. If
        **errorString** is not empty it will contain a textual description of
        the error.

        This signal and **QGeoRouteReply::error** () will be emitted at the same
        time.

        **Note:** Do not delete the **reply** object in the slot connected to
        this signal. Use **deleteLater** () instead.
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeoroutingmanager.html#finished

        **[signal] void QGeoRoutingManager::finished(QGeoRouteReply * reply )**

        This signal is emitted when **reply** has finished processing.

        If reply::error() equals **QGeoRouteReply::NoError**  then the
        processing finished successfully.

        This signal and **QGeoRouteReply::finished** () will be emitted at the
        same time.

        **Note:** Do not delete the **reply** object in the slot connected to
        this signal. Use **deleteLater** () instead.
        """
        ...
