"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtPositioning
from PyQt5 import QtCore
import datetime
from PyQt5.QtLocation import *
from PyQt5 import sip


class QGeoRouteRequest(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qgeorouterequest.html

    **Detailed Description**

    The default state of a QGeoRouteRequest instance will result in a request
    for basic route segment and navigation maneuvers describing the fastest
    route by car which covers the given waypoints.

    There may be significant variation in the features supported by different
    providers of routing information, or even in the features supported by the
    same provider if different levels of authorization are used.

    There are several functions in **QGeoRoutingManager**  which can be used to
    check which features are supported with the current provider and
    authorization level.

    **See also** **QGeoRoutingManager** .
    """

    class ManeuverDetail(int):
        NoManeuvers: QGeoRouteRequest = ...
        BasicManeuvers: QGeoRouteRequest = ...

    class SegmentDetail(int):
        NoSegmentData: QGeoRouteRequest = ...
        BasicSegmentData: QGeoRouteRequest = ...

    class RouteOptimization(int):
        ShortestRoute: QGeoRouteRequest = ...
        FastestRoute: QGeoRouteRequest = ...
        MostEconomicRoute: QGeoRouteRequest = ...
        MostScenicRoute: QGeoRouteRequest = ...

    class FeatureWeight(int):
        NeutralFeatureWeight: QGeoRouteRequest = ...
        PreferFeatureWeight: QGeoRouteRequest = ...
        RequireFeatureWeight: QGeoRouteRequest = ...
        AvoidFeatureWeight: QGeoRouteRequest = ...
        DisallowFeatureWeight: QGeoRouteRequest = ...

    class FeatureType(int):
        NoFeature: QGeoRouteRequest = ...
        TollFeature: QGeoRouteRequest = ...
        HighwayFeature: QGeoRouteRequest = ...
        PublicTransitFeature: QGeoRouteRequest = ...
        FerryFeature: QGeoRouteRequest = ...
        TunnelFeature: QGeoRouteRequest = ...
        DirtRoadFeature: QGeoRouteRequest = ...
        ParksFeature: QGeoRouteRequest = ...
        MotorPoolLaneFeature: QGeoRouteRequest = ...
        TrafficFeature: QGeoRouteRequest = ...

    class TravelMode(int):
        CarTravel: QGeoRouteRequest = ...
        PedestrianTravel: QGeoRouteRequest = ...
        BicycleTravel: QGeoRouteRequest = ...
        PublicTransitTravel: QGeoRouteRequest = ...
        TruckTravel: QGeoRouteRequest = ...

    class TravelModes(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGeoRouteRequest.TravelModes", "QGeoRouteRequest.TravelMode"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGeoRouteRequest.TravelModes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGeoRouteRequest.TravelModes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class FeatureTypes(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGeoRouteRequest.FeatureTypes", "QGeoRouteRequest.FeatureType"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGeoRouteRequest.FeatureTypes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGeoRouteRequest.FeatureTypes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class FeatureWeights(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGeoRouteRequest.FeatureWeights", "QGeoRouteRequest.FeatureWeight"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGeoRouteRequest.FeatureWeights") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGeoRouteRequest.FeatureWeights":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class RouteOptimizations(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGeoRouteRequest.RouteOptimizations",
                "QGeoRouteRequest.RouteOptimization",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGeoRouteRequest.RouteOptimizations") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGeoRouteRequest.RouteOptimizations":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class SegmentDetails(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGeoRouteRequest.SegmentDetails", "QGeoRouteRequest.SegmentDetail"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGeoRouteRequest.SegmentDetails") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGeoRouteRequest.SegmentDetails":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class ManeuverDetails(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGeoRouteRequest.ManeuverDetails", "QGeoRouteRequest.ManeuverDetail"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGeoRouteRequest.ManeuverDetails") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGeoRouteRequest.ManeuverDetails":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(
        self, waypoints: typing.Iterable[QtPositioning.QGeoCoordinate] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#QGeoRouteRequest

        **QGeoRouteRequest::QGeoRouteRequest(const QList<QGeoCoordinate> &
        waypoints = QList<QGeoCoordinate>())**

        Constructs a request to calculate a route through the coordinates
        **waypoints**.

        The route will traverse the objects of **waypoints** in order.
        """
        ...

    @typing.overload
    def __init__(
        self,
        origin: QtPositioning.QGeoCoordinate,
        destination: QtPositioning.QGeoCoordinate,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#QGeoRouteRequest-1

        **QGeoRouteRequest::QGeoRouteRequest(const QGeoCoordinate & origin ,
        const QGeoCoordinate & destination )**

        Constructs a request to calculate a route between **origin** and
        **destination**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoRouteRequest") -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#QGeoRouteRequest-2

        **QGeoRouteRequest::QGeoRouteRequest(const QGeoRouteRequest & other )**

        Constructs a route request object from the contents of **other**.
        """
        ...

    def departureTime(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#departureTime

        **QDateTime QGeoRouteRequest::departureTime() const**

        Returns the departure time in the request.

        This function was introduced in Qt 5.13.

        **See also** **setDepartureTime** ().
        """
        ...

    def setDepartureTime(
        self, departureTime: typing.Union[QtCore.QDateTime, datetime.datetime]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#setDepartureTime

        **void QGeoRouteRequest::setDepartureTime(const QDateTime &
        departureTime )**

        Sets the departure time **departureTime** for the route calculation.
        This information can be used by the backend to calculate a faster route,
        for example, by avoiding traffic congestion during rush hour.

        The default value is an invalid **QDateTime** .

        This function was introduced in Qt 5.13.

        **See also** **departureTime** ().
        """
        ...

    def extraParameters(self) -> typing.Dict[str, typing.Any]:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#extraParameters

        **QVariantMap QGeoRouteRequest::extraParameters() const**

        Returns the extra parameters set for this route request.

        This function was introduced in Qt 5.11.

        **See also** **setExtraParameters** ().
        """
        ...

    def setExtraParameters(self, extraParameters: typing.Dict[str, typing.Any]) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#setExtraParameters

        **void QGeoRouteRequest::setExtraParameters(const QVariantMap &
        extraParameters )**

        Sets the extra parameters **extraParameters** for the route request. The
        format of the extra parameters is plugin specific, and documented per
        plugin.

        This function was introduced in Qt 5.11.

        **See also** **extraParameters** ().
        """
        ...

    def waypointsMetadata(self) -> typing.List[typing.Dict[str, typing.Any]]:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#waypointsMetadata

        **QList<QVariantMap> QGeoRouteRequest::waypointsMetadata() const**

        Returns the metadata for the waypoints in this request.

        **See also** **setWaypointsMetadata** ().
        """
        ...

    def setWaypointsMetadata(
        self, waypointMetadata: typing.Iterable[typing.Dict[str, typing.Any]]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#setWaypointsMetadata

        **void QGeoRouteRequest::setWaypointsMetadata(const QList<QVariantMap> &
        waypointMetadata )**

        Sets **waypointMetadata** as the metadata for the waypoints set in this
        request. The metadata are intended as one **QVariantMap**  per waypoint,
        given in the same order as the waypoints.

        The content of the **QVariantMap**  is somehow backend-specific, but
        properties that can be specified using **Waypoint**  elements in QML can
        be assumed to be named and to work the same way across plugins, where
        supported.

        **See also** **waypointsMetadata** ().
        """
        ...

    def maneuverDetail(self) -> "QGeoRouteRequest.ManeuverDetail":
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#maneuverDetail

        **QGeoRouteRequest::ManeuverDetail QGeoRouteRequest::maneuverDetail()
        const**

        Returns the level of detail which will be used in the representation of
        routing maneuvers.

        **See also** **setManeuverDetail** ().
        """
        ...

    def setManeuverDetail(
        self, maneuverDetail: "QGeoRouteRequest.ManeuverDetail"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#setManeuverDetail

        **void
        QGeoRouteRequest::setManeuverDetail(QGeoRouteRequest::ManeuverDetail
        maneuverDetail )**

        Sets the level of detail to use when representing routing maneuvers to
        **maneuverDetail**.

        The default value is **QGeoRouteRequest::BasicManeuvers** .

        **See also** **maneuverDetail** ().
        """
        ...

    def segmentDetail(self) -> "QGeoRouteRequest.SegmentDetail":
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#segmentDetail

        **QGeoRouteRequest::SegmentDetail QGeoRouteRequest::segmentDetail()
        const**

        Returns the level of detail which will be used in the representation of
        routing segments.

        **See also** **setSegmentDetail** ().
        """
        ...

    def setSegmentDetail(self, segmentDetail: "QGeoRouteRequest.SegmentDetail") -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#setSegmentDetail

        **void
        QGeoRouteRequest::setSegmentDetail(QGeoRouteRequest::SegmentDetail
        segmentDetail )**

        Sets the level of detail to use when representing routing segments to
        **segmentDetail**.

        **See also** **segmentDetail** ().
        """
        ...

    def routeOptimization(self) -> "QGeoRouteRequest.RouteOptimizations":
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#routeOptimization

        **QGeoRouteRequest::RouteOptimizations
        QGeoRouteRequest::routeOptimization() const**

        Returns the optimization criteria which this request specifies should be
        used while planning the route.

        **See also** **setRouteOptimization** ().
        """
        ...

    def setRouteOptimization(
        self,
        optimization: typing.Union[
            "QGeoRouteRequest.RouteOptimizations", "QGeoRouteRequest.RouteOptimization"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#setRouteOptimization

        **void QGeoRouteRequest::setRouteOptimization(QGeoRouteRequest::RouteOpt
        imizations optimization )**

        Sets the optimization criteria to use while planning the route to
        **optimization**.

        The default value is **QGeoRouteRequest::FastestRoute** .

        **See also** **routeOptimization** ().
        """
        ...

    def featureTypes(self) -> typing.List["QGeoRouteRequest.FeatureType"]:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#featureTypes

        **QList<QGeoRouteRequest::FeatureType> QGeoRouteRequest::featureTypes()
        const**

        Returns the list of features that will be considered when planning the
        route. Features with a weight of **NeutralFeatureWeight**  will not be
        returned.
        """
        ...

    def featureWeight(
        self, featureType: "QGeoRouteRequest.FeatureType"
    ) -> "QGeoRouteRequest.FeatureWeight":
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#featureWeight

        **QGeoRouteRequest::FeatureWeight
        QGeoRouteRequest::featureWeight(QGeoRouteRequest::FeatureType
        featureType ) const**

        Returns the weight assigned to **featureType** in the planning of the
        route.

        If no feature weight has been specified for **featureType** then
        **NeutralFeatureWeight**  will be returned.

        **See also** **setFeatureWeight** ().
        """
        ...

    def setFeatureWeight(
        self,
        featureType: "QGeoRouteRequest.FeatureType",
        featureWeight: "QGeoRouteRequest.FeatureWeight",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#setFeatureWeight

        **void QGeoRouteRequest::setFeatureWeight(QGeoRouteRequest::FeatureType
        featureType , QGeoRouteRequest::FeatureWeight featureWeight )**

        Assigns the weight **featureWeight** to the feature **featureType**
        during the planning of the route.

        By default all features are assigned a weight of
        **NeutralFeatureWeight** .

        It is impossible to assign a weight to **QGeoRouteRequest::NoFeature** .

        **See also** **featureWeight** ().
        """
        ...

    def travelModes(self) -> "QGeoRouteRequest.TravelModes":
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#travelModes

        **QGeoRouteRequest::TravelModes QGeoRouteRequest::travelModes() const**

        Returns the travel modes which this request specifies should be
        considered during the planning of the route.

        **See also** **setTravelModes** ().
        """
        ...

    def setTravelModes(
        self,
        travelModes: typing.Union[
            "QGeoRouteRequest.TravelModes", "QGeoRouteRequest.TravelMode"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#setTravelModes

        **void QGeoRouteRequest::setTravelModes(QGeoRouteRequest::TravelModes
        travelModes )**

        Sets the travel modes which should be considered during the planning of
        the route to **travelModes**.

        The default value is **QGeoRouteRequest::CarTravel** .

        **See also** **travelModes** ().
        """
        ...

    def numberAlternativeRoutes(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#numberAlternativeRoutes

        **int QGeoRouteRequest::numberAlternativeRoutes() const**

        Returns the number of alternative routes which will be requested.

        **See also** **setNumberAlternativeRoutes** ().
        """
        ...

    def setNumberAlternativeRoutes(self, alternatives: int) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#setNumberAlternativeRoutes

        **void QGeoRouteRequest::setNumberAlternativeRoutes(int alternatives )**

        Sets the number of alternative routes to request to **alternatives**. If
        **alternatives** is negative the number of alternative routes is set to
        0.

        The default value is 0.

        **See also** **numberAlternativeRoutes** ().
        """
        ...

    def excludeAreas(self) -> typing.List[QtPositioning.QGeoRectangle]:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#excludeAreas

        **QList<QGeoRectangle> QGeoRouteRequest::excludeAreas() const**

        Returns areas the route must not cross.

        **See also** **setExcludeAreas** ().
        """
        ...

    def setExcludeAreas(
        self, areas: typing.Iterable[QtPositioning.QGeoRectangle]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#setExcludeAreas

        **void QGeoRouteRequest::setExcludeAreas(const QList<QGeoRectangle> &
        areas )**

        Sets **areas** as excluded areas that the route must not cross.

        **See also** **excludeAreas** ().
        """
        ...

    def waypoints(self) -> typing.List[QtPositioning.QGeoCoordinate]:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#waypoints

        **QList<QGeoCoordinate> QGeoRouteRequest::waypoints() const**

        Returns the waypoints that the route will pass through.

        **See also** **setWaypoints** ().
        """
        ...

    def setWaypoints(
        self, waypoints: typing.Iterable[QtPositioning.QGeoCoordinate]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeorouterequest.html#setWaypoints

        **void QGeoRouteRequest::setWaypoints(const QList<QGeoCoordinate> &
        waypoints )**

        Sets **waypoints** as the waypoints that the route should pass through.

        The waypoints should be given in order from origin to destination.

        This request will be invalid until the waypoints have been set to a list
        containing two or more coordinates.

        **See also** **waypoints** ().
        """
        ...
