"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtPositioning
from PyQt5.QtLocation import *
from PyQt5 import sip


class QGeoRoute(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qgeoroute.html

    **Detailed Description**

    A QGeoRoute object contains high level information about a route, such as
    the length the route, the estimated travel time for the route, and enough
    information to render a basic image of the route on a map.

    The QGeoRoute object also contains a list of **QGeoRouteSegment**  objecs
    which describe subsections of the route in greater detail.

    Routing information is normally requested using
    **QGeoRoutingManager::calculateRoute** (), which returns a
    **QGeoRouteReply**  instance. If the operation is completed successfully the
    routing information can be accessed with **QGeoRouteReply::routes** ()

    **See also** **QGeoRoutingManager** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#QGeoRoute

        **QGeoRoute::QGeoRoute()**

        Constructs a route object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoRoute") -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#QGeoRoute-1

        **QGeoRoute::QGeoRoute(const QGeoRoute & other )**

        Constructs a route object from the contents of **other**.
        """
        ...

    def extendedAttributes(self) -> typing.Dict[str, typing.Any]:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#extendedAttributes

        **QVariantMap QGeoRoute::extendedAttributes() const**

        Returns the extended attributes associated with this route.

        This function was introduced in Qt 5.13.

        **See also** **setExtendedAttributes** ().
        """
        ...

    def setExtendedAttributes(
        self, extendedAttributes: typing.Dict[str, typing.Any]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#setExtendedAttributes

        **void QGeoRoute::setExtendedAttributes(const QVariantMap &
        extendedAttributes )**

        Sets the extended attributes **extendedAttributes** associated with this
        route.

        This function was introduced in Qt 5.13.

        **See also** **extendedAttributes** ().
        """
        ...

    def routeLegs(self) -> typing.List["QGeoRouteLeg"]:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#routeLegs

        **QList<QGeoRouteLeg> QGeoRoute::routeLegs() const**

        Returns the legs for the route.

        This function was introduced in Qt 5.12.

        **See also** **setRouteLegs** () and **QGeoRouteLeg** .
        """
        ...

    def setRouteLegs(self, legs: typing.Iterable["QGeoRouteLeg"]) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#setRouteLegs

        **void QGeoRoute::setRouteLegs(const QList<QGeoRouteLeg> & legs )**

        Sets the route **legs** for a multi-waypoint route.

        This function was introduced in Qt 5.12.

        **See also** **routeLegs** () and **QGeoRouteLeg** .
        """
        ...

    def path(self) -> typing.List[QtPositioning.QGeoCoordinate]:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#path

        **QList<QGeoCoordinate> QGeoRoute::path() const**

        Returns the geometric shape of the route.

        The coordinates should be listed in the order in which they would be
        traversed by someone traveling along this segment of the route.

        **See also** **setPath** ().
        """
        ...

    def setPath(self, path: typing.Iterable[QtPositioning.QGeoCoordinate]) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#setPath

        **void QGeoRoute::setPath(const QList<QGeoCoordinate> & path )**

        Sets the geometric shape of the route to **path**.

        The coordinates in **path** should be listed in the order in which they
        would be traversed by someone traveling along this segment of the route.

        **See also** **path** ().
        """
        ...

    def travelMode(self) -> "QGeoRouteRequest.TravelMode":
        """
        https://doc.qt.io/qt-5/qgeoroute.html#travelMode

        **QGeoRouteRequest::TravelMode QGeoRoute::travelMode() const**

        Returns the travel mode for the this route.

        This should be one of the travel modes returned by **request**
        ().travelModes().

        **See also** **setTravelMode** ().
        """
        ...

    def setTravelMode(self, mode: "QGeoRouteRequest.TravelMode") -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#setTravelMode

        **void QGeoRoute::setTravelMode(QGeoRouteRequest::TravelMode mode )**

        Sets the travel mode for this route to **mode**.

        This should be one of the travel modes returned by **request**
        ().travelModes().

        **See also** **travelMode** ().
        """
        ...

    def distance(self) -> float:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#distance

        **qreal QGeoRoute::distance() const**

        Returns the distance covered by this route, in meters.

        **See also** **setDistance** ().
        """
        ...

    def setDistance(self, distance: float) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#setDistance

        **void QGeoRoute::setDistance(qreal distance )**

        Sets the distance covered by this route, in meters, to **distance**.

        **See also** **distance** ().
        """
        ...

    def travelTime(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#travelTime

        **int QGeoRoute::travelTime() const**

        Returns the estimated amount of time it will take to traverse this
        route, in seconds.

        **See also** **setTravelTime** ().
        """
        ...

    def setTravelTime(self, secs: int) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#setTravelTime

        **void QGeoRoute::setTravelTime(int secs )**

        Sets the estimated amount of time it will take to traverse this route,
        in seconds, to **secs**.

        **See also** **travelTime** ().
        """
        ...

    def firstRouteSegment(self) -> "QGeoRouteSegment":
        """
        https://doc.qt.io/qt-5/qgeoroute.html#firstRouteSegment

        **QGeoRouteSegment QGeoRoute::firstRouteSegment() const**

        Returns the first route segment in the route.

        Will return an invalid route segment if there are no route segments
        associated with the route.

        The remaining route segments can be accessed sequentially with
        **QGeoRouteSegment::nextRouteSegment** .

        **See also** **setFirstRouteSegment** ().
        """
        ...

    def setFirstRouteSegment(self, routeSegment: "QGeoRouteSegment") -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#setFirstRouteSegment

        **void QGeoRoute::setFirstRouteSegment(const QGeoRouteSegment &
        routeSegment )**

        Sets the first route segment in the route to **routeSegment**.

        **See also** **firstRouteSegment** ().
        """
        ...

    def bounds(self) -> QtPositioning.QGeoRectangle:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#bounds

        **QGeoRectangle QGeoRoute::bounds() const**

        Returns a bounding box which encompasses the entire route.

        **See also** **setBounds** ().
        """
        ...

    def setBounds(self, bounds: QtPositioning.QGeoRectangle) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#setBounds

        **void QGeoRoute::setBounds(const QGeoRectangle & bounds )**

        Sets the bounding box which encompasses the entire route to **bounds**.

        **See also** **bounds** ().
        """
        ...

    def request(self) -> "QGeoRouteRequest":
        """
        https://doc.qt.io/qt-5/qgeoroute.html#request

        **QGeoRouteRequest QGeoRoute::request() const**

        Returns the route request which describes the criteria used in the
        calculation of this route.

        **See also** **setRequest** ().
        """
        ...

    def setRequest(self, request: "QGeoRouteRequest") -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#setRequest

        **void QGeoRoute::setRequest(const QGeoRouteRequest & request )**

        Sets the route request which describes the criteria used in the
        calculcation of this route to **request**.

        **See also** **request** ().
        """
        ...

    def routeId(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#routeId

        **QString QGeoRoute::routeId() const**

        Returns the identifier of this route.

        Service providers which support the updating of routes commonly assign
        identifiers to routes. If this route did not come from such a service
        provider the function will return an empty string.

        **See also** **setRouteId** ().
        """
        ...

    def setRouteId(self, id: str) -> None:
        """
        https://doc.qt.io/qt-5/qgeoroute.html#setRouteId

        **void QGeoRoute::setRouteId(const QString & id )**

        Sets the identifier of this route to **id**.

        Service providers which support the updating of routes commonly assign
        identifiers to routes. If this route came from such a service provider
        changing the identifier will probably cause route updates to stop
        working.

        **See also** **routeId** ().
        """
        ...
