"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtPositioning
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QGeoCodingManagerEngine(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qgeocodingmanagerengine.html

    **Detailed Description**

    In the default implementation, supportsGeocoding() and
    supportsReverseGeocoding() returns false while **geocode** () and
    **reverseGeocode** () cause **QGeoCodeReply::UnsupportedOptionError**  to
    occur.

    If the service provider supports geocoding the subclass should provide an
    implementation of **geocode** () and call setSupportsGeocoding(true) at some
    point in time before **geocode** () is called.

    Similarly, if the service provider supports reverse geocoding the subclass
    should provide an implementation **reverseGeocode** () and call
    setSupportsReverseGeocoding(true) at some point in time before
    **reverseGeocode** () is called.

    A subclass of QGeoCodingManagerEngine will often make use of a subclass fo
    **QGeoCodeReply**  internally, in order to add any engine-specific data
    (such as a **QNetworkReply**  object for network-based services) to the
    **QGeoCodeReply**  instances used by the engine.

    **See also** **QGeoCodingManager** .
    """

    def __init__(
        self,
        parameters: typing.Dict[str, typing.Any],
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodingmanagerengine.html#QGeoCodingManagerEng
        ine

        **QGeoCodingManagerEngine::QGeoCodingManagerEngine(const QVariantMap &
        parameters , QObject * parent = nullptr)**

        Constructs a new engine with the specified **parent** , using
        **parameters** to pass any implementation specific data to the engine.
        """
        ...

    def locale(self) -> QtCore.QLocale:
        """
        https://doc.qt.io/qt-5/qgeocodingmanagerengine.html#locale

        **QLocale QGeoCodingManagerEngine::locale() const**

        Returns the locale used to hint to this geocoding manager about what
        language to use for the results.

        **See also** **setLocale** ().
        """
        ...

    def setLocale(self, locale: QtCore.QLocale) -> None:
        """
        https://doc.qt.io/qt-5/qgeocodingmanagerengine.html#setLocale

        **void QGeoCodingManagerEngine::setLocale(const QLocale & locale )**

        Sets the locale to be used by this manager to **locale**.

        If this geocoding manager supports returning the results in different
        languages, they will be returned in the language of **locale**.

        The locale used defaults to the system locale if this is not set.

        **See also** **locale** ().
        """
        ...

    def reverseGeocode(
        self, coordinate: QtPositioning.QGeoCoordinate, bounds: QtPositioning.QGeoShape
    ) -> QGeoCodeReply:
        """
        https://doc.qt.io/qt-5/qgeocodingmanagerengine.html#reverseGeocode

        **[virtual] QGeoCodeReply *QGeoCodingManagerEngine::reverseGeocode(const
        QGeoCoordinate & coordinate , const QGeoShape & bounds )**

        Begins the reverse geocoding of **coordinate**. Reverse geocoding is the
        process of finding an address that corresponds to a given coordinate.

        A **QGeoCodeReply**  object will be returned, which can be used to
        manage the reverse geocoding operation and to return the results of the
        operation.

        This engine and the returned **QGeoCodeReply**  object will emit signals
        indicating if the operation completes or if errors occur.

        If supportsReverseGeocoding() returns false an
        **QGeoCodeReply::UnsupportedOptionError**  will occur.

        At that point **QGeoCodeReply::locations** () can be used to retrieve
        the results, which will consist of a list of **QGeoLocation**  objects.
        These objects represent a combination of coordinate and address data.

        The coordinate data returned in the results may be different from
        **coordinate**. This will usually occur if the reverse geocoding service
        backend shifts the coordinates to be closer to the matching addresses,
        or if the backend returns results at multiple levels of detail.

        If multiple results are returned by the reverse geocoding service
        backend they will be provided in order of specificity. This normally
        occurs if the backend is configured to reverse geocode across multiple
        levels of detail. As an example, some services will return address and
        coordinate pairs for the street address, the city, the state and the
        country.

        If **bounds** is non-null and a valid **QGeoShape**  it will be used to
        limit the results to those that are contained by **bounds**.

        The user is responsible for deleting the returned reply object, although
        this can be done in the slot connected to
        **QGeoCodingManagerEngine::finished** (),
        **QGeoCodingManagerEngine::error** (), **QGeoCodeReply::finished** () or
        **QGeoCodeReply::error** () with **deleteLater** ().
        """
        ...

    @typing.overload
    def geocode(
        self, address: QtPositioning.QGeoAddress, bounds: QtPositioning.QGeoShape
    ) -> QGeoCodeReply:
        """
        https://doc.qt.io/qt-5/qgeocodingmanagerengine.html#geocode

        **[virtual] QGeoCodeReply *QGeoCodingManagerEngine::geocode(const
        QGeoAddress & address , const QGeoShape & bounds )**

        Begins the geocoding of **address**. Geocoding is the process of finding
        a coordinate that corresponds to a given address.

        A **QGeoCodeReply**  object will be returned, which can be used to
        manage the geocoding operation and to return the results of the
        operation.

        This engine and the returned **QGeoCodeReply**  object will emit signals
        indicating if the operation completes or if errors occur.

        If supportsGeocoding() returns false an
        **QGeoCodeReply::UnsupportedOptionError**  will occur.

        Once the operation has completed, **QGeoCodeReply::locations** () can be
        used to retrieve the results, which will consist of a list of
        **QGeoLocation**  objects. These objects represent a combination of
        coordinate and address data.

        The address data returned in the results may be different from
        **address**. This will usually occur if the geocoding service backend
        uses a different canonical form of addresses or if **address** was only
        partially filled out.

        If **bounds** is non-null and a valid **QGeoShape**  it will be used to
        limit the results to those that are contained by **bounds**. This is
        particularly useful if **address** is only partially filled out, as the
        service will attempt to geocode all matches for the specified data.

        The user is responsible for deleting the returned reply object, although
        this can be done in the slot connected to
        **QGeoCodingManagerEngine::finished** (),
        **QGeoCodingManagerEngine::error** (), **QGeoCodeReply::finished** () or
        **QGeoCodeReply::error** () with **deleteLater** ().
        """
        ...

    @typing.overload
    def geocode(
        self, address: str, limit: int, offset: int, bounds: QtPositioning.QGeoShape
    ) -> QGeoCodeReply:
        """
        https://doc.qt.io/qt-5/qgeocodingmanagerengine.html#geocode-1

        **[virtual] QGeoCodeReply *QGeoCodingManagerEngine::geocode(const
        QString & address , int limit , int offset , const QGeoShape & bounds
        )**

        Begins geocoding for a location matching **address**.

        A **QGeoCodeReply**  object will be returned, which can be used to
        manage the geocoding operation and to return the results of the
        operation.

        This engine and the returned **QGeoCodeReply**  object will emit signals
        indicating if the operation completes or if errors occur.

        Once the operation has completed, **QGeoCodeReply::locations** () can be
        used to retrieve the results, which will consist of a list of
        **QGeoLocation**  objects. These objects represent a combination of
        coordinate and address data.

        If **limit** is -1 the entire result set will be returned, otherwise at
        most **limit** results will be returned.

        The **offset** parameter is used to ask the geocoding service to not
        return the first **offset** results.

        The **limit** and **offset** results are used together to implement
        paging.

        If **bounds** is non-null and a valid **QGeoShape**  it will be used to
        limit the results to those that are contained by **bounds**.

        The user is responsible for deleting the returned reply object, although
        this can be done in the slot connected to
        **QGeoCodingManagerEngine::finished** (),
        **QGeoCodingManagerEngine::error** (), **QGeoCodeReply::finished** () or
        **QGeoCodeReply::error** () with **deleteLater** ().
        """
        ...

    def managerVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qgeocodingmanagerengine.html#managerVersion

        **int QGeoCodingManagerEngine::managerVersion() const**

        Returns the version of this engine implementation.

        The combination of **managerName** () and managerVersion() should be
        unique amongst plugin implementations.
        """
        ...

    def managerName(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeocodingmanagerengine.html#managerName

        **QString QGeoCodingManagerEngine::managerName() const**

        Returns the name which this engine implementation uses to distinguish
        itself from the implementations provided by other plugins.

        The combination of managerName() and **managerVersion** () should be
        unique amongst plugin implementations.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeocodingmanagerengine.html#error

        **[signal] void QGeoCodingManagerEngine::error(QGeoCodeReply * reply ,
        QGeoCodeReply::Error error , QString errorString = QString())**

        This signal is emitted when an error has been detected in the processing
        of **reply**. The **QGeoCodingManagerEngine::finished** () signal will
        probably follow.

        The error will be described by the error code **error**. If
        **errorString** is not empty it will contain a textual description of
        the error.

        This signal and **QGeoCodeReply::error** () will be emitted at the same
        time.

        **Note:** Do not delete the **reply** object in the slot connected to
        this signal. Use **deleteLater** () instead.
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgeocodingmanagerengine.html#finished

        **[signal] void QGeoCodingManagerEngine::finished(QGeoCodeReply * reply
        )**

        This signal is emitted when **reply** has finished processing.

        If reply::error() equals **QGeoCodeReply::NoError**  then the processing
        finished successfully.

        This signal and **QGeoCodeReply::finished** () will be emitted at the
        same time.

        **Note:** Do not delete the **reply** object in the slot connected to
        this signal. Use **deleteLater** () instead.
        """
        ...
