"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QValidator(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qvalidator.html

    **Detailed Description**

    The class itself is abstract. Two subclasses, **QIntValidator**  and
    **QDoubleValidator** , provide basic numeric-range checking, and
    **QRegExpValidator**  provides general checking using a custom regular
    expression.

    If the built-in validators aren't sufficient, you can subclass QValidator.
    The class has two virtual functions: **validate** () and **fixup** ().

    **validate** () must be implemented by every subclass. It returns
    **Invalid** , **Intermediate**  or **Acceptable**  depending on whether its
    argument is valid (for the subclass's definition of valid).

    These three states require some explanation. An **Invalid**  string is
    **clearly** invalid. **Intermediate**  is less obvious: the concept of
    validity is difficult to apply when the string is incomplete (still being
    edited). QValidator defines **Intermediate**  as the property of a string
    that is neither clearly invalid nor acceptable as a final result.
    **Acceptable**  means that the string is acceptable as a final result. One
    might say that any string that is a plausible intermediate state during
    entry of an **Acceptable**  string is **Intermediate** .

    Here are some examples:

    * For a line edit that accepts integers from 10 to 1000 inclusive, 42 and
    123 are **Acceptable** , the empty string and 5 are **Intermediate** , and
    "asdf" and 1114 is **Invalid** .
      * For an editable combobox that accepts
    URLs, any well-formed URL is **Acceptable** , "http://example.com/," is
    **Intermediate**  (it might be a cut and paste action that accidentally took
    in a comma at the end), the empty string is **Intermediate**  (the user
    might select and delete all of the text in preparation for entering a new
    URL) and "http:///./" is **Invalid** .
      * For a spin box that accepts
    lengths, "11cm" and "1in" are **Acceptable** , "11" and the empty string are
    **Intermediate** , and "http://example.com" and "hour" are **Invalid** .

    **fixup** () is provided for validators that can repair some user errors.
    The default implementation does nothing. **QLineEdit** , for example, will
    call **fixup** () if the user presses Enter (or Return) and the content is
    not currently valid. This allows the **fixup** () function the opportunity
    of performing some magic to make an **Invalid**  string **Acceptable** .

    A validator has a locale, set with **setLocale** (). It is typically used to
    parse localized data. For example, **QIntValidator**  and
    **QDoubleValidator**  use it to parse localized representations of integers
    and doubles.

    QValidator is typically used with **QLineEdit** , **QSpinBox**  and
    **QComboBox** .

    **See also** **QIntValidator** , **QDoubleValidator** , **QRegExpValidator**
    , and **Line Edits Example** .
    """

    class State(int):
        Invalid: QValidator = ...
        Intermediate: QValidator = ...
        Acceptable: QValidator = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qvalidator.html#QValidator

        **QValidator::QValidator(QObject * parent = nullptr)**

        Sets up the validator. The **parent** parameter is passed on to the
        **QObject**  constructor.
        """
        ...

    def locale(self) -> QtCore.QLocale:
        """
        https://doc.qt.io/qt-5/qvalidator.html#locale

        **QLocale QValidator::locale() const**

        Returns the locale for the validator. The locale is by default
        initialized to the same as QLocale().

        **See also** **setLocale** () and **QLocale::QLocale** ().
        """
        ...

    def setLocale(self, locale: QtCore.QLocale) -> None:
        """
        https://doc.qt.io/qt-5/qvalidator.html#setLocale

        **void QValidator::setLocale(const QLocale & locale )**

        Sets the **locale** that will be used for the validator. Unless
        setLocale has been called, the validator will use the default locale set
        with **QLocale::setDefault** (). If a default locale has not been set,
        it is the operating system's locale.

        **See also** **locale** () and **QLocale::setDefault** ().
        """
        ...

    def fixup(self, a0: str) -> str:
        """
        https://doc.qt.io/qt-5/qvalidator.html#fixup

        **[virtual] void QValidator::fixup(QString & input ) const**

        This function attempts to change **input** to be valid according to this
        validator's rules. It need not result in a valid string: callers of this
        function must re-test afterwards; the default does nothing.

        Reimplementations of this function can change **input** even if they do
        not produce a valid string. For example, an ISBN validator might want to
        delete every character except digits and "-", even if the result is
        still not a valid ISBN; a surname validator might want to remove
        whitespace from the start and end of the string, even if the resulting
        string is not in the list of accepted surnames.
        """
        ...

    def validate(self, a0: str, a1: int) -> typing.Tuple["QValidator.State", str, int]:
        """
        https://doc.qt.io/qt-5/qvalidator.html#validate

        **[pure virtual] QValidator::State QValidator::validate(QString & input
        , int & pos ) const**

        This virtual function returns **Invalid**  if **input** is invalid
        according to this validator's rules, **Intermediate**  if it is likely
        that a little more editing will make the input acceptable (e.g. the user
        types "4" into a widget which accepts integers between 10 and 99), and
        **Acceptable**  if the input is valid.

        The function can change both **input** and **pos** (the cursor position)
        if required.
        """
        ...

    @property
    def changed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvalidator.html#changed

        **[signal] void QValidator::changed()**

        This signal is emitted when any property that may affect the validity of
        a string has changed.
        """
        ...
