"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QTextBlock(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qtextblock.html

    **Detailed Description**

    A text block encapsulates a block or paragraph of text in a
    **QTextDocument** . QTextBlock provides read-only access to the
    block/paragraph structure of QTextDocuments. It is mainly of use if you want
    to implement your own layouts for the visual representation of a
    **QTextDocument** , or if you want to iterate over a document and write out
    the contents in your own custom format.

    Text blocks are created by their parent documents. If you need to create a
    new text block, or modify the contents of a document while examining its
    contents, use the cursor-based interface provided by **QTextCursor**
    instead.

    Each text block is located at a specific **position** () in a **document**
    (). The contents of the block can be obtained by using the **text** ()
    function. The **length** () function determines the block's size within the
    document (including formatting characters). The visual properties of the
    block are determined by its text **layout** (), its **charFormat** (), and
    its **blockFormat** ().

    The **next** () and **previous** () functions enable iteration over
    consecutive valid blocks in a document under the condition that the document
    is not modified by other means during the iteration process. Note that,
    although blocks are returned in sequence, adjacent blocks may come from
    different places in the document structure. The validity of a block can be
    determined by calling **isValid** ().

    QTextBlock provides comparison operators to make it easier to work with
    blocks: **operator==** () compares two block for equality, **operator!=** ()
    compares two blocks for inequality, and **operator<** () determines whether
    a block precedes another in the same document.

    ![](images/qtextblock-sequence.png)

    **See also** **QTextBlockFormat** , **QTextCharFormat** , and
    **QTextFragment** .
    """

    class iterator(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, o: "QTextBlock.iterator") -> None:
            ...

        def atEnd(self) -> bool:
            ...

        def fragment(self) -> "QTextFragment":
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextblock.html#QTextBlock-2

        **QTextBlock::QTextBlock(const QTextBlock & other )**

        Copies the **other** text block's attributes to this text block.
        """
        ...

    @typing.overload
    def __init__(self, o: "QTextBlock") -> None:
        """
        https://doc.qt.io/qt-5/qtextblock.html#QTextBlock-2

        **QTextBlock::QTextBlock(const QTextBlock & other )**

        Copies the **other** text block's attributes to this text block.
        """
        ...

    def textFormats(self) -> typing.List[QTextLayout.FormatRange]:
        """
        https://doc.qt.io/qt-5/qtextblock.html#textFormats

        **QVector<QTextLayout::FormatRange> QTextBlock::textFormats() const**

        Returns the block's text format options as a list of continuous ranges
        of **QTextCharFormat** . The range's character format is used when
        inserting text within the range boundaries.

        This function was introduced in Qt 5.3.

        **See also** **charFormat** () and **blockFormat** ().
        """
        ...

    def textDirection(self) -> QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-5/qtextblock.html#textDirection

        **Qt::LayoutDirection QTextBlock::textDirection() const**

        Returns the resolved text direction.

        If the block has no explicit direction set, it will resolve the
        direction from the blocks content. Returns either **Qt::LeftToRight**
        or **Qt::RightToLeft** .

        This function was introduced in Qt 4.7.

        **See also** **QTextFormat::layoutDirection** (),
        **QString::isRightToLeft** (), and **Qt::LayoutDirection** .
        """
        ...

    def lineCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextblock.html#lineCount

        **int QTextBlock::lineCount() const**

        Returns the line count. Not all document layouts support this feature.

        This function was introduced in Qt 4.5.

        **See also** **setLineCount** ().
        """
        ...

    def setLineCount(self, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qtextblock.html#setLineCount

        **void QTextBlock::setLineCount(int count )**

        Sets the line count to **count**.

        This function was introduced in Qt 4.5.

        **See also** **lineCount** ().
        """
        ...

    def firstLineNumber(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextblock.html#firstLineNumber

        **int QTextBlock::firstLineNumber() const**

        Returns the first line number of this block, or -1 if the block is
        invalid. Unless the layout supports it, the line number is identical to
        the block number.

        This function was introduced in Qt 4.5.

        **See also** **QTextBlock::blockNumber** ().
        """
        ...

    def blockNumber(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextblock.html#blockNumber

        **int QTextBlock::blockNumber() const**

        Returns the number of this block, or -1 if the block is invalid.

        This function was introduced in Qt 4.4.

        **See also** **QTextCursor::blockNumber** ().
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtextblock.html#setVisible

        **void QTextBlock::setVisible(bool visible )**

        Sets the block's visibility to **visible**.

        This function was introduced in Qt 4.4.

        **See also** **isVisible** ().
        """
        ...

    def isVisible(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextblock.html#isVisible

        **bool QTextBlock::isVisible() const**

        Returns `true` if the block is visible; otherwise returns `false`.

        This function was introduced in Qt 4.4.

        **See also** **setVisible** ().
        """
        ...

    def setRevision(self, rev: int) -> None:
        """
        https://doc.qt.io/qt-5/qtextblock.html#setRevision

        **void QTextBlock::setRevision(int rev )**

        Sets a blocks revision to **rev**.

        This function was introduced in Qt 4.4.

        **See also** **revision** () and **QTextDocument::revision** ().
        """
        ...

    def revision(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextblock.html#revision

        **int QTextBlock::revision() const**

        Returns the blocks revision.

        This function was introduced in Qt 4.4.

        **See also** **setRevision** () and **QTextDocument::revision** ().
        """
        ...

    def clearLayout(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextblock.html#clearLayout

        **void QTextBlock::clearLayout()**

        Clears the **QTextLayout**  that is used to lay out and display the
        block's contents.

        This function was introduced in Qt 4.4.

        **See also** **layout** ().
        """
        ...

    def setUserState(self, state: int) -> None:
        """
        https://doc.qt.io/qt-5/qtextblock.html#setUserState

        **void QTextBlock::setUserState(int state )**

        Stores the specified **state** integer value in the text block. This may
        be useful for example in a syntax highlighter to store a text parsing
        state.

        This function was introduced in Qt 4.1.

        **See also** **userState** ().
        """
        ...

    def userState(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextblock.html#userState

        **int QTextBlock::userState() const**

        Returns the integer value previously set with **setUserState** () or -1.

        This function was introduced in Qt 4.1.

        **See also** **setUserState** ().
        """
        ...

    def setUserData(self, data: "QTextBlockUserData") -> None:
        """
        https://doc.qt.io/qt-5/qtextblock.html#setUserData

        **void QTextBlock::setUserData(QTextBlockUserData * data )**

        Attaches the given **data** object to the text block.

        **QTextBlockUserData**  can be used to store custom settings. The
        ownership is passed to the underlying text document, i.e. the provided
        **QTextBlockUserData**  object will be deleted if the corresponding text
        block gets deleted. The user data object is not stored in the undo
        history, so it will not be available after undoing the deletion of a
        text block.

        For example, if you write a programming editor in an IDE, you may want
        to let your user set breakpoints visually in your code for an integrated
        debugger. In a programming editor a line of text usually corresponds to
        one **QTextBlock** . The **QTextBlockUserData**  interface allows the
        developer to store data for each **QTextBlock** , like for example in
        which lines of the source code the user has a breakpoint set. Of course
        this could also be stored externally, but by storing it inside the
        **QTextDocument** , it will for example be automatically deleted when
        the user deletes the associated line. It's really just a way to store
        custom information in the **QTextDocument**  without using custom
        properties in **QTextFormat**  which would affect the undo/redo stack.

        This function was introduced in Qt 4.1.

        **See also** **userData** ().
        """
        ...

    def userData(self) -> "QTextBlockUserData":
        """
        https://doc.qt.io/qt-5/qtextblock.html#userData

        **QTextBlockUserData *QTextBlock::userData() const**

        Returns a pointer to a **QTextBlockUserData**  object, if one has been
        set with **setUserData** (), or `nullptr`.

        This function was introduced in Qt 4.1.

        **See also** **setUserData** ().
        """
        ...

    def previous(self) -> "QTextBlock":
        """
        https://doc.qt.io/qt-5/qtextblock.html#previous

        **QTextBlock QTextBlock::previous() const**

        Returns the text block in the document before this block, or an empty
        text block if this is the first one.

        Note that the previous block may be in a different frame or table to
        this block.

        **See also** **next** (), **begin** (), and **end** ().
        """
        ...

    def next(self) -> "QTextBlock":
        """
        https://doc.qt.io/qt-5/qtextblock.html#next

        **QTextBlock QTextBlock::next() const**

        Returns the text block in the document after this block, or an empty
        text block if this is the last one.

        Note that the next block may be in a different frame or table to this
        block.

        **See also** **previous** (), **begin** (), and **end** ().
        """
        ...

    def end(self) -> "QTextBlock.iterator":
        """
        https://doc.qt.io/qt-5/qtextblock.html#end

        **QTextBlock::iterator QTextBlock::end() const**

        Returns a text block iterator pointing to the end of the text block.

        **See also** **begin** (), **next** (), and **previous** ().
        """
        ...

    def begin(self) -> "QTextBlock.iterator":
        """
        https://doc.qt.io/qt-5/qtextblock.html#begin

        **QTextBlock::iterator QTextBlock::begin() const**

        Returns a text block iterator pointing to the beginning of the text
        block.

        **See also** **end** ().
        """
        ...

    def textList(self) -> QTextList:
        """
        https://doc.qt.io/qt-5/qtextblock.html#textList

        **QTextList *QTextBlock::textList() const**

        If the block represents a list item, returns the list that the item
        belongs to; otherwise returns `nullptr`.
        """
        ...

    def document(self) -> QTextDocument:
        """
        https://doc.qt.io/qt-5/qtextblock.html#document

        **const QTextDocument *QTextBlock::document() const**

        Returns the text document this text block belongs to, or `nullptr` if
        the text block does not belong to any document.
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qtextblock.html#text

        **QString QTextBlock::text() const**

        Returns the block's contents as plain text.

        **See also** **length** (), **charFormat** (), and **blockFormat** ().
        """
        ...

    def charFormatIndex(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextblock.html#charFormatIndex

        **int QTextBlock::charFormatIndex() const**

        Returns an index into the document's internal list of character formats
        for the text block's character format.

        **See also** **QTextDocument::allFormats** ().
        """
        ...

    def charFormat(self) -> QTextCharFormat:
        """
        https://doc.qt.io/qt-5/qtextblock.html#charFormat

        **QTextCharFormat QTextBlock::charFormat() const**

        Returns the **QTextCharFormat**  that describes the block's character
        format. The block's character format is used when inserting text into an
        empty block.

        **See also** **blockFormat** ().
        """
        ...

    def blockFormatIndex(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextblock.html#blockFormatIndex

        **int QTextBlock::blockFormatIndex() const**

        Returns an index into the document's internal list of block formats for
        the text block's format.

        **See also** **QTextDocument::allFormats** ().
        """
        ...

    def blockFormat(self) -> QTextBlockFormat:
        """
        https://doc.qt.io/qt-5/qtextblock.html#blockFormat

        **QTextBlockFormat QTextBlock::blockFormat() const**

        Returns the **QTextBlockFormat**  that describes block-specific
        properties.

        **See also** **charFormat** ().
        """
        ...

    def layout(self) -> QTextLayout:
        """
        https://doc.qt.io/qt-5/qtextblock.html#layout

        **QTextLayout *QTextBlock::layout() const**

        Returns the **QTextLayout**  that is used to lay out and display the
        block's contents.

        Note that the returned **QTextLayout**  object can only be modified from
        the documentChanged implementation of a **QAbstractTextDocumentLayout**
        subclass. Any changes applied from the outside cause undefined behavior.

        **See also** **clearLayout** ().
        """
        ...

    def contains(self, position: int) -> bool:
        """
        https://doc.qt.io/qt-5/qtextblock.html#contains

        **bool QTextBlock::contains(int position ) const**

        Returns `true` if the given **position** is located within the text
        block; otherwise returns `false`.
        """
        ...

    def length(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextblock.html#length

        **int QTextBlock::length() const**

        Returns the length of the block in characters.

        **Note:** The length returned includes all formatting characters, for
        example, newline.

        **See also** **text** (), **charFormat** (), and **blockFormat** ().
        """
        ...

    def position(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextblock.html#position

        **int QTextBlock::position() const**

        Returns the index of the block's first character within the document.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qtextblock.html#isValid

        **bool QTextBlock::isValid() const**

        Returns `true` if this text block is valid; otherwise returns `false`.
        """
        ...
