"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QTabletEvent(QInputEvent):
    """
    https://doc.qt.io/qt-5/qtabletevent.html

    **Detailed Description**

    **Tablet events** are generated from tablet peripherals such as Wacom
    tablets and various other brands, and electromagnetic stylus devices
    included with some types of tablet computers. (It is not the same as
    **QTouchEvent**  which a touchscreen generates, even when a passive stylus
    is used on a touchscreen.)

    Tablet events are similar to mouse events; for example, the **x** (), **y**
    (), **pos** (), **globalX** (), **globalY** (), and **globalPos** ()
    accessors provide the cursor position, and you can see which **buttons** ()
    are pressed (pressing the stylus tip against the tablet surface is
    equivalent to a left mouse button). But tablet events also pass through some
    extra information that the tablet device driver provides; for example, you
    might want to do subpixel rendering with higher resolution coordinates
    (**globalPosF** ()), adjust color brightness based on the **pressure** () of
    the tool against the tablet surface, use different brushes depending on the
    type of tool in use (**deviceType** ()), modulate the brush shape in some
    way according to the X-axis and Y-axis tilt of the tool with respect to the
    tablet surface (**xTilt** () and **yTilt** ()), and use a virtual eraser
    instead of a brush if the user switches to the other end of a double-ended
    stylus (**pointerType** ()).

    Every event contains an accept flag that indicates whether the receiver
    wants the event. You should call **QTabletEvent::accept** () if you handle
    the tablet event; otherwise it will be sent to the parent widget. The
    exception are **TabletEnterProximity**  and **TabletLeaveProximity**
    events: these are only sent to **QApplication**  and do not check whether or
    not they are accepted.

    The **QWidget::setEnabled** () function can be used to enable or disable
    mouse, tablet and keyboard events for a widget.

    The event handler **QWidget::tabletEvent** () receives **TabletPress** ,
    **TabletRelease**  and **TabletMove**  events. Qt will first send a tablet
    event, then if it is not accepted by any widget, it will send a mouse event.
    This allows users of applications that are not designed for tablets to use a
    tablet like a mouse. However high-resolution drawing applications should
    handle the tablet events, because they can occur at a higher frequency,
    which is a benefit for smooth and accurate drawing. If the tablet events are
    rejected, the synthetic mouse events may be compressed for efficiency.

    New in Qt 5.4: QTabletEvent includes all information available from the
    device, including **QTabletEvent::buttons** (). Previously it was not
    possible to accept all tablet events and also know which stylus buttons were
    pressed.

    Note that pressing the stylus button while the stylus hovers over the tablet
    will generate a button press on some types of tablets, while on other types
    it will be necessary to press the stylus against the tablet surface in order
    to register the simultaneous stylus button press.

    **Notes for X11 Users**

    If the tablet is configured in xorg.conf to use the Wacom driver, there will
    be separate XInput "devices" for the stylus, eraser, and (optionally) cursor
    and touchpad. Qt recognizes these by their names. Otherwise, if the tablet
    is configured to use the evdev driver, there will be only one device and
    applications may not be able to distinguish the stylus from the eraser.

    **Notes for Windows Users**

    Tablet support currently requires the WACOM windows driver providing the DLL
    `wintab32.dll` to be installed. It is contained in older packages, for
    example `pentablet_5.3.5-3.exe`.
    """

    class PointerType(int):
        UnknownPointer: QTabletEvent = ...
        Pen: QTabletEvent = ...
        Cursor: QTabletEvent = ...
        Eraser: QTabletEvent = ...

    class TabletDevice(int):
        NoDevice: QTabletEvent = ...
        Puck: QTabletEvent = ...
        Stylus: QTabletEvent = ...
        Airbrush: QTabletEvent = ...
        FourDMouse: QTabletEvent = ...
        XFreeEraser: QTabletEvent = ...
        RotationStylus: QTabletEvent = ...

    @typing.overload
    def __init__(
        self,
        t: QtCore.QEvent.Type,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        device: int,
        pointerType: int,
        pressure: float,
        xTilt: int,
        yTilt: int,
        tangentialPressure: float,
        rotation: float,
        z: int,
        keyState: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier],
        uniqueID: int,
        button: QtCore.Qt.MouseButton,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#QTabletEvent-1

        **QTabletEvent::QTabletEvent(QEvent::Type type , const QPointF & pos ,
        const QPointF & globalPos , int device , int pointerType , qreal
        pressure , int xTilt , int yTilt , qreal tangentialPressure , qreal
        rotation , int z , Qt::KeyboardModifiers keyState , qint64 uniqueID ,
        Qt::MouseButton button , Qt::MouseButtons buttons )**

        Construct a tablet event of the given **type**.

        The **pos** parameter indicates where the event occurred in the widget;
        **globalPos** is the corresponding position in absolute coordinates.

        **pressure** contains the pressure exerted on the **device**.

        **pointerType** describes the type of pen that is being used.

        **xTilt** and **yTilt** contain the device's degree of tilt from the x
        and y axes respectively.

        **keyState** specifies which keyboard modifiers are pressed (e.g.,
        **Ctrl** ).

        The **uniqueID** parameter contains the unique ID for the current
        device.

        The **z** parameter contains the coordinate of the device on the tablet,
        this is usually given by a wheel on 4D mouse. If the device does not
        support a Z-axis, pass zero here.

        The **tangentialPressure** parameter contins the tangential pressure of
        an air brush. If the device does not support tangential pressure, pass 0
        here.

        **rotation** contains the device's rotation in degrees. 4D mice, the
        Wacom Art Pen, and the Apple Pencil support rotation. If the device does
        not support rotation, pass 0 here.

        The **button** that caused the event is given as a value from the
        **Qt::MouseButton**  enum. If the event **type** is not **TabletPress**
        or **TabletRelease** , the appropriate button for this event is
        **Qt::NoButton** .

        **buttons** is the state of all buttons at the time of the event.

        **See also** **pos** (), **globalPos** (), **device** (), **pressure**
        (), **xTilt** (), **yTilt** (), **uniqueId** (), **rotation** (),
        **tangentialPressure** (), and **z** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        t: QtCore.QEvent.Type,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        device: int,
        pointerType: int,
        pressure: float,
        xTilt: int,
        yTilt: int,
        tangentialPressure: float,
        rotation: float,
        z: int,
        keyState: typing.Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier],
        uniqueID: int,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#QTabletEvent-1

        **QTabletEvent::QTabletEvent(QEvent::Type type , const QPointF & pos ,
        const QPointF & globalPos , int device , int pointerType , qreal
        pressure , int xTilt , int yTilt , qreal tangentialPressure , qreal
        rotation , int z , Qt::KeyboardModifiers keyState , qint64 uniqueID ,
        Qt::MouseButton button , Qt::MouseButtons buttons )**

        Construct a tablet event of the given **type**.

        The **pos** parameter indicates where the event occurred in the widget;
        **globalPos** is the corresponding position in absolute coordinates.

        **pressure** contains the pressure exerted on the **device**.

        **pointerType** describes the type of pen that is being used.

        **xTilt** and **yTilt** contain the device's degree of tilt from the x
        and y axes respectively.

        **keyState** specifies which keyboard modifiers are pressed (e.g.,
        **Ctrl** ).

        The **uniqueID** parameter contains the unique ID for the current
        device.

        The **z** parameter contains the coordinate of the device on the tablet,
        this is usually given by a wheel on 4D mouse. If the device does not
        support a Z-axis, pass zero here.

        The **tangentialPressure** parameter contins the tangential pressure of
        an air brush. If the device does not support tangential pressure, pass 0
        here.

        **rotation** contains the device's rotation in degrees. 4D mice, the
        Wacom Art Pen, and the Apple Pencil support rotation. If the device does
        not support rotation, pass 0 here.

        The **button** that caused the event is given as a value from the
        **Qt::MouseButton**  enum. If the event **type** is not **TabletPress**
        or **TabletRelease** , the appropriate button for this event is
        **Qt::NoButton** .

        **buttons** is the state of all buttons at the time of the event.

        **See also** **pos** (), **globalPos** (), **device** (), **pressure**
        (), **xTilt** (), **yTilt** (), **uniqueId** (), **rotation** (),
        **tangentialPressure** (), and **z** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QTabletEvent") -> None:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#QTabletEvent-1

        **QTabletEvent::QTabletEvent(QEvent::Type type , const QPointF & pos ,
        const QPointF & globalPos , int device , int pointerType , qreal
        pressure , int xTilt , int yTilt , qreal tangentialPressure , qreal
        rotation , int z , Qt::KeyboardModifiers keyState , qint64 uniqueID ,
        Qt::MouseButton button , Qt::MouseButtons buttons )**

        Construct a tablet event of the given **type**.

        The **pos** parameter indicates where the event occurred in the widget;
        **globalPos** is the corresponding position in absolute coordinates.

        **pressure** contains the pressure exerted on the **device**.

        **pointerType** describes the type of pen that is being used.

        **xTilt** and **yTilt** contain the device's degree of tilt from the x
        and y axes respectively.

        **keyState** specifies which keyboard modifiers are pressed (e.g.,
        **Ctrl** ).

        The **uniqueID** parameter contains the unique ID for the current
        device.

        The **z** parameter contains the coordinate of the device on the tablet,
        this is usually given by a wheel on 4D mouse. If the device does not
        support a Z-axis, pass zero here.

        The **tangentialPressure** parameter contins the tangential pressure of
        an air brush. If the device does not support tangential pressure, pass 0
        here.

        **rotation** contains the device's rotation in degrees. 4D mice, the
        Wacom Art Pen, and the Apple Pencil support rotation. If the device does
        not support rotation, pass 0 here.

        The **button** that caused the event is given as a value from the
        **Qt::MouseButton**  enum. If the event **type** is not **TabletPress**
        or **TabletRelease** , the appropriate button for this event is
        **Qt::NoButton** .

        **buttons** is the state of all buttons at the time of the event.

        **See also** **pos** (), **globalPos** (), **device** (), **pressure**
        (), **xTilt** (), **yTilt** (), **uniqueId** (), **rotation** (),
        **tangentialPressure** (), and **z** ().
        """
        ...

    def deviceType(self) -> "QTabletEvent.TabletDevice":
        """
        https://doc.qt.io/qt-5/qtabletevent.html#deviceType

        **QTabletEvent::TabletDevice QTabletEvent::deviceType() const**

        Returns the type of device that generated the event.

        **See also** **TabletDevice** .
        """
        ...

    def buttons(self) -> QtCore.Qt.MouseButtons:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#buttons

        **Qt::MouseButtons QTabletEvent::buttons() const**

        Returns the button state when the event was generated. The button state
        is a combination of buttons from the **Qt::MouseButton**  enum using the
        OR operator. For **TabletMove**  events, this is all buttons that are
        pressed down. For **TabletPress**  events this includes the button that
        caused the event. For **TabletRelease**  events this excludes the button
        that caused the event.

        **See also** **button** () and **Qt::MouseButton** .
        """
        ...

    def button(self) -> QtCore.Qt.MouseButton:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#button

        **Qt::MouseButton QTabletEvent::button() const**

        Returns the button that caused the event.

        Note that the returned value is always **Qt::NoButton**  for
        **TabletMove** , **TabletEnterProximity**  and **TabletLeaveProximity**
        events.

        **See also** **buttons** () and **Qt::MouseButton** .
        """
        ...

    def globalPosF(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#globalPosF

        **const QPointF &QTabletEvent::globalPosF() const**

        Returns the global position of the device **at the time of the event**.
        This is important on asynchronous windows systems like X11; whenever you
        move your widgets around in response to mouse events, globalPosF() can
        differ significantly from the current position **QCursor::pos** ().

        **See also** **posF** ().
        """
        ...

    def posF(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#posF

        **const QPointF &QTabletEvent::posF() const**

        Returns the position of the device, relative to the widget that received
        the event.

        If you move widgets around in response to mouse events, use
        **globalPosF** () instead of this function.

        **See also** **globalPosF** ().
        """
        ...

    def yTilt(self) -> int:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#yTilt

        **int QTabletEvent::yTilt() const**

        Returns the angle between the device (a pen, for example) and the
        perpendicular in the direction of the y axis. Positive values are
        towards the bottom of the tablet. The angle is within the range -60 to
        +60 degrees.

        **See also** **xTilt** ().
        """
        ...

    def xTilt(self) -> int:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#xTilt

        **int QTabletEvent::xTilt() const**

        Returns the angle between the device (a pen, for example) and the
        perpendicular in the direction of the x axis. Positive values are
        towards the tablet's physical right. The angle is in the range -60 to
        +60 degrees.

        ![](images/qtabletevent-tilt.png)

        **See also** **yTilt** ().
        """
        ...

    def rotation(self) -> float:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#rotation

        **qreal QTabletEvent::rotation() const**

        Returns the rotation of the current tool in degrees, where zero means
        the tip of the stylus is pointing towards the top of the tablet, a
        positive value means it's turned to the right, and a negative value
        means it's turned to the left. This can be given by a 4D Mouse or a
        rotation-capable stylus (such as the Wacom Art Pen or the Apple Pencil).
        If the device does not support rotation, this value is always 0.0.
        """
        ...

    def tangentialPressure(self) -> float:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#tangentialPressure

        **qreal QTabletEvent::tangentialPressure() const**

        Returns the tangential pressure for the device. This is typically given
        by a finger wheel on an airbrush tool. The range is from -1.0 to 1.0.
        0.0 indicates a neutral position. Current airbrushes can only move in
        the positive direction from the neutrual position. If the device does
        not support tangential pressure, this value is always 0.0.

        **See also** **pressure** ().
        """
        ...

    def z(self) -> int:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#z

        **int QTabletEvent::z() const**

        Returns the z position of the device. Typically this is represented by a
        wheel on a 4D Mouse. If the device does not support a Z-axis, this value
        is always zero. This is **not** the same as pressure.

        **See also** **pressure** ().
        """
        ...

    def pressure(self) -> float:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#pressure

        **qreal QTabletEvent::pressure() const**

        Returns the pressure for the device. 0.0 indicates that the stylus is
        not on the tablet, 1.0 indicates the maximum amount of pressure for the
        stylus.

        **See also** **tangentialPressure** ().
        """
        ...

    def uniqueId(self) -> int:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#uniqueId

        **qint64 QTabletEvent::uniqueId() const**

        Returns a unique ID for the current device, making it possible to
        differentiate between multiple devices being used at the same time on
        the tablet.

        Support of this feature is dependent on the tablet.

        Values for the same device may vary from OS to OS.

        Later versions of the Wacom driver for Linux will now report the ID
        information. If you have a tablet that supports unique ID and are not
        getting the information on Linux, consider upgrading your driver.

        As of Qt 4.2, the unique ID is the same regardless of the orientation of
        the pen. Earlier versions would report a different value when using the
        eraser-end versus the pen-end of the stylus on some OS's.

        **See also** **pointerType** ().
        """
        ...

    def pointerType(self) -> "QTabletEvent.PointerType":
        """
        https://doc.qt.io/qt-5/qtabletevent.html#pointerType

        **QTabletEvent::PointerType QTabletEvent::pointerType() const**

        Returns the type of point that generated the event.
        """
        ...

    def device(self) -> "QTabletEvent.TabletDevice":
        ...

    def hiResGlobalY(self) -> float:
        ...

    def hiResGlobalX(self) -> float:
        ...

    def globalY(self) -> int:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#globalY

        **int QTabletEvent::globalY() const**

        Returns the global y position of the tablet device at the time of the
        event.

        **See also** **globalX** (), **globalPos** (), and **hiResGlobalY** ().
        """
        ...

    def globalX(self) -> int:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#globalX

        **int QTabletEvent::globalX() const**

        Returns the global x position of the mouse pointer at the time of the
        event.

        **See also** **globalY** (), **globalPos** (), and **hiResGlobalX** ().
        """
        ...

    def y(self) -> int:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#y

        **int QTabletEvent::y() const**

        Returns the y position of the device, relative to the widget that
        received the event.

        **See also** **x** () and **pos** ().
        """
        ...

    def x(self) -> int:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#x

        **int QTabletEvent::x() const**

        Returns the x position of the device, relative to the widget that
        received the event.

        **See also** **y** () and **pos** ().
        """
        ...

    def globalPos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#globalPos

        **QPoint QTabletEvent::globalPos() const**

        Returns the global position of the device **at the time of the event**.
        This is important on asynchronous windows systems like X11; whenever you
        move your widgets around in response to mouse events, globalPos() can
        differ significantly from the current position **QCursor::pos** ().

        **See also** **globalX** () and **globalY** ().
        """
        ...

    def pos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qtabletevent.html#pos

        **QPoint QTabletEvent::pos() const**

        Returns the position of the device, relative to the widget that received
        the event.

        If you move widgets around in response to mouse events, use
        **globalPos** () instead of this function.

        **See also** **x** (), **y** (), and **globalPos** ().
        """
        ...
