"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import PyQt5.sip
from PyQt5 import QtCore


class QStyleHints(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qstylehints.html

    **Detailed Description**

    An object of this class, obtained from **QGuiApplication** , provides access
    to certain global user interface parameters of the current platform.

    Access is read only; typically the platform itself provides the user a way
    to tune these parameters.

    Access to these parameters are useful when implementing custom user
    interface components, in that they allow the components to exhibit the same
    behaviour and feel as other components.

    **See also** **QGuiApplication::styleHints** ().
    """

    def touchDoubleTapDistance(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#touchDoubleTapDistance-prop

        **touchDoubleTapDistance : const int**

        This property holds the maximum distance, in pixels, that a finger can
        be moved between two consecutive taps and still have it detected as a
        double-tap

        This property was introduced in Qt 5.14.

        **Access functions:**

        int **touchDoubleTapDistance** () const
        """
        ...

    def mouseDoubleClickDistance(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#mouseDoubleClickDistance-prop

        **mouseDoubleClickDistance : const int**

        This property holds the maximum distance, in pixels, that the mouse can
        be moved between two consecutive mouse clicks and still have it detected
        as a double-click

        This property was introduced in Qt 5.14.

        **Access functions:**

        int **mouseDoubleClickDistance** () const
        """
        ...

    def setShowShortcutsInContextMenus(self, showShortcutsInContextMenus: bool) -> None:
        """
        https://doc.qt.io/qt-5/qstylehints.html#showShortcutsInContextMenus-prop

        **showShortcutsInContextMenus : bool**

        `true` if the platform normally shows shortcut key sequences in context
        menus, otherwise `false`.

        Since Qt 5.13, the setShowShortcutsInContextMenus() function can be used
        to override the platform default.

        This property was introduced in Qt 5.10.

        **Access functions:**

        bool **showShortcutsInContextMenus** () const
        void
        **setShowShortcutsInContextMenus** (bool **showShortcutsInContextMenus**
        )

        **Notifier signal:**

        void **showShortcutsInContextMenusChanged** ( **bool** )
        """
        ...

    def mouseQuickSelectionThreshold(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#mouseQuickSelectionThreshold-
        prop

        **mouseQuickSelectionThreshold : const int**

        Quick selection mouse threshold in **QLineEdit** .

        This property defines how much the mouse cursor should be moved along
        the y axis to trigger a quick selection during a normal **QLineEdit**
        text selection.

        If the property value is less than or equal to 0, the quick selection
        feature is disabled.

        This property was introduced in Qt 5.11.

        **Access functions:**

        int **mouseQuickSelectionThreshold** () const

        **Notifier signal:**

        void **mouseQuickSelectionThresholdChanged** (int **threshold** )
        """
        ...

    def showShortcutsInContextMenus(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstylehints.html#showShortcutsInContextMenus-prop

        **showShortcutsInContextMenus : bool**

        `true` if the platform normally shows shortcut key sequences in context
        menus, otherwise `false`.

        Since Qt 5.13, the setShowShortcutsInContextMenus() function can be used
        to override the platform default.

        This property was introduced in Qt 5.10.

        **Access functions:**

        bool **showShortcutsInContextMenus** () const
        void
        **setShowShortcutsInContextMenus** (bool **showShortcutsInContextMenus**
        )

        **Notifier signal:**

        void **showShortcutsInContextMenusChanged** ( **bool** )
        """
        ...

    def wheelScrollLines(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#wheelScrollLines-prop

        **wheelScrollLines : const int**

        Number of lines to scroll by default for each wheel click.

        This property was introduced in Qt 5.9.

        **Access functions:**

        int **wheelScrollLines** () const

        **Notifier signal:**

        void **wheelScrollLinesChanged** (int **scrollLines** )
        """
        ...

    def setUseHoverEffects(self, useHoverEffects: bool) -> None:
        """
        https://doc.qt.io/qt-5/qstylehints.html#useHoverEffects-prop

        **useHoverEffects : bool**

        This property holds whether UI elements use hover effects.

        This property is `true` if UI elements should use hover effects. This is
        the standard behavior on desktop platforms with a mouse pointer, whereas
        on touch platforms the overhead of hover event delivery can be avoided.

        This property was introduced in Qt 5.8.

        **Access functions:**

        bool **useHoverEffects** () const
        void **setUseHoverEffects** (bool
        **useHoverEffects** )

        **Notifier signal:**

        void **useHoverEffectsChanged** (bool **useHoverEffects** )
        """
        ...

    def useHoverEffects(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstylehints.html#useHoverEffects-prop

        **useHoverEffects : bool**

        This property holds whether UI elements use hover effects.

        This property is `true` if UI elements should use hover effects. This is
        the standard behavior on desktop platforms with a mouse pointer, whereas
        on touch platforms the overhead of hover event delivery can be avoided.

        This property was introduced in Qt 5.8.

        **Access functions:**

        bool **useHoverEffects** () const
        void **setUseHoverEffects** (bool
        **useHoverEffects** )

        **Notifier signal:**

        void **useHoverEffectsChanged** (bool **useHoverEffects** )
        """
        ...

    def showIsMaximized(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstylehints.html#showIsMaximized-prop

        **showIsMaximized : const bool**

        This property holds whether the platform defaults to maximized windows.

        This property is `true` if the platform defaults to windows being
        maximized, otherwise `false`.

        **Note:** The platform may still choose to show certain windows non-
        maximized, such as popups or dialogs. This property only reports the
        default behavior.

        This property was introduced in Qt 5.6.

        **Access functions:**

        bool **showIsMaximized** () const

        **See also** **QWindow::show** () and **showIsFullScreen** ().
        """
        ...

    def singleClickActivation(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstylehints.html#singleClickActivation-prop

        **singleClickActivation : const bool**

        This property holds whether items are activated by single or double
        click.

        This property is `true` if items should be activated by single click,
        `false` if they should be activated by double click instead.

        This property was introduced in Qt 5.5.

        **Access functions:**

        bool **singleClickActivation** () const
        """
        ...

    def tabFocusBehavior(self) -> QtCore.Qt.TabFocusBehavior:
        """
        https://doc.qt.io/qt-5/qstylehints.html#tabFocusBehavior-prop

        **tabFocusBehavior : const Qt::TabFocusBehavior**

        This property holds the focus behavior on press of the tab key.

        **Note:** Do not bind this value in QML because the change notifier
        signal is not implemented yet.

        This property was introduced in Qt 5.5.

        **Access functions:**

        Qt::TabFocusBehavior **tabFocusBehavior** () const

        **Notifier signal:**

        void **tabFocusBehaviorChanged** (Qt::TabFocusBehavior
        **tabFocusBehavior** )
        """
        ...

    def mousePressAndHoldInterval(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#mousePressAndHoldInterval-prop

        **mousePressAndHoldInterval : const int**

        This property holds the time limit in milliseconds that activates a
        press and hold.

        This property was introduced in Qt 5.3.

        **Access functions:**

        int **mousePressAndHoldInterval** () const

        **Notifier signal:**

        void **mousePressAndHoldIntervalChanged** (int
        **mousePressAndHoldInterval** )
        """
        ...

    def setFocusOnTouchRelease(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstylehints.html#setFocusOnTouchRelease-prop

        **setFocusOnTouchRelease : const bool**

        This property holds the event that should set input focus on focus
        objects.

        This property is `true` if focus objects (line edits etc) should receive
        input focus after a touch/mouse release. This is normal behavior on
        touch platforms. On desktop platforms, the standard is to set focus
        already on touch/mouse press.

        **Access functions:**

        bool **setFocusOnTouchRelease** () const
        """
        ...

    def passwordMaskCharacter(self) -> str:
        """
        https://doc.qt.io/qt-5/qstylehints.html#passwordMaskCharacter-prop

        **passwordMaskCharacter : const QChar**

        This property holds the character used to mask the characters typed into
        text input fields in password mode.

        **Access functions:**

        QChar **passwordMaskCharacter** () const
        """
        ...

    def useRtlExtensions(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstylehints.html#useRtlExtensions-prop

        **useRtlExtensions : const bool**

        This property holds the writing direction.

        This property is `true` if right-to-left writing direction is enabled,
        otherwise `false`.

        **Access functions:**

        bool **useRtlExtensions** () const
        """
        ...

    def fontSmoothingGamma(self) -> float:
        """
        https://doc.qt.io/qt-5/qstylehints.html#fontSmoothingGamma-prop

        **fontSmoothingGamma : const qreal**

        This property holds the gamma value used in font smoothing.

        **Access functions:**

        qreal **fontSmoothingGamma** () const
        """
        ...

    def passwordMaskDelay(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#passwordMaskDelay-prop

        **passwordMaskDelay : const int**

        This property holds the time, in milliseconds, a typed letter is
        displayed unshrouded in a text input field in password mode.

        **Access functions:**

        int **passwordMaskDelay** () const
        """
        ...

    def showIsFullScreen(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstylehints.html#showIsFullScreen-prop

        **showIsFullScreen : const bool**

        This property holds whether the platform defaults to fullscreen windows.

        This property is `true` if the platform defaults to windows being
        fullscreen, otherwise `false`.

        **Note:** The platform may still choose to show certain windows non-
        fullscreen, such as popups or dialogs. This property only reports the
        default behavior.

        **Access functions:**

        bool **showIsFullScreen** () const

        **See also** **QWindow::show** () and **showIsMaximized** ().
        """
        ...

    def cursorFlashTime(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#cursorFlashTime-prop

        **cursorFlashTime : const int**

        This property holds the text cursor's flash (blink) time in
        milliseconds.

        The flash time is the time used to display, invert and restore the caret
        display. Usually the text cursor is displayed for half the cursor flash
        time, then hidden for the same amount of time.

        **Access functions:**

        int **cursorFlashTime** () const

        **Notifier signal:**

        void **cursorFlashTimeChanged** (int **cursorFlashTime** )
        """
        ...

    def keyboardAutoRepeatRate(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#keyboardAutoRepeatRate-prop

        **keyboardAutoRepeatRate : const int**

        This property holds the rate, in events per second, in which additional
        repeated key presses will automatically be generated if a key is being
        held down.

        **Access functions:**

        int **keyboardAutoRepeatRate** () const
        """
        ...

    def keyboardInputInterval(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#keyboardInputInterval-prop

        **keyboardInputInterval : const int**

        This property holds the time limit, in milliseconds, that distinguishes
        a key press from two consecutive key presses.

        **Access functions:**

        int **keyboardInputInterval** () const

        **Notifier signal:**

        void **keyboardInputIntervalChanged** (int **keyboardInputInterval** )
        """
        ...

    def startDragVelocity(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#startDragVelocity-prop

        **startDragVelocity : const int**

        This property holds the limit for the velocity, in pixels per second,
        that the mouse may be moved, with a button held down, for a drag and
        drop operation to begin. A value of 0 means there is no such limit.

        **Access functions:**

        int **startDragVelocity** () const

        **See also** **startDragDistance**  and **Drag and Drop** .
        """
        ...

    def startDragTime(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#startDragTime-prop

        **startDragTime : const int**

        This property holds the time, in milliseconds, that a mouse button must
        be held down before a drag and drop operation will begin.

        If you support drag and drop in your application, and want to start a
        drag and drop operation after the user has held down a mouse button for
        a certain amount of time, you should use this property's value as the
        delay.

        **Access functions:**

        int **startDragTime** () const

        **Notifier signal:**

        void **startDragTimeChanged** (int **startDragTime** )

        **See also** **startDragDistance**  and **Drag and Drop** .
        """
        ...

    def startDragDistance(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#startDragDistance-prop

        **startDragDistance : const int**

        This property holds the distance, in pixels, that the mouse must be
        moved with a button held down before a drag and drop operation will
        begin.

        If you support drag and drop in your application, and want to start a
        drag and drop operation after the user has moved the cursor a certain
        distance with a button held down, you should use this property's value
        as the minimum distance required.

        For example, if the mouse position of the click is stored in `startPos`
        and the current position (e.g. in the mouse move event) is `currentPos`,
        you can find out if a drag should be started with code like this:

        if ((startPos - currentPos).manhattanLength() >=
        **QApplication** ::startDragDistance())
                startTheDrag();

        **Access functions:**

        int **startDragDistance** () const

        **Notifier signal:**

        void **startDragDistanceChanged** (int **startDragDistance** )

        **See also** **startDragTime** , **QPoint::manhattanLength** (), and
        **Drag and Drop** .
        """
        ...

    def mouseDoubleClickInterval(self) -> int:
        """
        https://doc.qt.io/qt-5/qstylehints.html#mouseDoubleClickInterval-prop

        **mouseDoubleClickInterval : const int**

        This property holds the time limit in milliseconds that distinguishes a
        double click from two consecutive mouse clicks.

        **Access functions:**

        int **mouseDoubleClickInterval** () const

        **Notifier signal:**

        void **mouseDoubleClickIntervalChanged** (int
        **mouseDoubleClickInterval** )
        """
        ...

    @property
    def cursorFlashTimeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def keyboardInputIntervalChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def mouseDoubleClickIntervalChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def mousePressAndHoldIntervalChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def mouseQuickSelectionThresholdChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def showShortcutsInContextMenusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def startDragDistanceChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def startDragTimeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def tabFocusBehaviorChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def useHoverEffectsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def wheelScrollLinesChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
