"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QStaticText(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qstatictext.html

    **Detailed Description**

    QStaticText provides a way to cache layout data for a block of text so that
    it can be drawn more efficiently than by using **QPainter::drawText** () in
    which the layout information is recalculated with every call.

    The class primarily provides an optimization for cases where the text, its
    font and the transformations on the painter are static over several paint
    events. If the text or its layout is changed for every iteration,
    **QPainter::drawText** () is the more efficient alternative, since the
    static text's layout would have to be recalculated to take the new state
    into consideration.

    Translating the painter will not cause the layout of the text to be
    recalculated, but will cause a very small performance impact on
    drawStaticText(). Altering any other parts of the painter's transformation
    or the painter's font will cause the layout of the static text to be
    recalculated. This should be avoided as often as possible to maximize the
    performance benefit of using QStaticText.

    In addition, only affine transformations are supported by drawStaticText().
    Calling drawStaticText() on a projected painter will perform slightly worse
    than using the regular drawText() call, so this should be avoided.

    class MyWidget: public **QWidget**
        {
        public:
    MyWidget(**QWidget**  *parent = 0) : **QWidget** (parent),
    m_staticText("This is static text")

        protected:
            void
    paintEvent(**QPaintEvent**  *)
            {
                **QPainter**
    painter(this);
                painter.drawStaticText(0, 0, m_staticText);
    }

        private:
            **QStaticText**  m_staticText;
        };

    The QStaticText class can be used to mimic the behavior of
    **QPainter::drawText** () to a specific point with no boundaries, and also
    when **QPainter::drawText** () is called with a bounding rectangle.

    If a bounding rectangle is not required, create a QStaticText object without
    setting a preferred text width. The text will then occupy a single line.

    If you set a text width on the QStaticText object, this will bound the text.
    The text will be formatted so that no line exceeds the given width. The text
    width set for QStaticText will not automatically be used for clipping. To
    achieve clipping in addition to line breaks, use **QPainter::setClipRect**
    (). The position of the text is decided by the argument passed to
    **QPainter::drawStaticText** () and can change from call to call with a
    minimal impact on performance.

    For extra convenience, it is possible to apply formatting to the text using
    the HTML subset supported by **QTextDocument** . QStaticText will attempt to
    guess the format of the input text using **Qt::mightBeRichText** (), and
    interpret it as rich text if this function returns `true`. To force
    QStaticText to display its contents as either plain text or rich text, use
    the function **QStaticText::setTextFormat** () and pass in, respectively,
    **Qt::PlainText**  and **Qt::RichText** .

    QStaticText can only represent text, so only HTML tags which alter the
    layout or appearance of the text will be respected. Adding an image to the
    input HTML, for instance, will cause the image to be included as part of the
    layout, affecting the positions of the text glyphs, but it will not be
    displayed. The result will be an empty area the size of the image in the
    output. Similarly, using tables will cause the text to be laid out in table
    format, but the borders will not be drawn.

    If it's the first time the static text is drawn, or if the static text, or
    the painter's font has been altered since the last time it was drawn, the
    text's layout has to be recalculated. On some paint engines, changing the
    matrix of the painter will also cause the layout to be recalculated. In
    particular, this will happen for any engine except for the OpenGL2 paint
    engine. Recalculating the layout will impose an overhead on the
    **QPainter::drawStaticText** () call where it occurs. To avoid this overhead
    in the paint event, you can call **prepare** () ahead of time to ensure that
    the layout is calculated.

    **See also** **QPainter::drawText** (), **QPainter::drawStaticText** (),
    **QTextLayout** , and **QTextDocument** .
    """

    class PerformanceHint(int):
        ModerateCaching: QStaticText = ...
        AggressiveCaching: QStaticText = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qstatictext.html#QStaticText

        **QStaticText::QStaticText()**

        Constructs an empty QStaticText
        """
        ...

    @typing.overload
    def __init__(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qstatictext.html#QStaticText-1

        **QStaticText::QStaticText(const QString & text )**

        Constructs a QStaticText object with the given **text**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QStaticText") -> None:
        """
        https://doc.qt.io/qt-5/qstatictext.html#QStaticText-2

        **QStaticText::QStaticText(const QStaticText & other )**

        Constructs a QStaticText object which is a copy of **other**.
        """
        ...

    def swap(self, other: "QStaticText") -> None:
        """
        https://doc.qt.io/qt-5/qstatictext.html#swap

        **void QStaticText::swap(QStaticText & other )**

        Swaps this static text instance with **other**. This function is very
        fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def performanceHint(self) -> "QStaticText.PerformanceHint":
        """
        https://doc.qt.io/qt-5/qstatictext.html#performanceHint

        **QStaticText::PerformanceHint QStaticText::performanceHint() const**

        Returns which performance hint is set for the **QStaticText** .

        **See also** **setPerformanceHint** ().
        """
        ...

    def setPerformanceHint(
        self, performanceHint: "QStaticText.PerformanceHint"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstatictext.html#setPerformanceHint

        **void QStaticText::setPerformanceHint(QStaticText::PerformanceHint
        performanceHint )**

        Sets the performance hint of the **QStaticText**  according to the
        **performanceHint** provided. The **performanceHint** is used to
        customize how much caching is done internally to improve performance.

        The default is **QStaticText::ModerateCaching** .

        **Note:** This function will cause the layout of the text to require
        recalculation.

        **See also** **performanceHint** ().
        """
        ...

    def prepare(self, matrix: "QTransform" = ..., font: QFont = ...) -> None:
        """
        https://doc.qt.io/qt-5/qstatictext.html#prepare

        **void QStaticText::prepare(const QTransform & matrix = QTransform(),
        const QFont & font = QFont())**

        Prepares the **QStaticText**  object for being painted with the given
        **matrix** and the given **font** to avoid overhead when the actual
        drawStaticText() call is made.

        When drawStaticText() is called, the layout of the **QStaticText**  will
        be recalculated if any part of the **QStaticText**  object has changed
        since the last time it was drawn. It will also be recalculated if the
        painter's font is not the same as when the **QStaticText**  was last
        drawn, or, on any other paint engine than the OpenGL2 engine, if the
        painter's matrix has been altered since the static text was last drawn.

        To avoid the overhead of creating the layout the first time you draw the
        **QStaticText**  after making changes, you can use the prepare()
        function and pass in the **matrix** and **font** you expect to use when
        drawing the text.

        **See also** **QPainter::setFont** () and **QPainter::setMatrix** ().
        """
        ...

    def size(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-5/qstatictext.html#size

        **QSizeF QStaticText::size() const**

        Returns the size of the bounding rect for this **QStaticText** .

        **See also** **textWidth** ().
        """
        ...

    def textOption(self) -> "QTextOption":
        """
        https://doc.qt.io/qt-5/qstatictext.html#textOption

        **QTextOption QStaticText::textOption() const**

        Returns the current text option used to control the layout process.

        **See also** **setTextOption** ().
        """
        ...

    def setTextOption(self, textOption: "QTextOption") -> None:
        """
        https://doc.qt.io/qt-5/qstatictext.html#setTextOption

        **void QStaticText::setTextOption(const QTextOption & textOption )**

        Sets the text option structure that controls the layout process to the
        given **textOption**.

        **See also** **textOption** ().
        """
        ...

    def textWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qstatictext.html#textWidth

        **qreal QStaticText::textWidth() const**

        Returns the preferred width for this **QStaticText** .

        **See also** **setTextWidth** ().
        """
        ...

    def setTextWidth(self, textWidth: float) -> None:
        """
        https://doc.qt.io/qt-5/qstatictext.html#setTextWidth

        **void QStaticText::setTextWidth(qreal textWidth )**

        Sets the preferred width for this **QStaticText** . If the text is wider
        than the specified width, it will be broken into multiple lines and grow
        vertically. If the text cannot be split into multiple lines, it will be
        larger than the specified **textWidth**.

        Setting the preferred text width to a negative number will cause the
        text to be unbounded.

        Use **size** () to get the actual size of the text.

        **Note:** This function will cause the layout of the text to require
        recalculation.

        **See also** **textWidth** () and **size** ().
        """
        ...

    def textFormat(self) -> QtCore.Qt.TextFormat:
        """
        https://doc.qt.io/qt-5/qstatictext.html#textFormat

        **Qt::TextFormat QStaticText::textFormat() const**

        Returns the text format of the **QStaticText** .

        **See also** **setTextFormat** (), **setText** (), and **text** ().
        """
        ...

    def setTextFormat(self, textFormat: QtCore.Qt.TextFormat) -> None:
        """
        https://doc.qt.io/qt-5/qstatictext.html#setTextFormat

        **void QStaticText::setTextFormat(Qt::TextFormat textFormat )**

        Sets the text format of the **QStaticText**  to **textFormat**. If
        **textFormat** is set to **Qt::AutoText**  (the default), the format of
        the text will try to be determined using the function
        **Qt::mightBeRichText** (). If the text format is **Qt::PlainText** ,
        then the text will be displayed as is, whereas it will be interpreted as
        HTML if the format is **Qt::RichText** . HTML tags that alter the font
        of the text, its color, or its layout are supported by **QStaticText** .

        **Note:** This function will cause the layout of the text to require
        recalculation.

        **See also** **textFormat** (), **setText** (), and **text** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qstatictext.html#text

        **QString QStaticText::text() const**

        Returns the text of the **QStaticText** .

        **See also** **setText** ().
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qstatictext.html#setText

        **void QStaticText::setText(const QString & text )**

        Sets the text of the **QStaticText**  to **text**.

        **Note:** This function will cause the layout of the text to require
        recalculation.

        **See also** **text** ().
        """
        ...
