"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QScreen(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qscreen.html

    **Detailed Description**

    A note on logical vs physical dots per inch: physical DPI is based on the
    actual physical pixel sizes when available, and is useful for print preview
    and other cases where it's desirable to know the exact physical dimensions
    of screen displayed contents.

    Logical dots per inch are used to convert font and user interface elements
    from point sizes to pixel sizes, and might be different from the physical
    dots per inch. The logical dots per inch are sometimes user-settable in the
    desktop environment's settings panel, to let the user globally control UI
    and font sizes in different applications.
    """

    def virtualSiblingAt(self, point: QtCore.QPoint) -> "QScreen":
        """
        https://doc.qt.io/qt-5/qscreen.html#virtualSiblingAt

        **QScreen *QScreen::virtualSiblingAt(QPoint point )**

        Returns the screen at **point** within the set of
        **QScreen::virtualSiblings** (), or `nullptr` if outside of any screen.

        The **point** is in relation to the **virtualGeometry** () of each set
        of virtual siblings.

        This function was introduced in Qt 5.15.
        """
        ...

    def serialNumber(self) -> str:
        """
        https://doc.qt.io/qt-5/qscreen.html#serialNumber-prop

        **serialNumber : const QString**

        This property holds the serial number of the screen

        This property was introduced in Qt 5.9.

        **Access functions:**

        QString **serialNumber** () const
        """
        ...

    def model(self) -> str:
        """
        https://doc.qt.io/qt-5/qscreen.html#model-prop

        **model : const QString**

        This property holds the model of the screen

        This property was introduced in Qt 5.9.

        **Access functions:**

        QString **model** () const
        """
        ...

    def manufacturer(self) -> str:
        """
        https://doc.qt.io/qt-5/qscreen.html#manufacturer-prop

        **manufacturer : const QString**

        This property holds the manufacturer of the screen

        This property was introduced in Qt 5.9.

        **Access functions:**

        QString **manufacturer** () const
        """
        ...

    def availableGeometryChanged(self, geometry: QtCore.QRect) -> None:
        ...

    def virtualGeometryChanged(self, rect: QtCore.QRect) -> None:
        ...

    def logicalDotsPerInchChanged(self, dpi: float) -> None:
        ...

    def physicalDotsPerInchChanged(self, dpi: float) -> None:
        ...

    def geometryChanged(self, geometry: QtCore.QRect) -> None:
        ...

    def devicePixelRatio(self) -> float:
        """
        https://doc.qt.io/qt-5/qscreen.html#devicePixelRatio-prop

        **devicePixelRatio : const qreal**

        This property holds the screen's ratio between physical pixels and
        device-independent pixels

        Returns the ratio between physical pixels and device-independent pixels
        for the screen.

        Common values are 1.0 on normal displays and 2.0 on "retina" displays.
        Higher values are also possible.

        This property was introduced in Qt 5.5.

        **Access functions:**

        qreal **devicePixelRatio** () const

        **Notifier signal:**

        void ****physicalDotsPerInchChanged** ** (qreal **dpi** )

        **See also** **QWindow::devicePixelRatio** () and
        **QGuiApplication::devicePixelRatio** ().
        """
        ...

    def refreshRate(self) -> float:
        """
        https://doc.qt.io/qt-5/qscreen.html#refreshRate-prop

        **refreshRate : const qreal**

        This property holds the approximate vertical refresh rate of the screen
        in Hz

        **Access functions:**

        qreal **refreshRate** () const

        **Notifier signal:**

        void **refreshRateChanged** (qreal **refreshRate** )
        """
        ...

    def grabWindow(
        self,
        window: PyQt5.sip.voidptr,
        x: int = ...,
        y: int = ...,
        width: int = ...,
        height: int = ...,
    ) -> QPixmap:
        """
        https://doc.qt.io/qt-5/qscreen.html#grabWindow

        **QPixmap QScreen::grabWindow(WId window , int x = 0, int y = 0, int
        width = -1, int height = -1)**

        Creates and returns a pixmap constructed by grabbing the contents of the
        given **window** restricted by **QRect** ( **x** , **y** , **width** ,
        **height** ).

        The arguments ( **x** , **y** ) specify the offset in the window,
        whereas ( **width** , **height** ) specify the area to be copied. If
        **width** is negative, the function copies everything to the right
        border of the window. If **height** is negative, the function copies
        everything to the bottom of the window.

        The offset and size arguments are specified in device independent
        pixels. The returned pixmap may be larger than the requested size when
        grabbing from a high-DPI screen. Call **QPixmap::devicePixelRatio** ()
        to determine if this is the case.

        The window system identifier (`WId`) can be retrieved using the
        **QWidget::winId** () function. The rationale for using a window
        identifier and not a **QWidget** , is to enable grabbing of windows that
        are not part of the application, window system frames, and so on.

        **Warning:** Grabbing windows that are not part of the application is
        not supported on systems such as iOS, where sandboxing/security prevents
        reading pixels of windows not owned by the application.

        The grabWindow() function grabs pixels from the screen, not from the
        window, i.e. if there is another window partially or entirely over the
        one you grab, you get pixels from the overlying window, too. The mouse
        cursor is generally not grabbed.

        Note on X11 that if the given **window** doesn't have the same depth as
        the root window, and another window partially or entirely obscures the
        one you grab, you will **not** get pixels from the overlying window. The
        contents of the obscured areas in the pixmap will be undefined and
        uninitialized.

        On Windows Vista and above grabbing a layered window, which is created
        by setting the **Qt::WA_TranslucentBackground**  attribute, will not
        work. Instead grabbing the desktop widget should work.

        **Warning:** In general, grabbing an area outside the screen is not
        safe. This depends on the underlying window system.
        """
        ...

    def isLandscape(self, orientation: QtCore.Qt.ScreenOrientation) -> bool:
        """
        https://doc.qt.io/qt-5/qscreen.html#isLandscape

        **bool QScreen::isLandscape(Qt::ScreenOrientation o ) const**

        Convenience function that returns `true` if **o** is either landscape or
        inverted landscape; otherwise returns `false`.

        **Qt::PrimaryOrientation**  is interpreted as the screen's
        **primaryOrientation** ().
        """
        ...

    def isPortrait(self, orientation: QtCore.Qt.ScreenOrientation) -> bool:
        """
        https://doc.qt.io/qt-5/qscreen.html#isPortrait

        **bool QScreen::isPortrait(Qt::ScreenOrientation o ) const**

        Convenience function that returns `true` if **o** is either portrait or
        inverted portrait; otherwise returns `false`.

        **Qt::PrimaryOrientation**  is interpreted as the screen's
        **primaryOrientation** ().
        """
        ...

    def mapBetween(
        self,
        a: QtCore.Qt.ScreenOrientation,
        b: QtCore.Qt.ScreenOrientation,
        rect: QtCore.QRect,
    ) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qscreen.html#mapBetween

        **QRect QScreen::mapBetween(Qt::ScreenOrientation a ,
        Qt::ScreenOrientation b , const QRect & rect ) const**

        Maps the rect between two screen orientations.

        This will flip the x and y dimensions of the rectangle **rect** if the
        orientation **a** is **Qt::PortraitOrientation**  or
        **Qt::InvertedPortraitOrientation**  and orientation **b** is
        **Qt::LandscapeOrientation**  or **Qt::InvertedLandscapeOrientation** ,
        or vice versa.

        **Qt::PrimaryOrientation**  is interpreted as the screen's
        **primaryOrientation** ().
        """
        ...

    def transformBetween(
        self,
        a: QtCore.Qt.ScreenOrientation,
        b: QtCore.Qt.ScreenOrientation,
        target: QtCore.QRect,
    ) -> "QTransform":
        """
        https://doc.qt.io/qt-5/qscreen.html#transformBetween

        **QTransform QScreen::transformBetween(Qt::ScreenOrientation a ,
        Qt::ScreenOrientation b , const QRect & target ) const**

        Convenience function to compute a transform that maps from the
        coordinate system defined by orientation **a** into the coordinate
        system defined by orientation **b** and target dimensions **target**.

        Example, **a** is Qt::Landscape, **b** is Qt::Portrait, and **target**
        is **QRect** (0, 0, w, h) the resulting transform will be such that the
        point **QPoint** (0, 0) is mapped to **QPoint** (0, w), and **QPoint**
        (h, w) is mapped to **QPoint** (0, h). Thus, the landscape coordinate
        system **QRect** (0, 0, h, w) is mapped (with a 90 degree rotation) into
        the portrait coordinate system **QRect** (0, 0, w, h).

        **Qt::PrimaryOrientation**  is interpreted as the screen's
        **primaryOrientation** ().
        """
        ...

    def angleBetween(
        self, a: QtCore.Qt.ScreenOrientation, b: QtCore.Qt.ScreenOrientation
    ) -> int:
        """
        https://doc.qt.io/qt-5/qscreen.html#angleBetween

        **int QScreen::angleBetween(Qt::ScreenOrientation a ,
        Qt::ScreenOrientation b ) const**

        Convenience function to compute the angle of rotation to get from
        rotation **a** to rotation **b**.

        The result will be 0, 90, 180, or 270.

        **Qt::PrimaryOrientation**  is interpreted as the screen's
        **primaryOrientation** ().
        """
        ...

    def setOrientationUpdateMask(
        self,
        mask: typing.Union[QtCore.Qt.ScreenOrientations, QtCore.Qt.ScreenOrientation],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qscreen.html#setOrientationUpdateMask

        **void QScreen::setOrientationUpdateMask(Qt::ScreenOrientations mask )**

        Sets the orientations that the application is interested in receiving
        updates for in conjunction with this screen.

        For example, to receive **orientation** () updates and thus have
        **orientationChanged** () signals being emitted for LandscapeOrientation
        and InvertedLandscapeOrientation, call setOrientationUpdateMask() with
        **mask** set to **Qt::LandscapeOrientation**  |
        **Qt::InvertedLandscapeOrientation** .

        The default, 0, means no **orientationChanged** () signals are fired.

        **See also** **orientationUpdateMask** ().
        """
        ...

    def orientationUpdateMask(self) -> QtCore.Qt.ScreenOrientations:
        """
        https://doc.qt.io/qt-5/qscreen.html#orientationUpdateMask

        **Qt::ScreenOrientations QScreen::orientationUpdateMask() const**

        Returns the currently set orientation update mask.

        **See also** **setOrientationUpdateMask** ().
        """
        ...

    def orientation(self) -> QtCore.Qt.ScreenOrientation:
        """
        https://doc.qt.io/qt-5/qscreen.html#orientation-prop

        **orientation : const Qt::ScreenOrientation**

        This property holds the screen orientation

        The screen orientation represents the physical orientation of the
        display. For example, the screen orientation of a mobile device will
        change based on how it is being held. A change to the orientation might
        or might not trigger a change to the primary orientation of the screen.

        Changes to this property will be filtered by **orientationUpdateMask**
        (), so in order to receive orientation updates the application must
        first call **setOrientationUpdateMask** () with a mask of the
        orientations it wants to receive.

        **Qt::PrimaryOrientation**  is never returned.

        **Access functions:**

        Qt::ScreenOrientation **orientation** () const

        **Notifier signal:**

        void ****orientationChanged** ** (Qt::ScreenOrientation **orientation**
        )

        **See also** **primaryOrientation** ().
        """
        ...

    def primaryOrientation(self) -> QtCore.Qt.ScreenOrientation:
        """
        https://doc.qt.io/qt-5/qscreen.html#primaryOrientation-prop

        **primaryOrientation : const Qt::ScreenOrientation**

        This property holds the primary screen orientation

        The primary screen orientation is **Qt::LandscapeOrientation**  if the
        screen geometry's width is greater than or equal to its height, or
        **Qt::PortraitOrientation**  otherwise. This property might change when
        the screen orientation was changed (i.e. when the display is rotated).
        The behavior is however platform dependent and can often be specified in
        an application manifest file.

        **Access functions:**

        Qt::ScreenOrientation **primaryOrientation** () const

        **Notifier signal:**

        void ****primaryOrientationChanged** ** (Qt::ScreenOrientation
        **orientation** )
        """
        ...

    def nativeOrientation(self) -> QtCore.Qt.ScreenOrientation:
        """
        https://doc.qt.io/qt-5/qscreen.html#nativeOrientation-prop

        **nativeOrientation : const Qt::ScreenOrientation**

        This property holds the native screen orientation

        The native orientation of the screen is the orientation where the logo
        sticker of the device appears the right way up, or
        **Qt::PrimaryOrientation**  if the platform does not support this
        functionality.

        The native orientation is a property of the hardware, and does not
        change.

        This property was introduced in Qt 5.2.

        **Access functions:**

        Qt::ScreenOrientation **nativeOrientation** () const
        """
        ...

    def availableVirtualGeometry(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qscreen.html#availableVirtualGeometry-prop

        **availableVirtualGeometry : const QRect**

        This property holds the available geometry of the virtual desktop to
        which this screen belongs

        Returns the available geometry of the virtual desktop corresponding to
        this screen.

        This is the union of the virtual siblings' individual available
        geometries.

        **Access functions:**

        QRect **availableVirtualGeometry** () const

        **Notifier signal:**

        void ****virtualGeometryChanged** ** (const QRect & **rect** )

        **See also** **availableGeometry** () and **virtualSiblings** ().
        """
        ...

    def availableVirtualSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qscreen.html#availableVirtualSize-prop

        **availableVirtualSize : const QSize**

        This property holds the available size of the virtual desktop to which
        this screen belongs

        Returns the available pixel size of the virtual desktop corresponding to
        this screen.

        This is the combined size of the virtual siblings' individual available
        geometries.

        **Access functions:**

        QSize **availableVirtualSize** () const

        **Notifier signal:**

        void ****virtualGeometryChanged** ** (const QRect & **rect** )

        **See also** **availableSize** () and **virtualSiblings** ().
        """
        ...

    def virtualGeometry(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qscreen.html#virtualGeometry-prop

        **virtualGeometry : const QRect**

        This property holds the pixel geometry of the virtual desktop to which
        this screen belongs

        Returns the pixel geometry of the virtual desktop corresponding to this
        screen.

        This is the union of the virtual siblings' individual geometries.

        **Access functions:**

        QRect **virtualGeometry** () const

        **Notifier signal:**

        void ****virtualGeometryChanged** ** (const QRect & **rect** )

        **See also** **virtualSiblings** ().
        """
        ...

    def virtualSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qscreen.html#virtualSize-prop

        **virtualSize : const QSize**

        This property holds the pixel size of the virtual desktop to which this
        screen belongs

        Returns the pixel size of the virtual desktop corresponding to this
        screen.

        This is the combined size of the virtual siblings' individual
        geometries.

        **Access functions:**

        QSize **virtualSize** () const

        **Notifier signal:**

        void ****virtualGeometryChanged** ** (const QRect & **rect** )

        **See also** **virtualSiblings** ().

        **Member Function Documentation**
        """
        ...

    def virtualSiblings(self) -> typing.List["QScreen"]:
        """
        https://doc.qt.io/qt-5/qscreen.html#virtualSiblings

        **QList<QScreen *> QScreen::virtualSiblings() const**

        Get the screen's virtual siblings.

        The virtual siblings are the screen instances sharing the same virtual
        desktop. They share a common coordinate system, and windows can freely
        be moved or positioned across them without having to be re-created.
        """
        ...

    def availableGeometry(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qscreen.html#availableGeometry-prop

        **availableGeometry : const QRect**

        This property holds the screen's available geometry in pixels

        The available geometry is the geometry excluding window manager reserved
        areas such as task bars and system menus.

        Note, on X11 this will return the true available geometry only on
        systems with one monitor and if window manager has set _NET_WORKAREA
        atom. In all other cases this is equal to **geometry** (). This is a
        limitation in X11 window manager specification.

        **Access functions:**

        QRect **availableGeometry** () const

        **Notifier signal:**

        void ****availableGeometryChanged** ** (const QRect & **geometry** )
        """
        ...

    def availableSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qscreen.html#availableSize-prop

        **availableSize : const QSize**

        This property holds the screen's available size in pixels

        The available size is the size excluding window manager reserved areas
        such as task bars and system menus.

        **Access functions:**

        QSize **availableSize** () const

        **Notifier signal:**

        void ****availableGeometryChanged** ** (const QRect & **geometry** )
        """
        ...

    def logicalDotsPerInch(self) -> float:
        """
        https://doc.qt.io/qt-5/qscreen.html#logicalDotsPerInch-prop

        **logicalDotsPerInch : const qreal**

        This property holds the number of logical dots or pixels per inch

        This value can be used to convert font point sizes to pixel sizes.

        This is a convenience property that's simply the average of the
        **logicalDotsPerInchX**  and **logicalDotsPerInchY**  properties.

        **Access functions:**

        qreal **logicalDotsPerInch** () const

        **Notifier signal:**

        void ****logicalDotsPerInchChanged** ** (qreal **dpi** )

        **See also** **logicalDotsPerInchX** () and **logicalDotsPerInchY** ().
        """
        ...

    def logicalDotsPerInchY(self) -> float:
        """
        https://doc.qt.io/qt-5/qscreen.html#logicalDotsPerInchY-prop

        **logicalDotsPerInchY : const qreal**

        This property holds the number of logical dots or pixels per inch in the
        vertical direction

        This value is used to convert font point sizes to pixel sizes.

        **Access functions:**

        qreal **logicalDotsPerInchY** () const

        **Notifier signal:**

        void ****logicalDotsPerInchChanged** ** (qreal **dpi** )

        **See also** **logicalDotsPerInchX** ().
        """
        ...

    def logicalDotsPerInchX(self) -> float:
        """
        https://doc.qt.io/qt-5/qscreen.html#logicalDotsPerInchX-prop

        **logicalDotsPerInchX : const qreal**

        This property holds the number of logical dots or pixels per inch in the
        horizontal direction

        This value is used to convert font point sizes to pixel sizes.

        **Access functions:**

        qreal **logicalDotsPerInchX** () const

        **Notifier signal:**

        void ****logicalDotsPerInchChanged** ** (qreal **dpi** )

        **See also** **logicalDotsPerInchY** ().
        """
        ...

    def physicalDotsPerInch(self) -> float:
        """
        https://doc.qt.io/qt-5/qscreen.html#physicalDotsPerInch-prop

        **physicalDotsPerInch : const qreal**

        This property holds the number of physical dots or pixels per inch

        This value represents the pixel density on the screen's display.
        Depending on what information the underlying system provides the value
        might not be entirely accurate.

        This is a convenience property that's simply the average of the
        **physicalDotsPerInchX**  and **physicalDotsPerInchY**  properties.

        **Access functions:**

        qreal **physicalDotsPerInch** () const

        **Notifier signal:**

        void ****physicalDotsPerInchChanged** ** (qreal **dpi** )

        **See also** **physicalDotsPerInchX** () and **physicalDotsPerInchY**
        ().
        """
        ...

    def physicalDotsPerInchY(self) -> float:
        """
        https://doc.qt.io/qt-5/qscreen.html#physicalDotsPerInchY-prop

        **physicalDotsPerInchY : const qreal**

        This property holds the number of physical dots or pixels per inch in
        the vertical direction

        This value represents the actual vertical pixel density on the screen's
        display. Depending on what information the underlying system provides
        the value might not be entirely accurate.

        **Access functions:**

        qreal **physicalDotsPerInchY** () const

        **Notifier signal:**

        void ****physicalDotsPerInchChanged** ** (qreal **dpi** )

        **See also** **physicalDotsPerInchX** ().
        """
        ...

    def physicalDotsPerInchX(self) -> float:
        """
        https://doc.qt.io/qt-5/qscreen.html#physicalDotsPerInchX-prop

        **physicalDotsPerInchX : const qreal**

        This property holds the number of physical dots or pixels per inch in
        the horizontal direction

        This value represents the actual horizontal pixel density on the
        screen's display. Depending on what information the underlying system
        provides the value might not be entirely accurate.

        **Access functions:**

        qreal **physicalDotsPerInchX** () const

        **Notifier signal:**

        void ****physicalDotsPerInchChanged** ** (qreal **dpi** )

        **See also** **physicalDotsPerInchY** ().
        """
        ...

    def physicalSize(self) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-5/qscreen.html#physicalSize-prop

        **physicalSize : const QSizeF**

        This property holds the screen's physical size (in millimeters)

        The physical size represents the actual physical dimensions of the
        screen's display.

        Depending on what information the underlying system provides the value
        might not be entirely accurate.

        **Access functions:**

        QSizeF **physicalSize** () const

        **Notifier signal:**

        void **physicalSizeChanged** (const QSizeF & **size** )
        """
        ...

    def geometry(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qscreen.html#geometry-prop

        **geometry : const QRect**

        This property holds the screen's geometry in pixels

        As an example this might return **QRect** (0, 0, 1280, 1024), or in a
        virtual desktop setting **QRect** (1280, 0, 1280, 1024).

        **Access functions:**

        QRect **geometry** () const

        **Notifier signal:**

        void ****geometryChanged** ** (const QRect & **geometry** )
        """
        ...

    def size(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qscreen.html#size-prop

        **size : const QSize**

        This property holds the pixel resolution of the screen

        **Access functions:**

        QSize **size** () const

        **Notifier signal:**

        void ****geometryChanged** ** (const QRect & **geometry** )
        """
        ...

    def depth(self) -> int:
        """
        https://doc.qt.io/qt-5/qscreen.html#depth-prop

        **depth : const int**

        This property holds the color depth of the screen

        **Access functions:**

        int **depth** () const
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qscreen.html#name-prop

        **name : const QString**

        This property holds a user presentable string representing the screen

        For example, on X11 these correspond to the XRandr screen names,
        typically "VGA1", "HDMI1", etc.

        **Access functions:**

        QString **name** () const
        """
        ...

    @property
    def orientationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qscreen.html#orientationChanged

        **[signal] void QScreen::orientationChanged(Qt::ScreenOrientation
        orientation )**

        This signal is emitted when the orientation of the screen changes with
        **orientation** as an argument.

        **Note:** Notifier signal for property **orientation** .

        **See also** **orientation** ().
        """
        ...

    @property
    def physicalSizeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def primaryOrientationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qscreen.html#primaryOrientationChanged

        **[signal] void QScreen::primaryOrientationChanged(Qt::ScreenOrientation
        orientation )**

        This signal is emitted when the primary orientation of the screen
        changes with **orientation** as an argument.

        **Note:** Notifier signal for property **primaryOrientation** .

        **See also** **primaryOrientation** ().
        """
        ...

    @property
    def refreshRateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
