"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QRawFont(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qrawfont.html

    **Detailed Description**

    **Note:** QRawFont is a low level class. For most purposes **QFont**  is a
    more appropriate class.

    Most commonly, when presenting text in a user interface, the exact fonts
    used to render the characters is to some extent unknown. This can be the
    case for several reasons: For instance, the actual, physical fonts present
    on the target system could be unexpected to the developers, or the text
    could contain user selected styles, sizes or writing systems that are not
    supported by font chosen in the code.

    Therefore, Qt's **QFont**  class really represents a query for fonts. When
    text is interpreted, Qt will do its best to match the text to the query, but
    depending on the support, different fonts can be used behind the scenes.

    For most use cases, this is both expected and necessary, as it minimizes the
    possibility of text in the user interface being undisplayable. In some
    cases, however, more direct control over the process might be useful. It is
    for these use cases the QRawFont class exists.

    A QRawFont object represents a single, physical instance of a given font in
    a given pixel size. I.e. in the typical case it represents a set of TrueType
    or OpenType font tables and uses a user specified pixel size to convert
    metrics into logical pixel units. It can be used in combination with the
    **QGlyphRun**  class to draw specific glyph indexes at specific positions,
    and also have accessors to some relevant data in the physical font.

    QRawFont only provides support for the main font technologies: GDI and
    DirectWrite on Windows platforms, **FreeType**  on Linux platforms and
    CoreText on macOS. For other font back-ends, the APIs will be disabled.

    QRawFont can be constructed in a number of ways:

    * It can be constructed by calling QTextLayout::glyphs() or
    QTextFragment::glyphs(). The returned QGlyphs objects will contain QRawFont
    objects which represent the actual fonts used to render each portion of the
    text.
      * It can be constructed by passing a **QFont**  object to
    **QRawFont::fromFont** (). The function will return a QRawFont object
    representing the font that will be selected as response to the **QFont**
    query and the selected writing system.
      * It can be constructed by passing
    a file name or **QByteArray**  directly to the QRawFont constructor, or by
    calling **loadFromFile** () or **loadFromData** (). In this case, the font
    will not be registered in **QFontDatabase** , and it will not be available
    as part of regular font selection.

    QRawFont is considered local to the thread in which it is constructed
    (either using a constructor, or by calling **loadFromData** () or
    **loadFromFile** ()). The QRawFont cannot be moved to a different thread,
    but will have to be recreated in the thread in question.

    **Note:** For the requirement of caching glyph indexes and font selections
    for static text to avoid reshaping and relayouting in the inner loop of an
    application, a better choice is the **QStaticText**  class, since it
    optimizes the memory cost of the cache and also provides the possibility of
    paint engine specific caches for an additional speed-up.
    """

    class LayoutFlag(int):
        SeparateAdvances: QRawFont = ...
        KernedAdvances: QRawFont = ...
        UseDesignMetrics: QRawFont = ...

    class AntialiasingType(int):
        PixelAntialiasing: QRawFont = ...
        SubPixelAntialiasing: QRawFont = ...

    class LayoutFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QRawFont.LayoutFlags", "QRawFont.LayoutFlag"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QRawFont.LayoutFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QRawFont.LayoutFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qrawfont.html#QRawFont

        **QRawFont::QRawFont()**

        Constructs an invalid QRawFont.
        """
        ...

    @typing.overload
    def __init__(
        self,
        fileName: str,
        pixelSize: float,
        hintingPreference: QFont.HintingPreference = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qrawfont.html#QRawFont-1

        **QRawFont::QRawFont(const QString & fileName , qreal pixelSize ,
        QFont::HintingPreference hintingPreference =
        QFont::PreferDefaultHinting)**

        Constructs a QRawFont representing the font contained in the file
        referenced by **fileName** for the size (in pixels) given by
        **pixelSize** , and using the hinting preference specified by
        **hintingPreference**.

        **Note:** The referenced file must contain a TrueType or OpenType font.
        """
        ...

    @typing.overload
    def __init__(
        self,
        fontData: typing.Union[QtCore.QByteArray, bytes, bytearray],
        pixelSize: float,
        hintingPreference: QFont.HintingPreference = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qrawfont.html#QRawFont-2

        **QRawFont::QRawFont(const QByteArray & fontData , qreal pixelSize ,
        QFont::HintingPreference hintingPreference =
        QFont::PreferDefaultHinting)**

        Constructs a QRawFont representing the font contained in the supplied
        **fontData** for the size (in pixels) given by **pixelSize** , and using
        the hinting preference specified by **hintingPreference**.

        **Note:** The data must contain a TrueType or OpenType font.
        """
        ...

    @typing.overload
    def __init__(self, other: "QRawFont") -> None:
        """
        https://doc.qt.io/qt-5/qrawfont.html#QRawFont-3

        **QRawFont::QRawFont(const QRawFont & other )**

        Creates a QRawFont which is a copy of **other**.
        """
        ...

    def __hash__(self) -> int:
        ...

    def capHeight(self) -> float:
        """
        https://doc.qt.io/qt-5/qrawfont.html#capHeight

        **qreal QRawFont::capHeight() const**

        Returns the cap height of this **QRawFont**  in pixel units.

        The cap height of a font is the height of a capital letter above the
        baseline. It specifically is the height of capital letters that are flat
        - such as H or I - as opposed to round letters such as O, or pointed
        letters like A, both of which may display overshoot.

        This function was introduced in Qt 5.8.

        **See also** **QFontMetricsF::capHeight** ().
        """
        ...

    def swap(self, other: "QRawFont") -> None:
        """
        https://doc.qt.io/qt-5/qrawfont.html#swap

        **void QRawFont::swap(QRawFont & other )**

        Swaps this raw font with **other**. This function is very fast and never
        fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def underlinePosition(self) -> float:
        """
        https://doc.qt.io/qt-5/qrawfont.html#underlinePosition

        **qreal QRawFont::underlinePosition() const**

        Returns the position from baseline for drawing underlines below the text
        rendered with this font.
        """
        ...

    def lineThickness(self) -> float:
        """
        https://doc.qt.io/qt-5/qrawfont.html#lineThickness

        **qreal QRawFont::lineThickness() const**

        Returns the thickness for drawing lines (underline, overline, etc.)
        along with text drawn in this font.
        """
        ...

    def boundingRect(self, glyphIndex: int) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qrawfont.html#boundingRect

        **QRectF QRawFont::boundingRect(quint32 glyphIndex ) const**

        Returns the smallest rectangle containing the glyph with the given
        **glyphIndex**.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def fromFont(
        font: QFont, writingSystem: QFontDatabase.WritingSystem = ...
    ) -> "QRawFont":
        """
        https://doc.qt.io/qt-5/qrawfont.html#fromFont

        **[static] QRawFont QRawFont::fromFont(const QFont & font ,
        QFontDatabase::WritingSystem writingSystem = QFontDatabase::Any)**

        Fetches the physical representation based on a **font** query. The
        physical font returned is the font that will be preferred by Qt in order
        to display text in the selected **writingSystem**.

        **Warning:** This function is potentially expensive and should not be
        called in performance sensitive code.
        """
        ...

    def fontTable(self, tagName: str) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qrawfont.html#fontTable

        **QByteArray QRawFont::fontTable(const char * tagName ) const**

        Retrieves the sfnt table named **tagName** from the underlying physical
        font, or an empty byte array if no such table was found. The returned
        font table's byte order is Big Endian, like the sfnt format specifies.
        The **tagName** must be four characters long and should be formatted in
        the default endianness of the current platform.
        """
        ...

    def supportedWritingSystems(self) -> typing.List[QFontDatabase.WritingSystem]:
        """
        https://doc.qt.io/qt-5/qrawfont.html#supportedWritingSystems

        **QList<QFontDatabase::WritingSystem>
        QRawFont::supportedWritingSystems() const**

        Returns a list of writing systems supported by the font according to
        designer supplied information in the font file. Please note that this
        does not guarantee support for a specific unicode point in the font. You
        can use the **supportsCharacter** () to check support for a single,
        specific character.

        **Note:** The list is determined based on the unicode ranges and
        codepage ranges set in the font's OS/2 table and requires such a table
        to be present in the underlying font file.

        **See also** **supportsCharacter** ().
        """
        ...

    @typing.overload
    def supportsCharacter(self, ucs4: int) -> bool:
        """
        https://doc.qt.io/qt-5/qrawfont.html#supportsCharacter

        **bool QRawFont::supportsCharacter(QChar character ) const**

        Returns `true` if the font has a glyph that corresponds to the given
        **character**.

        **See also** **supportedWritingSystems** ().
        """
        ...

    @typing.overload
    def supportsCharacter(self, character: str) -> bool:
        """
        https://doc.qt.io/qt-5/qrawfont.html#supportsCharacter-1

        **bool QRawFont::supportsCharacter(uint ucs4 ) const**

        This is an overloaded function.

        Returns `true` if the font has a glyph that corresponds to the UCS-4
        encoded character **ucs4**.

        **See also** **supportedWritingSystems** ().
        """
        ...

    def loadFromData(
        self,
        fontData: typing.Union[QtCore.QByteArray, bytes, bytearray],
        pixelSize: float,
        hintingPreference: QFont.HintingPreference,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qrawfont.html#loadFromData

        **void QRawFont::loadFromData(const QByteArray & fontData , qreal
        pixelSize , QFont::HintingPreference hintingPreference )**

        Replaces the current **QRawFont**  with the font contained in the
        supplied **fontData** for the size (in pixels) given by **pixelSize** ,
        and using the hinting preference specified by **hintingPreference**.

        The **fontData** must contain a TrueType or OpenType font.

        **See also** **loadFromFile** ().
        """
        ...

    def loadFromFile(
        self,
        fileName: str,
        pixelSize: float,
        hintingPreference: QFont.HintingPreference,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qrawfont.html#loadFromFile

        **void QRawFont::loadFromFile(const QString & fileName , qreal pixelSize
        , QFont::HintingPreference hintingPreference )**

        Replaces the current **QRawFont**  with the contents of the file
        referenced by **fileName** for the size (in pixels) given by
        **pixelSize** , and using the hinting preference specified by
        **hintingPreference**.

        The file must reference a TrueType or OpenType font.

        **See also** **loadFromData** ().
        """
        ...

    def unitsPerEm(self) -> float:
        """
        https://doc.qt.io/qt-5/qrawfont.html#unitsPerEm

        **qreal QRawFont::unitsPerEm() const**

        Returns the number of design units define the width and height of the em
        square for this **QRawFont** . This value is used together with the
        pixel size when converting design metrics to pixel units, as the
        internal metrics are specified in design units and the pixel size gives
        the size of 1 em in pixels.

        **See also** **pixelSize** () and **setPixelSize** ().
        """
        ...

    def maxCharWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qrawfont.html#maxCharWidth

        **qreal QRawFont::maxCharWidth() const**

        Returns the width of the widest character in the font.

        **See also** **QFontMetricsF::maxWidth** ().
        """
        ...

    def averageCharWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qrawfont.html#averageCharWidth

        **qreal QRawFont::averageCharWidth() const**

        Returns the average character width of this **QRawFont**  in pixel
        units.

        **See also** **QFontMetricsF::averageCharWidth** ().
        """
        ...

    def xHeight(self) -> float:
        """
        https://doc.qt.io/qt-5/qrawfont.html#xHeight

        **qreal QRawFont::xHeight() const**

        Returns the xHeight of this **QRawFont**  in pixel units.

        This is often but not always the same as the height of the character
        'x'.

        **See also** **QFontMetricsF::xHeight** ().
        """
        ...

    def leading(self) -> float:
        """
        https://doc.qt.io/qt-5/qrawfont.html#leading

        **qreal QRawFont::leading() const**

        Returns the leading of this **QRawFont**  in pixel units.

        This is the natural inter-line spacing.

        **See also** **QFontMetricsF::leading** ().
        """
        ...

    def descent(self) -> float:
        """
        https://doc.qt.io/qt-5/qrawfont.html#descent

        **qreal QRawFont::descent() const**

        Returns the descent of this **QRawFont**  in pixel units.

        The descent is the distance from the base line to the lowest point
        characters extend to. In practice, some font designers break this rule,
        e.g. to accommodate an unusual character in an exotic language, so it is
        possible (though rare) that this value will be too small.

        **See also** **QFontMetricsF::descent** ().
        """
        ...

    def ascent(self) -> float:
        """
        https://doc.qt.io/qt-5/qrawfont.html#ascent

        **qreal QRawFont::ascent() const**

        Returns the ascent of this **QRawFont**  in pixel units.

        The ascent of a font is the distance from the baseline to the highest
        position characters extend to. In practice, some font designers break
        this rule, e.g. when they put more than one accent on top of a
        character, or to accommodate an unusual character in an exotic language,
        so it is possible (though rare) that this value will be too small.

        **See also** **QFontMetricsF::ascent** ().
        """
        ...

    def hintingPreference(self) -> QFont.HintingPreference:
        """
        https://doc.qt.io/qt-5/qrawfont.html#hintingPreference

        **QFont::HintingPreference QRawFont::hintingPreference() const**

        Returns the hinting preference used to construct this **QRawFont** .

        **See also** **QFont::hintingPreference** ().
        """
        ...

    def pixelSize(self) -> float:
        """
        https://doc.qt.io/qt-5/qrawfont.html#pixelSize

        **qreal QRawFont::pixelSize() const**

        Returns the pixel size set for this **QRawFont** . The pixel size
        affects how glyphs are rasterized, the size of glyphs returned by
        **pathForGlyph** (), and is used to convert internal metrics from design
        units to logical pixel units.

        **See also** **setPixelSize** ().
        """
        ...

    def setPixelSize(self, pixelSize: float) -> None:
        """
        https://doc.qt.io/qt-5/qrawfont.html#setPixelSize

        **void QRawFont::setPixelSize(qreal pixelSize )**

        Sets the pixel size with which this font should be rendered to
        **pixelSize**.

        **See also** **pixelSize** ().
        """
        ...

    def pathForGlyph(self, glyphIndex: int) -> QPainterPath:
        """
        https://doc.qt.io/qt-5/qrawfont.html#pathForGlyph

        **QPainterPath QRawFont::pathForGlyph(quint32 glyphIndex ) const**

        This function returns the shape of the glyph at a given **glyphIndex**
        in the underlying font if the **QRawFont**  is valid. Otherwise, it
        returns an empty **QPainterPath** .

        The returned glyph will always be unhinted.

        **See also** **alphaMapForGlyph** () and **QPainterPath::addText** ().
        """
        ...

    def alphaMapForGlyph(
        self,
        glyphIndex: int,
        antialiasingType: "QRawFont.AntialiasingType" = ...,
        transform: "QTransform" = ...,
    ) -> QImage:
        """
        https://doc.qt.io/qt-5/qrawfont.html#alphaMapForGlyph

        **QImage QRawFont::alphaMapForGlyph(quint32 glyphIndex ,
        QRawFont::AntialiasingType antialiasingType = SubPixelAntialiasing,
        const QTransform & transform = QTransform()) const**

        This function returns a rasterized image of the glyph at the given
        **glyphIndex** in the underlying font, using the **transform**
        specified. If the **QRawFont**  is not valid, this function will return
        an invalid **QImage** .

        If the font is a color font, then the resulting image will contain the
        rendered glyph at the current pixel size. In this case, the
        **antialiasingType** will be ignored.

        Otherwise, if **antialiasingType** is set to
        **QRawFont::SubPixelAntialiasing** , then the resulting image will be in
        **QImage::Format_RGB32**  and the RGB values of each pixel will
        represent the subpixel opacities of the pixel in the rasterization of
        the glyph. Otherwise, the image will be in the format of
        **QImage::Format_Indexed8**  and each pixel will contain the opacity of
        the pixel in the rasterization.

        **See also** **pathForGlyph** () and **QPainter::drawGlyphRun** ().
        """
        ...

    @typing.overload
    def advancesForGlyphIndexes(
        self, glyphIndexes: typing.Iterable[int]
    ) -> typing.List[QtCore.QPointF]:
        """
        https://doc.qt.io/qt-5/qrawfont.html#advancesForGlyphIndexes

        **QVector<QPointF> QRawFont::advancesForGlyphIndexes(const
        QVector<quint32> & glyphIndexes , QRawFont::LayoutFlags layoutFlags )
        const**

        Returns the **QRawFont** 's advances for each of the **glyphIndexes** in
        pixel units. The advances give the distance from the position of a given
        glyph to where the next glyph should be drawn to make it appear as if
        the two glyphs are unspaced. How the advances are calculated is
        controlled by **layoutFlags**.

        This function was introduced in Qt 5.1.

        **See also** **QTextLine::horizontalAdvance** () and
        **QFontMetricsF::width** ().
        """
        ...

    @typing.overload
    def advancesForGlyphIndexes(
        self,
        glyphIndexes: typing.Iterable[int],
        layoutFlags: typing.Union["QRawFont.LayoutFlags", "QRawFont.LayoutFlag"],
    ) -> typing.List[QtCore.QPointF]:
        """
        https://doc.qt.io/qt-5/qrawfont.html#advancesForGlyphIndexes-1

        **QVector<QPointF> QRawFont::advancesForGlyphIndexes(const
        QVector<quint32> & glyphIndexes ) const**

        This is an overloaded function.

        Returns the **QRawFont** 's advances for each of the **glyphIndexes** in
        pixel units. The advances give the distance from the position of a given
        glyph to where the next glyph should be drawn to make it appear as if
        the two glyphs are unspaced. The advance of each glyph is calculated
        separately.

        **See also** **QTextLine::horizontalAdvance** () and
        **QFontMetricsF::width** ().
        """
        ...

    def glyphIndexesForString(self, text: str) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qrawfont.html#glyphIndexesForString

        **QVector<quint32> QRawFont::glyphIndexesForString(const QString & text
        ) const**

        Converts the string of unicode points given by **text** to glyph indexes
        using the CMAP table in the underlying font, and returns a vector
        containing the result.

        Note that, in cases where there are other tables in the font that affect
        the shaping of the text, the returned glyph indexes will not correctly
        represent the rendering of the text. To get the correctly shaped text,
        you can use **QTextLayout**  to lay out and shape the text, then call
        QTextLayout::glyphs() to get the set of glyph index list and
        **QRawFont**  pairs.

        **See also** **advancesForGlyphIndexes** (), **glyphIndexesForChars**
        (), **QGlyphRun** , **QTextLayout::glyphRuns** (), and
        **QTextFragment::glyphRuns** ().
        """
        ...

    def weight(self) -> int:
        """
        https://doc.qt.io/qt-5/qrawfont.html#weight

        **int QRawFont::weight() const**

        Returns the weight of this **QRawFont** .

        **See also** **QFont::weight** ().
        """
        ...

    def style(self) -> QFont.Style:
        """
        https://doc.qt.io/qt-5/qrawfont.html#style

        **QFont::Style QRawFont::style() const**

        Returns the style of this **QRawFont** .

        **See also** **QFont::style** ().
        """
        ...

    def styleName(self) -> str:
        """
        https://doc.qt.io/qt-5/qrawfont.html#styleName

        **QString QRawFont::styleName() const**

        Returns the style name of this **QRawFont** .

        **See also** **QFont::styleName** ().
        """
        ...

    def familyName(self) -> str:
        """
        https://doc.qt.io/qt-5/qrawfont.html#familyName

        **QString QRawFont::familyName() const**

        Returns the family name of this **QRawFont** .
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qrawfont.html#isValid

        **bool QRawFont::isValid() const**

        Returns `true` if the **QRawFont**  is valid and false otherwise.
        """
        ...
