"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QRadialGradient(QGradient):
    """
    https://doc.qt.io/qt-5/qradialgradient.html

    **Detailed Description**

    Qt supports both simple and extended radial gradients.

    Simple radial gradients interpolate colors between a focal point and end
    points on a circle surrounding it. Extended radial gradients interpolate
    colors between a focal circle and a center circle. Points outside the cone
    defined by the two circles will be transparent. For simple radial gradients
    the focal point is adjusted to lie inside the center circle, whereas the
    focal point can have any position in an extended radial gradient.

    Outside the end points the gradient is either padded, reflected or repeated
    depending on the currently set **spread**  method:

    ![](images/qradialgradient-pad.png)![](images/qradialgradient-
    reflect.png)![](images/qradialgradient-repeat.png)
    **PadSpread**
    (default)**ReflectSpread** **RepeatSpread**

    The colors in a gradient is defined using stop points of the
    **QGradientStop**  type, i.e. a position and a color. Use the
    **QGradient::setColorAt** () or the **QGradient::setStops** () function to
    define the stop points. It is the gradient's complete set of stop points
    that describes how the gradient area should be filled. If no stop points
    have been specified, a gradient of black at 0 to white at 1 is used.

    In addition to the functions inherited from **QGradient** , the
    QRadialGradient class provides the **center** (), **focalPoint** () and
    **radius** () functions returning the gradient's center, focal point and
    radius respectively.

    **See also** **QLinearGradient** , **QConicalGradient** , and **The
    Gradients Example** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#QRadialGradient

        **QRadialGradient::QRadialGradient()**

        Constructs a simple radial gradient with the center and focal point at
        (0, 0) with a radius of 1.
        """
        ...

    @typing.overload
    def __init__(
        self,
        center: typing.Union[QtCore.QPointF, QtCore.QPoint],
        radius: float,
        focalPoint: typing.Union[QtCore.QPointF, QtCore.QPoint],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#QRadialGradient-1

        **QRadialGradient::QRadialGradient(const QPointF & center , qreal radius
        , const QPointF & focalPoint )**

        Constructs a simple radial gradient with the given **center** ,
        **radius** and **focalPoint**.

        **Note:** If the given focal point is outside the circle defined by the
        **center** point and **radius** , it will be re-adjusted to lie at a
        point on the circle where it intersects with the line from **center** to
        **focalPoint**.

        **See also** **QGradient::setColorAt** () and **QGradient::setStops**
        ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        center: typing.Union[QtCore.QPointF, QtCore.QPoint],
        centerRadius: float,
        focalPoint: typing.Union[QtCore.QPointF, QtCore.QPoint],
        focalRadius: float,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#QRadialGradient-2

        **QRadialGradient::QRadialGradient(qreal cx , qreal cy , qreal radius ,
        qreal fx , qreal fy )**

        Constructs a simple radial gradient with the given center ( **cx** ,
        **cy** ), **radius** and focal point ( **fx** , **fy** ).

        **Note:** If the given focal point is outside the circle defined by the
        center ( **cx** , **cy** ) and the **radius** it will be re-adjusted to
        the intersection between the line from the center to the focal point and
        the circle.

        **See also** **QGradient::setColorAt** () and **QGradient::setStops**
        ().
        """
        ...

    @typing.overload
    def __init__(
        self, center: typing.Union[QtCore.QPointF, QtCore.QPoint], radius: float
    ) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#QRadialGradient-3

        **QRadialGradient::QRadialGradient(const QPointF & center , qreal radius
        )**

        Constructs a simple radial gradient with the given **center** ,
        **radius** and the focal point in the circle center.

        **See also** **QGradient::setColorAt** () and **QGradient::setStops**
        ().
        """
        ...

    @typing.overload
    def __init__(
        self, cx: float, cy: float, radius: float, fx: float, fy: float
    ) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#QRadialGradient-4

        **QRadialGradient::QRadialGradient(qreal cx , qreal cy , qreal radius
        )**

        Constructs a simple radial gradient with the center at ( **cx** , **cy**
        ) and the specified **radius**. The focal point lies at the center of
        the circle.

        **See also** **QGradient::setColorAt** () and **QGradient::setStops**
        ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        cx: float,
        cy: float,
        centerRadius: float,
        fx: float,
        fy: float,
        focalRadius: float,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#QRadialGradient-5

        **QRadialGradient::QRadialGradient(const QPointF & center , qreal
        centerRadius , const QPointF & focalPoint , qreal focalRadius )**

        Constructs an extended radial gradient with the given **center** ,
        **centerRadius** , **focalPoint** , and **focalRadius**.

        This function was introduced in Qt 4.8.
        """
        ...

    @typing.overload
    def __init__(self, cx: float, cy: float, radius: float) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#QRadialGradient-6

        **QRadialGradient::QRadialGradient(qreal cx , qreal cy , qreal
        centerRadius , qreal fx , qreal fy , qreal focalRadius )**

        Constructs an extended radial gradient with the given center ( **cx** ,
        **cy** ), center radius, **centerRadius** , focal point, ( **fx** ,
        **fy** ), and focal radius **focalRadius**.

        This function was introduced in Qt 4.8.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QRadialGradient") -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#QRadialGradient

        **QRadialGradient::QRadialGradient()**

        Constructs a simple radial gradient with the center and focal point at
        (0, 0) with a radius of 1.
        """
        ...

    def setFocalRadius(self, radius: float) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#setFocalRadius

        **void QRadialGradient::setFocalRadius(qreal radius )**

        Sets the focal radius of this radial gradient in logical coordinates to
        **radius**

        This function was introduced in Qt 4.8.

        **See also** **focalRadius** ().
        """
        ...

    def focalRadius(self) -> float:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#focalRadius

        **qreal QRadialGradient::focalRadius() const**

        Returns the focal radius of this radial gradient in logical coordinates.

        This function was introduced in Qt 4.8.

        **See also** **setFocalRadius** () and **QGradient::stops** ().
        """
        ...

    def setCenterRadius(self, radius: float) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#setCenterRadius

        **void QRadialGradient::setCenterRadius(qreal radius )**

        Sets the center radius of this radial gradient in logical coordinates to
        **radius**

        This function was introduced in Qt 4.8.

        **See also** **centerRadius** ().
        """
        ...

    def centerRadius(self) -> float:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#centerRadius

        **qreal QRadialGradient::centerRadius() const**

        Returns the center radius of this radial gradient in logical
        coordinates.

        This function was introduced in Qt 4.8.

        **See also** **setCenterRadius** () and **QGradient::stops** ().
        """
        ...

    def setRadius(self, radius: float) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#setRadius

        **void QRadialGradient::setRadius(qreal radius )**

        Sets the radius of this radial gradient in logical coordinates to
        **radius**

        Equivalent to **setCenterRadius** ()

        This function was introduced in Qt 4.2.

        **See also** **radius** ().
        """
        ...

    @typing.overload
    def setFocalPoint(
        self, focalPoint: typing.Union[QtCore.QPointF, QtCore.QPoint]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#setFocalPoint

        **void QRadialGradient::setFocalPoint(const QPointF & focalPoint )**

        Sets the focal point of this radial gradient in logical coordinates to
        **focalPoint**.

        This function was introduced in Qt 4.2.

        **See also** **focalPoint** ().
        """
        ...

    @typing.overload
    def setFocalPoint(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#setFocalPoint-1

        **void QRadialGradient::setFocalPoint(qreal x , qreal y )**

        This is an overloaded function.

        Sets the focal point of this radial gradient in logical coordinates to (
        **x** , **y** ).

        This function was introduced in Qt 4.2.

        **See also** **focalPoint** ().
        """
        ...

    @typing.overload
    def setCenter(self, center: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#setCenter

        **void QRadialGradient::setCenter(const QPointF & center )**

        Sets the center of this radial gradient in logical coordinates to
        **center**.

        This function was introduced in Qt 4.2.

        **See also** **center** ().
        """
        ...

    @typing.overload
    def setCenter(self, x: float, y: float) -> None:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#setCenter-1

        **void QRadialGradient::setCenter(qreal x , qreal y )**

        This is an overloaded function.

        Sets the center of this radial gradient in logical coordinates to (
        **x** , **y** ).

        This function was introduced in Qt 4.2.

        **See also** **center** ().
        """
        ...

    def radius(self) -> float:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#radius

        **qreal QRadialGradient::radius() const**

        Returns the radius of this radial gradient in logical coordinates.

        Equivalent to **centerRadius** ()

        **See also** **setRadius** () and **QGradient::stops** ().
        """
        ...

    def focalPoint(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#focalPoint

        **QPointF QRadialGradient::focalPoint() const**

        Returns the focal point of this radial gradient in logical coordinates.

        **See also** **setFocalPoint** () and **QGradient::stops** ().
        """
        ...

    def center(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qradialgradient.html#center

        **QPointF QRadialGradient::center() const**

        Returns the center of this radial gradient in logical coordinates.

        **See also** **setCenter** () and **QGradient::stops** ().
        """
        ...
