"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtGui import *
from PyQt5 import sip


class QQuaternion(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qquaternion.html

    **Detailed Description**

    Quaternions are used to represent rotations in 3D space, and consist of a 3D
    rotation axis specified by the x, y, and z coordinates, and a scalar
    representing the rotation angle.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#QQuaternion

        **QQuaternion::QQuaternion()**

        Constructs an identity quaternion (1, 0, 0, 0), i.e. with the vector (0,
        0, 0) and scalar 1.
        """
        ...

    @typing.overload
    def __init__(self, aScalar: float, xpos: float, ypos: float, zpos: float) -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#QQuaternion-2

        **QQuaternion::QQuaternion(float scalar , float xpos , float ypos ,
        float zpos )**

        Constructs a quaternion with the vector ( **xpos** , **ypos** , **zpos**
        ) and **scalar**.
        """
        ...

    @typing.overload
    def __init__(self, aScalar: float, aVector: "QVector3D") -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#QQuaternion-3

        **QQuaternion::QQuaternion(float scalar , const QVector3D & vector )**

        Constructs a quaternion vector from the specified **vector** and
        **scalar**.

        **See also** **vector** () and **scalar** ().
        """
        ...

    @typing.overload
    def __init__(self, aVector: "QVector4D") -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#QQuaternion-4

        **QQuaternion::QQuaternion(const QVector4D & vector )**

        Constructs a quaternion from the components of **vector**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QQuaternion") -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#QQuaternion

        **QQuaternion::QQuaternion()**

        Constructs an identity quaternion (1, 0, 0, 0), i.e. with the vector (0,
        0, 0) and scalar 1.
        """
        ...

    def __neg__(self) -> "QQuaternion":
        ...

    def toEulerAngles(self) -> "QVector3D":
        """
        https://doc.qt.io/qt-5/qquaternion.html#toEulerAngles

        **QVector3D QQuaternion::toEulerAngles() const**

        This is an overloaded function.

        Calculates roll, pitch, and yaw Euler angles (in degrees) that
        corresponds to this quaternion.

        This function was introduced in Qt 5.5.

        **See also** **fromEulerAngles** ().
        """
        ...

    def conjugated(self) -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#conjugated

        **QQuaternion QQuaternion::conjugated() const**

        Returns the conjugate of this quaternion, which is (-x, -y, -z, scalar).

        This function was introduced in Qt 5.5.
        """
        ...

    def inverted(self) -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#inverted

        **QQuaternion QQuaternion::inverted() const**

        Returns the inverse of this quaternion. If this quaternion is null, then
        a null quaternion is returned.

        This function was introduced in Qt 5.5.

        **See also** **isNull** () and **length** ().
        """
        ...

    @staticmethod
    def dotProduct(q1: "QQuaternion", q2: "QQuaternion") -> float:
        """
        https://doc.qt.io/qt-5/qquaternion.html#dotProduct

        **[static] float QQuaternion::dotProduct(const QQuaternion & q1 , const
        QQuaternion & q2 )**

        Returns the dot product of **q1** and **q2**.

        This function was introduced in Qt 5.5.

        **See also** **length** ().
        """
        ...

    @staticmethod
    def rotationTo(from_: "QVector3D", to: "QVector3D") -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#rotationTo

        **[static] QQuaternion QQuaternion::rotationTo(const QVector3D & from ,
        const QVector3D & to )**

        Returns the shortest arc quaternion to rotate from the direction
        described by the vector **from** to the direction described by the
        vector **to**.

        This function was introduced in Qt 5.5.

        **See also** **fromDirection** ().
        """
        ...

    @staticmethod
    def fromDirection(direction: "QVector3D", up: "QVector3D") -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#fromDirection

        **[static] QQuaternion QQuaternion::fromDirection(const QVector3D &
        direction , const QVector3D & up )**

        Constructs the quaternion using specified forward direction
        **direction** and upward direction **up**. If the upward direction was
        not specified or the forward and upward vectors are collinear, a new
        orthonormal upward direction will be generated.

        This function was introduced in Qt 5.5.

        **See also** **fromAxes** () and **rotationTo** ().
        """
        ...

    @staticmethod
    def fromAxes(
        xAxis: "QVector3D", yAxis: "QVector3D", zAxis: "QVector3D"
    ) -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#fromAxes

        **[static] QQuaternion QQuaternion::fromAxes(const QVector3D & xAxis ,
        const QVector3D & yAxis , const QVector3D & zAxis )**

        Constructs the quaternion using 3 axes ( **xAxis** , **yAxis** ,
        **zAxis** ).

        **Note:** The axes are assumed to be orthonormal.

        This function was introduced in Qt 5.5.

        **See also** **getAxes** () and **fromRotationMatrix** ().
        """
        ...

    def getAxes(self) -> typing.Tuple["QVector3D", "QVector3D", "QVector3D"]:
        """
        https://doc.qt.io/qt-5/qquaternion.html#getAxes

        **void QQuaternion::getAxes(QVector3D * xAxis , QVector3D * yAxis ,
        QVector3D * zAxis ) const**

        Returns the 3 orthonormal axes ( **xAxis** , **yAxis** , **zAxis** )
        defining the quaternion.

        This function was introduced in Qt 5.5.

        **See also** **fromAxes** () and **toRotationMatrix** ().
        """
        ...

    @staticmethod
    def fromRotationMatrix(rot3x3: QMatrix3x3) -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#fromRotationMatrix

        **[static] QQuaternion QQuaternion::fromRotationMatrix(const QMatrix3x3
        & rot3x3 )**

        Creates a quaternion that corresponds to a rotation matrix **rot3x3**.

        **Note:** If a given rotation matrix is not normalized, the resulting
        quaternion will contain scaling information.

        This function was introduced in Qt 5.5.

        **See also** **toRotationMatrix** () and **fromAxes** ().
        """
        ...

    def toRotationMatrix(self) -> QMatrix3x3:
        """
        https://doc.qt.io/qt-5/qquaternion.html#toRotationMatrix

        **QMatrix3x3 QQuaternion::toRotationMatrix() const**

        Creates a rotation matrix that corresponds to this quaternion.

        **Note:** If this quaternion is not normalized, the resulting rotation
        matrix will contain scaling information.

        This function was introduced in Qt 5.5.

        **See also** **fromRotationMatrix** () and **getAxes** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromEulerAngles(pitch: float, yaw: float, roll: float) -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#fromEulerAngles

        **[static] QQuaternion QQuaternion::fromEulerAngles(float pitch , float
        yaw , float roll )**

        Creates a quaternion that corresponds to a rotation of **roll** degrees
        around the z axis, **pitch** degrees around the x axis, and **yaw**
        degrees around the y axis (in that order).

        This function was introduced in Qt 5.5.

        **See also** **getEulerAngles** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromEulerAngles(eulerAngles: "QVector3D") -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#fromEulerAngles-1

        **[static] QQuaternion QQuaternion::fromEulerAngles(const QVector3D &
        eulerAngles )**

        This is an overloaded function.

        Creates a quaternion that corresponds to a rotation of **eulerAngles** :
        eulerAngles.**z** () degrees around the z axis, eulerAngles.**x** ()
        degrees around the x axis, and eulerAngles.**y** () degrees around the y
        axis (in that order).

        This function was introduced in Qt 5.5.

        **See also** **toEulerAngles** ().
        """
        ...

    def getEulerAngles(self) -> typing.Tuple[float, float, float]:
        """
        https://doc.qt.io/qt-5/qquaternion.html#getEulerAngles

        **void QQuaternion::getEulerAngles(float * pitch , float * yaw , float *
        roll ) const**

        Calculates **roll** , **pitch** , and **yaw** Euler angles (in degrees)
        that corresponds to this quaternion.

        This function was introduced in Qt 5.5.

        **See also** **fromEulerAngles** ().
        """
        ...

    def getAxisAndAngle(self) -> typing.Tuple["QVector3D", float]:
        """
        https://doc.qt.io/qt-5/qquaternion.html#getAxisAndAngle

        **void QQuaternion::getAxisAndAngle(float * x , float * y , float * z ,
        float * angle ) const**

        Extracts a 3D axis ( **x** , **y** , **z** ) and a rotating angle
        **angle** (in degrees) that corresponds to this quaternion.

        This function was introduced in Qt 5.5.

        **See also** **fromAxisAndAngle** ().
        """
        ...

    def toVector4D(self) -> "QVector4D":
        """
        https://doc.qt.io/qt-5/qquaternion.html#toVector4D

        **QVector4D QQuaternion::toVector4D() const**

        Returns this quaternion as a 4D vector.
        """
        ...

    def vector(self) -> "QVector3D":
        """
        https://doc.qt.io/qt-5/qquaternion.html#vector

        **QVector3D QQuaternion::vector() const**

        Returns the vector component of this quaternion.

        **See also** **setVector** () and **scalar** ().
        """
        ...

    @typing.overload
    def setVector(self, aVector: "QVector3D") -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#setVector

        **void QQuaternion::setVector(const QVector3D & vector )**

        Sets the vector component of this quaternion to **vector**.

        **See also** **vector** () and **setScalar** ().
        """
        ...

    @typing.overload
    def setVector(self, aX: float, aY: float, aZ: float) -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#setVector-1

        **void QQuaternion::setVector(float x , float y , float z )**

        Sets the vector component of this quaternion to ( **x** , **y** , **z**
        ).

        **See also** **vector** () and **setScalar** ().
        """
        ...

    def conjugate(self) -> "QQuaternion":
        ...

    def setScalar(self, aScalar: float) -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#setScalar

        **void QQuaternion::setScalar(float scalar )**

        Sets the scalar component of this quaternion to **scalar**.

        **See also** **scalar** (), **setX** (), **setY** (), and **setZ** ().
        """
        ...

    def setZ(self, aZ: float) -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#setZ

        **void QQuaternion::setZ(float z )**

        Sets the z coordinate of this quaternion's vector to the given **z**
        coordinate.

        **See also** **z** (), **setX** (), **setY** (), and **setScalar** ().
        """
        ...

    def setY(self, aY: float) -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#setY

        **void QQuaternion::setY(float y )**

        Sets the y coordinate of this quaternion's vector to the given **y**
        coordinate.

        **See also** **y** (), **setX** (), **setZ** (), and **setScalar** ().
        """
        ...

    def setX(self, aX: float) -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#setX

        **void QQuaternion::setX(float x )**

        Sets the x coordinate of this quaternion's vector to the given **x**
        coordinate.

        **See also** **x** (), **setY** (), **setZ** (), and **setScalar** ().
        """
        ...

    def scalar(self) -> float:
        """
        https://doc.qt.io/qt-5/qquaternion.html#scalar

        **float QQuaternion::scalar() const**

        Returns the scalar component of this quaternion.

        **See also** **setScalar** (), **x** (), **y** (), and **z** ().
        """
        ...

    def z(self) -> float:
        """
        https://doc.qt.io/qt-5/qquaternion.html#z

        **float QQuaternion::z() const**

        Returns the z coordinate of this quaternion's vector.

        **See also** **setZ** (), **x** (), **y** (), and **scalar** ().
        """
        ...

    def y(self) -> float:
        """
        https://doc.qt.io/qt-5/qquaternion.html#y

        **float QQuaternion::y() const**

        Returns the y coordinate of this quaternion's vector.

        **See also** **setY** (), **x** (), **z** (), and **scalar** ().
        """
        ...

    def x(self) -> float:
        """
        https://doc.qt.io/qt-5/qquaternion.html#x

        **float QQuaternion::x() const**

        Returns the x coordinate of this quaternion's vector.

        **See also** **setX** (), **y** (), **z** (), and **scalar** ().
        """
        ...

    def isIdentity(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquaternion.html#isIdentity

        **bool QQuaternion::isIdentity() const**

        Returns `true` if the x, y, and z components of this quaternion are set
        to 0.0, and the scalar component is set to 1.0; otherwise returns
        `false`.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquaternion.html#isNull

        **bool QQuaternion::isNull() const**

        Returns `true` if the x, y, z, and scalar components of this quaternion
        are set to 0.0; otherwise returns `false`.
        """
        ...

    @staticmethod
    def nlerp(q1: "QQuaternion", q2: "QQuaternion", t: float) -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#nlerp

        **[static] QQuaternion QQuaternion::nlerp(const QQuaternion & q1 , const
        QQuaternion & q2 , float t )**

        Interpolates along the shortest linear path between the rotational
        positions **q1** and **q2**. The value **t** should be between 0 and 1,
        indicating the distance to travel between **q1** and **q2**. The result
        will be **normalized** ().

        If **t** is less than or equal to 0, then **q1** will be returned. If
        **t** is greater than or equal to 1, then **q2** will be returned.

        The nlerp() function is typically faster than **slerp** () and will give
        approximate results to spherical interpolation that are good enough for
        some applications.

        **See also** **slerp** ().
        """
        ...

    @staticmethod
    def slerp(q1: "QQuaternion", q2: "QQuaternion", t: float) -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#slerp

        **[static] QQuaternion QQuaternion::slerp(const QQuaternion & q1 , const
        QQuaternion & q2 , float t )**

        Interpolates along the shortest spherical path between the rotational
        positions **q1** and **q2**. The value **t** should be between 0 and 1,
        indicating the spherical distance to travel between **q1** and **q2**.

        If **t** is less than or equal to 0, then **q1** will be returned. If
        **t** is greater than or equal to 1, then **q2** will be returned.

        **See also** **nlerp** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromAxisAndAngle(axis: "QVector3D", angle: float) -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#fromAxisAndAngle

        **[static] QQuaternion QQuaternion::fromAxisAndAngle(const QVector3D &
        axis , float angle )**

        Creates a normalized quaternion that corresponds to rotating through
        **angle** degrees about the specified 3D **axis**.

        **See also** **getAxisAndAngle** ().
        """
        ...

    @typing.overload
    @staticmethod
    def fromAxisAndAngle(x: float, y: float, z: float, angle: float) -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#fromAxisAndAngle-1

        **[static] QQuaternion QQuaternion::fromAxisAndAngle(float x , float y ,
        float z , float angle )**

        Creates a normalized quaternion that corresponds to rotating through
        **angle** degrees about the 3D axis ( **x** , **y** , **z** ).

        **See also** **getAxisAndAngle** ().
        """
        ...

    def rotatedVector(self, vector: "QVector3D") -> "QVector3D":
        """
        https://doc.qt.io/qt-5/qquaternion.html#rotatedVector

        **QVector3D QQuaternion::rotatedVector(const QVector3D & vector )
        const**

        Rotates **vector** with this quaternion to produce a new vector in 3D
        space. The following code:

        QVector3D result = q.rotatedVector(vector);

        is equivalent to the following:

        QVector3D result = (q * **QQuaternion** (0, vector) *
        q.conjugated()).vector();
        """
        ...

    def normalize(self) -> None:
        """
        https://doc.qt.io/qt-5/qquaternion.html#normalize

        **void QQuaternion::normalize()**

        Normalizes the current quaternion in place. Nothing happens if this is a
        null quaternion or the length of the quaternion is very close to 1.

        **See also** **length** () and **normalized** ().
        """
        ...

    def normalized(self) -> "QQuaternion":
        """
        https://doc.qt.io/qt-5/qquaternion.html#normalized

        **QQuaternion QQuaternion::normalized() const**

        Returns the normalized unit form of this quaternion.

        If this quaternion is null, then a null quaternion is returned. If the
        length of the quaternion is very close to 1, then the quaternion will be
        returned as-is. Otherwise the normalized form of the quaternion of
        length 1 will be returned.

        **See also** **normalize** (), **length** (), and **dotProduct** ().
        """
        ...

    def lengthSquared(self) -> float:
        """
        https://doc.qt.io/qt-5/qquaternion.html#lengthSquared

        **float QQuaternion::lengthSquared() const**

        Returns the squared length of the quaternion.

        **See also** **length** () and **dotProduct** ().
        """
        ...

    def length(self) -> float:
        """
        https://doc.qt.io/qt-5/qquaternion.html#length

        **float QQuaternion::length() const**

        Returns the length of the quaternion. This is also called the "norm".

        **See also** **lengthSquared** (), **normalized** (), and **dotProduct**
        ().
        """
        ...

    def __repr__(self) -> str:
        ...
