"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtGui import *
from PyQt5 import sip


class QPixelFormat(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qpixelformat.html

    **Detailed Description**

    In Qt there is a often a need to represent the layout of the pixels in a
    graphics buffer. Internally QPixelFormat stores everything in a 64 bit
    datastructure. This gives performance but also some limitations.

    QPixelFormat can describe 5 color channels and 1 alpha channel, each can use
    6 bits to describe the size of the color channel.

    The position of the alpha channel is described with a separate enum. This is
    to make it possible to describe **QImage**  formats like ARGB32, and also
    describe typical OpenGL formats like RBGA8888.

    How pixels are suppose to be read is determined by the
    **TypeInterpretation**  enum. It describes if color values are suppose to be
    read byte per byte, or if a pixel is suppose to be read as a complete int
    and then masked.

    There is no support for describing YUV's macro pixels. Instead a list of YUV
    formats has been made. When a QPixelFormat is describing a YUV format, the
    **bitsPerPixel**  value has been deduced by the YUV Layout enum. Also, the
    color channels should all be set to zero except the fifth color channel that
    should store the **bitsPerPixel**  value.

    **See also** **TypeInterpretation** .
    """

    class ByteOrder(int):
        LittleEndian: QPixelFormat = ...
        BigEndian: QPixelFormat = ...
        CurrentSystemEndian: QPixelFormat = ...

    class YUVLayout(int):
        YUV444: QPixelFormat = ...
        YUV422: QPixelFormat = ...
        YUV411: QPixelFormat = ...
        YUV420P: QPixelFormat = ...
        YUV420SP: QPixelFormat = ...
        YV12: QPixelFormat = ...
        UYVY: QPixelFormat = ...
        YUYV: QPixelFormat = ...
        NV12: QPixelFormat = ...
        NV21: QPixelFormat = ...
        IMC1: QPixelFormat = ...
        IMC2: QPixelFormat = ...
        IMC3: QPixelFormat = ...
        IMC4: QPixelFormat = ...
        Y8: QPixelFormat = ...
        Y16: QPixelFormat = ...

    class TypeInterpretation(int):
        UnsignedInteger: QPixelFormat = ...
        UnsignedShort: QPixelFormat = ...
        UnsignedByte: QPixelFormat = ...
        FloatingPoint: QPixelFormat = ...

    class AlphaPremultiplied(int):
        NotPremultiplied: QPixelFormat = ...
        Premultiplied: QPixelFormat = ...

    class AlphaPosition(int):
        AtBeginning: QPixelFormat = ...
        AtEnd: QPixelFormat = ...

    class AlphaUsage(int):
        UsesAlpha: QPixelFormat = ...
        IgnoresAlpha: QPixelFormat = ...

    class ColorModel(int):
        RGB: QPixelFormat = ...
        BGR: QPixelFormat = ...
        Indexed: QPixelFormat = ...
        Grayscale: QPixelFormat = ...
        CMYK: QPixelFormat = ...
        HSL: QPixelFormat = ...
        HSV: QPixelFormat = ...
        YUV: QPixelFormat = ...
        Alpha: QPixelFormat = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#QPixelFormat

        **QPixelFormat::QPixelFormat()**

        Creates a null pixelformat. This format maps to
        **QImage::Format_Invalid** .
        """
        ...

    @typing.overload
    def __init__(
        self,
        mdl: "QPixelFormat.ColorModel",
        firstSize: int,
        secondSize: int,
        thirdSize: int,
        fourthSize: int,
        fifthSize: int,
        alfa: int,
        usage: "QPixelFormat.AlphaUsage",
        position: "QPixelFormat.AlphaPosition",
        premult: "QPixelFormat.AlphaPremultiplied",
        typeInterp: "QPixelFormat.TypeInterpretation",
        byteOrder: "QPixelFormat.ByteOrder" = ...,
        subEnum: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#QPixelFormat-1

        **QPixelFormat::QPixelFormat(QPixelFormat::ColorModel colorModel , uchar
        firstSize , uchar secondSize , uchar thirdSize , uchar fourthSize ,
        uchar fifthSize , uchar alphaSize , QPixelFormat::AlphaUsage alphaUsage
        , QPixelFormat::AlphaPosition alphaPosition ,
        QPixelFormat::AlphaPremultiplied premultiplied ,
        QPixelFormat::TypeInterpretation typeInterpretation ,
        QPixelFormat::ByteOrder byteOrder = CurrentSystemEndian, uchar subEnum =
        0)**

        Creates a QPixelFormat which assigns its data to the attributes.
        **colorModel** will be put into a buffer which is 4 bits long.

        **firstSize** **secondSize** **thirdSize** **fourthSize** **fifthSize**
        **alphaSize** are all meant to represent the size of a channel. The
        channels will be used for different uses dependent on the
        **colorModel**. For RGB the firstSize will represent the Red channel. On
        CMYK it will represent the value of the Cyan channel.

        **alphaUsage** represents if the alpha channel is used or not.

        **alphaPosition** is the position of the alpha channel.

        **premultiplied** represents if the alpha channel is already multiplied
        with the color channels.

        **typeInterpretation** is how the pixel is interpreted.

        **byteOrder** represents the endianness of the pixelformat. This
        defaults to **CurrentSystemEndian** .

        **subEnum** is used for colorModels that have to store some extra
        information with supplying an extra enum. This is used by YUV to store
        the YUV type The default value is 0.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QPixelFormat") -> None:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#QPixelFormat

        **QPixelFormat::QPixelFormat()**

        Creates a null pixelformat. This format maps to
        **QImage::Format_Invalid** .
        """
        ...

    def subEnum(self) -> int:
        ...

    def yuvLayout(self) -> "QPixelFormat.YUVLayout":
        """
        https://doc.qt.io/qt-5/qpixelformat.html#yuvLayout

        **QPixelFormat::YUVLayout QPixelFormat::yuvLayout() const**

        Accessor function for the **YUVLayout** . It is difficult to describe
        the color channels of a YUV pixel format since YUV color model uses
        macro pixels. Instead the layout of the pixels are stored as an enum.
        """
        ...

    def byteOrder(self) -> "QPixelFormat.ByteOrder":
        """
        https://doc.qt.io/qt-5/qpixelformat.html#byteOrder

        **QPixelFormat::ByteOrder QPixelFormat::byteOrder() const**

        The byte order is almost always set the byte order of the current
        system. However, it can be useful to describe some YUV formats. This
        function should never return **QPixelFormat::CurrentSystemEndian**  as
        this value is translated to a endian value in the constructor.
        """
        ...

    def typeInterpretation(self) -> "QPixelFormat.TypeInterpretation":
        """
        https://doc.qt.io/qt-5/qpixelformat.html#typeInterpretation

        **QPixelFormat::TypeInterpretation QPixelFormat::typeInterpretation()
        const**

        Accessor function for the type representation of a color channel or a
        pixel.

        **See also** **TypeInterpretation** .
        """
        ...

    def premultiplied(self) -> "QPixelFormat.AlphaPremultiplied":
        """
        https://doc.qt.io/qt-5/qpixelformat.html#premultiplied

        **QPixelFormat::AlphaPremultiplied QPixelFormat::premultiplied() const**

        Accessor function for the **AlphaPremultiplied**  enum. This indicates
        if the alpha channel is multiplied in to the color channels.
        """
        ...

    def alphaPosition(self) -> "QPixelFormat.AlphaPosition":
        """
        https://doc.qt.io/qt-5/qpixelformat.html#alphaPosition

        **QPixelFormat::AlphaPosition QPixelFormat::alphaPosition() const**

        Accessor function for alphaPosition.
        """
        ...

    def alphaUsage(self) -> "QPixelFormat.AlphaUsage":
        """
        https://doc.qt.io/qt-5/qpixelformat.html#alphaUsage

        **QPixelFormat::AlphaUsage QPixelFormat::alphaUsage() const**

        Accessor function for alphaUsage.
        """
        ...

    def bitsPerPixel(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#bitsPerPixel

        **uchar QPixelFormat::bitsPerPixel() const**

        Accessor function for the bits used per pixel. This function returns the
        sum of the color channels + the size of the alpha channel.
        """
        ...

    def alphaSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#alphaSize

        **uchar QPixelFormat::alphaSize() const**

        Accessor function for the alpha channel size.
        """
        ...

    def brightnessSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#brightnessSize

        **uchar QPixelFormat::brightnessSize() const**

        Accessor function for the brightness channel size.
        """
        ...

    def lightnessSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#lightnessSize

        **uchar QPixelFormat::lightnessSize() const**

        Accessor function for the lightness channel size.
        """
        ...

    def saturationSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#saturationSize

        **uchar QPixelFormat::saturationSize() const**

        Accessor function for the saturation channel size.
        """
        ...

    def hueSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#hueSize

        **uchar QPixelFormat::hueSize() const**

        Accessor function for the hue channel size.
        """
        ...

    def blackSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#blackSize

        **uchar QPixelFormat::blackSize() const**

        Accessor function for the black/key color channel.
        """
        ...

    def yellowSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#yellowSize

        **uchar QPixelFormat::yellowSize() const**

        Accessor function for the yellow color channel.
        """
        ...

    def magentaSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#magentaSize

        **uchar QPixelFormat::magentaSize() const**

        Accessor function for the megenta color channel.
        """
        ...

    def cyanSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#cyanSize

        **uchar QPixelFormat::cyanSize() const**

        Accessor function for the cyan color channel.
        """
        ...

    def blueSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#blueSize

        **uchar QPixelFormat::blueSize() const**

        Accessor function for the size of the blue color channel.
        """
        ...

    def greenSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#greenSize

        **uchar QPixelFormat::greenSize() const**

        Accessor function for the size of the green color channel.
        """
        ...

    def redSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#redSize

        **uchar QPixelFormat::redSize() const**

        Accessor function for the size of the red color channel.
        """
        ...

    def channelCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qpixelformat.html#channelCount

        **uchar QPixelFormat::channelCount() const**

        Accessor function for getting the channelCount. Channel Count is deduced
        by color channels with a size > 0 and if the size of the alpha channel
        is > 0.
        """
        ...

    def colorModel(self) -> "QPixelFormat.ColorModel":
        """
        https://doc.qt.io/qt-5/qpixelformat.html#colorModel

        **QPixelFormat::ColorModel QPixelFormat::colorModel() const**

        Accessor function for getting the colorModel.
        """
        ...
