"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QPictureIO(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qpictureio.html

    **Detailed Description**

    QPictureIO contains a **QIODevice**  object that is used for picture data
    I/O. The programmer can install new picture file formats in addition to
    those that Qt provides.

    You don't normally need to use this class; **QPicture::load** (),
    **QPicture::save** ().

    **See also** **QPicture** , **QPixmap** , and **QFile** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#QPictureIO

        **QPictureIO::QPictureIO()**

        Constructs a QPictureIO object with all parameters set to zero.
        """
        ...

    @typing.overload
    def __init__(self, ioDevice: QtCore.QIODevice, format: str) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#QPictureIO-1

        **QPictureIO::QPictureIO(QIODevice * ioDevice , const char * format )**

        Constructs a QPictureIO object with the I/O device **ioDevice** and a
        **format** tag.
        """
        ...

    @typing.overload
    def __init__(self, fileName: str, format: str) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#QPictureIO-2

        **QPictureIO::QPictureIO(const QString & fileName , const char * format
        )**

        Constructs a QPictureIO object with the file name **fileName** and a
        **format** tag.
        """
        ...

    @staticmethod
    def defineIOHandler(
        format: str,
        header: str,
        flags: str,
        read_picture: typing.Optional[typing.Callable[["QPictureIO"], None]],
        write_picture: typing.Optional[typing.Callable[["QPictureIO"], None]],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#defineIOHandler

        **[static] void QPictureIO::defineIOHandler(const char * format , const
        char * header , const char * flags , picture_io_handler readPicture ,
        picture_io_handler writePicture )**

        Defines a picture I/O handler for the picture format called **format** ,
        which is recognized using the regular expression defined in **header** ,
        read using **readPicture** and written using **writePicture**.

        **flags** is a string of single-character flags for this format. The
        only flag defined currently is T (upper case), so the only legal value
        for **flags** are "T" and the empty string. The "T" flag means that the
        picture file is a text file, and Qt should treat all newline conventions
        as equivalent. (XPM files and some PPM files are text files for
        example.)

        **format** is used to select a handler to write a **QPicture** ;
        **header** is used to select a handler to read an picture file.

        If **readPicture** is `nullptr`, the **QPictureIO**  will not be able to
        read pictures in **format**. If **writePicture** is `nullptr`, the
        **QPictureIO**  will not be able to write pictures in **format**. If
        both are null, the **QPictureIO**  object is valid but useless.

        Example:

        void readSVG(**QPictureIO**  *picture)
            {
                // read the picture
        using the picture->ioDevice()
            }

            void
        writeSVG(**QPictureIO**  *picture)
            {
                // write the picture
        using the picture->ioDevice()
            }

                // add the SVG picture
        handler
                // ...

        Before the regular expression test, all the 0 bytes in the file header
        are converted to 1 bytes. This is done because when Qt was ASCII-based,
        **QRegExp**  could not handle 0 bytes in strings.

        The regexp is only applied on the first 14 bytes of the file.

        (Note that if one handlerIO supports writing a format and another
        supports reading it, Qt supports both reading and writing. If two
        handlers support the same operation, Qt chooses one arbitrarily.)
        """
        ...

    @staticmethod
    def outputFormats() -> typing.List[QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-5/qpictureio.html#outputFormats

        **[static] QList<QByteArray> QPictureIO::outputFormats()**

        Returns a sorted list of picture formats that are supported for picture
        output.
        """
        ...

    @staticmethod
    def inputFormats() -> typing.List[QtCore.QByteArray]:
        """
        https://doc.qt.io/qt-5/qpictureio.html#inputFormats

        **[static] QList<QByteArray> QPictureIO::inputFormats()**

        Returns a sorted list of picture formats that are supported for picture
        input.
        """
        ...

    @typing.overload
    @staticmethod
    def pictureFormat(fileName: str) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qpictureio.html#pictureFormat

        **[static] QByteArray QPictureIO::pictureFormat(const QString & fileName
        )**

        Returns a string that specifies the picture format of the file
        **fileName** , or null if the file cannot be read or if the format is
        not recognized.
        """
        ...

    @typing.overload
    @staticmethod
    def pictureFormat(a0: QtCore.QIODevice) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qpictureio.html#pictureFormat-1

        **[static] QByteArray QPictureIO::pictureFormat(QIODevice * d )**

        This is an overloaded function.

        Returns a string that specifies the picture format of the picture read
        from IO device **d** , or 0 if the device cannot be read or if the
        format is not recognized.

        Make sure that **d** is at the right position in the device (for
        example, at the beginning of the file).

        **See also** **QIODevice::pos** ().
        """
        ...

    def write(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpictureio.html#write

        **bool QPictureIO::write()**

        Writes an picture to an IO device and returns `true` if the picture was
        successfully written; otherwise returns `false`.

        Before writing an picture you must set an IO device or a file name. If
        both an IO device and a file name have been set, the IO device will be
        used.

        The picture will be written using the specified picture format.

        Example:

        **QPictureIO**  iio;
                    **QPicture**    picture;
        **QPainter**  painter(&picture);
                    painter.drawPixmap(0, 0,
        pixmap);
                    iio.setPicture(picture);
        iio.setFileName("vegeburger.pic");
                    iio.setFormat("PIC");
        if (iio.write())
                        return true; // returned true if
        written successfully

        **See also** **setIODevice** (), **setFileName** (), **setFormat** (),
        **read** (), and **QPixmap::save** ().
        """
        ...

    def read(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpictureio.html#read

        **bool QPictureIO::read()**

        Reads an picture into memory and returns `true` if the picture was
        successfully read; otherwise returns `false`.

        Before reading an picture you must set an IO device or a file name. If
        both an IO device and a file name have been set, the IO device will be
        used.

        Setting the picture file format string is optional.

        Note that this function does **not** set the **format**  used to read
        the picture. If you need that information, use the **pictureFormat** ()
        static functions.

        Example:

        **QPictureIO**  iio;
                    **QPixmap**   pixmap;
        iio.setFileName("vegeburger.pic");
                    if (iio.read()) {
        // OK
                        **QPicture**  picture = iio.picture();
        **QPainter**  painter(&pixmap);
                        painter.drawPicture(0,
        0, picture);
                    }

        **See also** **setIODevice** (), **setFileName** (), **setFormat** (),
        **write** (), and **QPixmap::load** ().
        """
        ...

    def setGamma(self, a0: float) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#setGamma

        **void QPictureIO::setGamma(float gamma )**

        Sets the gamma value at which the picture will be viewed to **gamma**.
        If the picture format stores a gamma value for which the picture is
        intended to be used, then this setting will be used to modify the
        picture. Setting to 0.0 will disable gamma correction (i.e. any
        specification in the file will be ignored).

        The default value is 0.0.

        **See also** **gamma** ().
        """
        ...

    def setParameters(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#setParameters

        **void QPictureIO::setParameters(const char * parameters )**

        Sets the picture's parameter string to **parameters**. This is for
        picture handlers that require special parameters.

        Although the current picture formats supported by Qt ignore the
        parameters string, it may be used in future extensions or by
        contributions (for example, JPEG).

        **See also** **parameters** ().
        """
        ...

    def setDescription(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#setDescription

        **void QPictureIO::setDescription(const QString & description )**

        Sets the picture description string for picture handlers that support
        picture descriptions to **description**.

        Currently, no picture format supported by Qt uses the description
        string.

        **See also** **description** ().
        """
        ...

    def setQuality(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#setQuality

        **void QPictureIO::setQuality(int q )**

        Sets the quality of the written picture to **q** , related to the
        compression ratio.

        **q** must be in the range -1..100. Specify 0 to obtain small compressed
        files, 100 for large uncompressed files. (-1 signifies the default
        compression.)

        **See also** **quality** () and **QPicture::save** ().
        """
        ...

    def setFileName(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#setFileName

        **void QPictureIO::setFileName(const QString & fileName )**

        Sets the name of the file to read or write an picture from to
        **fileName**.

        **See also** **fileName** () and **setIODevice** ().
        """
        ...

    def setIODevice(self, a0: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#setIODevice

        **void QPictureIO::setIODevice(QIODevice * ioDevice )**

        Sets the IO device to be used for reading or writing an picture.

        Setting the IO device allows pictures to be read/written to any block-
        oriented **QIODevice** .

        If **ioDevice** is not null, this IO device will override file name
        settings.

        **See also** **setFileName** ().
        """
        ...

    def setFormat(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#setFormat

        **void QPictureIO::setFormat(const char * format )**

        Sets the picture format to **format** for the picture to be read or
        written.

        It is necessary to specify a format before writing an picture, but it is
        not necessary to specify a format before reading an picture.

        If no format has been set, Qt guesses the picture format before reading
        it. If a format is set the picture will only be read if it has that
        format.

        **See also** **read** (), **write** (), and **format** ().
        """
        ...

    def setStatus(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#setStatus

        **void QPictureIO::setStatus(int status )**

        Sets the picture IO status to **status**. A non-zero value indicates an
        error, whereas 0 means that the IO operation was successful.

        **See also** **status** ().
        """
        ...

    def setPicture(self, a0: QPicture) -> None:
        """
        https://doc.qt.io/qt-5/qpictureio.html#setPicture

        **void QPictureIO::setPicture(const QPicture & picture )**

        Sets the picture to **picture**.

        **See also** **picture** ().
        """
        ...

    def gamma(self) -> float:
        """
        https://doc.qt.io/qt-5/qpictureio.html#gamma

        **float QPictureIO::gamma() const**

        Returns the gamma value at which the picture will be viewed.

        **See also** **setGamma** ().
        """
        ...

    def parameters(self) -> str:
        """
        https://doc.qt.io/qt-5/qpictureio.html#parameters

        **const char *QPictureIO::parameters() const**

        Returns the picture's parameters string.

        **See also** **setParameters** ().
        """
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-5/qpictureio.html#description

        **QString QPictureIO::description() const**

        Returns the picture description string.

        **See also** **setDescription** ().
        """
        ...

    def quality(self) -> int:
        """
        https://doc.qt.io/qt-5/qpictureio.html#quality

        **int QPictureIO::quality() const**

        Returns the quality of the written picture, related to the compression
        ratio.

        **See also** **setQuality** () and **QPicture::save** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-5/qpictureio.html#fileName

        **QString QPictureIO::fileName() const**

        Returns the file name currently set.

        **See also** **setFileName** ().
        """
        ...

    def ioDevice(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-5/qpictureio.html#ioDevice

        **QIODevice *QPictureIO::ioDevice() const**

        Returns the IO device currently set.

        **See also** **setIODevice** ().
        """
        ...

    def format(self) -> str:
        """
        https://doc.qt.io/qt-5/qpictureio.html#format

        **const char *QPictureIO::format() const**

        Returns the picture format string or `nullptr` if no format has been
        explicitly set.

        **See also** **setFormat** ().
        """
        ...

    def status(self) -> int:
        """
        https://doc.qt.io/qt-5/qpictureio.html#status

        **int QPictureIO::status() const**

        Returns the picture's IO status. A non-zero value indicates an error,
        whereas 0 means that the IO operation was successful.

        **See also** **setStatus** ().
        """
        ...

    def picture(self) -> QPicture:
        """
        https://doc.qt.io/qt-5/qpictureio.html#picture

        **const QPicture &QPictureIO::picture() const**

        Returns the picture currently set.

        **See also** **setPicture** ().
        """
        ...
