"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QPdfWriter(QtCore.QObject, QPagedPaintDevice):
    """
    https://doc.qt.io/qt-5/qpdfwriter.html

    **Detailed Description**

    QPdfWriter generates PDF out of a series of drawing commands using
    **QPainter** . The **newPage** () method can be used to create several
    pages.
    """

    @typing.overload
    def __init__(self, filename: str) -> None:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#QPdfWriter

        **QPdfWriter::QPdfWriter(const QString & filename )**

        Constructs a PDF writer that will write the pdf to **filename**.
        """
        ...

    @typing.overload
    def __init__(self, device: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#QPdfWriter-1

        **QPdfWriter::QPdfWriter(QIODevice * device )**

        Constructs a PDF writer that will write the pdf to **device**.
        """
        ...

    def addFileAttachment(
        self,
        fileName: str,
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
        mimeType: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#addFileAttachment

        **void QPdfWriter::addFileAttachment(const QString & fileName , const
        QByteArray & data , const QString & mimeType = QString())**

        Adds **fileName** attachment to the PDF with (optional) **mimeType**.
        **data** contains the raw file data to embed into the PDF file.

        This function was introduced in Qt 5.15.
        """
        ...

    def documentXmpMetadata(self) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#documentXmpMetadata

        **QByteArray QPdfWriter::documentXmpMetadata() const**

        Gets the document metadata, as it was provided with a call to
        **setDocumentXmpMetadata** . It will not return the default metadata.

        This function was introduced in Qt 5.15.

        **See also** **setDocumentXmpMetadata** ().
        """
        ...

    def setDocumentXmpMetadata(
        self, xmpMetadata: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#setDocumentXmpMetadata

        **void QPdfWriter::setDocumentXmpMetadata(const QByteArray & xmpMetadata
        )**

        Sets the document metadata. This metadata is not influenced by the
        **setTitle**  / **setCreator**  methods, so is up to the user to keep it
        consistent. **xmpMetadata** contains XML formatted metadata to embed
        into the PDF file.

        This function was introduced in Qt 5.15.

        **See also** **documentXmpMetadata** ().
        """
        ...

    def pdfVersion(self) -> QPagedPaintDevice.PdfVersion:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#pdfVersion

        **QPagedPaintDevice::PdfVersion QPdfWriter::pdfVersion() const**

        Returns the PDF version for this writer. The default is
        `PdfVersion_1_4`.

        This function was introduced in Qt 5.10.

        **See also** **setPdfVersion** ().
        """
        ...

    def setPdfVersion(self, version: QPagedPaintDevice.PdfVersion) -> None:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#setPdfVersion

        **void QPdfWriter::setPdfVersion(QPagedPaintDevice::PdfVersion version
        )**

        Sets the PDF version for this writer to **version**.

        If **version** is the same value as currently set then no change will be
        made.

        This function was introduced in Qt 5.10.

        **See also** **pdfVersion** ().
        """
        ...

    def resolution(self) -> int:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#resolution

        **int QPdfWriter::resolution() const**

        Returns the resolution of the PDF in DPI.

        This function was introduced in Qt 5.3.

        **See also** **setResolution** ().
        """
        ...

    def setResolution(self, resolution: int) -> None:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#setResolution

        **void QPdfWriter::setResolution(int resolution )**

        Sets the PDF **resolution** in DPI.

        This setting affects the coordinate system as returned by, for example
        **QPainter::viewport** ().

        This function was introduced in Qt 5.3.

        **See also** **resolution** ().
        """
        ...

    def metric(self, id: QPaintDevice.PaintDeviceMetric) -> int:
        ...

    def paintEngine(self) -> QPaintEngine:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#paintEngine

        **[override virtual protected] QPaintEngine *QPdfWriter::paintEngine()
        const**

        Reimplements: **QPaintDevice::paintEngine** () const.
        """
        ...

    def setMargins(self, m: QPagedPaintDevice.Margins) -> None:
        ...

    def setPageSizeMM(self, size: QtCore.QSizeF) -> None:
        ...

    @typing.overload
    def setPageSize(self, size: QPagedPaintDevice.PageSize) -> None:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#setPageSize

        **bool QPdfWriter::setPageSize(const QPageSize & pageSize )**

        Sets the PDF page size to **pageSize**.

        To get the current **QPageSize**  use **pageLayout** ().**pageSize** ().

        You should call this before calling **QPainter::begin** (), or
        immediately before calling **newPage** () to apply the new page size to
        a new page. You should not call any painting methods between a call to
        setPageSize() and **newPage** () as the wrong paint metrics may be used.

        Returns true if the page size was successfully set to **pageSize**.

        This function was introduced in Qt 5.3.

        **See also** **pageLayout** ().
        """
        ...

    @typing.overload
    def setPageSize(self, pageSize: QPageSize) -> bool:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#setPageSize

        **bool QPdfWriter::setPageSize(const QPageSize & pageSize )**

        Sets the PDF page size to **pageSize**.

        To get the current **QPageSize**  use **pageLayout** ().**pageSize** ().

        You should call this before calling **QPainter::begin** (), or
        immediately before calling **newPage** () to apply the new page size to
        a new page. You should not call any painting methods between a call to
        setPageSize() and **newPage** () as the wrong paint metrics may be used.

        Returns true if the page size was successfully set to **pageSize**.

        This function was introduced in Qt 5.3.

        **See also** **pageLayout** ().
        """
        ...

    def newPage(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#newPage

        **[override virtual] bool QPdfWriter::newPage()**

        Reimplements: **QPagedPaintDevice::newPage** ().
        """
        ...

    def setCreator(self, creator: str) -> None:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#setCreator

        **void QPdfWriter::setCreator(const QString & creator )**

        Sets the creator of the document to **creator**.

        **See also** **creator** ().
        """
        ...

    def creator(self) -> str:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#creator

        **QString QPdfWriter::creator() const**

        Returns the creator of the document.

        **See also** **setCreator** ().
        """
        ...

    def setTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#setTitle

        **void QPdfWriter::setTitle(const QString & title )**

        Sets the title of the document being created to **title**.

        **See also** **title** ().
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-5/qpdfwriter.html#title

        **QString QPdfWriter::title() const**

        Returns the title of the document.

        **See also** **setTitle** ().
        """
        ...
