"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QPaintEngineState(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qpaintenginestate.html

    **Detailed Description**

    QPaintEngineState records which properties that have changed since the last
    time the paint engine was updated, as well as their current value.

    Which properties that have changed can at any time be retrieved using the
    **state** () function. This function returns an instance of the
    **QPaintEngine::DirtyFlags**  type which stores an OR combination of
    **QPaintEngine::DirtyFlag**  values. The **QPaintEngine::DirtyFlag**  enum
    defines whether a property has changed since the last update or not.

    If a property is marked with a dirty flag, its current value can be
    retrieved using the corresponding get function:

    Property FlagCurrent Property Value
    **QPaintEngine::DirtyBackground**
    **backgroundBrush** ()
    **QPaintEngine::DirtyBackgroundMode**
    **backgroundMode** ()
    **QPaintEngine::DirtyBrush** **brush** ()
    **QPaintEngine::DirtyBrushOrigin** **brushOrigin** ()
    **QPaintEngine::DirtyClipRegion**  **or** **QPaintEngine::DirtyClipPath**
    **clipOperation** ()
    **QPaintEngine::DirtyClipPath** **clipPath** ()
    **QPaintEngine::DirtyClipRegion** **clipRegion** ()
    **QPaintEngine::DirtyCompositionMode** **compositionMode** ()
    **QPaintEngine::DirtyFont** **font** ()
    **QPaintEngine::DirtyTransform**
    **transform** ()
    **QPaintEngine::DirtyClipEnabled** **isClipEnabled** ()
    **QPaintEngine::DirtyPen** **pen** ()
    **QPaintEngine::DirtyHints**
    **renderHints** ()

    The QPaintEngineState class also provide the **painter** () function which
    returns a pointer to the painter that is currently updating the paint
    engine.

    An instance of this class, representing the current state of the active
    paint engine, is passed as argument to the **QPaintEngine::updateState** ()
    function. The only situation in which you will have to use this class
    directly is when implementing your own paint engine.

    **See also** **QPaintEngine** .
    """

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QPaintEngineState") -> None:
        ...

    def penNeedsResolving(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#penNeedsResolving

        **bool QPaintEngineState::penNeedsResolving() const**

        Returns whether the coordinate of the stroke have been specified as
        bounded by the current rendering operation and have to be resolved
        (about the currently rendered primitive).

        This function was introduced in Qt 4.3.
        """
        ...

    def brushNeedsResolving(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#brushNeedsResolving

        **bool QPaintEngineState::brushNeedsResolving() const**

        Returns whether the coordinate of the fill have been specified as
        bounded by the current rendering operation and have to be resolved
        (about the currently rendered primitive).

        This function was introduced in Qt 4.3.
        """
        ...

    def transform(self) -> "QTransform":
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#transform

        **QTransform QPaintEngineState::transform() const**

        Returns the matrix in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyTransform**  flag.

        This function was introduced in Qt 4.3.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def painter(self) -> QPainter:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#painter

        **QPainter *QPaintEngineState::painter() const**

        Returns a pointer to the painter currently updating the paint engine.
        """
        ...

    def compositionMode(self) -> QPainter.CompositionMode:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#compositionMode

        **QPainter::CompositionMode QPaintEngineState::compositionMode() const**

        Returns the composition mode in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyCompositionMode**
        flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def renderHints(self) -> QPainter.RenderHints:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#renderHints

        **QPainter::RenderHints QPaintEngineState::renderHints() const**

        Returns the render hints in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyHints**  flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def isClipEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#isClipEnabled

        **bool QPaintEngineState::isClipEnabled() const**

        Returns whether clipping is enabled or not in the current paint engine
        state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyClipEnabled**  flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def clipPath(self) -> "QPainterPath":
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#clipPath

        **QPainterPath QPaintEngineState::clipPath() const**

        Returns the clip path in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyClipPath**  flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def clipRegion(self) -> "QRegion":
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#clipRegion

        **QRegion QPaintEngineState::clipRegion() const**

        Returns the clip region in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyClipRegion**  flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def clipOperation(self) -> QtCore.Qt.ClipOperation:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#clipOperation

        **Qt::ClipOperation QPaintEngineState::clipOperation() const**

        Returns the clip operation in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes either the **QPaintEngine::DirtyClipPath**
        or the **QPaintEngine::DirtyClipRegion**  flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def opacity(self) -> float:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#opacity

        **qreal QPaintEngineState::opacity() const**

        Returns the opacity in the current paint engine state.

        This function was introduced in Qt 4.2.
        """
        ...

    def font(self) -> QFont:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#font

        **QFont QPaintEngineState::font() const**

        Returns the font in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyFont**  flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def backgroundMode(self) -> QtCore.Qt.BGMode:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#backgroundMode

        **Qt::BGMode QPaintEngineState::backgroundMode() const**

        Returns the background mode in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyBackgroundMode**
        flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def backgroundBrush(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#backgroundBrush

        **QBrush QPaintEngineState::backgroundBrush() const**

        Returns the background brush in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyBackground**  flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def brushOrigin(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#brushOrigin

        **QPointF QPaintEngineState::brushOrigin() const**

        Returns the brush origin in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyBrushOrigin**  flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def brush(self) -> QBrush:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#brush

        **QBrush QPaintEngineState::brush() const**

        Returns the brush in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyBrush**  flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def pen(self) -> "QPen":
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#pen

        **QPen QPaintEngineState::pen() const**

        Returns the pen in the current paint engine state.

        This variable should only be used when the **state** () returns a
        combination which includes the **QPaintEngine::DirtyPen**  flag.

        **See also** **state** () and **QPaintEngine::updateState** ().
        """
        ...

    def state(self) -> QPaintEngine.DirtyFlags:
        """
        https://doc.qt.io/qt-5/qpaintenginestate.html#state

        **QPaintEngine::DirtyFlags QPaintEngineState::state() const**

        Returns a combination of flags identifying the set of properties that
        need to be updated when updating the paint engine's state (i.e. during a
        call to the **QPaintEngine::updateState** () function).

        **See also** **QPaintEngine::updateState** ().
        """
        ...
