"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QPaintDeviceWindow(QWindow, QPaintDevice):
    """
    https://doc.qt.io/qt-5/qpaintdevicewindow.html

    **Detailed Description**

    QPaintDeviceWindow is like a regular **QWindow** , with the added
    functionality of being a paint device too. Whenever the content needs to be
    updated, the virtual **paintEvent** () function is called. Subclasses, that
    reimplement this function, can then simply open a **QPainter**  on the
    window.

    **Note:** This class cannot directly be used in applications. It rather
    serves as a base for subclasses like **QOpenGLWindow** .

    **See also** **QOpenGLWindow** .
    """

    def event(self, event: QtCore.QEvent) -> bool:
        ...

    def exposeEvent(self, a0: QExposeEvent) -> None:
        ...

    def metric(self, metric: QPaintDevice.PaintDeviceMetric) -> int:
        ...

    def paintEvent(self, event: QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qpaintdevicewindow.html#paintEvent

        **[virtual protected] void QPaintDeviceWindow::paintEvent(QPaintEvent *
        event )**

        Handles paint events passed in the **event** parameter.

        The default implementation does nothing. Reimplement this function to
        perform painting. If necessary, the dirty area is retrievable from the
        **event**.
        """
        ...

    @typing.overload
    def update(self, rect: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qpaintdevicewindow.html#update

        **void QPaintDeviceWindow::update(const QRect & rect )**

        Marks the **rect** of the window as dirty and schedules a repaint.

        **Note:** Subsequent calls to this function before the next paint event
        will get ignored, but **rect** is added to the region to update.

        **Note:** For non-exposed windows the update is deferred until the
        window becomes exposed again.
        """
        ...

    @typing.overload
    def update(self, region: "QRegion") -> None:
        """
        https://doc.qt.io/qt-5/qpaintdevicewindow.html#update-1

        **void QPaintDeviceWindow::update(const QRegion & region )**

        Marks the **region** of the window as dirty and schedules a repaint.

        **Note:** Subsequent calls to this function before the next paint event
        will get ignored, but **region** is added to the region to update.

        **Note:** For non-exposed windows the update is deferred until the
        window becomes exposed again.
        """
        ...

    @typing.overload
    def update(self) -> None:
        """
        https://doc.qt.io/qt-5/qpaintdevicewindow.html#update-2

        **[slot] void QPaintDeviceWindow::update()**

        Marks the entire window as dirty and schedules a repaint.

        **Note:** Subsequent calls to this function before the next paint event
        will get ignored.

        **Note:** For non-exposed windows the update is deferred until the
        window becomes exposed again.
        """
        ...
