"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QPagedPaintDevice(QPaintDevice):
    """
    https://doc.qt.io/qt-5/qpagedpaintdevice.html

    **Detailed Description**

    Paged paint devices are used to generate output for printing or for formats
    like PDF. **QPdfWriter**  and **QPrinter**  inherit from it.
    """

    class PdfVersion(int):
        PdfVersion_1_4: QPagedPaintDevice = ...
        PdfVersion_A1b: QPagedPaintDevice = ...
        PdfVersion_1_6: QPagedPaintDevice = ...

    class PageSize(int):
        A4: QPagedPaintDevice = ...
        B5: QPagedPaintDevice = ...
        Letter: QPagedPaintDevice = ...
        Legal: QPagedPaintDevice = ...
        Executive: QPagedPaintDevice = ...
        A0: QPagedPaintDevice = ...
        A1: QPagedPaintDevice = ...
        A2: QPagedPaintDevice = ...
        A3: QPagedPaintDevice = ...
        A5: QPagedPaintDevice = ...
        A6: QPagedPaintDevice = ...
        A7: QPagedPaintDevice = ...
        A8: QPagedPaintDevice = ...
        A9: QPagedPaintDevice = ...
        B0: QPagedPaintDevice = ...
        B1: QPagedPaintDevice = ...
        B10: QPagedPaintDevice = ...
        B2: QPagedPaintDevice = ...
        B3: QPagedPaintDevice = ...
        B4: QPagedPaintDevice = ...
        B6: QPagedPaintDevice = ...
        B7: QPagedPaintDevice = ...
        B8: QPagedPaintDevice = ...
        B9: QPagedPaintDevice = ...
        C5E: QPagedPaintDevice = ...
        Comm10E: QPagedPaintDevice = ...
        DLE: QPagedPaintDevice = ...
        Folio: QPagedPaintDevice = ...
        Ledger: QPagedPaintDevice = ...
        Tabloid: QPagedPaintDevice = ...
        Custom: QPagedPaintDevice = ...
        A10: QPagedPaintDevice = ...
        A3Extra: QPagedPaintDevice = ...
        A4Extra: QPagedPaintDevice = ...
        A4Plus: QPagedPaintDevice = ...
        A4Small: QPagedPaintDevice = ...
        A5Extra: QPagedPaintDevice = ...
        B5Extra: QPagedPaintDevice = ...
        JisB0: QPagedPaintDevice = ...
        JisB1: QPagedPaintDevice = ...
        JisB2: QPagedPaintDevice = ...
        JisB3: QPagedPaintDevice = ...
        JisB4: QPagedPaintDevice = ...
        JisB5: QPagedPaintDevice = ...
        JisB6: QPagedPaintDevice = ...
        JisB7: QPagedPaintDevice = ...
        JisB8: QPagedPaintDevice = ...
        JisB9: QPagedPaintDevice = ...
        JisB10: QPagedPaintDevice = ...
        AnsiC: QPagedPaintDevice = ...
        AnsiD: QPagedPaintDevice = ...
        AnsiE: QPagedPaintDevice = ...
        LegalExtra: QPagedPaintDevice = ...
        LetterExtra: QPagedPaintDevice = ...
        LetterPlus: QPagedPaintDevice = ...
        LetterSmall: QPagedPaintDevice = ...
        TabloidExtra: QPagedPaintDevice = ...
        ArchA: QPagedPaintDevice = ...
        ArchB: QPagedPaintDevice = ...
        ArchC: QPagedPaintDevice = ...
        ArchD: QPagedPaintDevice = ...
        ArchE: QPagedPaintDevice = ...
        Imperial7x9: QPagedPaintDevice = ...
        Imperial8x10: QPagedPaintDevice = ...
        Imperial9x11: QPagedPaintDevice = ...
        Imperial9x12: QPagedPaintDevice = ...
        Imperial10x11: QPagedPaintDevice = ...
        Imperial10x13: QPagedPaintDevice = ...
        Imperial10x14: QPagedPaintDevice = ...
        Imperial12x11: QPagedPaintDevice = ...
        Imperial15x11: QPagedPaintDevice = ...
        ExecutiveStandard: QPagedPaintDevice = ...
        Note: QPagedPaintDevice = ...
        Quarto: QPagedPaintDevice = ...
        Statement: QPagedPaintDevice = ...
        SuperA: QPagedPaintDevice = ...
        SuperB: QPagedPaintDevice = ...
        Postcard: QPagedPaintDevice = ...
        DoublePostcard: QPagedPaintDevice = ...
        Prc16K: QPagedPaintDevice = ...
        Prc32K: QPagedPaintDevice = ...
        Prc32KBig: QPagedPaintDevice = ...
        FanFoldUS: QPagedPaintDevice = ...
        FanFoldGerman: QPagedPaintDevice = ...
        FanFoldGermanLegal: QPagedPaintDevice = ...
        EnvelopeB4: QPagedPaintDevice = ...
        EnvelopeB5: QPagedPaintDevice = ...
        EnvelopeB6: QPagedPaintDevice = ...
        EnvelopeC0: QPagedPaintDevice = ...
        EnvelopeC1: QPagedPaintDevice = ...
        EnvelopeC2: QPagedPaintDevice = ...
        EnvelopeC3: QPagedPaintDevice = ...
        EnvelopeC4: QPagedPaintDevice = ...
        EnvelopeC6: QPagedPaintDevice = ...
        EnvelopeC65: QPagedPaintDevice = ...
        EnvelopeC7: QPagedPaintDevice = ...
        Envelope9: QPagedPaintDevice = ...
        Envelope11: QPagedPaintDevice = ...
        Envelope12: QPagedPaintDevice = ...
        Envelope14: QPagedPaintDevice = ...
        EnvelopeMonarch: QPagedPaintDevice = ...
        EnvelopePersonal: QPagedPaintDevice = ...
        EnvelopeChou3: QPagedPaintDevice = ...
        EnvelopeChou4: QPagedPaintDevice = ...
        EnvelopeInvite: QPagedPaintDevice = ...
        EnvelopeItalian: QPagedPaintDevice = ...
        EnvelopeKaku2: QPagedPaintDevice = ...
        EnvelopeKaku3: QPagedPaintDevice = ...
        EnvelopePrc1: QPagedPaintDevice = ...
        EnvelopePrc2: QPagedPaintDevice = ...
        EnvelopePrc3: QPagedPaintDevice = ...
        EnvelopePrc4: QPagedPaintDevice = ...
        EnvelopePrc5: QPagedPaintDevice = ...
        EnvelopePrc6: QPagedPaintDevice = ...
        EnvelopePrc7: QPagedPaintDevice = ...
        EnvelopePrc8: QPagedPaintDevice = ...
        EnvelopePrc9: QPagedPaintDevice = ...
        EnvelopePrc10: QPagedPaintDevice = ...
        EnvelopeYou4: QPagedPaintDevice = ...
        NPaperSize: QPagedPaintDevice = ...
        AnsiA: QPagedPaintDevice = ...
        AnsiB: QPagedPaintDevice = ...
        EnvelopeC5: QPagedPaintDevice = ...
        EnvelopeDL: QPagedPaintDevice = ...
        Envelope10: QPagedPaintDevice = ...
        LastPageSize: QPagedPaintDevice = ...

    class Margins(sip.simplewrapper):
        bottom: float = ...
        left: float = ...
        right: float = ...
        top: float = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QPagedPaintDevice.Margins") -> None:
            ...

    def __init__(self) -> None:
        ...

    def pageLayout(self) -> "QPageLayout":
        """
        https://doc.qt.io/qt-5/qpagedpaintdevice.html#pageLayout

        **QPageLayout QPagedPaintDevice::pageLayout() const**

        Returns the current page layout. Use this method to access the current
        **QPageSize** , **QPageLayout::Orientation** , **QMarginsF** ,
        fullRect() and paintRect().

        Note that you cannot use the setters on the returned object, you must
        either call the individual **QPagedPaintDevice**  setters or use
        **setPageLayout** ().

        This function was introduced in Qt 5.3.

        **See also** **setPageLayout** (), **setPageSize** (),
        **setPageOrientation** (), and **setPageMargins** ().
        """
        ...

    @typing.overload
    def setPageMargins(self, margins: QtCore.QMarginsF) -> bool:
        """
        https://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageMargins

        **bool QPagedPaintDevice::setPageMargins(const QMarginsF & margins )**

        Set the page **margins** in the current page layout units.

        You should call this before calling **QPainter::begin** (), or
        immediately before calling **newPage** () to apply the new margins to a
        new page. You should not call any painting methods between a call to
        setPageMargins() and **newPage** () as the wrong paint metrics may be
        used.

        To get the current page margins use **pageLayout** ().margins().

        Returns true if the page margins were successfully set to **margins**.

        This function was introduced in Qt 5.3.

        **See also** **pageLayout** ().
        """
        ...

    @typing.overload
    def setPageMargins(
        self, margins: QtCore.QMarginsF, units: "QPageLayout.Unit"
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageMargins-1

        **bool QPagedPaintDevice::setPageMargins(const QMarginsF & margins ,
        QPageLayout::Unit units )**

        Set the page **margins** defined in the given **units**.

        You should call this before calling **QPainter::begin** (), or
        immediately before calling **newPage** () to apply the new margins to a
        new page. You should not call any painting methods between a call to
        setPageMargins() and **newPage** () as the wrong paint metrics may be
        used.

        To get the current page margins use **pageLayout** ().margins().

        Returns true if the page margins were successfully set to **margins**.

        This function was introduced in Qt 5.3.

        **See also** **pageLayout** ().
        """
        ...

    def setPageOrientation(self, orientation: "QPageLayout.Orientation") -> bool:
        """
        https://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageOrientation

        **bool QPagedPaintDevice::setPageOrientation(QPageLayout::Orientation
        orientation )**

        Sets the page **orientation**.

        The page orientation is used to define the orientation of the page size
        when obtaining the page rect.

        You should call this before calling **QPainter::begin** (), or
        immediately before calling **newPage** () to apply the new orientation
        to a new page. You should not call any painting methods between a call
        to setPageOrientation() and **newPage** () as the wrong paint metrics
        may be used.

        To get the current **QPageLayout::Orientation**  use **pageLayout**
        ().orientation().

        Returns true if the page orientation was successfully set to
        **orientation**.

        This function was introduced in Qt 5.3.

        **See also** **pageLayout** ().
        """
        ...

    def setPageLayout(self, pageLayout: "QPageLayout") -> bool:
        """
        https://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageLayout

        **bool QPagedPaintDevice::setPageLayout(const QPageLayout &
        newPageLayout )**

        Sets the page layout to **newPageLayout**.

        You should call this before calling **QPainter::begin** (), or
        immediately before calling **newPage** () to apply the new page layout
        to a new page. You should not call any painting methods between a call
        to setPageLayout() and **newPage** () as the wrong paint metrics may be
        used.

        Returns true if the page layout was successfully set to
        **newPageLayout**.

        This function was introduced in Qt 5.3.

        **See also** **pageLayout** ().
        """
        ...

    def margins(self) -> "QPagedPaintDevice.Margins":
        ...

    def setMargins(self, margins: "QPagedPaintDevice.Margins") -> None:
        ...

    def pageSizeMM(self) -> QtCore.QSizeF:
        ...

    def setPageSizeMM(self, size: QtCore.QSizeF) -> None:
        ...

    def pageSize(self) -> "QPagedPaintDevice.PageSize":
        """
        https://doc.qt.io/qt-5/qpagedpaintdevice.html#pageSize

        **QPagedPaintDevice::PageSize QPagedPaintDevice::pageSize() const**

        Returns the currently used page size.

        **See also** **setPageSize** ().
        """
        ...

    @typing.overload
    def setPageSize(self, size: "QPagedPaintDevice.PageSize") -> None:
        """
        https://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageSize

        **bool QPagedPaintDevice::setPageSize(const QPageSize & pageSize )**

        Sets the page size to **pageSize**.

        To get the current **QPageSize**  use **pageLayout** ().**pageSize** ().

        You should call this before calling **QPainter::begin** (), or
        immediately before calling **newPage** () to apply the new page size to
        a new page. You should not call any painting methods between a call to
        setPageSize() and **newPage** () as the wrong paint metrics may be used.

        Returns true if the page size was successfully set to **pageSize**.

        This function was introduced in Qt 5.3.

        **See also** **pageSize** () and **pageLayout** ().
        """
        ...

    @typing.overload
    def setPageSize(self, pageSize: "QPageSize") -> bool:
        """
        https://doc.qt.io/qt-5/qpagedpaintdevice.html#setPageSize-1

        **[virtual] void
        QPagedPaintDevice::setPageSize(QPagedPaintDevice::PageSize size )**

        Sets the size of the a page to **size**.

        **See also** **setPageSizeMM** ().
        """
        ...

    def newPage(self) -> bool:
        """
        https://doc.qt.io/qt-5/qpagedpaintdevice.html#newPage

        **[pure virtual] bool QPagedPaintDevice::newPage()**

        Starts a new page. Returns `true` on success.
        """
        ...
