"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QOpenGLTextureBlitter(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qopengltextureblitter.html

    **Detailed Description**

    Drawing textured quads, in order to get the contents of a texture onto the
    screen, is a common operation when developing 2D user interfaces.
    QOpenGLTextureBlitter provides a convenience class to avoid repeating vertex
    data, shader sources, buffer and program management and matrix calculations.

    For example, a **QOpenGLWidget**  subclass can do the following to draw the
    contents rendered into a framebuffer at the pixel position `(x, y)`:

    void OpenGLWidget::initializeGL()
        {
            m_blitter.create();
    m_fbo = new **QOpenGLFramebufferObject** (size);
        }

        void
    OpenGLWidget::paintGL()
        {
            m_fbo->bind();
            // update
    offscreen content
            m_fbo->release();

            m_blitter.bind();
    const **QRect**  targetRect(**QPoint** (x, y), m_fbo->size());
            const
    QMatrix4x4 target = **QOpenGLTextureBlitter** ::targetTransform(targetRect,
    **QRect** (**QPoint** (0, 0), m_fbo->size()));
    m_blitter.blit(m_fbo->texture(), target, **QOpenGLTextureBlitter**
    ::OriginBottomLeft);
            m_blitter.release();
        }

    The blitter implements GLSL shaders both for GLSL 1.00 (suitable for OpenGL
    (ES) 2.x and compatibility profiles of newer OpenGL versions) and version
    150 (suitable for core profile contexts with OpenGL 3.2 and newer).
    """

    class Origin(int):
        OriginBottomLeft: QOpenGLTextureBlitter = ...
        OriginTopLeft: QOpenGLTextureBlitter = ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#QOpenGLTextureBlitter

        **QOpenGLTextureBlitter::QOpenGLTextureBlitter()**

        Constructs a new QOpenGLTextureBlitter instance.

        **Note:** no graphics resources are initialized in the constructor. This
        makes it safe to place plain QOpenGLTextureBlitter members into classes
        because the actual initialization that depends on the OpenGL context
        happens only in **create** ().
        """
        ...

    @staticmethod
    def sourceTransform(
        subTexture: QtCore.QRectF,
        textureSize: QtCore.QSize,
        origin: "QOpenGLTextureBlitter.Origin",
    ) -> QMatrix3x3:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#sourceTransform

        **[static] QMatrix3x3 QOpenGLTextureBlitter::sourceTransform(const
        QRectF & subTexture , const QSize & textureSize ,
        QOpenGLTextureBlitter::Origin origin )**

        Calculates a 3x3 matrix suitable as the input to **blit** (). This is
        used when only a part of the texture is to be used in the blit.

        **subTexture** is the desired source rectangle in pixels,
        **textureSize** is the full width and height of the texture data.
        **origin** specifies the orientation of the image data when it comes to
        the Y axis.

        **See also** **blit** () and **Origin** .
        """
        ...

    @staticmethod
    def targetTransform(target: QtCore.QRectF, viewport: QtCore.QRect) -> QMatrix4x4:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#targetTransform

        **[static] QMatrix4x4 QOpenGLTextureBlitter::targetTransform(const
        QRectF & target , const QRect & viewport )**

        Calculates a target transform suitable for **blit** ().

        **target** is the target rectangle in pixels. **viewport** describes the
        source dimensions and will in most cases be set to (0, 0, image width,
        image height).

        For unscaled output the size of **target** and **viewport** should
        match.

        **See also** **blit** ().
        """
        ...

    @typing.overload
    def blit(
        self,
        texture: int,
        targetTransform: QMatrix4x4,
        sourceOrigin: "QOpenGLTextureBlitter.Origin",
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#blit

        **void QOpenGLTextureBlitter::blit(GLuint texture , const QMatrix4x4 &
        targetTransform , QOpenGLTextureBlitter::Origin sourceOrigin )**

        Performs the blit with the source texture **texture**.

        **targetTransform** specifies the transformation applied. This is
        usually generated by the **targetTransform** () helper function.

        **sourceOrigin** specifies if the image data needs flipping. When
        **texture** corresponds to a texture attached to an FBO pass
        **OriginBottomLeft** . On the other hand, when **texture** is based on
        unflipped image data, pass **OriginTopLeft** . This is more efficient
        than using **QImage::mirrored** ().

        **See also** **targetTransform** (), **Origin** , and **bind** ().
        """
        ...

    @typing.overload
    def blit(
        self, texture: int, targetTransform: QMatrix4x4, sourceTransform: QMatrix3x3
    ) -> None:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#blit-1

        **void QOpenGLTextureBlitter::blit(GLuint texture , const QMatrix4x4 &
        targetTransform , const QMatrix3x3 & sourceTransform )**

        Performs the blit with the source texture **texture**.

        **targetTransform** specifies the transformation applied. This is
        usually generated by the **targetTransform** () helper function.

        **sourceTransform** specifies the transformation applied to the source.
        This allows using only a sub-rect of the source texture. This is usually
        generated by the **sourceTransform** () helper function.

        **See also** **sourceTransform** (), **targetTransform** (), **Origin**
        , and **bind** ().
        """
        ...

    def setOpacity(self, opacity: float) -> None:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#setOpacity

        **void QOpenGLTextureBlitter::setOpacity(float opacity )**

        Changes the opacity to **opacity**. The default opacity is 1.0.

        **Note:** the blitter does not alter the blend state. It is up to the
        caller of **blit** () to ensure the correct blend settings are active.
        """
        ...

    def setRedBlueSwizzle(self, swizzle: bool) -> None:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#setRedBlueSwizzle

        **void QOpenGLTextureBlitter::setRedBlueSwizzle(bool swizzle )**

        Sets whether swizzling is enabled for the red and blue color channels to
        **swizzle**. An BGRA to RGBA conversion (occurring in the shader on the
        GPU, instead of a slow CPU-side transformation) can be useful when the
        source texture contains data from a **QImage**  with a format like
        **QImage::Format_ARGB32**  which maps to BGRA on little endian systems.

        By default the red-blue swizzle is disabled since this is what a texture
        attached to an framebuffer object or a texture based on a byte ordered
        **QImage**  format (like **QImage::Format_RGBA8888** ) needs.
        """
        ...

    def release(self) -> None:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#release

        **void QOpenGLTextureBlitter::release()**

        Unbinds the graphics resources used by the blitter.

        **See also** **bind** ().
        """
        ...

    def bind(self, target: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#bind

        **void QOpenGLTextureBlitter::bind(GLenum target = GL_TEXTURE_2D)**

        Binds the graphics resources used by the blitter. This must be called
        before calling **blit** (). Code modifying the OpenGL state should be
        avoided between the call to bind() and **blit** () because otherwise
        conflicts may arise.

        **target** is the texture target for the source texture and must be
        either `GL_TEXTURE_2D` or `GL_OES_EGL_image_external`.

        **See also** **release** () and **blit** ().
        """
        ...

    def supportsExternalOESTarget(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#supportsExternalOESTar
        get

        **bool QOpenGLTextureBlitter::supportsExternalOESTarget() const**

        Returns `true` when **bind** () accepts `GL_TEXTURE_EXTERNAL_OES` as its
        target argument.

        **See also** **bind** () and **blit** ().
        """
        ...

    def destroy(self) -> None:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#destroy

        **void QOpenGLTextureBlitter::destroy()**

        Frees all graphics resources held by the blitter. Assumes that the
        OpenGL context, or another context sharing resources with it, that was
        current on the thread when invoking **create** () is current.

        The function has no effect when the blitter is not in created state.

        **See also** **create** ().
        """
        ...

    def isCreated(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#isCreated

        **bool QOpenGLTextureBlitter::isCreated() const**

        Returns `true` if **create** () was called and succeeded. `false`
        otherwise.

        **See also** **create** () and **destroy** ().
        """
        ...

    def create(self) -> bool:
        """
        https://doc.qt.io/qt-5/qopengltextureblitter.html#create

        **bool QOpenGLTextureBlitter::create()**

        Initializes the graphics resources used by the blitter.

        Returns `true` if successful, `false` if there was a failure. Failures
        can occur when there is no OpenGL context current on the current thread,
        or when shader compilation fails for some reason.

        **See also** **isCreated** () and **destroy** ().
        """
        ...
