"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QIconEngine(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qiconengine.html

    **Detailed Description**

    An icon engine provides the rendering functions for a **QIcon** . Each icon
    has a corresponding icon engine that is responsible for drawing the icon
    with a requested size, mode and state.

    The icon is rendered by the **paint** () function, and the icon can
    additionally be obtained as a pixmap with the **pixmap** () function (the
    default implementation simply uses **paint** () to achieve this). The
    **addPixmap** () function can be used to add new pixmaps to the icon engine,
    and is used by **QIcon**  to add specialized custom pixmaps.

    The **paint** (), **pixmap** (), and **addPixmap** () functions are all
    virtual, and can therefore be reimplemented in subclasses of QIconEngine.

    **See also** **QIconEnginePlugin** .
    """

    class IconEngineHook(int):
        AvailableSizesHook: QIconEngine = ...
        IconNameHook: QIconEngine = ...
        IsNullHook: QIconEngine = ...
        ScaledPixmapHook: QIconEngine = ...

    class AvailableSizesArgument(sip.simplewrapper):
        mode: QIcon = ...
        sizes: typing = ...
        state: QIcon = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QIconEngine.AvailableSizesArgument") -> None:
            ...

    class ScaledPixmapArgument(sip.simplewrapper):
        mode: QIcon = ...
        pixmap: QPixmap = ...
        scale: float = ...
        size: QtCore = ...
        state: QIcon = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QIconEngine.ScaledPixmapArgument") -> None:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qiconengine.html#QIconEngine

        **QIconEngine::QIconEngine()**

        Constructs the icon engine.

        This function was introduced in Qt 5.6.
        """
        ...

    @typing.overload
    def __init__(self, other: "QIconEngine") -> None:
        """
        https://doc.qt.io/qt-5/qiconengine.html#QIconEngine

        **QIconEngine::QIconEngine()**

        Constructs the icon engine.

        This function was introduced in Qt 5.6.
        """
        ...

    def scaledPixmap(
        self, size: QtCore.QSize, mode: QIcon.Mode, state: QIcon.State, scale: float
    ) -> QPixmap:
        """
        https://doc.qt.io/qt-5/qiconengine.html#scaledPixmap

        **QPixmap QIconEngine::scaledPixmap(const QSize & size , QIcon::Mode
        mode , QIcon::State state , qreal scale )**

        Returns a pixmap for the given **size** , **mode** , **state** and
        **scale**.

        The **scale** argument is typically equal to the **device pixel ratio**
        of the display.

        **Note:** This is a helper method and the actual work is done by the
        **virtual_hook** () method, hence this method depends on icon engine
        support and may not work with all icon engines.

        **Note:** Some engines may cast **scale** to an integer.

        This function was introduced in Qt 5.9.

        **See also** **ScaledPixmapArgument** .
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qiconengine.html#isNull

        **bool QIconEngine::isNull() const**

        Returns true if this icon engine represent a null **QIcon** .

        **Note:** This is a helper method and the actual work is done by the
        **virtual_hook** () method, hence this method depends on icon engine
        support and may not work with all icon engines.

        This function was introduced in Qt 5.7.
        """
        ...

    def iconName(self) -> str:
        """
        https://doc.qt.io/qt-5/qiconengine.html#iconName

        **[virtual] QString QIconEngine::iconName() const**

        Returns the name used to create the engine, if available.

        **Note:** This is a helper method and the actual work is done by the
        **virtual_hook** () method, hence this method depends on icon engine
        support and may not work with all icon engines.

        This function was introduced in Qt 4.7.
        """
        ...

    def availableSizes(
        self, mode: QIcon.Mode = ..., state: QIcon.State = ...
    ) -> typing.List[QtCore.QSize]:
        """
        https://doc.qt.io/qt-5/qiconengine.html#availableSizes

        **[virtual] QList<QSize> QIconEngine::availableSizes(QIcon::Mode mode =
        QIcon::Normal, QIcon::State state = QIcon::Off) const**

        Returns sizes of all images that are contained in the engine for the
        specific **mode** and **state**.

        **Note:** This is a helper method and the actual work is done by the
        **virtual_hook** () method, hence this method depends on icon engine
        support and may not work with all icon engines.

        This function was introduced in Qt 4.5.
        """
        ...

    def write(self, out: QtCore.QDataStream) -> bool:
        """
        https://doc.qt.io/qt-5/qiconengine.html#write

        **[virtual] bool QIconEngine::write(QDataStream & out ) const**

        Writes the contents of this engine to the **QDataStream**  **out**.
        Returns `true` if the contents were written; otherwise returns `false`.

        **QIconEngine** 's default implementation always return false.
        """
        ...

    def read(self, in_: QtCore.QDataStream) -> bool:
        """
        https://doc.qt.io/qt-5/qiconengine.html#read

        **[virtual] bool QIconEngine::read(QDataStream & in )**

        Reads icon engine contents from the **QDataStream**  **in**. Returns
        true if the contents were read; otherwise returns `false`.

        **QIconEngine** 's default implementation always return false.
        """
        ...

    def clone(self) -> "QIconEngine":
        """
        https://doc.qt.io/qt-5/qiconengine.html#clone

        **[pure virtual] QIconEngine *QIconEngine::clone() const**

        Reimplement this method to return a clone of this icon engine.
        """
        ...

    def key(self) -> str:
        """
        https://doc.qt.io/qt-5/qiconengine.html#key

        **[virtual] QString QIconEngine::key() const**

        Returns a key that identifies this icon engine.
        """
        ...

    def addFile(
        self, fileName: str, size: QtCore.QSize, mode: QIcon.Mode, state: QIcon.State
    ) -> None:
        """
        https://doc.qt.io/qt-5/qiconengine.html#addFile

        **[virtual] void QIconEngine::addFile(const QString & fileName , const
        QSize & size , QIcon::Mode mode , QIcon::State state )**

        Called by **QIcon::addFile** (). Adds a specialized pixmap from the file
        with the given **fileName** , **size** , **mode** and **state**. The
        default pixmap-based engine stores any supplied file names, and it loads
        the pixmaps on demand instead of using scaled pixmaps if the size of a
        pixmap matches the size of icon requested. Custom icon engines that
        implement scalable vector formats are free to ignores any extra files.
        """
        ...

    def addPixmap(self, pixmap: QPixmap, mode: QIcon.Mode, state: QIcon.State) -> None:
        """
        https://doc.qt.io/qt-5/qiconengine.html#addPixmap

        **[virtual] void QIconEngine::addPixmap(const QPixmap & pixmap ,
        QIcon::Mode mode , QIcon::State state )**

        Called by **QIcon::addPixmap** (). Adds a specialized **pixmap** for the
        given **mode** and **state**. The default pixmap-based engine stores any
        supplied pixmaps, and it uses them instead of scaled pixmaps if the size
        of a pixmap matches the size of icon requested. Custom icon engines that
        implement scalable vector formats are free to ignores any extra pixmaps.
        """
        ...

    def pixmap(
        self, size: QtCore.QSize, mode: QIcon.Mode, state: QIcon.State
    ) -> QPixmap:
        """
        https://doc.qt.io/qt-5/qiconengine.html#pixmap

        **[virtual] QPixmap QIconEngine::pixmap(const QSize & size , QIcon::Mode
        mode , QIcon::State state )**

        Returns the icon as a pixmap with the required **size** , **mode** , and
        **state**. The default implementation creates a new pixmap and calls
        **paint** () to fill it.
        """
        ...

    def actualSize(
        self, size: QtCore.QSize, mode: QIcon.Mode, state: QIcon.State
    ) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qiconengine.html#actualSize

        **[virtual] QSize QIconEngine::actualSize(const QSize & size ,
        QIcon::Mode mode , QIcon::State state )**

        Returns the actual size of the icon the engine provides for the
        requested **size** , **mode** and **state**. The default implementation
        returns the given **size**.
        """
        ...

    def paint(
        self,
        painter: "QPainter",
        rect: QtCore.QRect,
        mode: QIcon.Mode,
        state: QIcon.State,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qiconengine.html#paint

        **[pure virtual] void QIconEngine::paint(QPainter * painter , const
        QRect & rect , QIcon::Mode mode , QIcon::State state )**

        Uses the given **painter** to paint the icon with the required **mode**
        and **state** into the rectangle **rect**.
        """
        ...
