"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QGuiApplication(QtCore.QCoreApplication):
    """
    https://doc.qt.io/qt-5/qguiapplication.html

    **Detailed Description**

    QGuiApplication contains the main event loop, where all events from the
    window system and other sources are processed and dispatched. It also
    handles the application's initialization and finalization, and provides
    session management. In addition, QGuiApplication handles most of the system-
    wide and application-wide settings.

    For any GUI application using Qt, there is precisely **one** QGuiApplication
    object no matter whether the application has 0, 1, 2 or more windows at any
    given time. For non-GUI Qt applications, use **QCoreApplication**  instead,
    as it does not depend on the Qt GUI module. For **QWidget**  based Qt
    applications, use **QApplication**  instead, as it provides some
    functionality needed for creating **QWidget**  instances.

    The QGuiApplication object is accessible through the **instance** ()
    function, which returns a pointer equivalent to the global **qApp**
    pointer.

    QGuiApplication's main areas of responsibility are:

    * It initializes the application with the user's desktop settings, such as
    **palette** (), **font** () and **styleHints** (). It keeps track of these
    properties in case the user changes the desktop globally, for example,
    through some kind of control panel.
      * It performs event handling, meaning
    that it receives events from the underlying window system and dispatches
    them to the relevant widgets. You can send your own events to windows by
    using **sendEvent** () and **postEvent** ().
      * It parses common command
    line arguments and sets its internal state accordingly. See the
    **constructor documentation**  below for more details.
      * It provides
    localization of strings that are visible to the user via **translate** ().
    * It provides some magical objects like the **clipboard** ().
      * It knows
    about the application's windows. You can ask which window is at a certain
    position using **topLevelAt** (), get a list of **topLevelWindows** (), etc.
    * It manages the application's mouse cursor handling, see
    **setOverrideCursor** ()
      * It provides support for sophisticated **session
    management** . This makes it possible for applications to terminate
    gracefully when the user logs out, to cancel a shutdown process if
    termination isn't possible and even to preserve the entire application's
    state for a future session. See **isSessionRestored** (), **sessionId** ()
    and **commitDataRequest** () and **saveStateRequest** () for details.

    Since the QGuiApplication object does so much initialization, it **must** be
    created before any other objects related to the user interface are created.
    QGuiApplication also deals with common command line arguments. Hence, it is
    usually a good idea to create it **before** any interpretation or
    modification of `argv` is done in the application itself.

    Groups of functions
    System settings**desktopSettingsAware** (),
    **setDesktopSettingsAware** (), **styleHints** (), **palette** (),
    **setPalette** (), **font** (), **setFont** ().
    Event handling**exec** (),
    **processEvents** (), **exit** (), **quit** (). **sendEvent** (),
    **postEvent** (), **sendPostedEvents** (), **removePostedEvents** (),
    hasPendingEvents(), **notify** ().
    Windows**allWindows** (),
    **topLevelWindows** (), **focusWindow** (), **clipboard** (), **topLevelAt**
    ().
    Advanced cursor handling**overrideCursor** (), **setOverrideCursor**
    (), **restoreOverrideCursor** ().
    Session management**isSessionRestored**
    (), **sessionId** (), **commitDataRequest** (), **saveStateRequest** ().
    Miscellaneous**startingUp** (), **closingDown** ().

    **See also** **QCoreApplication** , **QAbstractEventDispatcher** , and
    **QEventLoop** .
    """

    def __init__(self, argv: typing.List[str]) -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#QGuiApplication

        **QGuiApplication::QGuiApplication(int & argc , char ** argv )**

        Initializes the window system and constructs an application object with
        **argc** command line arguments in **argv**.

        **Warning:** The data referred to by **argc** and **argv** must stay
        valid for the entire lifetime of the QGuiApplication object. In
        addition, **argc** must be greater than zero and **argv** must contain
        at least one valid character string.

        The global `qApp` pointer refers to this application object. Only one
        application object should be created.

        This application object must be constructed before any **paint devices**
        (including pixmaps, bitmaps etc.).

        **Note:** **argc** and **argv** might be changed as Qt removes command
        line arguments that it recognizes.

        **Supported Command Line Options**

        All Qt programs automatically support a set of command-line options that
        allow modifying the way Qt will interact with the windowing system. Some
        of the options are also accessible via environment variables, which are
        the preferred form if the application can launch GUI sub-processes or
        other applications (environment variables will be inherited by child
        processes). When in doubt, use the environment variables.

        The options currently supported are the following:

        * `-platform` ****platformName** [:options]**, specifies the **Qt
        Platform Abstraction**  (QPA) plugin.

        Overrides the `QT_QPA_PLATFORM`
        environment variable.

          * `-platformpluginpath` **path** , specifies
        the path to platform plugins.

        Overrides the
        `QT_QPA_PLATFORM_PLUGIN_PATH` environment variable.

          *
        `-platformtheme` **platformTheme** , specifies the platform theme.
        Overrides the `QT_QPA_PLATFORMTHEME` environment variable.

          *
        `-plugin` **plugin** , specifies additional plugins to load. The
        argument may appear multiple times.

        Concatenated with the plugins in
        the `QT_QPA_GENERIC_PLUGINS` environment variable.

          *
        `-qmljsdebugger=`, activates the QML/JS debugger with a specified port.
        The value must be of format `port:1234` **[,block]** , where **block**
        is optional and will make the application wait until a debugger connects
        to it.
          * `-qwindowgeometry` **geometry** , specifies window geometry
        for the main window using the X11-syntax. For example: `-qwindowgeometry
        100x100+50+50`
          * `-qwindowicon`, sets the default window icon
          *
        `-qwindowtitle`, sets the title of the first window
          * `-reverse`, sets
        the application's layout direction to **Qt::RightToLeft** . This option
        is intended to aid debugging and should not be used in production. The
        default value is automatically detected from the user's locale (see also
        **QLocale::textDirection** ()).
          * `-session` **session** , restores
        the application from an earlier **session** .

        The following standard command line options are available for X11:

        * `-display` **hostname:screen_number** , switches displays on X11.
        Overrides the `DISPLAY` environment variable.

          * `-geometry`
        **geometry** , same as `-qwindowgeometry`.

        **Platform-Specific Arguments**

        You can specify platform-specific arguments for the `-platform` option.
        Place them after the platform plugin name following a colon as a comma-
        separated list. For example, `-platform
        windows:dialogs=xp,fontengine=freetype`.

        The following parameters are available for `-platform windows`:

        * `altgr`, detect the key `AltGr` found on some keyboards as
        **Qt::GroupSwitchModifier**  (since Qt 5.12).
          * `darkmode=[1|2]`
        controls how Qt responds to the activation of the **Dark Mode for
        applications** introduced in Windows 10 1903 (since Qt 5.15).

        A value
        of 1 causes Qt to switch the window borders to black when **Dark Mode
        for applications** is activated and no High Contrast Theme is in use.
        This is intended for applications that implement their own theming.

        A
        value of 2 will in addition cause the Windows Vista style to be
        deactivated and switch to the Windows style using a simplified palette
        in dark mode. This is currently experimental pending the introduction of
        new style that properly adapts to dark mode.

          * `dialogs=[xp|none]`,
        `xp` uses XP-style native dialogs and `none` disables them.
          *
        `dpiawareness=[0|1|2]` Sets the DPI awareness of the process (see **High
        DPI Displays** , since Qt 5.4).
          * `fontengine=freetype`, uses the
        **FreeType**  font engine.
          * `menus=[native|none]`, controls the use
        of native menus.

        Native menus are implemented using Win32 API and are
        simpler than **QMenu** -based menus in for example that they do allow
        for placing widgets on them or changing properties like fonts and do not
        provide hover signals. They are mainly intended for Qt Quick. By
        default, they will be used if the application is not an instance of
        **QApplication**  or for Qt Quick Controls 2 applications (since Qt
        5.10).

          * `nocolorfonts` Turn off DirectWrite Color fonts (since Qt
        5.8).
          * `nodirectwrite` Turn off DirectWrite fonts (since Qt 5.8).
          *
        `nomousefromtouch` Ignores mouse events synthesized from touch events by
        the operating system.
          * `nowmpointer` Switches from Pointer Input
        Messages handling to legacy mouse handling (since Qt 5.12).
          *
        `reverse` Activates Right-to-left mode (experimental). Windows title
        bars will be shown accordingly in Right-to-left locales (since Qt 5.13).
        * `tabletabsoluterange=<value>` Sets a value for mouse mode detection of
        **WinTab**  tablets (Legacy, since Qt 5.3).

        The following parameter is available for `-platform cocoa` (on macOS):

        * `fontengine=freetype`, uses the **FreeType**  font engine.

        For more information about the platform-specific arguments available for
        embedded Linux platforms, see **Qt for Embedded Linux** .

        **See also** **arguments** () and **QGuiApplication::platformName** .
        """
        ...

    @staticmethod
    def highDpiScaleFactorRoundingPolicy() -> QtCore.Qt.HighDpiScaleFactorRoundingPolicy:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#highDpiScaleFactorRoundingPo
        licy

        **[static] Qt::HighDpiScaleFactorRoundingPolicy
        QGuiApplication::highDpiScaleFactorRoundingPolicy()**

        Returns the high-DPI scale factor rounding policy.

        This function was introduced in Qt 5.14.

        **See also** **setHighDpiScaleFactorRoundingPolicy** ().
        """
        ...

    @staticmethod
    def setHighDpiScaleFactorRoundingPolicy(
        policy: QtCore.Qt.HighDpiScaleFactorRoundingPolicy,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#setHighDpiScaleFactorRoundin
        gPolicy

        **[static] void QGuiApplication::setHighDpiScaleFactorRoundingPolicy(Qt:
        :HighDpiScaleFactorRoundingPolicy policy )**

        Sets the high-DPI scale factor rounding policy for the application. The
        **policy** decides how non-integer scale factors (such as Windows 150%)
        are handled, for applications that have AA_EnableHighDpiScaling enabled.

        The two principal options are whether fractional scale factors should be
        rounded to an integer or not. Keeping the scale factor as-is will make
        the user interface size match the OS setting exactly, but may cause
        painting errors, for example with the Windows style.

        If rounding is wanted, then which type of rounding should be decided
        next. Mathematically correct rounding is supported but may not give the
        best visual results: Consider if you want to render 1.5x as 1x ("small
        UI") or as 2x ("large UI"). See the
        **Qt::HighDpiScaleFactorRoundingPolicy**  enum for a complete list of
        all options.

        This function must be called before creating the application object, and
        can be overridden by setting the QT_SCALE_FACTOR_ROUNDING_POLICY
        environment variable. The
        **QGuiApplication::highDpiScaleFactorRoundingPolicy** () accessor will
        reflect the environment, if set.

        The default value is Qt::HighDpiScaleFactorRoundingPolicy::Round. On Qt
        for Android the default is
        Qt::HighDpiScaleFactorRoundingPolicy::PassThrough, which preserves
        historical behavior from earlier Qt versions.

        This function was introduced in Qt 5.14.

        **See also** **highDpiScaleFactorRoundingPolicy** ().
        """
        ...

    @staticmethod
    def screenAt(point: QtCore.QPoint) -> "QScreen":
        """
        https://doc.qt.io/qt-5/qguiapplication.html#screenAt

        **[static] QScreen *QGuiApplication::screenAt(const QPoint & point )**

        Returns the screen at **point** , or `nullptr` if outside of any screen.

        The **point** is in relation to the virtualGeometry() of each set of
        virtual siblings. If the point maps to more than one set of virtual
        siblings the first match is returned. If you wish to search only the
        virtual desktop siblings of a known screen (for example siblings of the
        screen of your application window `QWidget::windowHandle()->screen()`),
        use **QScreen::virtualSiblingAt** ().

        This function was introduced in Qt 5.10.
        """
        ...

    @staticmethod
    def desktopFileName() -> str:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#desktopFileName-prop

        **desktopFileName : QString**

        This property holds the base name of the desktop entry for this
        application

        This is the file name, without the full path, of the desktop entry that
        represents this application according to the freedesktop desktop entry
        specification.

        This property gives a precise indication of what desktop entry
        represents the application and it is needed by the windowing system to
        retrieve such information without resorting to imprecise heuristics.

        The latest version of the freedesktop desktop entry specification can be
        obtained **here** .

        This property was introduced in Qt 5.7.

        **Access functions:**

        QString **desktopFileName** ()
        void **setDesktopFileName** (const
        QString & **name** )
        """
        ...

    @staticmethod
    def setDesktopFileName(name: str) -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#desktopFileName-prop

        **desktopFileName : QString**

        This property holds the base name of the desktop entry for this
        application

        This is the file name, without the full path, of the desktop entry that
        represents this application according to the freedesktop desktop entry
        specification.

        This property gives a precise indication of what desktop entry
        represents the application and it is needed by the windowing system to
        retrieve such information without resorting to imprecise heuristics.

        The latest version of the freedesktop desktop entry specification can be
        obtained **here** .

        This property was introduced in Qt 5.7.

        **Access functions:**

        QString **desktopFileName** ()
        void **setDesktopFileName** (const
        QString & **name** )
        """
        ...

    @staticmethod
    def setFallbackSessionManagementEnabled(a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#setFallbackSessionManagement
        Enabled

        **[static] void
        QGuiApplication::setFallbackSessionManagementEnabled(bool enabled )**

        Sets whether **QGuiApplication**  will use fallback session management
        to **enabled**.

        This function was introduced in Qt 5.6.

        **See also** **isFallbackSessionManagementEnabled** ().
        """
        ...

    @staticmethod
    def isFallbackSessionManagementEnabled() -> bool:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#isFallbackSessionManagementE
        nabled

        **[static] bool QGuiApplication::isFallbackSessionManagementEnabled()**

        Returns whether **QGuiApplication**  will use fallback session
        management.

        The default is `true`.

        If this is `true` and the session manager allows user interaction,
        **QGuiApplication**  will try to close toplevel windows after
        **commitDataRequest** () has been emitted. If a window cannot be closed,
        session shutdown will be canceled and the application will keep running.

        Fallback session management only benefits applications that have an "are
        you sure you want to close this window?" feature or other logic that
        prevents closing a toplevel window depending on certain conditions, and
        that do nothing to explicitly implement session management. In
        applications that **do** implement session management using the proper
        session management API, fallback session management interferes and may
        break session management logic.

        **Warning:** If all windows **are** closed due to fallback session
        management and **quitOnLastWindowClosed** () is `true`, the application
        will quit before it is explicitly instructed to quit through the
        platform's session management protocol. That violation of protocol may
        prevent the platform session manager from saving application state.

        This function was introduced in Qt 5.6.

        **See also** **setFallbackSessionManagementEnabled** (),
        **QSessionManager::allowsInteraction** (), **saveStateRequest** (),
        **commitDataRequest** (), and **Session Management** .
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#event

        **[override virtual protected] bool QGuiApplication::event(QEvent * e
        )**

        Reimplements: **QCoreApplication::event** (QEvent *e).
        """
        ...

    @staticmethod
    def windowIcon() -> "QIcon":
        """
        https://doc.qt.io/qt-5/qguiapplication.html#windowIcon-prop

        **windowIcon : QIcon**

        This property holds the default window icon

        **Access functions:**

        QIcon **windowIcon** ()
        void **setWindowIcon** (const QIcon & **icon**
        )

        **See also** **QWindow::setIcon** () and **Setting the Application
        Icon** .

        **Member Function Documentation**
        """
        ...

    @staticmethod
    def setWindowIcon(icon: "QIcon") -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#windowIcon-prop

        **windowIcon : QIcon**

        This property holds the default window icon

        **Access functions:**

        QIcon **windowIcon** ()
        void **setWindowIcon** (const QIcon & **icon**
        )

        **See also** **QWindow::setIcon** () and **Setting the Application
        Icon** .

        **Member Function Documentation**
        """
        ...

    @staticmethod
    def sync() -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#sync

        **[static] void QGuiApplication::sync()**

        Function that can be used to sync Qt state with the Window Systems
        state.

        This function will first empty Qts events by calling
        **QCoreApplication::processEvents** (), then the platform plugin will
        sync up with the windowsystem, and finally Qts events will be delived by
        another call to **QCoreApplication::processEvents** ();

        This function is timeconsuming and its use is discouraged.

        This function was introduced in Qt 5.2.
        """
        ...

    @staticmethod
    def applicationState() -> QtCore.Qt.ApplicationState:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#applicationState

        **[static] Qt::ApplicationState QGuiApplication::applicationState()**

        Returns the current state of the application.

        You can react to application state changes to perform actions such as
        stopping/resuming CPU-intensive tasks, freeing/loading resources or
        saving/restoring application data.

        This function was introduced in Qt 5.2.
        """
        ...

    def isSavingSession(self) -> bool:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#isSavingSession

        **bool QGuiApplication::isSavingSession() const**

        Returns `true` if the application is currently saving the **session** ;
        otherwise returns `false`.

        This is `true` when **commitDataRequest** () and **saveStateRequest** ()
        are emitted, but also when the windows are closed afterwards by session
        management.

        This function was introduced in Qt 5.0.

        **See also** **sessionId** (), **commitDataRequest** (), and
        **saveStateRequest** ().
        """
        ...

    def sessionKey(self) -> str:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#sessionKey

        **QString QGuiApplication::sessionKey() const**

        Returns the session key in the current **session** .

        If the application has been restored from an earlier session, this key
        is the same as it was when the previous session ended.

        The session key changes every time the session is saved. If the shutdown
        process is cancelled, another session key will be used when shutting
        down again.

        **See also** **isSessionRestored** (), **sessionId** (),
        **commitDataRequest** (), and **saveStateRequest** ().
        """
        ...

    def sessionId(self) -> str:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#sessionId

        **QString QGuiApplication::sessionId() const**

        Returns the current **session's**  identifier.

        If the application has been restored from an earlier session, this
        identifier is the same as it was in that previous session. The session
        identifier is guaranteed to be unique both for different applications
        and for different instances of the same application.

        **See also** **isSessionRestored** (), **sessionKey** (),
        **commitDataRequest** (), and **saveStateRequest** ().
        """
        ...

    def isSessionRestored(self) -> bool:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#isSessionRestored

        **bool QGuiApplication::isSessionRestored() const**

        Returns `true` if the application has been restored from an earlier
        **session** ; otherwise returns `false`.

        **See also** **sessionId** (), **commitDataRequest** (), and
        **saveStateRequest** ().
        """
        ...

    def devicePixelRatio(self) -> float:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#devicePixelRatio

        **qreal QGuiApplication::devicePixelRatio() const**

        Returns the highest screen device pixel ratio found on the system. This
        is the ratio between physical pixels and device-independent pixels.

        Use this function only when you don't know which window you are
        targeting. If you do know the target window, use
        **QWindow::devicePixelRatio** () instead.

        **See also** **QWindow::devicePixelRatio** ().
        """
        ...

    @staticmethod
    def inputMethod() -> "QInputMethod":
        """
        https://doc.qt.io/qt-5/qguiapplication.html#inputMethod

        **[static] QInputMethod *QGuiApplication::inputMethod()**

        returns the input method.

        The input method returns properties about the state and position of the
        virtual keyboard. It also provides information about the position of the
        current focused input element.

        **See also** **QInputMethod** .
        """
        ...

    @staticmethod
    def styleHints() -> "QStyleHints":
        """
        https://doc.qt.io/qt-5/qguiapplication.html#styleHints

        **[static] QStyleHints *QGuiApplication::styleHints()**

        Returns the application's style hints.

        The style hints encapsulate a set of platform dependent properties such
        as double click intervals, full width selection and others.

        The hints can be used to integrate tighter with the underlying platform.

        **See also** **QStyleHints** .
        """
        ...

    @staticmethod
    def modalWindow() -> "QWindow":
        """
        https://doc.qt.io/qt-5/qguiapplication.html#modalWindow

        **[static] QWindow *QGuiApplication::modalWindow()**

        Returns the most recently shown modal window. If no modal windows are
        visible, this function returns zero.

        A modal window is a window which has its **modality**  property set to
        **Qt::WindowModal**  or **Qt::ApplicationModal** . A modal window must
        be closed before the user can continue with other parts of the program.

        Modal window are organized in a stack. This function returns the modal
        window at the top of the stack.

        **See also** **Qt::WindowModality**  and **QWindow::setModality** ().
        """
        ...

    @staticmethod
    def applicationDisplayName() -> str:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#applicationDisplayName-prop

        **applicationDisplayName : QString**

        This property holds the user-visible name of this application

        This name is shown to the user, for instance in window titles. It can be
        translated, if necessary.

        If not set, the application display name defaults to the application
        name.

        This property was introduced in Qt 5.0.

        **Access functions:**

        QString **applicationDisplayName** ()
        void
        **setApplicationDisplayName** (const QString & **name** )

        **Notifier signal:**

        void **applicationDisplayNameChanged** ()

        **See also** **applicationName** .
        """
        ...

    @staticmethod
    def setApplicationDisplayName(name: str) -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#applicationDisplayName-prop

        **applicationDisplayName : QString**

        This property holds the user-visible name of this application

        This name is shown to the user, for instance in window titles. It can be
        translated, if necessary.

        If not set, the application display name defaults to the application
        name.

        This property was introduced in Qt 5.0.

        **Access functions:**

        QString **applicationDisplayName** ()
        void
        **setApplicationDisplayName** (const QString & **name** )

        **Notifier signal:**

        void **applicationDisplayNameChanged** ()

        **See also** **applicationName** .
        """
        ...

    def notify(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#notify

        **[override virtual] bool QGuiApplication::notify(QObject * object ,
        QEvent * event )**

        Reimplements: **QCoreApplication::notify** (QObject *receiver, QEvent
        *event).
        """
        ...

    @staticmethod
    def exec() -> int:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#exec

        **[static] int QGuiApplication::exec()**

        Enters the main event loop and waits until **exit** () is called, and
        then returns the value that was set to **exit** () (which is 0 if
        **exit** () is called via **quit** ()).

        It is necessary to call this function to start event handling. The main
        event loop receives events from the window system and dispatches these
        to the application widgets.

        Generally, no user interaction can take place before calling exec().

        To make your application perform idle processing, e.g., executing a
        special function whenever there are no pending events, use a **QTimer**
        with 0 timeout. More advanced idle processing schemes can be achieved
        using **processEvents** ().

        We recommend that you connect clean-up code to the **aboutToQuit()**
        signal, instead of putting it in your application's `main()` function.
        This is because, on some platforms, the **QApplication::exec** () call
        may not return.

        **See also** **quitOnLastWindowClosed** , **quit** (), **exit** (),
        **processEvents** (), and **QCoreApplication::exec** ().
        """
        ...

    @staticmethod
    def exec_() -> int:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#exec

        **[static] int QGuiApplication::exec()**

        Enters the main event loop and waits until **exit** () is called, and
        then returns the value that was set to **exit** () (which is 0 if
        **exit** () is called via **quit** ()).

        It is necessary to call this function to start event handling. The main
        event loop receives events from the window system and dispatches these
        to the application widgets.

        Generally, no user interaction can take place before calling exec().

        To make your application perform idle processing, e.g., executing a
        special function whenever there are no pending events, use a **QTimer**
        with 0 timeout. More advanced idle processing schemes can be achieved
        using **processEvents** ().

        We recommend that you connect clean-up code to the **aboutToQuit()**
        signal, instead of putting it in your application's `main()` function.
        This is because, on some platforms, the **QApplication::exec** () call
        may not return.

        **See also** **quitOnLastWindowClosed** , **quit** (), **exit** (),
        **processEvents** (), and **QCoreApplication::exec** ().
        """
        ...

    @staticmethod
    def quitOnLastWindowClosed() -> bool:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#quitOnLastWindowClosed-prop

        **quitOnLastWindowClosed : bool**

        This property holds whether the application implicitly quits when the
        last window is closed.

        The default is `true`.

        If this property is `true`, the applications quits when the last visible
        primary window (i.e. window with no parent) is closed.

        **Access functions:**

        bool **quitOnLastWindowClosed** ()
        void **setQuitOnLastWindowClosed**
        (bool **quit** )

        **See also** **quit** () and **QWindow::close** ().
        """
        ...

    @staticmethod
    def setQuitOnLastWindowClosed(quit: bool) -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#quitOnLastWindowClosed-prop

        **quitOnLastWindowClosed : bool**

        This property holds whether the application implicitly quits when the
        last window is closed.

        The default is `true`.

        If this property is `true`, the applications quits when the last visible
        primary window (i.e. window with no parent) is closed.

        **Access functions:**

        bool **quitOnLastWindowClosed** ()
        void **setQuitOnLastWindowClosed**
        (bool **quit** )

        **See also** **quit** () and **QWindow::close** ().
        """
        ...

    @staticmethod
    def desktopSettingsAware() -> bool:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#desktopSettingsAware

        **[static] bool QGuiApplication::desktopSettingsAware()**

        Returns `true` if Qt is set to use the system's standard colors, fonts,
        etc.; otherwise returns `false`. The default is `true`.

        **See also** **setDesktopSettingsAware** ().
        """
        ...

    @staticmethod
    def setDesktopSettingsAware(on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#setDesktopSettingsAware

        **[static] void QGuiApplication::setDesktopSettingsAware(bool on )**

        Sets whether Qt should use the system's standard colors, fonts, etc., to
        **on**. By default, this is `true`.

        This function must be called before creating the **QGuiApplication**
        object, like this:

        int main(int argc, char *argv[])
            {
                **QApplication**
        ::setDesktopSettingsAware(false);
                **QApplication**  app(argc,
        argv);
                ...
                return app.exec();
            }

        **See also** **desktopSettingsAware** ().
        """
        ...

    @staticmethod
    def isLeftToRight() -> bool:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#isLeftToRight

        **[static] bool QGuiApplication::isLeftToRight()**

        Returns `true` if the application's layout direction is
        **Qt::LeftToRight** ; otherwise returns `false`.

        **See also** **layoutDirection** () and **isRightToLeft** ().
        """
        ...

    @staticmethod
    def isRightToLeft() -> bool:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#isRightToLeft

        **[static] bool QGuiApplication::isRightToLeft()**

        Returns `true` if the application's layout direction is
        **Qt::RightToLeft** ; otherwise returns `false`.

        **See also** **layoutDirection** () and **isLeftToRight** ().
        """
        ...

    @staticmethod
    def layoutDirection() -> QtCore.Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#layoutDirection-prop

        **layoutDirection : Qt::LayoutDirection**

        This property holds the default layout direction for this application

        On system start-up, the default layout direction depends on the
        application's language.

        The notifier signal was introduced in Qt 5.4.

        **Access functions:**

        Qt::LayoutDirection **layoutDirection** ()
        void **setLayoutDirection**
        (Qt::LayoutDirection **direction** )

        **Notifier signal:**

        void **layoutDirectionChanged** (Qt::LayoutDirection **direction** )

        **See also** **QWidget::layoutDirection** , **isLeftToRight** (), and
        **isRightToLeft** ().
        """
        ...

    @staticmethod
    def setLayoutDirection(direction: QtCore.Qt.LayoutDirection) -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#layoutDirection-prop

        **layoutDirection : Qt::LayoutDirection**

        This property holds the default layout direction for this application

        On system start-up, the default layout direction depends on the
        application's language.

        The notifier signal was introduced in Qt 5.4.

        **Access functions:**

        Qt::LayoutDirection **layoutDirection** ()
        void **setLayoutDirection**
        (Qt::LayoutDirection **direction** )

        **Notifier signal:**

        void **layoutDirectionChanged** (Qt::LayoutDirection **direction** )

        **See also** **QWidget::layoutDirection** , **isLeftToRight** (), and
        **isRightToLeft** ().
        """
        ...

    @staticmethod
    def mouseButtons() -> QtCore.Qt.MouseButtons:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#mouseButtons

        **[static] Qt::MouseButtons QGuiApplication::mouseButtons()**

        Returns the current state of the buttons on the mouse. The current state
        is updated synchronously as the event queue is emptied of events that
        will spontaneously change the mouse state (**QEvent::MouseButtonPress**
        and **QEvent::MouseButtonRelease**  events).

        It should be noted this may not reflect the actual buttons held on the
        input device at the time of calling but rather the mouse buttons as last
        reported in one of the above events. If no mouse buttons are being held
        **Qt::NoButton**  is returned.

        **See also** **keyboardModifiers** ().
        """
        ...

    @staticmethod
    def queryKeyboardModifiers() -> QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#queryKeyboardModifiers

        **[static] Qt::KeyboardModifiers
        QGuiApplication::queryKeyboardModifiers()**

        Queries and returns the state of the modifier keys on the keyboard.
        Unlike **keyboardModifiers** , this method returns the actual keys held
        on the input device at the time of calling the method.

        It does not rely on the keypress events having been received by this
        process, which makes it possible to check the modifiers while moving a
        window, for instance. Note that in most cases, you should use
        **keyboardModifiers** (), which is faster and more accurate since it
        contains the state of the modifiers as they were when the currently
        processed event was received.

        **See also** **keyboardModifiers** ().
        """
        ...

    @staticmethod
    def keyboardModifiers() -> QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#keyboardModifiers

        **[static] Qt::KeyboardModifiers QGuiApplication::keyboardModifiers()**

        Returns the current state of the modifier keys on the keyboard. The
        current state is updated sychronously as the event queue is emptied of
        events that will spontaneously change the keyboard state
        (**QEvent::KeyPress**  and **QEvent::KeyRelease**  events).

        It should be noted this may not reflect the actual keys held on the
        input device at the time of calling but rather the modifiers as last
        reported in one of the above events. If no keys are being held
        **Qt::NoModifier**  is returned.

        **See also** **mouseButtons** () and **queryKeyboardModifiers** ().
        """
        ...

    @staticmethod
    def setPalette(pal: "QPalette") -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#setPalette

        **[static] void QGuiApplication::setPalette(const QPalette & pal )**

        Changes the application palette to **pal**.

        The color roles from this palette are combined with the system's
        platform theme to form the application's final palette.

        **See also** **palette** ().
        """
        ...

    @staticmethod
    def palette() -> "QPalette":
        """
        https://doc.qt.io/qt-5/qguiapplication.html#palette

        **[static] QPalette QGuiApplication::palette()**

        Returns the current application palette.

        Roles that have not been explicitly set will reflect the system's
        platform theme.

        **See also** **setPalette** ().
        """
        ...

    @staticmethod
    def clipboard() -> QClipboard:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#clipboard

        **[static] QClipboard *QGuiApplication::clipboard()**

        Returns the object for interacting with the clipboard.
        """
        ...

    @staticmethod
    def setFont(a0: QFont) -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#setFont

        **[static] void QGuiApplication::setFont(const QFont & font )**

        Changes the default application font to **font**.

        **See also** **font** ().
        """
        ...

    @staticmethod
    def font() -> QFont:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#font

        **[static] QFont QGuiApplication::font()**

        Returns the default application font.

        **See also** **setFont** ().
        """
        ...

    @staticmethod
    def restoreOverrideCursor() -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#restoreOverrideCursor

        **[static] void QGuiApplication::restoreOverrideCursor()**

        Undoes the last **setOverrideCursor** ().

        If **setOverrideCursor** () has been called twice, calling
        restoreOverrideCursor() will activate the first cursor set. Calling this
        function a second time restores the original widgets' cursors.

        **See also** **setOverrideCursor** () and **overrideCursor** ().
        """
        ...

    @staticmethod
    def changeOverrideCursor(a0: typing.Union[QCursor, QtCore.Qt.CursorShape]) -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#changeOverrideCursor

        **[static] void QGuiApplication::changeOverrideCursor(const QCursor &
        cursor )**

        Changes the currently active application override cursor to **cursor**.

        This function has no effect if **setOverrideCursor** () was not called.

        **See also** **setOverrideCursor** (), **overrideCursor** (),
        **restoreOverrideCursor** (), and **QWidget::setCursor** ().
        """
        ...

    @staticmethod
    def setOverrideCursor(a0: typing.Union[QCursor, QtCore.Qt.CursorShape]) -> None:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#setOverrideCursor

        **[static] void QGuiApplication::setOverrideCursor(const QCursor &
        cursor )**

        Sets the application override cursor to **cursor**.

        Application override cursors are intended for showing the user that the
        application is in a special state, for example during an operation that
        might take some time.

        This cursor will be displayed in all the application's widgets until
        **restoreOverrideCursor** () or another setOverrideCursor() is called.

        Application cursors are stored on an internal stack. setOverrideCursor()
        pushes the cursor onto the stack, and **restoreOverrideCursor** () pops
        the active cursor off the stack. **changeOverrideCursor** () changes the
        curently active application override cursor.

        Every setOverrideCursor() must eventually be followed by a corresponding
        **restoreOverrideCursor** (), otherwise the stack will never be emptied.

        Example:

        **QGuiApplication** ::setOverrideCursor(**QCursor** (Qt::WaitCursor));
        calculateHugeMandelbrot();              // lunch time...
        **QGuiApplication** ::restoreOverrideCursor();

        **See also** **overrideCursor** (), **restoreOverrideCursor** (),
        **changeOverrideCursor** (), and **QWidget::setCursor** ().
        """
        ...

    @staticmethod
    def overrideCursor() -> QCursor:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#overrideCursor

        **[static] QCursor *QGuiApplication::overrideCursor()**

        Returns the active application override cursor.

        This function returns `nullptr` if no application cursor has been
        defined (i.e. the internal cursor stack is empty).

        **See also** **setOverrideCursor** () and **restoreOverrideCursor** ().
        """
        ...

    @staticmethod
    def screens() -> typing.List["QScreen"]:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#screens

        **[static] QList<QScreen *> QGuiApplication::screens()**

        Returns a list of all the screens associated with the windowing system
        the application is connected to.
        """
        ...

    @staticmethod
    def primaryScreen() -> "QScreen":
        """
        https://doc.qt.io/qt-5/qguiapplication.html#primaryScreen-prop

        **primaryScreen : QScreen* const**

        This property holds the primary (or default) screen of the application.

        This will be the screen where QWindows are initially shown, unless
        otherwise specified.

        The primaryScreenChanged signal was introduced in Qt 5.6.

        **Access functions:**

        QScreen * **primaryScreen** ()

        **Notifier signal:**

        void **primaryScreenChanged** (QScreen * **screen** )

        **See also** **screens** ().
        """
        ...

    @staticmethod
    def focusObject() -> QtCore.QObject:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#focusObject

        **[static] QObject *QGuiApplication::focusObject()**

        Returns the **QObject**  in currently active window that will be final
        receiver of events tied to focus, such as key events.
        """
        ...

    @staticmethod
    def focusWindow() -> "QWindow":
        """
        https://doc.qt.io/qt-5/qguiapplication.html#focusWindow

        **[static] QWindow *QGuiApplication::focusWindow()**

        Returns the **QWindow**  that receives events tied to focus, such as key
        events.
        """
        ...

    @staticmethod
    def platformName() -> str:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#platformName-prop

        **platformName : const QString**

        This property holds the name of the underlying platform plugin.

        The QPA platform plugins are located in `qtbase\\src\\plugins\\platforms`.
        At the time of writing, the following platform plugin names are
        supported:

        * `android`
          * `cocoa` is a platform plugin for macOS.
          * `directfb`
        * `eglfs` is a platform plugin for running Qt5 applications on top of
        EGL and OpenGL ES 2.0 without an actual windowing system (like X11 or
        Wayland). For more information, see **EGLFS** .
          * `ios` (also used for
        tvOS)
          * `kms` is an experimental platform plugin using kernel
        modesetting and **DRM**  (Direct Rendering Manager).
          * `linuxfb`
        writes directly to the framebuffer. For more information, see
        **LinuxFB** .
          * `minimal` is provided as an examples for developers
        who want to write their own platform plugins. However, you can use the
        plugin to run GUI applications in environments without a GUI, such as
        servers.
          * `minimalegl` is an example plugin.
          * `offscreen`
          *
        `openwfd`
          * `qnx`
          * `windows`
          * `wayland` is a platform plugin for
        modern Linux desktops and some embedded systems.
          * `xcb` is the X11
        plugin used on regular desktop Linux platforms.

        For more information about the platform plugins for embedded Linux
        devices, see **Qt for Embedded Linux** .

        **Access functions:**

        QString **platformName** ()
        """
        ...

    @staticmethod
    def topLevelAt(pos: QtCore.QPoint) -> "QWindow":
        """
        https://doc.qt.io/qt-5/qguiapplication.html#topLevelAt

        **[static] QWindow *QGuiApplication::topLevelAt(const QPoint & pos )**

        Returns the top level window at the given position **pos** , if any.
        """
        ...

    @staticmethod
    def topLevelWindows() -> typing.List["QWindow"]:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#topLevelWindows

        **[static] QWindowList QGuiApplication::topLevelWindows()**

        Returns a list of the top-level windows in the application.

        **See also** **allWindows** ().
        """
        ...

    @staticmethod
    def allWindows() -> typing.List["QWindow"]:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#allWindows

        **[static] QWindowList QGuiApplication::allWindows()**

        Returns a list of all the windows in the application.

        The list is empty if there are no windows.

        **See also** **topLevelWindows** ().
        """
        ...

    @property
    def applicationDisplayNameChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def applicationStateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#applicationStateChanged

        **[signal] void
        QGuiApplication::applicationStateChanged(Qt::ApplicationState state )**

        This signal is emitted when the **state** of the application changes.

        This function was introduced in Qt 5.2.

        **See also** **applicationState** ().
        """
        ...

    @property
    def commitDataRequest(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#commitDataRequest

        **[signal] void QGuiApplication::commitDataRequest(QSessionManager &
        manager )**

        This signal deals with **session management** . It is emitted when the
        **QSessionManager**  wants the application to commit all its data.

        Usually this means saving all open files, after getting permission from
        the user. Furthermore you may want to provide a means by which the user
        can cancel the shutdown.

        You should not exit the application within this signal. Instead, the
        session manager may or may not do this afterwards, depending on the
        context.

        **Warning:** Within this signal, no user interaction is possible,
        **unless** you ask the **manager** for explicit permission. See
        **QSessionManager::allowsInteraction** () and
        **QSessionManager::allowsErrorInteraction** () for details and example
        usage.

        **Note:** You should use **Qt::DirectConnection**  when connecting to
        this signal.

        This function was introduced in Qt 4.2.

        **See also** **setFallbackSessionManagementEnabled** (),
        **isSessionRestored** (), **sessionId** (), **saveStateRequest** (), and
        **Session Management** .
        """
        ...

    @property
    def focusObjectChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#focusObjectChanged

        **[signal] void QGuiApplication::focusObjectChanged(QObject *
        focusObject )**

        This signal is emitted when final receiver of events tied to focus is
        changed. **focusObject** is the new receiver.

        **See also** **focusObject** ().
        """
        ...

    @property
    def focusWindowChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#focusWindowChanged

        **[signal] void QGuiApplication::focusWindowChanged(QWindow *
        focusWindow )**

        This signal is emitted when the focused window changes. **focusWindow**
        is the new focused window.

        **See also** **focusWindow** ().
        """
        ...

    @property
    def fontChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#fontChanged

        **[signal] void QGuiApplication::fontChanged(const QFont & font )**

        This signal is emitted when the **font** of the application changes.

        This function was introduced in Qt 5.11.

        **See also** **font** ().
        """
        ...

    @property
    def fontDatabaseChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#fontDatabaseChanged

        **[signal] void QGuiApplication::fontDatabaseChanged()**

        This signal is emitted when application fonts are loaded or removed.

        **See also** **QFontDatabase::addApplicationFont** (),
        **QFontDatabase::addApplicationFontFromData** (),
        **QFontDatabase::removeAllApplicationFonts** (), and
        **QFontDatabase::removeApplicationFont** ().
        """
        ...

    @property
    def lastWindowClosed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#lastWindowClosed

        **[signal] void QGuiApplication::lastWindowClosed()**

        This signal is emitted from **exec** () when the last visible primary
        window (i.e. window with no parent) is closed.

        By default, **QGuiApplication**  quits after this signal is emitted.
        This feature can be turned off by setting **quitOnLastWindowClosed**  to
        `false`.

        **See also** **QWindow::close** () and **QWindow::isTopLevel** ().
        """
        ...

    @property
    def layoutDirectionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def paletteChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#paletteChanged

        **[signal] void QGuiApplication::paletteChanged(const QPalette & palette
        )**

        This signal is emitted when the **palette** of the application changes.

        This function was introduced in Qt 5.4.

        **See also** **palette** ().
        """
        ...

    @property
    def primaryScreenChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def saveStateRequest(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#saveStateRequest

        **[signal] void QGuiApplication::saveStateRequest(QSessionManager &
        manager )**

        This signal deals with **session management** . It is invoked when the
        **session manager**  wants the application to preserve its state for a
        future session.

        For example, a text editor would create a temporary file that includes
        the current contents of its edit buffers, the location of the cursor and
        other aspects of the current editing session.

        You should never exit the application within this signal. Instead, the
        session manager may or may not do this afterwards, depending on the
        context. Furthermore, most session managers will very likely request a
        saved state immediately after the application has been started. This
        permits the session manager to learn about the application's restart
        policy.

        **Warning:** Within this signal, no user interaction is possible,
        **unless** you ask the **manager** for explicit permission. See
        **QSessionManager::allowsInteraction** () and
        **QSessionManager::allowsErrorInteraction** () for details.

        **Note:** You should use **Qt::DirectConnection**  when connecting to
        this signal.

        This function was introduced in Qt 4.2.

        **See also** **isSessionRestored** (), **sessionId** (),
        **commitDataRequest** (), and **Session Management** .
        """
        ...

    @property
    def screenAdded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#screenAdded

        **[signal] void QGuiApplication::screenAdded(QScreen * screen )**

        This signal is emitted whenever a new screen **screen** has been added
        to the system.

        **See also** **screens** (), **primaryScreen** , and **screenRemoved**
        ().
        """
        ...

    @property
    def screenRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qguiapplication.html#screenRemoved

        **[signal] void QGuiApplication::screenRemoved(QScreen * screen )**

        This signal is emitted whenever a **screen** is removed from the system.
        It provides an opportunity to manage the windows on the screen before Qt
        falls back to moving them to the primary screen.

        This function was introduced in Qt 5.4.

        **See also** **screens** (), **screenAdded** (), **QObject::destroyed**
        (), and **QWindow::setScreen** ().
        """
        ...
