"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QGradient(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qgradient.html

    **Detailed Description**

    Qt currently supports three types of gradient fills:

    * **Linear** gradients interpolate colors between start and end points.
      *
    **Simple** radial gradients interpolate colors between a focal point and end
    points on a circle surrounding it.
      * **Extended** radial gradients
    interpolate colors between a center and a focal circle.
      * **Conical**
    gradients interpolate colors around a center point.

    A gradient's type can be retrieved using the **type** () function. Each of
    the types is represented by a subclass of QGradient:

    **QLinearGradient** **QRadialGradient** **QConicalGradient**
    ![](images/qgradient-linear.png)![](images/qgradient-
    radial.png)![](images/qgradient-conical.png)

    The colors in a gradient are defined using stop points of the
    **QGradientStop**  type; i.e., a position and a color. Use the
    **setColorAt** () function to define a single stop point. Alternatively, use
    the **setStops** () function to define several stop points in one go. Note
    that the latter function **replaces** the current set of stop points.

    It is the gradient's complete set of stop points (accessible through the
    **stops** () function) that describes how the gradient area should be
    filled. If no stop points have been specified, a gradient of black at 0 to
    white at 1 is used.

    A diagonal linear gradient from black at (100, 100) to white at (200, 200)
    could be specified like this:

    **QLinearGradient**  linearGrad(**QPointF** (100, 100), **QPointF** (200,
    200));
            linearGrad.setColorAt(0, Qt::black);
    linearGrad.setColorAt(1, Qt::white);

    A gradient can have an arbitrary number of stop points. The following would
    create a radial gradient starting with red in the center, blue and then
    green on the edges:

    **QRadialGradient**  radialGrad(**QPointF** (100, 100), 100);
    radialGrad.setColorAt(0, Qt::red);
            radialGrad.setColorAt(0.5,
    Qt::blue);
            radialGrad.setColorAt(1, Qt::green);

    It is possible to repeat or reflect the gradient outside its area by
    specifiying the **spread method**  using the **setSpread** () function. The
    default is to pad the outside area with the color at the closest stop point.
    The currently set **spread method**  can be retrieved using the **spread**
    () function. The **QGradient::Spread**  enum defines three different
    methods:

    ![](images/qradialgradient-pad.png)![](images/qradialgradient-
    repeat.png)![](images/qradialgradient-reflect.png)
    **PadSpread**
    **RepeatSpread** **ReflectSpread**

    Note that the **setSpread** () function only has effect for linear and
    radial gradients. The reason is that the conical gradient is closed by
    definition, i.e. the **conical** gradient fills the entire circle from 0 -
    360 degrees, while the boundary of a radial or a linear gradient can be
    specified through its radius or final stop points, respectively.

    The gradient coordinates can be specified in logical coordinates, relative
    to device coordinates, or relative to object bounding box coordinates. The
    **coordinate mode**  can be set using the **setCoordinateMode** () function.
    The default is **LogicalMode** , where the gradient coordinates are
    specified in the same way as the object coordinates. To retrieve the
    currently set **coordinate mode**  use **coordinateMode** ().

    **See also** **The Gradients Example**  and **QBrush** .
    """

    class Preset(int):
        WarmFlame: QGradient = ...
        NightFade: QGradient = ...
        SpringWarmth: QGradient = ...
        JuicyPeach: QGradient = ...
        YoungPassion: QGradient = ...
        LadyLips: QGradient = ...
        SunnyMorning: QGradient = ...
        RainyAshville: QGradient = ...
        FrozenDreams: QGradient = ...
        WinterNeva: QGradient = ...
        DustyGrass: QGradient = ...
        TemptingAzure: QGradient = ...
        HeavyRain: QGradient = ...
        AmyCrisp: QGradient = ...
        MeanFruit: QGradient = ...
        DeepBlue: QGradient = ...
        RipeMalinka: QGradient = ...
        CloudyKnoxville: QGradient = ...
        MalibuBeach: QGradient = ...
        NewLife: QGradient = ...
        TrueSunset: QGradient = ...
        MorpheusDen: QGradient = ...
        RareWind: QGradient = ...
        NearMoon: QGradient = ...
        WildApple: QGradient = ...
        SaintPetersburg: QGradient = ...
        PlumPlate: QGradient = ...
        EverlastingSky: QGradient = ...
        HappyFisher: QGradient = ...
        Blessing: QGradient = ...
        SharpeyeEagle: QGradient = ...
        LadogaBottom: QGradient = ...
        LemonGate: QGradient = ...
        ItmeoBranding: QGradient = ...
        ZeusMiracle: QGradient = ...
        OldHat: QGradient = ...
        StarWine: QGradient = ...
        HappyAcid: QGradient = ...
        AwesomePine: QGradient = ...
        NewYork: QGradient = ...
        ShyRainbow: QGradient = ...
        MixedHopes: QGradient = ...
        FlyHigh: QGradient = ...
        StrongBliss: QGradient = ...
        FreshMilk: QGradient = ...
        SnowAgain: QGradient = ...
        FebruaryInk: QGradient = ...
        KindSteel: QGradient = ...
        SoftGrass: QGradient = ...
        GrownEarly: QGradient = ...
        SharpBlues: QGradient = ...
        ShadyWater: QGradient = ...
        DirtyBeauty: QGradient = ...
        GreatWhale: QGradient = ...
        TeenNotebook: QGradient = ...
        PoliteRumors: QGradient = ...
        SweetPeriod: QGradient = ...
        WideMatrix: QGradient = ...
        SoftCherish: QGradient = ...
        RedSalvation: QGradient = ...
        BurningSpring: QGradient = ...
        NightParty: QGradient = ...
        SkyGlider: QGradient = ...
        HeavenPeach: QGradient = ...
        PurpleDivision: QGradient = ...
        AquaSplash: QGradient = ...
        SpikyNaga: QGradient = ...
        LoveKiss: QGradient = ...
        CleanMirror: QGradient = ...
        PremiumDark: QGradient = ...
        ColdEvening: QGradient = ...
        CochitiLake: QGradient = ...
        SummerGames: QGradient = ...
        PassionateBed: QGradient = ...
        MountainRock: QGradient = ...
        DesertHump: QGradient = ...
        JungleDay: QGradient = ...
        PhoenixStart: QGradient = ...
        OctoberSilence: QGradient = ...
        FarawayRiver: QGradient = ...
        AlchemistLab: QGradient = ...
        OverSun: QGradient = ...
        PremiumWhite: QGradient = ...
        MarsParty: QGradient = ...
        EternalConstance: QGradient = ...
        JapanBlush: QGradient = ...
        SmilingRain: QGradient = ...
        CloudyApple: QGradient = ...
        BigMango: QGradient = ...
        HealthyWater: QGradient = ...
        AmourAmour: QGradient = ...
        RiskyConcrete: QGradient = ...
        StrongStick: QGradient = ...
        ViciousStance: QGradient = ...
        PaloAlto: QGradient = ...
        HappyMemories: QGradient = ...
        MidnightBloom: QGradient = ...
        Crystalline: QGradient = ...
        PartyBliss: QGradient = ...
        ConfidentCloud: QGradient = ...
        LeCocktail: QGradient = ...
        RiverCity: QGradient = ...
        FrozenBerry: QGradient = ...
        ChildCare: QGradient = ...
        FlyingLemon: QGradient = ...
        NewRetrowave: QGradient = ...
        HiddenJaguar: QGradient = ...
        AboveTheSky: QGradient = ...
        Nega: QGradient = ...
        DenseWater: QGradient = ...
        Seashore: QGradient = ...
        MarbleWall: QGradient = ...
        CheerfulCaramel: QGradient = ...
        NightSky: QGradient = ...
        MagicLake: QGradient = ...
        YoungGrass: QGradient = ...
        ColorfulPeach: QGradient = ...
        GentleCare: QGradient = ...
        PlumBath: QGradient = ...
        HappyUnicorn: QGradient = ...
        AfricanField: QGradient = ...
        SolidStone: QGradient = ...
        OrangeJuice: QGradient = ...
        GlassWater: QGradient = ...
        NorthMiracle: QGradient = ...
        FruitBlend: QGradient = ...
        MillenniumPine: QGradient = ...
        HighFlight: QGradient = ...
        MoleHall: QGradient = ...
        SpaceShift: QGradient = ...
        ForestInei: QGradient = ...
        RoyalGarden: QGradient = ...
        RichMetal: QGradient = ...
        JuicyCake: QGradient = ...
        SmartIndigo: QGradient = ...
        SandStrike: QGradient = ...
        NorseBeauty: QGradient = ...
        AquaGuidance: QGradient = ...
        SunVeggie: QGradient = ...
        SeaLord: QGradient = ...
        BlackSea: QGradient = ...
        GrassShampoo: QGradient = ...
        LandingAircraft: QGradient = ...
        WitchDance: QGradient = ...
        SleeplessNight: QGradient = ...
        AngelCare: QGradient = ...
        CrystalRiver: QGradient = ...
        SoftLipstick: QGradient = ...
        SaltMountain: QGradient = ...
        PerfectWhite: QGradient = ...
        FreshOasis: QGradient = ...
        StrictNovember: QGradient = ...
        MorningSalad: QGradient = ...
        DeepRelief: QGradient = ...
        SeaStrike: QGradient = ...
        NightCall: QGradient = ...
        SupremeSky: QGradient = ...
        LightBlue: QGradient = ...
        MindCrawl: QGradient = ...
        LilyMeadow: QGradient = ...
        SugarLollipop: QGradient = ...
        SweetDessert: QGradient = ...
        MagicRay: QGradient = ...
        TeenParty: QGradient = ...
        FrozenHeat: QGradient = ...
        GagarinView: QGradient = ...
        FabledSunset: QGradient = ...
        PerfectBlue: QGradient = ...
        NumPresets: QGradient = ...

    class Spread(int):
        PadSpread: QGradient = ...
        ReflectSpread: QGradient = ...
        RepeatSpread: QGradient = ...

    class Type(int):
        LinearGradient: QGradient = ...
        RadialGradient: QGradient = ...
        ConicalGradient: QGradient = ...
        NoGradient: QGradient = ...

    class CoordinateMode(int):
        LogicalMode: QGradient = ...
        StretchToDeviceMode: QGradient = ...
        ObjectBoundingMode: QGradient = ...
        ObjectMode: QGradient = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qgradient.html#QGradient-1

        **QGradient::QGradient(QGradient::Preset preset )**

        Constructs a gradient based on a predefined **preset**.

        The coordinate mode of the resulting gradient is
        **QGradient::ObjectMode** , allowing the preset to be applied to
        arbitrary object sizes.

        This function was introduced in Qt 5.12.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QGradient.Preset") -> None:
        """
        https://doc.qt.io/qt-5/qgradient.html#QGradient-1

        **QGradient::QGradient(QGradient::Preset preset )**

        Constructs a gradient based on a predefined **preset**.

        The coordinate mode of the resulting gradient is
        **QGradient::ObjectMode** , allowing the preset to be applied to
        arbitrary object sizes.

        This function was introduced in Qt 5.12.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QGradient") -> None:
        """
        https://doc.qt.io/qt-5/qgradient.html#QGradient-1

        **QGradient::QGradient(QGradient::Preset preset )**

        Constructs a gradient based on a predefined **preset**.

        The coordinate mode of the resulting gradient is
        **QGradient::ObjectMode** , allowing the preset to be applied to
        arbitrary object sizes.

        This function was introduced in Qt 5.12.
        """
        ...

    def setCoordinateMode(self, mode: "QGradient.CoordinateMode") -> None:
        """
        https://doc.qt.io/qt-5/qgradient.html#setCoordinateMode

        **void QGradient::setCoordinateMode(QGradient::CoordinateMode mode )**

        Sets the coordinate mode of this gradient to **mode**. The default mode
        is **LogicalMode** .

        This function was introduced in Qt 4.4.

        **See also** **coordinateMode** ().
        """
        ...

    def coordinateMode(self) -> "QGradient.CoordinateMode":
        """
        https://doc.qt.io/qt-5/qgradient.html#coordinateMode

        **QGradient::CoordinateMode QGradient::coordinateMode() const**

        Returns the coordinate mode of this gradient. The default mode is
        **LogicalMode** .

        This function was introduced in Qt 4.4.

        **See also** **setCoordinateMode** ().
        """
        ...

    def setSpread(self, aspread: "QGradient.Spread") -> None:
        """
        https://doc.qt.io/qt-5/qgradient.html#setSpread

        **void QGradient::setSpread(QGradient::Spread method )**

        Specifies the spread **method** that should be used for this gradient.

        Note that this function only has effect for linear and radial gradients.

        **See also** **spread** ().
        """
        ...

    def stops(self) -> typing.List[typing.Tuple[float, QColor]]:
        """
        https://doc.qt.io/qt-5/qgradient.html#stops

        **QGradientStops QGradient::stops() const**

        Returns the stop points for this gradient.

        If no stop points have been specified, a gradient of black at 0 to white
        at 1 is used.

        **See also** **setStops** () and **setColorAt** ().
        """
        ...

    def setStops(
        self,
        stops: typing.Iterable[
            typing.Tuple[
                float, typing.Union[QColor, QtCore.Qt.GlobalColor, "QGradient"]
            ]
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgradient.html#setStops

        **void QGradient::setStops(const QGradientStops & stopPoints )**

        Replaces the current set of stop points with the given **stopPoints**.
        The positions of the points must be in the range 0 to 1, and must be
        sorted with the lowest point first.

        **See also** **setColorAt** () and **stops** ().
        """
        ...

    def setColorAt(
        self,
        pos: float,
        color: typing.Union[QColor, QtCore.Qt.GlobalColor, "QGradient"],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgradient.html#setColorAt

        **void QGradient::setColorAt(qreal position , const QColor & color )**

        Creates a stop point at the given **position** with the given **color**.
        The given **position** must be in the range 0 to 1.

        **See also** **setStops** () and **stops** ().
        """
        ...

    def spread(self) -> "QGradient.Spread":
        """
        https://doc.qt.io/qt-5/qgradient.html#spread

        **QGradient::Spread QGradient::spread() const**

        Returns the spread method use by this gradient. The default is
        **PadSpread** .

        **See also** **setSpread** ().
        """
        ...

    def type(self) -> "QGradient.Type":
        """
        https://doc.qt.io/qt-5/qgradient.html#type

        **QGradient::Type QGradient::type() const**

        Returns the type of gradient.
        """
        ...
