"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QFontMetricsF(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qfontmetricsf.html

    **Detailed Description**

    QFontMetricsF functions calculate the size of characters and strings for a
    given font. You can construct a QFontMetricsF object with an existing
    **QFont**  to obtain metrics for that font. If the font is changed later,
    the font metrics object is **not** updated.

    Once created, the object provides functions to access the individual metrics
    of the font, its characters, and for strings rendered in the font.

    There are several functions that operate on the font: **ascent** (),
    **descent** (), **height** (), **leading** () and **lineSpacing** () return
    the basic size properties of the font. The **underlinePos** (),
    **overlinePos** (), **strikeOutPos** () and **lineWidth** () functions,
    return the properties of the line that underlines, overlines or strikes out
    the characters. These functions are all fast.

    There are also some functions that operate on the set of glyphs in the font:
    **minLeftBearing** (), **minRightBearing** () and **maxWidth** (). These are
    by necessity slow, and we recommend avoiding them if possible.

    For each character, you can get its **horizontalAdvance** (),
    **leftBearing** (), and **rightBearing** (), and find out whether it is in
    the font using **inFont** (). You can also treat the character as a string,
    and use the string functions on it.

    The string functions include **horizontalAdvance** (), to return the width
    of a string in pixels (or points, for a printer), **boundingRect** (), to
    return a rectangle large enough to contain the rendered string, and **size**
    (), to return the size of that rectangle.

    Example:

    **QFont**  font("times", 24);
        **QFontMetricsF**  fm(font);
        **qreal**
    pixelsWide = fm.horizontalAdvance("What's the width of this text?");
    **qreal**  pixelsHigh = fm.height();

    **See also** **QFont** , **QFontInfo** , and **QFontDatabase** .
    """

    @typing.overload
    def __init__(self, a0: QFont) -> None:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#QFontMetricsF

        **QFontMetricsF::QFontMetricsF(const QFont & font )**

        Constructs a font metrics object for **font**.

        The font metrics will be compatible with the paintdevice used to create
        **font**.

        The font metrics object holds the information for the font that is
        passed in the constructor at the time it is created, and is not updated
        if the font's attributes are changed later.

        Use QFontMetricsF(const **QFont**  &, **QPaintDevice**  *) to get the
        font metrics that are compatible with a certain paint device.
        """
        ...

    @typing.overload
    def __init__(self, a0: QFont, pd: QPaintDevice) -> None:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#QFontMetricsF-2

        **QFontMetricsF::QFontMetricsF(const QFont & font , const QPaintDevice *
        paintdevice )**

        Constructs a font metrics object for **font** and **paintdevice**.

        The font metrics will be compatible with the paintdevice passed. If the
        **paintdevice** is `nullptr`, the metrics will be screen-compatible, ie.
        the metrics you get if you use the font for drawing text on a
        **widgets**  or **pixmaps** , not on a **QPicture**  or **QPrinter** .

        The font metrics object holds the information for the font that is
        passed in the constructor at the time it is created, and is not updated
        if the font's attributes are changed later.

        This function was introduced in Qt 5.13.
        """
        ...

    @typing.overload
    def __init__(self, a0: QFontMetrics) -> None:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#QFontMetricsF-3

        **QFontMetricsF::QFontMetricsF(const QFontMetrics & fontMetrics )**

        Constructs a font metrics object with floating point precision from the
        given **fontMetrics** object.

        This function was introduced in Qt 4.2.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QFontMetricsF") -> None:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#QFontMetricsF-4

        **QFontMetricsF::QFontMetricsF(const QFontMetricsF & fm )**

        Constructs a copy of **fm**.
        """
        ...

    def fontDpi(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#fontDpi

        **qreal QFontMetricsF::fontDpi() const**

        Returns the font DPI.

        This function was introduced in Qt 5.14.
        """
        ...

    def horizontalAdvance(self, string: str, length: int = ...) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#horizontalAdvance

        **qreal QFontMetricsF::horizontalAdvance(const QString & text , int
        length = -1) const**

        Returns the horizontal advance in pixels of the first **length**
        characters of **text**. If **length** is negative (the default), the
        entire string is used.

        The advance is the distance appropriate for drawing a subsequent
        character after **text**.

        This function was introduced in Qt 5.11.

        **See also** **boundingRect** ().
        """
        ...

    def capHeight(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#capHeight

        **qreal QFontMetricsF::capHeight() const**

        Returns the cap height of the font.

        The cap height of a font is the height of a capital letter above the
        baseline. It specifically is the height of capital letters that are flat
        - such as H or I - as opposed to round letters such as O, or pointed
        letters like A, both of which may display overshoot.

        This function was introduced in Qt 5.8.

        **See also** **ascent** ().
        """
        ...

    def swap(self, other: "QFontMetricsF") -> None:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#swap

        **void QFontMetricsF::swap(QFontMetricsF & other )**

        Swaps this font metrics instance with **other**. This function is very
        fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def inFontUcs4(self, character: int) -> bool:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#inFontUcs4

        **bool QFontMetricsF::inFontUcs4(uint ch ) const**

        Returns `true` if the character given by **ch** , encoded in
        UCS-4/UTF-32, is a valid character in the font; otherwise returns
        `false`.
        """
        ...

    def tightBoundingRect(self, text: str) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#tightBoundingRect

        **QRectF QFontMetricsF::tightBoundingRect(const QString & text ) const**

        Returns a tight bounding rectangle around the characters in the string
        specified by **text**. The bounding rectangle always covers at least the
        set of pixels the text would cover if drawn at (0, 0).

        Note that the bounding rectangle may extend to the left of (0, 0), e.g.
        for italicized fonts, and that the width of the returned rectangle might
        be different than what the **horizontalAdvance** () method returns.

        If you want to know the advance width of the string (to lay out a set of
        strings next to each other), use **horizontalAdvance** () instead.

        Newline characters are processed as normal characters, **not** as
        linebreaks.

        **Warning:** Calling this method is very slow on Windows.

        This function was introduced in Qt 4.3.

        **See also** **horizontalAdvance** (), **height** (), and
        **boundingRect** ().
        """
        ...

    def elidedText(
        self, text: str, mode: QtCore.Qt.TextElideMode, width: float, flags: int = ...
    ) -> str:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#elidedText

        **QString QFontMetricsF::elidedText(const QString & text ,
        Qt::TextElideMode mode , qreal width , int flags = 0) const**

        If the string **text** is wider than **width** , returns an elided
        version of the string (i.e., a string with "..." in it). Otherwise,
        returns the original string.

        The **mode** parameter specifies whether the text is elided on the left
        (for example, "...tech"), in the middle (for example, "Tr...ch"), or on
        the right (for example, "Trol...").

        The **width** is specified in pixels, not characters.

        The **flags** argument is optional and currently only supports
        **Qt::TextShowMnemonic**  as value.

        The elide mark follows the **layoutdirection** . For example, it will be
        on the right side of the text for right-to-left layouts if the **mode**
        is `Qt::ElideLeft`, and on the left side of the text if the **mode** is
        `Qt::ElideRight`.

        This function was introduced in Qt 4.2.
        """
        ...

    def averageCharWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#averageCharWidth

        **qreal QFontMetricsF::averageCharWidth() const**

        Returns the average width of glyphs in the font.

        This function was introduced in Qt 4.2.
        """
        ...

    def lineWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#lineWidth

        **qreal QFontMetricsF::lineWidth() const**

        Returns the width of the underline and strikeout lines, adjusted for the
        point size of the font.

        **See also** **underlinePos** (), **overlinePos** (), and
        **strikeOutPos** ().
        """
        ...

    def strikeOutPos(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#strikeOutPos

        **qreal QFontMetricsF::strikeOutPos() const**

        Returns the distance from the base line to where the strikeout line
        should be drawn.

        **See also** **underlinePos** (), **overlinePos** (), and **lineWidth**
        ().
        """
        ...

    def overlinePos(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#overlinePos

        **qreal QFontMetricsF::overlinePos() const**

        Returns the distance from the base line to where an overline should be
        drawn.

        **See also** **underlinePos** (), **strikeOutPos** (), and **lineWidth**
        ().
        """
        ...

    def underlinePos(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#underlinePos

        **qreal QFontMetricsF::underlinePos() const**

        Returns the distance from the base line to where an underscore should be
        drawn.

        **See also** **overlinePos** (), **strikeOutPos** (), and **lineWidth**
        ().
        """
        ...

    def size(
        self,
        flags: int,
        text: str,
        tabStops: int = ...,
        tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...,
    ) -> QtCore.QSizeF:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#size

        **QSizeF QFontMetricsF::size(int flags , const QString & text , int
        tabStops = 0, int * tabArray = nullptr) const**

        Returns the size in pixels of the characters in the given **text**.

        The **flags** argument is the bitwise OR of the following flags:

        * **Qt::TextSingleLine**  ignores newline characters.
          *
        **Qt::TextExpandTabs**  expands tabs (see below)
          *
        **Qt::TextShowMnemonic**  interprets "&x" as **x** ; i.e., underlined.
        * **Qt::TextWordWrap**  breaks the text to fit the rectangle.

        These flags are defined in the **Qt::TextFlag**  enum.

        If **Qt::TextExpandTabs**  is set in **flags** , the following behavior
        is used to interpret tab characters in the text:

        * If **tabArray** is non-null, it specifies a 0-terminated sequence of
        pixel-positions for tabs in the text.
          * If **tabStops** is non-zero,
        it is used as the tab spacing (in pixels).

        Newline characters are processed as line breaks.

        Note: Despite the different actual character heights, the heights of the
        bounding rectangles of "Yes" and "yes" are the same.

        **See also** **boundingRect** ().
        """
        ...

    @typing.overload
    def boundingRect(self, string: str) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#boundingRect

        **QRectF QFontMetricsF::boundingRect(const QString & text ) const**

        Returns the bounding rectangle of the characters in the string specified
        by **text**. The bounding rectangle always covers at least the set of
        pixels the text would cover if drawn at (0, 0).

        Note that the bounding rectangle may extend to the left of (0, 0), e.g.
        for italicized fonts, and that the width of the returned rectangle might
        be different than what the **horizontalAdvance** () method returns.

        If you want to know the advance width of the string (to lay out a set of
        strings next to each other), use **horizontalAdvance** () instead.

        Newline characters are processed as normal characters, **not** as
        linebreaks.

        The height of the bounding rectangle is at least as large as the value
        returned **height** ().

        **See also** **horizontalAdvance** (), **height** (), and
        **QPainter::boundingRect** ().
        """
        ...

    @typing.overload
    def boundingRect(
        self,
        rect: QtCore.QRectF,
        flags: int,
        text: str,
        tabStops: int = ...,
        tabArray: typing.Optional[typing.Optional[typing.List[int]]] = ...,
    ) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#boundingRect-1

        **QRectF QFontMetricsF::boundingRect(QChar ch ) const**

        Returns the bounding rectangle of the character **ch** relative to the
        left-most point on the base line.

        Note that the bounding rectangle may extend to the left of (0, 0), e.g.
        for italicized fonts, and that the text output may cover **all** pixels
        in the bounding rectangle.

        Note that the rectangle usually extends both above and below the base
        line.

        **See also** **horizontalAdvance** ().
        """
        ...

    def boundingRectChar(self, a0: str) -> QtCore.QRectF:
        ...

    def width(self, string: str) -> float:
        ...

    def widthChar(self, a0: str) -> float:
        ...

    def rightBearing(self, a0: str) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#rightBearing

        **qreal QFontMetricsF::rightBearing(QChar ch ) const**

        Returns the right bearing of character **ch** in the font.

        The right bearing is the left-ward distance of the right-most pixel of
        the character from the logical origin of a subsequent character. This
        value is negative if the pixels of the character extend to the right of
        the **horizontalAdvance** () of the character.

        See **horizontalAdvance** () for a graphical description of this metric.

        **See also** **leftBearing** (), **minRightBearing** (), and
        **horizontalAdvance** ().
        """
        ...

    def leftBearing(self, a0: str) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#leftBearing

        **qreal QFontMetricsF::leftBearing(QChar ch ) const**

        Returns the left bearing of character **ch** in the font.

        The left bearing is the right-ward distance of the left-most pixel of
        the character from the logical origin of the character. This value is
        negative if the pixels of the character extend to the left of the
        logical origin.

        See **horizontalAdvance** () for a graphical description of this metric.

        **See also** **rightBearing** (), **minLeftBearing** (), and
        **horizontalAdvance** ().
        """
        ...

    def inFont(self, a0: str) -> bool:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#inFont

        **bool QFontMetricsF::inFont(QChar ch ) const**

        Returns `true` if character **ch** is a valid character in the font;
        otherwise returns `false`.
        """
        ...

    def xHeight(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#xHeight

        **qreal QFontMetricsF::xHeight() const**

        Returns the 'x' height of the font. This is often but not always the
        same as the height of the character 'x'.
        """
        ...

    def maxWidth(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#maxWidth

        **qreal QFontMetricsF::maxWidth() const**

        Returns the width of the widest character in the font.
        """
        ...

    def minRightBearing(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#minRightBearing

        **qreal QFontMetricsF::minRightBearing() const**

        Returns the minimum right bearing of the font.

        This is the smallest **rightBearing** (char) of all characters in the
        font.

        Note that this function can be very slow if the font is large.

        **See also** **minLeftBearing** () and **rightBearing** ().
        """
        ...

    def minLeftBearing(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#minLeftBearing

        **qreal QFontMetricsF::minLeftBearing() const**

        Returns the minimum left bearing of the font.

        This is the smallest **leftBearing** (char) of all characters in the
        font.

        Note that this function can be very slow if the font is large.

        **See also** **minRightBearing** () and **leftBearing** ().
        """
        ...

    def lineSpacing(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#lineSpacing

        **qreal QFontMetricsF::lineSpacing() const**

        Returns the distance from one base line to the next.

        This value is always equal to **leading** ()+**height** ().

        **See also** **height** () and **leading** ().
        """
        ...

    def leading(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#leading

        **qreal QFontMetricsF::leading() const**

        Returns the leading of the font.

        This is the natural inter-line spacing.

        **See also** **height** () and **lineSpacing** ().
        """
        ...

    def height(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#height

        **qreal QFontMetricsF::height() const**

        Returns the height of the font.

        This is always equal to **ascent** ()+**descent** ().

        **See also** **leading** () and **lineSpacing** ().
        """
        ...

    def descent(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#descent

        **qreal QFontMetricsF::descent() const**

        Returns the descent of the font.

        The descent is the distance from the base line to the lowest point
        characters extend to. (Note that this is different from X, which adds 1
        pixel.) In practice, some font designers break this rule, e.g. to
        accommodate an unusual character in an exotic language, so it is
        possible (though rare) that this value will be too small.

        **See also** **ascent** ().
        """
        ...

    def ascent(self) -> float:
        """
        https://doc.qt.io/qt-5/qfontmetricsf.html#ascent

        **qreal QFontMetricsF::ascent() const**

        Returns the ascent of the font.

        The ascent of a font is the distance from the baseline to the highest
        position characters extend to. In practice, some font designers break
        this rule, e.g. when they put more than one accent on top of a
        character, or to accommodate an unusual character in an exotic language,
        so it is possible (though rare) that this value will be too small.

        **See also** **descent** ().
        """
        ...
