"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtGui import *
from PyQt5 import sip


class QFont(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qfont.html

    **Detailed Description**

    QFont can be regarded as a query for one or more fonts on the system.

    When you create a QFont object you specify various attributes that you want
    the font to have. Qt will use the font with the specified attributes, or if
    no matching font exists, Qt will use the closest matching installed font.
    The attributes of the font that is actually used are retrievable from a
    **QFontInfo**  object. If the window system provides an exact match
    **exactMatch** () returns `true`. Use **QFontMetricsF**  to get
    measurements, e.g. the pixel length of a string using QFontMetrics::width().

    Attributes which are not specifically set will not affect the font selection
    algorithm, and default values will be preferred instead.

    To load a specific physical font, typically represented by a single file,
    use **QRawFont**  instead.

    Note that a **QGuiApplication**  instance must exist before a QFont can be
    used. You can set the application's default font with
    **QGuiApplication::setFont** ().

    If a chosen font does not include all the characters that need to be
    displayed, QFont will try to find the characters in the nearest equivalent
    fonts. When a **QPainter**  draws a character from a font the QFont will
    report whether or not it has the character; if it does not, **QPainter**
    will draw an unfilled square.

    Create QFonts like this:

    **QFont**  serifFont("Times", 10, **QFont** ::Bold);
        **QFont**
    sansFont("Helvetica [Cronyx]", 12);

    The attributes set in the constructor can also be set later, e.g.
    **setFamily** (), **setPointSize** (), **setPointSizeF** (), **setWeight**
    () and **setItalic** (). The remaining attributes must be set after
    contstruction, e.g. **setBold** (), **setUnderline** (), **setOverline** (),
    **setStrikeOut** () and **setFixedPitch** (). **QFontInfo**  objects should
    be created **after** the font's attributes have been set. A **QFontInfo**
    object will not change, even if you change the font's attributes. The
    corresponding "get" functions, e.g. **family** (), **pointSize** (), etc.,
    return the values that were set, even though the values used may differ. The
    actual values are available from a **QFontInfo**  object.

    If the requested font family is unavailable you can influence the **font
    matching algorithm**  by choosing a particular **QFont::StyleHint**  and
    **QFont::StyleStrategy**  with **setStyleHint** (). The default family
    (corresponding to the current style hint) is returned by **defaultFamily**
    ().

    You can provide substitutions for font family names using
    **insertSubstitution** () and **insertSubstitutions** (). Substitutions can
    be removed with **removeSubstitutions** (). Use **substitute** () to
    retrieve a family's first substitute, or the family name itself if it has no
    substitutes. Use **substitutes** () to retrieve a list of a family's
    substitutes (which may be empty). After substituting a font, you must
    trigger the updating of the font by destroying and re-creating all QFont
    objects.

    Every QFont has a **key** () which you can use, for example, as the key in a
    cache or dictionary. If you want to store a user's font preferences you
    could use **QSettings** , writing the font information with **toString** ()
    and reading it back with **fromString** (). The operator<<() and
    operator>>() functions are also available, but they work on a data stream.

    It is possible to set the height of characters shown on the screen to a
    specified number of pixels with **setPixelSize** (); however using
    **setPointSize** () has a similar effect and provides device independence.

    Loading fonts can be expensive, especially on X11. QFont contains extensive
    optimizations to make the copying of QFont objects fast, and to cache the
    results of the slow window system functions it depends upon.

    The font matching algorithm works as follows:

    1. The specified font families (set by **setFamilies** ()) are searched for.
    2. If not found, then if set the specified font family exists and can be
    used to represent the writing system in use, it will be selected.
      3. If
    not, a replacement font that supports the writing system is selected. The
    font matching algorithm will try to find the best match for all the
    properties set in the QFont. How this is done varies from platform to
    platform.
      4. If no font exists on the system that can support the text,
    then special "missing character" boxes will be shown in its place.

    **Note:** If the selected font, though supporting the writing system in
    general, is missing glyphs for one or more specific characters, then Qt will
    try to find a fallback font for this or these particular characters. This
    feature can be disabled using **QFont::NoFontMerging**  style strategy.

    In Windows a request for the "Courier" font is automatically changed to
    "Courier New", an improved version of Courier that allows for smooth
    scaling. The older "Courier" bitmap font can be selected by setting the
    **PreferBitmap**  style strategy (see **setStyleStrategy** ()).

    Once a font is found, the remaining attributes are matched in order of
    priority:

    1. **fixedPitch** ()
      2. **pointSize** () (see below)
      3. **weight** ()
    4. **style** ()

    If you have a font which matches on family, even if none of the other
    attributes match, this font will be chosen in preference to a font which
    doesn't match on family but which does match on the other attributes. This
    is because font family is the dominant search criteria.

    The point size is defined to match if it is within 20% of the requested
    point size. When several fonts match and are only distinguished by point
    size, the font with the closest point size to the one requested will be
    chosen.

    The actual family, font size, weight and other font attributes used for
    drawing text will depend on what's available for the chosen family under the
    window system. A **QFontInfo**  object can be used to determine the actual
    values used for drawing the text.

    Examples:

    **QFont**  f("Helvetica");

    If you had both an Adobe and a Cronyx Helvetica, you might get either.

    **QFont**  f("Helvetica [Cronyx]");

    You can specify the foundry you want in the family name. The font f in the
    above example will be set to "Helvetica [Cronyx]".

    To determine the attributes of the font actually used in the window system,
    use a **QFontInfo**  object, e.g.

    **QFontInfo**  info(f1);
        **QString**  family = info.family();

    To find out font metrics use a **QFontMetrics**  object, e.g.

    **QFontMetrics**  fm(f1);
        int textWidthInPixels =
    fm.horizontalAdvance("How many pixels wide is this text?");
        int
    textHeightInPixels = fm.height();

    For more general information on fonts, see the **comp.fonts FAQ** .
    Information on encodings can be found from **Roman Czyborra's**  page.

    **See also** **QFontMetrics** , **QFontInfo** , **QFontDatabase** , and
    **Character Map Example** .
    """

    class HintingPreference(int):
        PreferDefaultHinting: QFont = ...
        PreferNoHinting: QFont = ...
        PreferVerticalHinting: QFont = ...
        PreferFullHinting: QFont = ...

    class SpacingType(int):
        PercentageSpacing: QFont = ...
        AbsoluteSpacing: QFont = ...

    class Capitalization(int):
        MixedCase: QFont = ...
        AllUppercase: QFont = ...
        AllLowercase: QFont = ...
        SmallCaps: QFont = ...
        Capitalize: QFont = ...

    class Stretch(int):
        AnyStretch: QFont = ...
        UltraCondensed: QFont = ...
        ExtraCondensed: QFont = ...
        Condensed: QFont = ...
        SemiCondensed: QFont = ...
        Unstretched: QFont = ...
        SemiExpanded: QFont = ...
        Expanded: QFont = ...
        ExtraExpanded: QFont = ...
        UltraExpanded: QFont = ...

    class Style(int):
        StyleNormal: QFont = ...
        StyleItalic: QFont = ...
        StyleOblique: QFont = ...

    class Weight(int):
        Thin: QFont = ...
        ExtraLight: QFont = ...
        Light: QFont = ...
        Normal: QFont = ...
        Medium: QFont = ...
        DemiBold: QFont = ...
        Bold: QFont = ...
        ExtraBold: QFont = ...
        Black: QFont = ...

    class StyleStrategy(int):
        PreferDefault: QFont = ...
        PreferBitmap: QFont = ...
        PreferDevice: QFont = ...
        PreferOutline: QFont = ...
        ForceOutline: QFont = ...
        PreferMatch: QFont = ...
        PreferQuality: QFont = ...
        PreferAntialias: QFont = ...
        NoAntialias: QFont = ...
        NoSubpixelAntialias: QFont = ...
        OpenGLCompatible: QFont = ...
        NoFontMerging: QFont = ...
        ForceIntegerMetrics: QFont = ...
        PreferNoShaping: QFont = ...

    class StyleHint(int):
        Helvetica: QFont = ...
        SansSerif: QFont = ...
        Times: QFont = ...
        Serif: QFont = ...
        Courier: QFont = ...
        TypeWriter: QFont = ...
        OldEnglish: QFont = ...
        Decorative: QFont = ...
        System: QFont = ...
        AnyStyle: QFont = ...
        Cursive: QFont = ...
        Monospace: QFont = ...
        Fantasy: QFont = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#QFont

        **QFont::QFont()**

        Constructs a font object that uses the application's default font.

        **See also** **QGuiApplication::setFont** () and
        **QGuiApplication::font** ().
        """
        ...

    @typing.overload
    def __init__(
        self, family: str, pointSize: int = ..., weight: int = ..., italic: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#QFont-1

        **QFont::QFont(const QString & family , int pointSize = -1, int weight =
        -1, bool italic = false)**

        Constructs a font object with the specified **family** , **pointSize** ,
        **weight** and **italic** settings.

        If **pointSize** is zero or negative, the point size of the font is set
        to a system-dependent default value. Generally, this is 12 points.

        The **family** name may optionally also include a foundry name, e.g.
        "Helvetica [Cronyx]". If the **family** is available from more than one
        foundry and the foundry isn't specified, an arbitrary foundry is chosen.
        If the family isn't available a family will be set using the **font
        matching**  algorithm.

        **See also** **Weight** , **setFamily** (), **setPointSize** (),
        **setWeight** (), **setItalic** (), **setStyleHint** (), and
        **QGuiApplication::font** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QFont", pd: QPaintDevice) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#QFont-3

        **QFont::QFont(const QFont & font , const QPaintDevice * pd )**

        Constructs a font from **font** for use on the paint device **pd**.

        This function was introduced in Qt 5.13.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QFont") -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#QFont-4

        **QFont::QFont(const QFont & font )**

        Constructs a font that is a copy of **font**.
        """
        ...

    @typing.overload
    def __init__(self, variant: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#QFont

        **QFont::QFont()**

        Constructs a font object that uses the application's default font.

        **See also** **QGuiApplication::setFont** () and
        **QGuiApplication::font** ().
        """
        ...

    def setFamilies(self, a0: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setFamilies

        **void QFont::setFamilies(const QStringList & families )**

        Sets the list of family names for the font. The names are case
        insensitive and may include a foundry name. The first family in
        **families** will be set as the main family for the font.

        Each family name entry in **families** may optionally also include a
        foundry name, e.g. "Helvetica [Cronyx]". If the family is available from
        more than one foundry and the foundry isn't specified, an arbitrary
        foundry is chosen. If the family isn't available a family will be set
        using the **font matching**  algorithm.

        This function was introduced in Qt 5.13.

        **See also** **family** (), **families** (), **setFamily** (),
        **setStyleHint** (), and **QFontInfo** .
        """
        ...

    def families(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfont.html#families

        **QStringList QFont::families() const**

        Returns the requested font family names, i.e. the names set in the last
        **setFamilies** () call or via the constructor. Otherwise it returns an
        empty list.

        This function was introduced in Qt 5.13.

        **See also** **setFamily** (), **setFamilies** (), **family** (),
        **substitutes** (), and **substitute** ().
        """
        ...

    def __hash__(self) -> int:
        ...

    def swap(self, other: "QFont") -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#swap

        **void QFont::swap(QFont & other )**

        Swaps this font instance with **other**. This function is very fast and
        never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def hintingPreference(self) -> "QFont.HintingPreference":
        """
        https://doc.qt.io/qt-5/qfont.html#hintingPreference

        **QFont::HintingPreference QFont::hintingPreference() const**

        Returns the currently preferred hinting level for glyphs rendered with
        this font.

        This function was introduced in Qt 4.8.

        **See also** **setHintingPreference** ().
        """
        ...

    def setHintingPreference(
        self, hintingPreference: "QFont.HintingPreference"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setHintingPreference

        **void QFont::setHintingPreference(QFont::HintingPreference
        hintingPreference )**

        Set the preference for the hinting level of the glyphs to
        **hintingPreference**. This is a hint to the underlying font rendering
        system to use a certain level of hinting, and has varying support across
        platforms. See the table in the documentation for
        **QFont::HintingPreference**  for more details.

        The default hinting preference is **QFont::PreferDefaultHinting** .

        This function was introduced in Qt 4.8.

        **See also** **hintingPreference** ().
        """
        ...

    def setStyleName(self, styleName: str) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setStyleName

        **void QFont::setStyleName(const QString & styleName )**

        Sets the style name of the font to **styleName**. When set, other style
        properties like **style** () and **weight** () will be ignored for font
        matching, though they may be simulated afterwards if supported by the
        platform's font engine.

        Due to the lower quality of artificially simulated styles, and the lack
        of full cross platform support, it is not recommended to use matching by
        style name together with matching by style properties

        This function was introduced in Qt 4.8.

        **See also** **styleName** ().
        """
        ...

    def styleName(self) -> str:
        """
        https://doc.qt.io/qt-5/qfont.html#styleName

        **QString QFont::styleName() const**

        Returns the requested font style name. This can be used to match the
        font with irregular styles (that can't be normalized in other style
        properties).

        This function was introduced in Qt 4.8.

        **See also** **setStyleName** (), **setFamily** (), and **setStyle** ().
        """
        ...

    def capitalization(self) -> "QFont.Capitalization":
        """
        https://doc.qt.io/qt-5/qfont.html#capitalization

        **QFont::Capitalization QFont::capitalization() const**

        Returns the current capitalization type of the font.

        This function was introduced in Qt 4.4.

        **See also** **setCapitalization** ().
        """
        ...

    def setCapitalization(self, a0: "QFont.Capitalization") -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setCapitalization

        **void QFont::setCapitalization(QFont::Capitalization caps )**

        Sets the capitalization of the text in this font to **caps**.

        A font's capitalization makes the text appear in the selected
        capitalization mode.

        This function was introduced in Qt 4.4.

        **See also** **capitalization** ().
        """
        ...

    def setWordSpacing(self, spacing: float) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setWordSpacing

        **void QFont::setWordSpacing(qreal spacing )**

        Sets the word spacing for the font to **spacing**.

        Word spacing changes the default spacing between individual words. A
        positive value increases the word spacing by a corresponding amount of
        pixels, while a negative value decreases the inter-word spacing
        accordingly.

        Word spacing will not apply to writing systems, where indiviaul words
        are not separated by white space.

        This function was introduced in Qt 4.4.

        **See also** **wordSpacing** () and **setLetterSpacing** ().
        """
        ...

    def wordSpacing(self) -> float:
        """
        https://doc.qt.io/qt-5/qfont.html#wordSpacing

        **qreal QFont::wordSpacing() const**

        Returns the word spacing for the font.

        This function was introduced in Qt 4.4.

        **See also** **setWordSpacing** () and **setLetterSpacing** ().
        """
        ...

    def setLetterSpacing(self, type: "QFont.SpacingType", spacing: float) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setLetterSpacing

        **void QFont::setLetterSpacing(QFont::SpacingType type , qreal spacing
        )**

        Sets the letter spacing for the font to **spacing** and the type of
        spacing to **type**.

        Letter spacing changes the default spacing between individual letters in
        the font. The spacing between the letters can be made smaller as well as
        larger either in percentage of the character width or in pixels,
        depending on the selected spacing type.

        This function was introduced in Qt 4.4.

        **See also** **letterSpacing** (), **letterSpacingType** (), and
        **setWordSpacing** ().
        """
        ...

    def letterSpacingType(self) -> "QFont.SpacingType":
        """
        https://doc.qt.io/qt-5/qfont.html#letterSpacingType

        **QFont::SpacingType QFont::letterSpacingType() const**

        Returns the spacing type used for letter spacing.

        This function was introduced in Qt 4.4.

        **See also** **letterSpacing** (), **setLetterSpacing** (), and
        **setWordSpacing** ().
        """
        ...

    def letterSpacing(self) -> float:
        """
        https://doc.qt.io/qt-5/qfont.html#letterSpacing

        **qreal QFont::letterSpacing() const**

        Returns the letter spacing for the font.

        This function was introduced in Qt 4.4.

        **See also** **setLetterSpacing** (), **letterSpacingType** (), and
        **setWordSpacing** ().
        """
        ...

    def setItalic(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setItalic

        **void QFont::setItalic(bool enable )**

        Sets the **style** () of the font to **QFont::StyleItalic**  if
        **enable** is true; otherwise the style is set to **QFont::StyleNormal**
        .

        **Note:** If **styleName** () is set, this value may be ignored, or if
        supported on the platform, the font may be rendered tilted instead of
        picking a designed italic font-variant.

        **See also** **italic** () and **QFontInfo** .
        """
        ...

    def italic(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfont.html#italic

        **bool QFont::italic() const**

        Returns `true` if the **style** () of the font is not
        **QFont::StyleNormal**

        **See also** **setItalic** () and **style** ().
        """
        ...

    def setBold(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setBold

        **void QFont::setBold(bool enable )**

        If **enable** is true sets the font's weight to **QFont::Bold** ;
        otherwise sets the weight to **QFont::Normal** .

        For finer boldness control use **setWeight** ().

        **Note:** If **styleName** () is set, this value may be ignored, or if
        supported on the platform, the font artificially embolded.

        **See also** **bold** () and **setWeight** ().
        """
        ...

    def bold(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfont.html#bold

        **bool QFont::bold() const**

        Returns `true` if **weight** () is a value greater than
        **QFont::Medium** ; otherwise returns `false`.

        **See also** **weight** (), **setBold** (), and **QFontInfo::bold** ().
        """
        ...

    def resolve(self, a0: "QFont") -> "QFont":
        """
        https://doc.qt.io/qt-5/qfont.html#resolve

        **QFont QFont::resolve(const QFont & other ) const**

        Returns a new **QFont**  that has attributes copied from **other** that
        have not been previously set on this font.
        """
        ...

    def lastResortFont(self) -> str:
        ...

    def lastResortFamily(self) -> str:
        ...

    def defaultFamily(self) -> str:
        """
        https://doc.qt.io/qt-5/qfont.html#defaultFamily

        **QString QFont::defaultFamily() const**

        Returns the family name that corresponds to the current style hint.

        **See also** **StyleHint** , **styleHint** (), and **setStyleHint** ().
        """
        ...

    @staticmethod
    def cacheStatistics() -> None:
        ...

    @staticmethod
    def cleanup() -> None:
        ...

    @staticmethod
    def initialize() -> None:
        ...

    @staticmethod
    def removeSubstitutions(a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#removeSubstitutions

        **[static] void QFont::removeSubstitutions(const QString & familyName
        )**

        Removes all the substitutions for **familyName**.

        This function was introduced in Qt 5.0.

        **See also** **insertSubstitutions** (), **insertSubstitution** (),
        **substitutions** (), and **substitute** ().
        """
        ...

    @staticmethod
    def insertSubstitutions(a0: str, a1: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#insertSubstitutions

        **[static] void QFont::insertSubstitutions(const QString & familyName ,
        const QStringList & substituteNames )**

        Inserts the list of families **substituteNames** into the substitution
        list for **familyName**.

        After substituting a font, trigger the updating of the font by
        destroying and re-creating all **QFont**  objects.

        **See also** **insertSubstitution** (), **removeSubstitutions** (),
        **substitutions** (), and **substitute** ().
        """
        ...

    @staticmethod
    def insertSubstitution(a0: str, a1: str) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#insertSubstitution

        **[static] void QFont::insertSubstitution(const QString & familyName ,
        const QString & substituteName )**

        Inserts **substituteName** into the substitution table for the family
        **familyName**.

        After substituting a font, trigger the updating of the font by
        destroying and re-creating all **QFont**  objects.

        **See also** **insertSubstitutions** (), **removeSubstitutions** (),
        **substitutions** (), **substitute** (), and **substitutes** ().
        """
        ...

    @staticmethod
    def substitutions() -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfont.html#substitutions

        **[static] QStringList QFont::substitutions()**

        Returns a sorted list of substituted family names.

        **See also** **insertSubstitution** (), **removeSubstitution** (), and
        **substitute** ().
        """
        ...

    @staticmethod
    def substitutes(a0: str) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfont.html#substitutes

        **[static] QStringList QFont::substitutes(const QString & familyName )**

        Returns a list of family names to be used whenever **familyName** is
        specified. The lookup is case insensitive.

        If there is no substitution for **familyName** , an empty list is
        returned.

        **See also** **substitute** (), **insertSubstitutions** (),
        **insertSubstitution** (), and **removeSubstitutions** ().
        """
        ...

    @staticmethod
    def substitute(a0: str) -> str:
        """
        https://doc.qt.io/qt-5/qfont.html#substitute

        **[static] QString QFont::substitute(const QString & familyName )**

        Returns the first family name to be used whenever **familyName** is
        specified. The lookup is case insensitive.

        If there is no substitution for **familyName** , **familyName** is
        returned.

        To obtain a list of substitutions use **substitutes** ().

        **See also** **setFamily** (), **insertSubstitutions** (),
        **insertSubstitution** (), and **removeSubstitutions** ().
        """
        ...

    def fromString(self, a0: str) -> bool:
        """
        https://doc.qt.io/qt-5/qfont.html#fromString

        **bool QFont::fromString(const QString & descrip )**

        Sets this font to match the description **descrip**. The description is
        a comma-separated list of the font attributes, as returned by
        **toString** ().

        **See also** **toString** ().
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-5/qfont.html#toString

        **QString QFont::toString() const**

        Returns a description of the font. The description is a comma-separated
        list of the attributes, perfectly suited for use in **QSettings** .

        **See also** **fromString** ().
        """
        ...

    def key(self) -> str:
        """
        https://doc.qt.io/qt-5/qfont.html#key

        **QString QFont::key() const**

        Returns the font's key, a textual representation of a font. It is
        typically used as the key for a cache or dictionary of fonts.

        **See also** **QMap** .
        """
        ...

    def rawName(self) -> str:
        ...

    def setRawName(self, a0: str) -> None:
        ...

    def isCopyOf(self, a0: "QFont") -> bool:
        """
        https://doc.qt.io/qt-5/qfont.html#isCopyOf

        **bool QFont::isCopyOf(const QFont & f ) const**

        Returns `true` if this font and **f** are copies of each other, i.e. one
        of them was created as a copy of the other and neither has been modified
        since. This is much stricter than equality.

        **See also** **operator=** () and **operator==** ().
        """
        ...

    def exactMatch(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfont.html#exactMatch

        **bool QFont::exactMatch() const**

        Returns `true` if a window system font exactly matching the settings of
        this font is available.

        **See also** **QFontInfo** .
        """
        ...

    def setRawMode(self, a0: bool) -> None:
        ...

    def rawMode(self) -> bool:
        ...

    def setStretch(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setStretch

        **void QFont::setStretch(int factor )**

        Sets the stretch factor for the font.

        The stretch factor matches a condensed or expanded version of the font
        or applies a stretch transform that changes the width of all characters
        in the font by **factor** percent. For example, setting **factor** to
        150 results in all characters in the font being 1.5 times (ie. 150%)
        wider. The minimum stretch factor is 1, and the maximum stretch factor
        is 4000. The default stretch factor is `AnyStretch`, which will accept
        any stretch factor and not apply any transform on the font.

        The stretch factor is only applied to outline fonts. The stretch factor
        is ignored for bitmap fonts.

        **Note:** When matching a font with a native non-default stretch factor,
        requesting a stretch of 100 will stretch it back to a medium width font.

        **See also** **stretch** () and **QFont::Stretch** .
        """
        ...

    def stretch(self) -> int:
        """
        https://doc.qt.io/qt-5/qfont.html#stretch

        **int QFont::stretch() const**

        Returns the stretch factor for the font.

        **See also** **setStretch** ().
        """
        ...

    def setStyleStrategy(self, s: "QFont.StyleStrategy") -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setStyleStrategy

        **void QFont::setStyleStrategy(QFont::StyleStrategy s )**

        Sets the style strategy for the font to **s**.

        **See also** **styleStrategy** () and **QFont::StyleStrategy** .
        """
        ...

    def setStyleHint(
        self, hint: "QFont.StyleHint", strategy: "QFont.StyleStrategy" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setStyleHint

        **void QFont::setStyleHint(QFont::StyleHint hint , QFont::StyleStrategy
        strategy = PreferDefault)**

        Sets the style hint and strategy to **hint** and **strategy** ,
        respectively.

        If these aren't set explicitly the style hint will default to `AnyStyle`
        and the style strategy to `PreferDefault`.

        Qt does not support style hints on X11 since this information is not
        provided by the window system.

        **See also** **StyleHint** , **styleHint** (), **StyleStrategy** ,
        **styleStrategy** (), and **QFontInfo** .
        """
        ...

    def styleStrategy(self) -> "QFont.StyleStrategy":
        """
        https://doc.qt.io/qt-5/qfont.html#styleStrategy

        **QFont::StyleStrategy QFont::styleStrategy() const**

        Returns the **StyleStrategy** .

        The style strategy affects the **font matching**  algorithm. See
        **QFont::StyleStrategy**  for the list of available strategies.

        **See also** **setStyleStrategy** (), **setStyleHint** (), and
        **QFont::StyleHint** .
        """
        ...

    def styleHint(self) -> "QFont.StyleHint":
        """
        https://doc.qt.io/qt-5/qfont.html#styleHint

        **QFont::StyleHint QFont::styleHint() const**

        Returns the **StyleHint** .

        The style hint affects the **font matching algorithm** . See
        **QFont::StyleHint**  for the list of available hints.

        **See also** **setStyleHint** (), **QFont::StyleStrategy** , and
        **QFontInfo::styleHint** ().
        """
        ...

    def setKerning(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setKerning

        **void QFont::setKerning(bool enable )**

        Enables kerning for this font if **enable** is true; otherwise disables
        it. By default, kerning is enabled.

        When kerning is enabled, glyph metrics do not add up anymore, even for
        Latin text. In other words, the assumption that width('a') + width('b')
        is equal to width("ab") is not necessarily true.

        **See also** **kerning** () and **QFontMetrics** .
        """
        ...

    def kerning(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfont.html#kerning

        **bool QFont::kerning() const**

        Returns `true` if kerning should be used when drawing text with this
        font.

        **See also** **setKerning** ().
        """
        ...

    def setFixedPitch(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setFixedPitch

        **void QFont::setFixedPitch(bool enable )**

        If **enable** is true, sets fixed pitch on; otherwise sets fixed pitch
        off.

        **See also** **fixedPitch** () and **QFontInfo** .
        """
        ...

    def fixedPitch(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfont.html#fixedPitch

        **bool QFont::fixedPitch() const**

        Returns `true` if fixed pitch has been set; otherwise returns `false`.

        **See also** **setFixedPitch** () and **QFontInfo::fixedPitch** ().
        """
        ...

    def setStrikeOut(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setStrikeOut

        **void QFont::setStrikeOut(bool enable )**

        If **enable** is true, sets strikeout on; otherwise sets strikeout off.

        **See also** **strikeOut** () and **QFontInfo** .
        """
        ...

    def strikeOut(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfont.html#strikeOut

        **bool QFont::strikeOut() const**

        Returns `true` if strikeout has been set; otherwise returns `false`.

        **See also** **setStrikeOut** ().
        """
        ...

    def setOverline(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setOverline

        **void QFont::setOverline(bool enable )**

        If **enable** is true, sets overline on; otherwise sets overline off.

        **See also** **overline** () and **QFontInfo** .
        """
        ...

    def overline(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfont.html#overline

        **bool QFont::overline() const**

        Returns `true` if overline has been set; otherwise returns `false`.

        **See also** **setOverline** ().
        """
        ...

    def setUnderline(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setUnderline

        **void QFont::setUnderline(bool enable )**

        If **enable** is true, sets underline on; otherwise sets underline off.

        **See also** **underline** () and **QFontInfo** .
        """
        ...

    def underline(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfont.html#underline

        **bool QFont::underline() const**

        Returns `true` if underline has been set; otherwise returns `false`.

        **See also** **setUnderline** ().
        """
        ...

    def style(self) -> "QFont.Style":
        """
        https://doc.qt.io/qt-5/qfont.html#style

        **QFont::Style QFont::style() const**

        Returns the style of the font.

        **See also** **setStyle** ().
        """
        ...

    def setStyle(self, style: "QFont.Style") -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setStyle

        **void QFont::setStyle(QFont::Style style )**

        Sets the style of the font to **style**.

        **See also** **style** (), **italic** (), and **QFontInfo** .
        """
        ...

    def setWeight(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setWeight

        **void QFont::setWeight(int weight )**

        Sets the weight of the font to **weight** , using the scale defined by
        **QFont::Weight**  enumeration.

        **Note:** If **styleName** () is set, this value may be ignored for font
        selection.

        **See also** **weight** () and **QFontInfo** .
        """
        ...

    def weight(self) -> int:
        """
        https://doc.qt.io/qt-5/qfont.html#weight

        **int QFont::weight() const**

        Returns the weight of the font, using the same scale as the
        **QFont::Weight**  enumeration.

        **See also** **setWeight** (), **Weight** , and **QFontInfo** .
        """
        ...

    def setPixelSize(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setPixelSize

        **void QFont::setPixelSize(int pixelSize )**

        Sets the font size to **pixelSize** pixels.

        Using this function makes the font device dependent. Use
        **setPointSize** () or **setPointSizeF** () to set the size of the font
        in a device independent manner.

        **See also** **pixelSize** ().
        """
        ...

    def pixelSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qfont.html#pixelSize

        **int QFont::pixelSize() const**

        Returns the pixel size of the font if it was set with **setPixelSize**
        (). Returns -1 if the size was set with **setPointSize** () or
        **setPointSizeF** ().

        **See also** **setPixelSize** (), **pointSize** (),
        **QFontInfo::pointSize** (), and **QFontInfo::pixelSize** ().
        """
        ...

    def setPointSizeF(self, a0: float) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setPointSizeF

        **void QFont::setPointSizeF(qreal pointSize )**

        Sets the point size to **pointSize**. The point size must be greater
        than zero. The requested precision may not be achieved on all platforms.

        **See also** **pointSizeF** (), **setPointSize** (), and
        **setPixelSize** ().
        """
        ...

    def pointSizeF(self) -> float:
        """
        https://doc.qt.io/qt-5/qfont.html#pointSizeF

        **qreal QFont::pointSizeF() const**

        Returns the point size of the font. Returns -1 if the font size was
        specified in pixels.

        **See also** **pointSize** (), **setPointSizeF** (), **pixelSize** (),
        **QFontInfo::pointSize** (), and **QFontInfo::pixelSize** ().
        """
        ...

    def setPointSize(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setPointSize

        **void QFont::setPointSize(int pointSize )**

        Sets the point size to **pointSize**. The point size must be greater
        than zero.

        **See also** **pointSize** () and **setPointSizeF** ().
        """
        ...

    def pointSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qfont.html#pointSize

        **int QFont::pointSize() const**

        Returns the point size of the font. Returns -1 if the font size was
        specified in pixels.

        **See also** **setPointSize** () and **pointSizeF** ().
        """
        ...

    def setFamily(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qfont.html#setFamily

        **void QFont::setFamily(const QString & family )**

        Sets the family name of the font. The name is case insensitive and may
        include a foundry name.

        The **family** name may optionally also include a foundry name, e.g.
        "Helvetica [Cronyx]". If the **family** is available from more than one
        foundry and the foundry isn't specified, an arbitrary foundry is chosen.
        If the family isn't available a family will be set using the **font
        matching**  algorithm.

        **See also** **family** (), **setStyleHint** (), and **QFontInfo** .
        """
        ...

    def family(self) -> str:
        """
        https://doc.qt.io/qt-5/qfont.html#family

        **QString QFont::family() const**

        Returns the requested font family name, i.e. the name set in the
        constructor or the last setFont() call.

        **See also** **setFamily** (), **substitutes** (), and **substitute**
        ().
        """
        ...
