"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore


class QCloseEvent(QtCore.QEvent):
    """
    https://doc.qt.io/qt-5/qcloseevent.html

    **Detailed Description**

    Close events are sent to widgets that the user wants to close, usually by
    choosing "Close" from the window menu, or by clicking the **X** title bar
    button. They are also sent when you call **QWidget::close** () to close a
    widget programmatically.

    Close events contain a flag that indicates whether the receiver wants the
    widget to be closed or not. When a widget accepts the close event, it is
    hidden (and destroyed if it was created with the **Qt::WA_DeleteOnClose**
    flag). If it refuses to accept the close event nothing happens. (Under X11
    it is possible that the window manager will forcibly close the window; but
    at the time of writing we are not aware of any window manager that does
    this.)

    The event handler **QWidget::closeEvent** () receives close events. The
    default implementation of this event handler accepts the close event. If you
    do not want your widget to be hidden, or want some special handling, you
    should reimplement the event handler and **ignore** () the event.

    The **closeEvent() in the Application example**  shows a close event handler
    that asks whether to save a document before closing.

    If you want the widget to be deleted when it is closed, create it with the
    **Qt::WA_DeleteOnClose**  flag. This is very useful for independent top-
    level windows in a multi-window application.

    **QObject** s emits the **destroyed()**  signal when they are deleted.

    If the last top-level window is closed, the
    **QGuiApplication::lastWindowClosed** () signal is emitted.

    The **isAccepted** () function returns `true` if the event's receiver has
    agreed to close the widget; call **accept** () to agree to close the widget
    and call **ignore** () if the receiver of this event does not want the
    widget to be closed.

    **See also** **QWidget::close** (), **QWidget::hide** (),
    **QObject::destroyed** (), **QCoreApplication::exec** (),
    **QCoreApplication::quit** (), and **QGuiApplication::lastWindowClosed** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qcloseevent.html#QCloseEvent

        **QCloseEvent::QCloseEvent()**

        Constructs a close event object.

        **See also** **accept** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QCloseEvent") -> None:
        """
        https://doc.qt.io/qt-5/qcloseevent.html#QCloseEvent

        **QCloseEvent::QCloseEvent()**

        Constructs a close event object.

        **See also** **accept** ().
        """
        ...
