"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *
from PyQt5 import sip


class QBrush(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qbrush.html

    **Detailed Description**

    A brush has a style, a color, a gradient and a texture.

    The brush **style** () defines the fill pattern using the **Qt::BrushStyle**
    enum. The default brush style is **Qt::NoBrush**  (depending on how you
    construct a brush). This style tells the painter to not fill shapes. The
    standard style for filling is **Qt::SolidPattern** . The style can be set
    when the brush is created using the appropriate constructor, and in addition
    the **setStyle** () function provides means for altering the style once the
    brush is constructed.

    ![Brush Styles](images/brush-styles.png)

    The brush **color** () defines the color of the fill pattern. The color can
    either be one of Qt's predefined colors, **Qt::GlobalColor** , or any other
    custom **QColor** . The currently set color can be retrieved and altered
    using the **color** () and **setColor** () functions, respectively.

    The **gradient** () defines the gradient fill used when the current style is
    either **Qt::LinearGradientPattern** , **Qt::RadialGradientPattern**  or
    **Qt::ConicalGradientPattern** . Gradient brushes are created by giving a
    **QGradient**  as a constructor argument when creating the QBrush. Qt
    provides three different gradients: **QLinearGradient** ,
    **QConicalGradient** , and **QRadialGradient**  \\- all of which inherit
    **QGradient** .

    **QRadialGradient**  gradient(50, 50, 50, 50, 50);
    gradient.setColorAt(0, **QColor** ::fromRgbF(0, 1, 0, 1));
    gradient.setColorAt(1, **QColor** ::fromRgbF(0, 0, 0, 0));
    **QBrush**  brush(gradient);

    The **texture** () defines the pixmap used when the current style is
    **Qt::TexturePattern** . You can create a brush with a texture by providing
    the pixmap when the brush is created or by using **setTexture** ().

    Note that applying **setTexture** () makes **style** () ==
    **Qt::TexturePattern** , regardless of previous style settings. Also,
    calling **setColor** () will not make a difference if the style is a
    gradient. The same is the case if the style is **Qt::TexturePattern**  style
    unless the current texture is a **QBitmap** .

    The **isOpaque** () function returns `true` if the brush is fully opaque
    otherwise false. A brush is considered opaque if:

    * The alpha component of the **color** () is 255.
      * Its **texture** ()
    does not have an alpha channel and is not a **QBitmap** .
      * The colors in
    the **gradient** () all have an alpha component that is 255.

    ![Outlines](images/brush-outline.png)To specify the style and color of lines
    and outlines, use the **QPainter** 's **pen**  combined with
    **Qt::PenStyle**  and **Qt::GlobalColor** :



        **QPainter**
    painter(this);

        painter.setBrush(Qt::cyan);
    painter.setPen(Qt::darkCyan);
        painter.drawRect(0, 0, 100,100);
    painter.setBrush(Qt::NoBrush);
        painter.setPen(Qt::darkGreen);
    painter.drawRect(40, 40, 100, 100);

    Note that, by default, **QPainter**
    renders the outline (using the currently set pen) when drawing shapes. Use
    [`painter.setPen(Qt::NoPen)`**  to disable this behavior.

    For more information about painting in general, see the **Paint System** .

    **See also** **Qt::BrushStyle** , **QPainter** , and **QColor** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#QBrush

        **QBrush::QBrush()**

        Constructs a default black brush with the style **Qt::NoBrush**  (i.e.
        this brush will not fill shapes).
        """
        ...

    @typing.overload
    def __init__(self, bs: QtCore.Qt.BrushStyle) -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#QBrush-1

        **QBrush::QBrush(Qt::BrushStyle style )**

        Constructs a black brush with the given **style**.

        **See also** **setStyle** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        color: typing.Union[QColor, QtCore.Qt.GlobalColor],
        style: QtCore.Qt.BrushStyle = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#QBrush-2

        **QBrush::QBrush(const QColor & color , Qt::BrushStyle style =
        Qt::SolidPattern)**

        Constructs a brush with the given **color** and **style**.

        **See also** **setColor** () and **setStyle** ().
        """
        ...

    @typing.overload
    def __init__(
        self, color: typing.Union[QColor, QtCore.Qt.GlobalColor], pixmap: QPixmap
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#QBrush-3

        **QBrush::QBrush(Qt::GlobalColor color , Qt::BrushStyle style =
        Qt::SolidPattern)**

        Constructs a brush with the given **color** and **style**.

        **See also** **setColor** () and **setStyle** ().
        """
        ...

    @typing.overload
    def __init__(self, pixmap: QPixmap) -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#QBrush-4

        **QBrush::QBrush(const QColor & color , const QPixmap & pixmap )**

        Constructs a brush with the given **color** and the custom pattern
        stored in **pixmap**.

        The style is set to **Qt::TexturePattern** . The color will only have an
        effect for QBitmaps.

        **See also** **setColor** () and **setTexture** ().
        """
        ...

    @typing.overload
    def __init__(self, image: "QImage") -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#QBrush-5

        **QBrush::QBrush(Qt::GlobalColor color , const QPixmap & pixmap )**

        Constructs a brush with the given **color** and the custom pattern
        stored in **pixmap**.

        The style is set to **Qt::TexturePattern** . The color will only have an
        effect for QBitmaps.

        **See also** **setColor** () and **setTexture** ().
        """
        ...

    @typing.overload
    def __init__(
        self, brush: typing.Union["QBrush", QColor, QtCore.Qt.GlobalColor, "QGradient"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#QBrush-6

        **QBrush::QBrush(const QPixmap & pixmap )**

        Constructs a brush with a black color and a texture set to the given
        **pixmap**. The style is set to **Qt::TexturePattern** .

        **See also** **setTexture** ().
        """
        ...

    @typing.overload
    def __init__(self, variant: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#QBrush-7

        **QBrush::QBrush(const QImage & image )**

        Constructs a brush with a black color and a texture set to the given
        **image**. The style is set to **Qt::TexturePattern** .

        **See also** **setTextureImage** ().
        """
        ...

    def swap(self, other: "QBrush") -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#swap

        **void QBrush::swap(QBrush & other )**

        Swaps brush **other** with this brush. This operation is very fast and
        never fails.

        This function was introduced in Qt 4.8.
        """
        ...

    def transform(self) -> "QTransform":
        """
        https://doc.qt.io/qt-5/qbrush.html#transform

        **QTransform QBrush::transform() const**

        Returns the current transformation matrix for the brush.

        This function was introduced in Qt 4.3.

        **See also** **setTransform** ().
        """
        ...

    def setTransform(self, a0: "QTransform") -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#setTransform

        **void QBrush::setTransform(const QTransform & matrix )**

        Sets **matrix** as an explicit transformation matrix on the current
        brush. The brush transformation matrix is merged with **QPainter**
        transformation matrix to produce the final result.

        This function was introduced in Qt 4.3.

        **See also** **transform** ().
        """
        ...

    def textureImage(self) -> "QImage":
        """
        https://doc.qt.io/qt-5/qbrush.html#textureImage

        **QImage QBrush::textureImage() const**

        Returns the custom brush pattern, or a null image if no custom brush
        pattern has been set.

        If the texture was set as a **QPixmap**  it will be converted to a
        **QImage** .

        This function was introduced in Qt 4.2.

        **See also** **setTextureImage** ().
        """
        ...

    def setTextureImage(self, image: "QImage") -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#setTextureImage

        **void QBrush::setTextureImage(const QImage & image )**

        Sets the brush image to **image**. The style is set to
        **Qt::TexturePattern** .

        Note the current brush color will **not** have any affect on monochrome
        images, as opposed to calling **setTexture** () with a **QBitmap** . If
        you want to change the color of monochrome image brushes, either convert
        the image to **QBitmap**  with `QBitmap::fromImage()` and set the
        resulting **QBitmap**  as a texture, or change the entries in the color
        table for the image.

        This function was introduced in Qt 4.2.

        **See also** **textureImage** () and **setTexture** ().
        """
        ...

    def color(self) -> QColor:
        """
        https://doc.qt.io/qt-5/qbrush.html#color

        **const QColor &QBrush::color() const**

        Returns the brush color.

        **See also** **setColor** ().
        """
        ...

    def style(self) -> QtCore.Qt.BrushStyle:
        """
        https://doc.qt.io/qt-5/qbrush.html#style

        **Qt::BrushStyle QBrush::style() const**

        Returns the brush style.

        **See also** **setStyle** ().
        """
        ...

    def isOpaque(self) -> bool:
        """
        https://doc.qt.io/qt-5/qbrush.html#isOpaque

        **bool QBrush::isOpaque() const**

        Returns `true` if the brush is fully opaque otherwise false. A brush is
        considered opaque if:

        * The alpha component of the **color** () is 255.
          * Its **texture** ()
        does not have an alpha channel and is not a **QBitmap** .
          * The colors
        in the **gradient** () all have an alpha component that is 255.
          * It
        is an extended radial gradient.
        """
        ...

    def gradient(self) -> "QGradient":
        """
        https://doc.qt.io/qt-5/qbrush.html#gradient

        **const QGradient *QBrush::gradient() const**

        Returns the gradient describing this brush.
        """
        ...

    @typing.overload
    def setColor(
        self, color: typing.Union[QColor, QtCore.Qt.GlobalColor, "QGradient"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#setColor

        **void QBrush::setColor(const QColor & color )**

        Sets the brush color to the given **color**.

        Note that calling setColor() will not make a difference if the style is
        a gradient. The same is the case if the style is **Qt::TexturePattern**
        style unless the current texture is a **QBitmap** .

        **See also** **color** ().
        """
        ...

    @typing.overload
    def setColor(self, acolor: QtCore.Qt.GlobalColor) -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#setColor-1

        **void QBrush::setColor(Qt::GlobalColor color )**

        This is an overloaded function.

        Sets the brush color to the given **color**.
        """
        ...

    def setTexture(self, pixmap: QPixmap) -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#setTexture

        **void QBrush::setTexture(const QPixmap & pixmap )**

        Sets the brush pixmap to **pixmap**. The style is set to
        **Qt::TexturePattern** .

        The current brush color will only have an effect for monochrome pixmaps,
        i.e. for **QPixmap::depth** () == 1 (**QBitmaps** ).

        **See also** **texture** ().
        """
        ...

    def texture(self) -> QPixmap:
        """
        https://doc.qt.io/qt-5/qbrush.html#texture

        **QPixmap QBrush::texture() const**

        Returns the custom brush pattern, or a null pixmap if no custom brush
        pattern has been set.

        **See also** **setTexture** ().
        """
        ...

    def setStyle(self, a0: QtCore.Qt.BrushStyle) -> None:
        """
        https://doc.qt.io/qt-5/qbrush.html#setStyle

        **void QBrush::setStyle(Qt::BrushStyle style )**

        Sets the brush style to **style**.

        **See also** **style** ().
        """
        ...
