"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtDesigner import *


class QExtensionManager(QtCore.QObject, QAbstractExtensionManager):
    """
    https://doc.qt.io/qt-5/qextensionmanager.html

    **Detailed Description**

    In **Qt Designer** the extensions are not created until they are required.
    For that reason, when implementing an extension, you must also create a
    **QExtensionFactory** , i.e a class that is able to make an instance of your
    extension, and register it using **Qt Designer** 's extension manager.

    The registration of an extension factory is typically made in the
    **QDesignerCustomWidgetInterface::initialize** () function:

    void MyPlugin::initialize(**QDesignerFormEditorInterface**  *formEditor)
    {
                    if (initialized)
                        return;
    **QExtensionManager**  *manager = formEditor->extensionManager();
    Q_ASSERT(manager != 0);

                    manager->registerExtensions(new
    MyExtensionFactory(manager),
    Q_TYPEID(**QDesignerTaskMenuExtension** ));

                    initialized
    = true;
                }

    The QExtensionManager is not intended to be instantiated directly. You can
    retrieve an interface to **Qt Designer** 's extension manager using the
    **QDesignerFormEditorInterface::extensionManager** () function. A pointer to
    **Qt Designer** 's current **QDesignerFormEditorInterface**  object
    (`formEditor` in the example above) is provided by the
    **QDesignerCustomWidgetInterface::initialize** () function's parameter. When
    implementing a custom widget plugin, you must subclass the
    **QDesignerCustomWidgetInterface**  to expose your plugin to **Qt
    Designer**.

    Then, when an extension is required, **Qt Designer** 's extension manager
    will run through all its registered factories calling
    **QExtensionFactory::createExtension** () for each until the first one that
    is able to create the requested extension for the selected object, is found.
    This factory will then make an instance of the extension.

    There are four available types of extensions in **Qt Designer** :
    **QDesignerContainerExtension**  , **QDesignerMemberSheetExtension** ,
    **QDesignerPropertySheetExtension**  and **QDesignerTaskMenuExtension** .
    **Qt Designer** 's behavior is the same whether the requested extension is
    associated with a container, a member sheet, a property sheet or a task
    menu.

    For a complete example using the QExtensionManager class, see the **Task
    Menu Extension example** . The example shows how to create a custom widget
    plugin for Qt Designer, and how to to use the **QDesignerTaskMenuExtension**
    class to add custom items to **Qt Designer** 's task menu.

    **See also** **QExtensionFactory**  and **QAbstractExtensionManager** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qextensionmanager.html#QExtensionManager

        **QExtensionManager::QExtensionManager(QObject * parent = nullptr)**

        Constructs an extension manager with the given **parent**.
        """
        ...

    def extension(self, object: QtCore.QObject, iid: str) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-5/qextensionmanager.html#extension

        **[override virtual] QObject *QExtensionManager::extension(QObject *
        object , const QString & iid ) const**

        Reimplements: **QAbstractExtensionManager::extension** (QObject *object,
        const QString &iid) const.

        Returns the extension specified by **iid** , for the given **object**.
        """
        ...

    def unregisterExtensions(
        self, factory: QAbstractExtensionFactory, iid: str = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qextensionmanager.html#unregisterExtensions

        **[override virtual] void
        QExtensionManager::unregisterExtensions(QAbstractExtensionFactory *
        factory , const QString & iid = QString())**

        Reimplements: **QAbstractExtensionManager::unregisterExtensions**
        (QAbstractExtensionFactory *factory, const QString &iid).

        Unregister the extension specified by the given **factory** and
        extension identifier **iid**.
        """
        ...

    def registerExtensions(
        self, factory: QAbstractExtensionFactory, iid: str = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qextensionmanager.html#registerExtensions

        **[override virtual] void
        QExtensionManager::registerExtensions(QAbstractExtensionFactory *
        factory , const QString & iid = QString())**

        Reimplements: **QAbstractExtensionManager::registerExtensions**
        (QAbstractExtensionFactory *factory, const QString &iid).

        Register the extension specified by the given **factory** and extension
        identifier **iid**.
        """
        ...
