"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtWidgets
from PyQt5.QtDesigner import *
from PyQt5 import sip


class QDesignerCustomWidgetInterface(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html

    **Detailed Description**

    QDesignerCustomWidgetInterface provides a custom widget with an interface.
    The class contains a set of functions that must be subclassed to return
    basic information about the widget, such as its class name and the name of
    its header file. Other functions must be implemented to initialize the
    plugin when it is loaded, and to construct instances of the custom widget
    for **Qt Designer** to use.

    When implementing a custom widget you must subclass
    QDesignerCustomWidgetInterface to expose your widget to **Qt Designer**. For
    example, this is the declaration for the plugin used in the **Custom Widget
    Plugin example**  that enables an analog clock custom widget to be used by
    **Qt Designer** :

    class AnalogClockPlugin : public **QObject** , public
    **QDesignerCustomWidgetInterface**
        {
            Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.qt-project.Qt.QDesignerCustomWidgetInterface")
    Q_INTERFACES(**QDesignerCustomWidgetInterface** )
        public:
    explicit AnalogClockPlugin(**QObject**  *parent = nullptr);
    bool isContainer() const override;
            bool isInitialized() const
    override;
            QIcon icon() const override;
            **QString**  domXml()
    const override;
            **QString**  group() const override;
    **QString**  includeFile() const override;
            **QString**  name() const
    override;
            **QString**  toolTip() const override;
            **QString**
    whatsThis() const override;
            **QWidget**  *createWidget(**QWidget**
    *parent) override;
            void initialize(**QDesignerFormEditorInterface**
    *core) override;

        private:
            bool initialized = false;
        };

    Note that the only part of the class definition that is specific to this
    particular custom widget is the class name. In addition, since we are
    implementing an interface, we must ensure that it's made known to the meta
    object system using the **Q_INTERFACES** () macro. This enables **Qt
    Designer** to use the **qobject_cast** () function to query for supported
    interfaces using nothing but a **QObject**  pointer.

    After **Qt Designer** loads a custom widget plugin, it calls the interface's
    **initialize** () function to enable it to set up any resources that it may
    need. This function is called with a **QDesignerFormEditorInterface**
    parameter that provides the plugin with a gateway to all of **Qt Designer**
    's API.

    **Qt Designer** constructs instances of the custom widget by calling the
    plugin's **createWidget** () function with a suitable parent widget. Plugins
    must construct and return an instance of a custom widget with the specified
    parent widget.

    Exporting your custom widget plugin to **Qt Designer** using the
    **Q_PLUGIN_METADATA** () macro. For example, if a library called
    `libcustomwidgetplugin.so` (on Unix) or `libcustomwidget.dll` (on Windows)
    contains a widget class called `MyCustomWidget`, we can export it by adding
    the following line to the file containing the plugin header:

    Q_PLUGIN_METADATA(IID "org.qt-project.Qt.QDesignerCustomWidgetInterface")

    This macro ensures that **Qt Designer** can access and construct the custom
    widget. Without this macro, there is no way for **Qt Designer** to use it.

    When implementing a custom widget plugin, you build it as a separate
    library. If you want to include several custom widget plugins in the same
    library, you must in addition subclass
    **QDesignerCustomWidgetCollectionInterface** .

    **Warning:** If your custom widget plugin contains **QVariant**  properties,
    be aware that only the following **types**  are supported:

    * QVariant::ByteArray
      * QVariant::Bool
      * QVariant::Color
      *
    QVariant::Cursor
      * QVariant::Date
      * QVariant::DateTime
      *
    QVariant::Double
      * QVariant::Int
      * QVariant::Point
      * QVariant::Rect
    * QVariant::Size
      * QVariant::SizePolicy
      * QVariant::String
      *
    QVariant::Time
      * QVariant::UInt

    For a complete example using the QDesignerCustomWidgetInterface class, see
    the **Custom Widget Example** . The example shows how to create a custom
    widget plugin for **Qt Designer**.

    **See also** **QDesignerCustomWidgetCollectionInterface**  and **Creating
    Custom Widgets for Qt Designer** .
    """

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QDesignerCustomWidgetInterface") -> None:
        ...

    def codeTemplate(self) -> str:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#codeTemplate

        **[virtual] QString QDesignerCustomWidgetInterface::codeTemplate()
        const**

        This function is reserved for future use by **Qt Designer**.
        """
        ...

    def domXml(self) -> str:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#domXml

        **[virtual] QString QDesignerCustomWidgetInterface::domXml() const**

        Returns the XML that is used to describe the custom widget's properties
        to **Qt Designer**.
        """
        ...

    def initialize(self, core: QDesignerFormEditorInterface) -> None:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#initialize

        **[virtual] void
        QDesignerCustomWidgetInterface::initialize(QDesignerFormEditorInterface
        * formEditor )**

        Initializes the widget for use with the specified **formEditor**
        interface.

        **See also** **isInitialized** ().
        """
        ...

    def isInitialized(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#isInitialized

        **[virtual] bool QDesignerCustomWidgetInterface::isInitialized() const**

        Returns true if the widget has been initialized; otherwise returns
        false.

        **See also** **initialize** ().
        """
        ...

    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#createWidget

        **[pure virtual] QWidget
        *QDesignerCustomWidgetInterface::createWidget(QWidget * parent )**

        Returns a new instance of the custom widget, with the given **parent**.
        """
        ...

    def isContainer(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#isContainer

        **[pure virtual] bool QDesignerCustomWidgetInterface::isContainer()
        const**

        Returns true if the custom widget is intended to be used as a container;
        otherwise returns false.

        Most custom widgets are not used to hold other widgets, so their
        implementations of this function will return false, but custom
        containers will return true to ensure that they behave correctly in **Qt
        Designer**.
        """
        ...

    def icon(self) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#icon

        **[pure virtual] QIcon QDesignerCustomWidgetInterface::icon() const**

        Returns the icon used to represent the custom widget in **Qt Designer**
        's widget box.
        """
        ...

    def includeFile(self) -> str:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#includeFile

        **[pure virtual] QString QDesignerCustomWidgetInterface::includeFile()
        const**

        Returns the path to the include file that **uic**  uses when creating
        code for the custom widget.
        """
        ...

    def whatsThis(self) -> str:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#whatsThis

        **[pure virtual] QString QDesignerCustomWidgetInterface::whatsThis()
        const**

        Returns a description of the widget that can be used by **Qt Designer**
        in "What's This?" help for the widget.
        """
        ...

    def toolTip(self) -> str:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#toolTip

        **[pure virtual] QString QDesignerCustomWidgetInterface::toolTip()
        const**

        Returns a short description of the widget that can be used by **Qt
        Designer** in a tool tip.
        """
        ...

    def group(self) -> str:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#group

        **[pure virtual] QString QDesignerCustomWidgetInterface::group() const**

        Returns the name of the group to which the custom widget belongs.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qdesignercustomwidgetinterface.html#name

        **[pure virtual] QString QDesignerCustomWidgetInterface::name() const**

        Returns the class name of the custom widget supplied by the interface.

        The name returned **must** be identical to the class name used for the
        custom widget.
        """
        ...
