"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtDBus import *
from PyQt5 import sip


class QDBusServiceWatcher(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qdbusservicewatcher.html

    **Detailed Description**

    A QDBusServiceWatcher object can be used to notify the application about an
    ownership change of a service name on the bus. It has three watch modes:

    * Watching for service registration only.
      * Watching for service
    unregistration only.
      * Watching for any kind of service ownership change
    (the default mode).

    Besides being created or deleted, services may change owners without a
    unregister/register operation happening. So the **serviceRegistered** () and
    **serviceUnregistered** () signals may not be emitted if that happens.

    This class is more efficient than using the
    QDBusConnectionInterface::serviceOwnerChanged() signal because it allows one
    to receive only the signals for which the class is interested in.

    Ending a service name with the character '*' will match all service names
    within the specified namespace.

    For example "com.example.backend1*" will match

    * com.example.backend1
      * com.example.backend1.foo
      *
    com.example.backend1.foo.bar

    Substrings in the same domain will not be matched, i.e
    "com.example.backend12".

    **See also** **QDBusConnection** .
    """

    class WatchModeFlag(int):
        WatchForRegistration: QDBusServiceWatcher = ...
        WatchForUnregistration: QDBusServiceWatcher = ...
        WatchForOwnerChange: QDBusServiceWatcher = ...

    class WatchMode(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QDBusServiceWatcher.WatchMode", "QDBusServiceWatcher.WatchModeFlag"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QDBusServiceWatcher.WatchMode") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QDBusServiceWatcher.WatchMode":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#QDBusServiceWatcher

        **QDBusServiceWatcher::QDBusServiceWatcher(QObject * parent = nullptr)**

        Creates a QDBusServiceWatcher object. Note that until you set a
        connection with **setConnection** (), this object will not emit any
        signals.

        The **parent** parameter is passed to **QObject**  to set the parent of
        this object.
        """
        ...

    @typing.overload
    def __init__(
        self,
        service: str,
        connection: QDBusConnection,
        watchMode: typing.Union[
            "QDBusServiceWatcher.WatchMode", "QDBusServiceWatcher.WatchModeFlag"
        ] = ...,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#QDBusServiceWatcher-1

        **QDBusServiceWatcher::QDBusServiceWatcher(const QString & service ,
        const QDBusConnection & connection , QDBusServiceWatcher::WatchMode
        watchMode = WatchForOwnerChange, QObject * parent = nullptr)**

        Creates a QDBusServiceWatcher object and attaches it to the
        **connection** connection. Also, this function immediately starts
        watching for **watchMode** changes to service **service**.

        The **parent** parameter is passed to **QObject**  to set the parent of
        this object.
        """
        ...

    def setConnection(self, connection: QDBusConnection) -> None:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#setConnection

        **void QDBusServiceWatcher::setConnection(const QDBusConnection &
        connection )**

        Sets the D-Bus connection that this object is attached to be
        **connection**. All services watched will be transferred to this
        connection.

        Note that **QDBusConnection**  objects are reference counted:
        **QDBusServiceWatcher**  will keep a reference for this connection while
        it exists. The connection is not closed until the reference count drops
        to zero, so this will ensure that any notifications are received while
        this **QDBusServiceWatcher**  object exists.

        **See also** **connection** ().
        """
        ...

    def connection(self) -> QDBusConnection:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#connection

        **QDBusConnection QDBusServiceWatcher::connection() const**

        Returns the **QDBusConnection**  that this object is attached to.

        **See also** **setConnection** ().
        """
        ...

    def setWatchMode(
        self,
        mode: typing.Union[
            "QDBusServiceWatcher.WatchMode", "QDBusServiceWatcher.WatchModeFlag"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#watchMode-prop

        **watchMode : WatchMode**

        The `watchMode` property holds the current watch mode for this
        **QDBusServiceWatcher**  object. The default value for this property is
        QDBusServiceWatcher::WatchForOwnershipChange.

        **Access functions:**

        QDBusServiceWatcher::WatchMode **watchMode** () const
        void
        **setWatchMode** (QDBusServiceWatcher::WatchMode **mode** )
        """
        ...

    def watchMode(self) -> "QDBusServiceWatcher.WatchMode":
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#watchMode-prop

        **watchMode : WatchMode**

        The `watchMode` property holds the current watch mode for this
        **QDBusServiceWatcher**  object. The default value for this property is
        QDBusServiceWatcher::WatchForOwnershipChange.

        **Access functions:**

        QDBusServiceWatcher::WatchMode **watchMode** () const
        void
        **setWatchMode** (QDBusServiceWatcher::WatchMode **mode** )
        """
        ...

    def removeWatchedService(self, service: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#removeWatchedService

        **bool QDBusServiceWatcher::removeWatchedService(const QString & service
        )**

        Removes the **service** from the list of services being watched by this
        object. Note that D-Bus notifications are asynchronous, so there may
        still be signals pending delivery about **service**. Those signals will
        still be emitted whenever the D-Bus messages are processed.

        This function returns `true` if any services were removed.
        """
        ...

    def addWatchedService(self, newService: str) -> None:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#addWatchedService

        **void QDBusServiceWatcher::addWatchedService(const QString & newService
        )**

        Adds **newService** to the list of services to be watched by this
        object. This function is more efficient than **setWatchedServices** ()
        and should be used whenever possible to add services.
        """
        ...

    def setWatchedServices(self, services: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#setWatchedServices

        **void QDBusServiceWatcher::setWatchedServices(const QStringList &
        services )**

        Sets the list of D-Bus services being watched to be **services**.

        Note that setting the entire list means removing all previous rules for
        watching services and adding new ones. This is an expensive operation
        and should be avoided, if possible. Instead, use **addWatchedService**
        () and **removeWatchedService** () if you can to manipulate entries in
        the list.

        **Note:** Setter function for property **watchedServices** .

        **See also** **watchedServices** ().
        """
        ...

    def watchedServices(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#watchedServices

        **QStringList QDBusServiceWatcher::watchedServices() const**

        Returns the list of D-Bus services that are being watched.

        **Note:** Getter function for property watchedServices.

        **See also** **setWatchedServices** ().
        """
        ...

    @property
    def serviceOwnerChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#serviceOwnerChanged

        **[signal] void QDBusServiceWatcher::serviceOwnerChanged(const QString &
        serviceName , const QString & oldOwner , const QString & newOwner )**

        This signal is emitted whenever this object detects that there was a
        service ownership change relating to the **serviceName** service. The
        **oldOwner** parameter contains the old owner name and **newOwner** is
        the new owner. Both **oldOwner** and **newOwner** are unique connection
        names.

        Note that this signal is also emitted whenever the **serviceName**
        service was registered or unregistered. If it was registered,
        **oldOwner** will contain an empty string, whereas if it was
        unregistered, **newOwner** will contain an empty string.

        If you need only to find out if the service is registered or
        unregistered only, without being notified that the ownership changed,
        consider using the specific modes for those operations. This class is
        more efficient if you use the more specific modes.

        **See also** **serviceRegistered** () and **serviceUnregistered** ().
        """
        ...

    @property
    def serviceRegistered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#serviceRegistered

        **[signal] void QDBusServiceWatcher::serviceRegistered(const QString &
        serviceName )**

        This signal is emitted whenever this object detects that the service
        **serviceName** became available on the bus.

        **See also** **serviceUnregistered** () and **serviceOwnerChanged** ().
        """
        ...

    @property
    def serviceUnregistered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdbusservicewatcher.html#serviceUnregistered

        **[signal] void QDBusServiceWatcher::serviceUnregistered(const QString &
        serviceName )**

        This signal is emitted whenever this object detects that the service
        **serviceName** was unregistered from the bus and is no longer
        available.

        **See also** **serviceRegistered** () and **serviceOwnerChanged** ().
        """
        ...
