"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
from PyQt5.QtDBus import *
from PyQt5 import sip


class QDBusPendingCall(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdbuspendingcall.html

    **Detailed Description**

    A QDBusPendingCall object is a reference to a method call that was sent over
    D-Bus without waiting for a reply. QDBusPendingCall is an opaque type, meant
    to be used as a handle for a pending reply.

    In most programs, the QDBusPendingCall class will not be used directly. It
    can be safely replaced with the template-based **QDBusPendingReply** , in
    order to access the contents of the reply or wait for it to be complete.

    The **QDBusPendingCallWatcher**  class allows one to connect to a signal
    that will indicate when the reply has arrived or if the call has timed out.
    It also provides the **QDBusPendingCallWatcher::waitForFinished** () method
    which will suspend the execution of the program until the reply has arrived.

    **Note:** If you create a copy of a QDBusPendingCall object, all information
    will be shared among the many copies. Therefore, QDBusPendingCall is an
    explicitly-shared object and does not provide a method of detaching the
    copies (since they refer to the same pending call)

    **See also** **QDBusPendingReply**  and **QDBusPendingCallWatcher** .
    """

    def __init__(self, other: "QDBusPendingCall") -> None:
        """
        https://doc.qt.io/qt-5/qdbuspendingcall.html#QDBusPendingCall

        **QDBusPendingCall::QDBusPendingCall(const QDBusPendingCall & other )**

        Creates a copy of the **other** pending asynchronous call. Note that
        both objects will refer to the same pending call.
        """
        ...

    def swap(self, other: "QDBusPendingCall") -> None:
        """
        https://doc.qt.io/qt-5/qdbuspendingcall.html#swap

        **void QDBusPendingCall::swap(QDBusPendingCall & other )**

        Swaps this pending call instance with **other**. This function is very
        fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def fromCompletedCall(message: QDBusMessage) -> "QDBusPendingCall":
        """
        https://doc.qt.io/qt-5/qdbuspendingcall.html#fromCompletedCall

        **[static] QDBusPendingCall QDBusPendingCall::fromCompletedCall(const
        QDBusMessage & msg )**

        Creates a **QDBusPendingCall**  object based on the message **msg**. The
        message must be of type **QDBusMessage::ErrorMessage**  or
        **QDBusMessage::ReplyMessage**  (that is, a message that is typical of a
        completed call).

        This function is useful for code that requires simulating a pending
        call, but that has already finished.

        This function was introduced in Qt 4.6.

        **See also** **fromError** ().
        """
        ...

    @staticmethod
    def fromError(error: QDBusError) -> "QDBusPendingCall":
        """
        https://doc.qt.io/qt-5/qdbuspendingcall.html#fromError

        **[static] QDBusPendingCall QDBusPendingCall::fromError(const QDBusError
        & error )**

        Creates a **QDBusPendingCall**  object based on the error condition
        **error**. The resulting pending call object will be in the "finished"
        state and **QDBusPendingReply** <T1, T2, T3, T4, T5, T6, T7,
        T8>::isError() will return true.

        This function was introduced in Qt 4.6.

        **See also** **fromCompletedCall** ().
        """
        ...
