"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtDBus import *
from PyQt5 import sip


class QDBusConnection(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qdbusconnection.html

    **Detailed Description**

    This class is the initial point in a D-Bus session. Using it, you can get
    access to remote objects, interfaces; connect remote signals to your
    object's slots; register objects, etc.

    D-Bus connections are created using the **connectToBus** () function, which
    opens a connection to the server daemon and does the initial handshaking,
    associating that connection with a name. Further attempts to connect using
    the same name will return the same connection.

    The connection is then torn down using the **disconnectFromBus** ()
    function.

    Once disconnected, calling **connectToBus** () will not reestablish a
    connection, you must create a new QDBusConnection instance.

    As a convenience for the two most common connection types, the
    **sessionBus** () and **systemBus** () functions return open connections to
    the session server daemon and the system server daemon, respectively. Those
    connections are opened when first used and are closed when the
    **QCoreApplication**  destructor is run.

    D-Bus also supports peer-to-peer connections, without the need for a bus
    server daemon. Using this facility, two applications can talk to each other
    and exchange messages. This can be achieved by passing an address to
    **connectToBus** () function, which was opened by another D-Bus application
    using **QDBusServer** .
    """

    class ConnectionCapability(int):
        UnixFileDescriptorPassing: QDBusConnection = ...

    class UnregisterMode(int):
        UnregisterNode: QDBusConnection = ...
        UnregisterTree: QDBusConnection = ...

    class RegisterOption(int):
        ExportAdaptors: QDBusConnection = ...
        ExportScriptableSlots: QDBusConnection = ...
        ExportScriptableSignals: QDBusConnection = ...
        ExportScriptableProperties: QDBusConnection = ...
        ExportScriptableInvokables: QDBusConnection = ...
        ExportScriptableContents: QDBusConnection = ...
        ExportNonScriptableSlots: QDBusConnection = ...
        ExportNonScriptableSignals: QDBusConnection = ...
        ExportNonScriptableProperties: QDBusConnection = ...
        ExportNonScriptableInvokables: QDBusConnection = ...
        ExportNonScriptableContents: QDBusConnection = ...
        ExportAllSlots: QDBusConnection = ...
        ExportAllSignals: QDBusConnection = ...
        ExportAllProperties: QDBusConnection = ...
        ExportAllInvokables: QDBusConnection = ...
        ExportAllContents: QDBusConnection = ...
        ExportAllSignal: QDBusConnection = ...
        ExportChildObjects: QDBusConnection = ...

    class BusType(int):
        SessionBus: QDBusConnection = ...
        SystemBus: QDBusConnection = ...
        ActivationBus: QDBusConnection = ...

    class RegisterOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QDBusConnection.RegisterOptions", "QDBusConnection.RegisterOption"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QDBusConnection.RegisterOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QDBusConnection.RegisterOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class ConnectionCapabilities(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QDBusConnection.ConnectionCapabilities",
                "QDBusConnection.ConnectionCapability",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QDBusConnection.ConnectionCapabilities") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QDBusConnection.ConnectionCapabilities":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    @typing.overload
    def __init__(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#QDBusConnection

        **QDBusConnection::QDBusConnection(const QString & name )**

        Creates a QDBusConnection object attached to the connection with name
        **name**.

        This does not open the connection. You have to call **connectToBus** ()
        to open it.
        """
        ...

    @typing.overload
    def __init__(self, other: "QDBusConnection") -> None:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#QDBusConnection-1

        **QDBusConnection::QDBusConnection(const QDBusConnection & other )**

        Creates a copy of the **other** connection.
        """
        ...

    def swap(self, other: "QDBusConnection") -> None:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#swap

        **void QDBusConnection::swap(QDBusConnection & other )**

        Swaps this **QDBusConnection**  instance with **other**.
        """
        ...

    @staticmethod
    def sender() -> "QDBusConnection":
        ...

    @staticmethod
    def systemBus() -> "QDBusConnection":
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#systemBus

        **[static] QDBusConnection QDBusConnection::systemBus()**

        Returns a **QDBusConnection**  object opened with the system bus. The
        object reference returned by this function is valid until the
        **QCoreApplication** 's destructor is run, when the connection will be
        closed and the object, deleted.
        """
        ...

    @staticmethod
    def sessionBus() -> "QDBusConnection":
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#sessionBus

        **[static] QDBusConnection QDBusConnection::sessionBus()**

        Returns a **QDBusConnection**  object opened with the session bus. The
        object reference returned by this function is valid until the
        application terminates, at which point the connection will be closed and
        the object deleted.
        """
        ...

    @staticmethod
    def localMachineId() -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#localMachineId

        **[static] QByteArray QDBusConnection::localMachineId()**

        Returns the local machine ID as known to the D-Bus system. Each node or
        host that runs D-Bus has a unique identifier that can be used to
        distinguish it from other hosts if they are sharing resources like the
        filesystem.

        Note that the local machine ID is not guaranteed to be persistent across
        boots of the system, so this identifier should not be stored in
        persistent storage (like the filesystem). It is guaranteed to remain
        constant only during the lifetime of this boot session.

        This function was introduced in Qt 4.8.
        """
        ...

    @staticmethod
    def disconnectFromPeer(name: str) -> None:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#disconnectFromPeer

        **[static] void QDBusConnection::disconnectFromPeer(const QString & name
        )**

        Closes the peer connection of name **name**.

        Note that if there are still **QDBusConnection**  objects associated
        with the same connection, the connection will not be closed until all
        references are dropped. However, no further references can be created
        using the **QDBusConnection**  constructor.

        This function was introduced in Qt 4.8.
        """
        ...

    @staticmethod
    def disconnectFromBus(name: str) -> None:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#disconnectFromBus

        **[static] void QDBusConnection::disconnectFromBus(const QString & name
        )**

        Closes the bus connection of name **name**.

        Note that if there are still **QDBusConnection**  objects associated
        with the same connection, the connection will not be closed until all
        references are dropped. However, no further references can be created
        using the **QDBusConnection**  constructor.
        """
        ...

    @staticmethod
    def connectToPeer(address: str, name: str) -> "QDBusConnection":
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#connectToPeer

        **[static] QDBusConnection QDBusConnection::connectToPeer(const QString
        & address , const QString & name )**

        Opens a peer-to-peer connection on address **address** and associate
        with it the connection name **name**. Returns a **QDBusConnection**
        object associated with that connection.

        This function was introduced in Qt 4.8.
        """
        ...

    @typing.overload
    @staticmethod
    def connectToBus(type: "QDBusConnection.BusType", name: str) -> "QDBusConnection":
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#connectToBus

        **[static] QDBusConnection
        QDBusConnection::connectToBus(QDBusConnection::BusType type , const
        QString & name )**

        Opens a connection of type **type** to one of the known busses and
        associate with it the connection name **name**. Returns a
        **QDBusConnection**  object associated with that connection.
        """
        ...

    @typing.overload
    @staticmethod
    def connectToBus(address: str, name: str) -> "QDBusConnection":
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#connectToBus-1

        **[static] QDBusConnection QDBusConnection::connectToBus(const QString &
        address , const QString & name )**

        Opens a connection to a private bus on address **address** and associate
        with it the connection name **name**. Returns a **QDBusConnection**
        object associated with that connection.
        """
        ...

    def interface(self) -> "QDBusConnectionInterface":
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#interface

        **QDBusConnectionInterface *QDBusConnection::interface() const**

        Returns a **QDBusConnectionInterface**  object that represents the D-Bus
        server interface on this connection.
        """
        ...

    def unregisterService(self, serviceName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#unregisterService

        **bool QDBusConnection::unregisterService(const QString & serviceName
        )**

        Unregisters the service **serviceName** that was previously registered
        with **registerService** () and returns `true` if it succeeded.

        **See also** **registerService** () and
        **QDBusConnectionInterface::unregisterService** ().
        """
        ...

    def registerService(self, serviceName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#registerService

        **bool QDBusConnection::registerService(const QString & serviceName )**

        Attempts to register the **serviceName** on the D-Bus server and returns
        `true` if the registration succeeded. The registration will fail if the
        name is already registered by another application.

        **See also** **unregisterService** () and
        **QDBusConnectionInterface::registerService** ().
        """
        ...

    def objectRegisteredAt(self, path: str) -> QtCore.QObject:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#objectRegisteredAt

        **QObject *QDBusConnection::objectRegisteredAt(const QString & path )
        const**

        Return the object that was registered with the **registerObject** () at
        the object path given by **path**.
        """
        ...

    def unregisterObject(
        self, path: str, mode: "QDBusConnection.UnregisterMode" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#unregisterObject

        **void QDBusConnection::unregisterObject(const QString & path ,
        QDBusConnection::UnregisterMode mode = UnregisterNode)**

        Unregisters an object that was registered with the **registerObject** ()
        at the object path given by **path** and, if **mode** is
        **QDBusConnection::UnregisterTree** , all of its sub-objects too.

        Note that you cannot unregister objects that were not registered with
        **registerObject** ().
        """
        ...

    @typing.overload
    def registerObject(
        self,
        path: str,
        object: QtCore.QObject,
        options: typing.Union[
            "QDBusConnection.RegisterOptions", "QDBusConnection.RegisterOption"
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#registerObject

        **bool QDBusConnection::registerObject(const QString & path , QObject *
        object , QDBusConnection::RegisterOptions options = ExportAdaptors)**

        Registers the object **object** at path **path** and returns `true` if
        the registration was successful. The **options** parameter specifies how
        much of the object **object** will be exposed through D-Bus.

        This function does not replace existing objects: if there is already an
        object registered at path **path** , this function will return false.
        Use **unregisterObject** () to unregister it first.

        The **ExportChildObjects**  flag exports child objects on D-Bus based on
        the path of the registered objects and the **QObject::objectName**  of
        the child. Therefore, it is important for the child object to have an
        object name.

        You cannot register an object as a child object of an object that was
        registered with **ExportChildObjects** .
        """
        ...

    @typing.overload
    def registerObject(
        self,
        path: str,
        interface: str,
        object: QtCore.QObject,
        options: typing.Union[
            "QDBusConnection.RegisterOptions", "QDBusConnection.RegisterOption"
        ] = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#registerObject-1

        **bool QDBusConnection::registerObject(const QString & path , const
        QString & interface , QObject * object ,
        QDBusConnection::RegisterOptions options = ExportAdaptors)**

        This is an overloaded function.

        Registers the object **object** at path **path** with interface name
        **interface** and returns `true` if the registration was successful. The
        **options** parameter specifies how much of the object **object** will
        be exposed through D-Bus.

        This function does not replace existing objects: if there is already an
        object registered at path **path** , this function will return false.
        Use **unregisterObject** () to unregister it first.

        The **ExportChildObjects**  flag exports child objects on D-Bus based on
        the path of the registered objects and the **QObject::objectName**  of
        the child. Therefore, it is important for the child object to have an
        object name.

        You cannot register an object as a child object of an object that was
        registered with **ExportChildObjects** .

        This function was introduced in Qt 5.5.
        """
        ...

    @typing.overload
    def disconnect(
        self, service: str, path: str, interface: str, name: str, slot: PYQT_SLOT
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#disconnect

        **bool QDBusConnection::disconnect(const QString & service , const
        QString & path , const QString & interface , const QString & name ,
        QObject * receiver , const char * slot )**

        Disconnects the signal specified by the **service** , **path** ,
        **interface** and **name** parameters from the slot **slot** in object
        **receiver**. The arguments must be the same as passed to the
        **connect** () function.

        Returns `true` if the disconnection was successful.
        """
        ...

    @typing.overload
    def disconnect(
        self,
        service: str,
        path: str,
        interface: str,
        name: str,
        signature: str,
        slot: PYQT_SLOT,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#disconnect-1

        **bool QDBusConnection::disconnect(const QString & service , const
        QString & path , const QString & interface , const QString & name ,
        const QString & signature , QObject * receiver , const char * slot )**

        This is an overloaded function.

        Disconnects the signal specified by the **service** , **path** ,
        **interface** , **name** , and **signature** parameters from the slot
        **slot** in object **receiver**. The arguments must be the same as
        passed to the **connect** () function.

        Returns `true` if the disconnection was successful.
        """
        ...

    @typing.overload
    def disconnect(
        self,
        service: str,
        path: str,
        interface: str,
        name: str,
        argumentMatch: typing.Iterable[str],
        signature: str,
        slot: PYQT_SLOT,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#disconnect-2

        **bool QDBusConnection::disconnect(const QString & service , const
        QString & path , const QString & interface , const QString & name ,
        const QStringList & argumentMatch , const QString & signature , QObject
        * receiver , const char * slot )**

        This is an overloaded function.

        Disconnects the signal specified by the **service** , **path** ,
        **interface** , **name** , **argumentMatch** , and **signature**
        parameters from the slot **slot** in object **receiver**. The arguments
        must be the same as passed to the **connect** () function.

        Returns `true` if the disconnection was successful.

        This function was introduced in Qt 4.6.
        """
        ...

    @typing.overload
    def connect(
        self, service: str, path: str, interface: str, name: str, slot: PYQT_SLOT
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#connect

        **bool QDBusConnection::connect(const QString & service , const QString
        & path , const QString & interface , const QString & name , QObject *
        receiver , const char * slot )**

        Connects the signal specified by the **service** , **path** ,
        **interface** and **name** parameters to the slot **slot** in object
        **receiver**. The arguments **service** and **path** can be empty,
        denoting a connection to any signal of the ( **interface** , **name** )
        pair, from any remote application.

        Returns `true` if the connection was successful.

        **Warning:** The signal will only be delivered to the slot if the
        parameters match. This verification can be done only when the signal is
        received, not at connection time.
        """
        ...

    @typing.overload
    def connect(
        self,
        service: str,
        path: str,
        interface: str,
        name: str,
        signature: str,
        slot: PYQT_SLOT,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#connect-1

        **bool QDBusConnection::connect(const QString & service , const QString
        & path , const QString & interface , const QString & name , const
        QString & signature , QObject * receiver , const char * slot )**

        This is an overloaded function.

        Connects the signal to the slot **slot** in object **receiver**. Unlike
        the previous connect() overload, this function allows one to specify the
        parameter signature to be connected using the **signature** variable.
        The function will then verify that this signature can be delivered to
        the slot specified by **slot** and return false otherwise.

        Returns `true` if the connection was successful.

        **Note:** This function verifies that the signal signature matches the
        slot's parameters, but it does not verify that the actual signal exists
        with the given signature in the remote service.
        """
        ...

    @typing.overload
    def connect(
        self,
        service: str,
        path: str,
        interface: str,
        name: str,
        argumentMatch: typing.Iterable[str],
        signature: str,
        slot: PYQT_SLOT,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#connect-2

        **bool QDBusConnection::connect(const QString & service , const QString
        & path , const QString & interface , const QString & name , const
        QStringList & argumentMatch , const QString & signature , QObject *
        receiver , const char * slot )**

        This is an overloaded function.

        Connects the signal to the slot **slot** in object **receiver**. Unlike
        the previous connect() overload, this function allows one to specify the
        parameter signature to be connected using the **signature** variable.
        The function will then verify that this signature can be delivered to
        the slot specified by **slot** and return false otherwise.

        The **argumentMatch** parameter lists the string parameters to be
        matched, in sequential order. Note that, to match an empty string, you
        need to pass a **QString**  that is empty but not null (i.e.,
        **QString** ("")). A null **QString**  skips matching at that position.

        Returns `true` if the connection was successful.

        **Note:** This function verifies that the signal signature matches the
        slot's parameters, but it does not verify that the actual signal exists
        with the given signature in the remote service.

        This function was introduced in Qt 4.6.
        """
        ...

    def asyncCall(
        self, message: "QDBusMessage", timeout: int = ...
    ) -> "QDBusPendingCall":
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#asyncCall

        **QDBusPendingCall QDBusConnection::asyncCall(const QDBusMessage &
        message , int timeout = -1) const**

        Sends the **message** over this connection and returns immediately. This
        function is suitable for method calls only. It returns an object of type
        **QDBusPendingCall**  which can be used to track the status of the
        reply.

        If no reply is received within **timeout** milliseconds, an automatic
        error will be delivered indicating the expiration of the call. The
        default **timeout** is -1, which will be replaced with an
        implementation-defined value that is suitable for inter-process
        communications (generally, 25 seconds). This timeout is also the upper
        limit for waiting in QDBusPendingCall::waitForFinished().

        See the **QDBusInterface::asyncCall** () function for a more friendly
        way of placing calls.

        This function was introduced in Qt 4.5.
        """
        ...

    def call(
        self, message: "QDBusMessage", mode: QDBus.CallMode = ..., timeout: int = ...
    ) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#call

        **QDBusMessage QDBusConnection::call(const QDBusMessage & message ,
        QDBus::CallMode mode = QDBus::Block, int timeout = -1) const**

        Sends the **message** over this connection and blocks, waiting for a
        reply, for at most **timeout** milliseconds. This function is suitable
        for method calls only. It returns the reply message as its return value,
        which will be either of type **QDBusMessage::ReplyMessage**  or
        **QDBusMessage::ErrorMessage** .

        If no reply is received within **timeout** milliseconds, an automatic
        error will be delivered indicating the expiration of the call. The
        default **timeout** is -1, which will be replaced with an
        implementation-defined value that is suitable for inter-process
        communications (generally, 25 seconds).

        See the **QDBusInterface::call** () function for a more friendly way of
        placing calls.

        **Warning:** If **mode** is **QDBus::BlockWithGui** , this function will
        reenter the Qt event loop in order to wait for the reply. During the
        wait, it may deliver signals and other method calls to your application.
        Therefore, it must be prepared to handle a reentrancy whenever a call is
        placed with call().
        """
        ...

    def callWithCallback(
        self,
        message: "QDBusMessage",
        returnMethod: PYQT_SLOT,
        errorMethod: PYQT_SLOT,
        timeout: int = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#callWithCallback

        **bool QDBusConnection::callWithCallback(const QDBusMessage & message ,
        QObject * receiver , const char * returnMethod , const char *
        errorMethod , int timeout = -1) const**

        Sends the **message** over this connection and returns immediately. When
        the reply is received, the method **returnMethod** is called in the
        **receiver** object. If an error occurs, the method **errorMethod** will
        be called instead.

        If no reply is received within **timeout** milliseconds, an automatic
        error will be delivered indicating the expiration of the call. The
        default **timeout** is -1, which will be replaced with an
        implementation-defined value that is suitable for inter-process
        communications (generally, 25 seconds).

        This function is suitable for method calls only. It is guaranteed that
        the slot will be called exactly once with the reply, as long as the
        parameter types match and no error occurs.

        Returns `true` if the message was sent, or false if the message could
        not be sent.
        """
        ...

    def send(self, message: "QDBusMessage") -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#send

        **bool QDBusConnection::send(const QDBusMessage & message ) const**

        Sends the **message** over this connection, without waiting for a reply.
        This is suitable for errors, signals, and return values as well as calls
        whose return values are not necessary.

        Returns `true` if the message was queued successfully, false otherwise.
        """
        ...

    def connectionCapabilities(self) -> "QDBusConnection.ConnectionCapabilities":
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#connectionCapabilities

        **QDBusConnection::ConnectionCapabilities
        QDBusConnection::connectionCapabilities() const**

        Returns the capabilities of this connection as negotiated with the bus
        server or peer. If this **QDBusConnection**  is not connected, this
        function returns no capabilities.

        This function was introduced in Qt 4.8.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#name

        **QString QDBusConnection::name() const**

        Returns the connection name for this connection, as given as the name
        parameter to **connectToBus** ().

        The connection name can be used to uniquely identify actual underlying
        connections to buses. Copies made from a single connection will always
        implicitly share the underlying connection, and hence will have the same
        connection name.

        Inversely, two connections having different connection names will always
        either be connected to different buses, or have a different unique name
        (as returned by **baseService** ()) on that bus.

        This function was introduced in Qt 4.5.

        **See also** **connectToBus** () and **disconnectFromBus** ().
        """
        ...

    def lastError(self) -> "QDBusError":
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#lastError

        **QDBusError QDBusConnection::lastError() const**

        Returns the last error that happened in this connection.

        This function is provided for low-level code. If you're using
        **QDBusInterface::call** (), error codes are reported by its return
        value.

        **See also** **QDBusInterface**  and **QDBusMessage** .
        """
        ...

    def baseService(self) -> str:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#baseService

        **QString QDBusConnection::baseService() const**

        Returns the unique connection name for this connection, if this
        **QDBusConnection**  object is connected, or an empty **QString**
        otherwise.

        A Unique Connection Name is a string in the form ":x.xxx" (where x are
        decimal digits) that is assigned by the D-Bus server daemon upon
        connection. It uniquely identifies this client in the bus.

        This function returns an empty **QString**  for peer-to-peer
        connections.
        """
        ...

    def isConnected(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdbusconnection.html#isConnected

        **bool QDBusConnection::isConnected() const**

        Returns `true` if this **QDBusConnection**  object is connected.
        """
        ...
