"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import sip


class QXmlStreamAttribute(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlstreamattribute.html

    **Detailed Description**

    An attribute consists of an optionally empty **namespaceUri** (), a **name**
    (), a **value** (), and an **isDefault** () attribute.

    The raw XML attribute name is returned as **qualifiedName** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlstreamattribute.html#QXmlStreamAttribute

        **QXmlStreamAttribute::QXmlStreamAttribute()**

        Creates an empty attribute.
        """
        ...

    @typing.overload
    def __init__(self, qualifiedName: str, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlstreamattribute.html#QXmlStreamAttribute-1

        **QXmlStreamAttribute::QXmlStreamAttribute(const QString & qualifiedName
        , const QString & value )**

        Constructs an attribute with qualified name **qualifiedName** and value
        **value**.
        """
        ...

    @typing.overload
    def __init__(self, namespaceUri: str, name: str, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlstreamattribute.html#QXmlStreamAttribute-2

        **QXmlStreamAttribute::QXmlStreamAttribute(const QString & namespaceUri
        , const QString & name , const QString & value )**

        Constructs an attribute in the namespace described with **namespaceUri**
        with **name** and value **value**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QXmlStreamAttribute") -> None:
        """
        https://doc.qt.io/qt-5/qxmlstreamattribute.html#QXmlStreamAttribute-3

        **QXmlStreamAttribute::QXmlStreamAttribute(const QXmlStreamAttribute &
        other )**

        Creates a copy of **other**.
        """
        ...

    def isDefault(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlstreamattribute.html#isDefault

        **bool QXmlStreamAttribute::isDefault() const**

        Returns `true` if the parser added this attribute with a default value
        following an ATTLIST declaration in the DTD; otherwise returns `false`.
        """
        ...

    def value(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmlstreamattribute.html#value

        **QStringRef QXmlStreamAttribute::value() const**

        Returns the attribute's value.
        """
        ...

    def prefix(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmlstreamattribute.html#prefix

        **QStringRef QXmlStreamAttribute::prefix() const**

        Returns the attribute's namespace prefix.

        This function was introduced in Qt 4.4.

        **See also** **name** () and **qualifiedName** ().
        """
        ...

    def qualifiedName(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmlstreamattribute.html#qualifiedName

        **QStringRef QXmlStreamAttribute::qualifiedName() const**

        Returns the attribute's qualified name.

        A qualified name is the raw name of an attribute in the XML data. It
        consists of the namespace **prefix** (), followed by colon, followed by
        the attribute's local **name** (). Since the namespace prefix is not
        unique (the same prefix can point to different namespaces and different
        prefixes can point to the same namespace), you shouldn't use
        qualifiedName(), but the resolved **namespaceUri** () and the
        attribute's local **name** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmlstreamattribute.html#name

        **QStringRef QXmlStreamAttribute::name() const**

        Returns the attribute's local name.
        """
        ...

    def namespaceUri(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmlstreamattribute.html#namespaceUri

        **QStringRef QXmlStreamAttribute::namespaceUri() const**

        Returns the attribute's resolved namespaceUri, or an empty string
        reference if the attribute does not have a defined namespace.
        """
        ...
