"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import sip


class QVersionNumber(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qversionnumber.html

    **Detailed Description**

    **QVersionNumber**  version(1, 2, 3);  // 1.2.3
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#QVersionNumber

        **QVersionNumber::QVersionNumber()**

        Produces a null version.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    def __init__(self, seg: typing.Iterable[int]) -> None:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#QVersionNumber-1

        **QVersionNumber::QVersionNumber(const QVector<int> & seg )**

        Constructs a version number from the list of numbers contained in
        **seg**.
        """
        ...

    @typing.overload
    def __init__(self, maj: int) -> None:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#QVersionNumber-2

        **QVersionNumber::QVersionNumber(QVector<int> && seg )**

        Move-constructs a version number from the list of numbers contained in
        **seg**.

        This constructor is only enabled if the compiler supports C++11 move
        semantics.
        """
        ...

    @typing.overload
    def __init__(self, maj: int, min: int) -> None:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#QVersionNumber-3

        **QVersionNumber::QVersionNumber(std::initializer_list<int> args )**

        Construct a version number from the std::initializer_list specified by
        **args**.

        This constructor is only enabled if the compiler supports C++11
        initializer lists.
        """
        ...

    @typing.overload
    def __init__(self, maj: int, min: int, mic: int) -> None:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#QVersionNumber-4

        **QVersionNumber::QVersionNumber(int maj )**

        Constructs a QVersionNumber consisting of just the major version number
        **maj**.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QVersionNumber") -> None:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#QVersionNumber-5

        **QVersionNumber::QVersionNumber(int maj , int min )**

        Constructs a QVersionNumber consisting of the major and minor version
        numbers **maj** and **min** , respectively.
        """
        ...

    def __hash__(self) -> int:
        ...

    @staticmethod
    def fromString(string: str) -> typing.Tuple["QVersionNumber", int]:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#fromString

        **[static] QVersionNumber QVersionNumber::fromString(const QString &
        string , int * suffixIndex = nullptr)**

        Constructs a **QVersionNumber**  from a specially formatted **string**
        of non-negative decimal numbers delimited by a period (`.`).

        Once the numerical segments have been parsed, the remainder of the
        string is considered to be the suffix string. The start index of that
        string will be stored in **suffixIndex** if it is not null.

        **QString**  string("5.4.0-alpha");
            int suffixIndex;
        **QVersionNumber**  version = **QVersionNumber** ::fromString(string,
        &suffixIndex);
            // version is 5.4.0
            // suffixIndex is 5

        **See also** **isNull** ().
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#toString

        **QString QVersionNumber::toString() const**

        Returns a string with all of the segments delimited by a period (`.`).

        **See also** **majorVersion** (), **minorVersion** (), **microVersion**
        (), and **segments** ().
        """
        ...

    @staticmethod
    def commonPrefix(v1: "QVersionNumber", v2: "QVersionNumber") -> "QVersionNumber":
        """
        https://doc.qt.io/qt-5/qversionnumber.html#commonPrefix

        **[static] QVersionNumber QVersionNumber::commonPrefix(const
        QVersionNumber & v1 , const QVersionNumber & v2 )**

        **QVersionNumber**  QVersionNumber::commonPrefix(const
        **QVersionNumber**  &v1, const **QVersionNumber**  &v2)

        Returns a version number that is a parent version of both **v1** and
        **v2**.

        **See also** **isPrefixOf** ().
        """
        ...

    @staticmethod
    def compare(v1: "QVersionNumber", v2: "QVersionNumber") -> int:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#compare

        **[static] int QVersionNumber::compare(const QVersionNumber & v1 , const
        QVersionNumber & v2 )**

        Compares **v1** with **v2** and returns an integer less than, equal to,
        or greater than zero, depending on whether **v1** is less than, equal
        to, or greater than **v2** , respectively.

        Comparisons are performed by comparing the segments of **v1** and **v2**
        starting at index 0 and working towards the end of the longer list.

        **QVersionNumber**  v1(1, 2);
            **QVersionNumber**  v2(1, 2, 0);
        int compare = **QVersionNumber** ::compare(v1, v2); // compare == -1
        """
        ...

    def isPrefixOf(self, other: "QVersionNumber") -> bool:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#isPrefixOf

        **bool QVersionNumber::isPrefixOf(const QVersionNumber & other ) const**

        Returns `true` if the current version number is contained in the
        **other** version number, otherwise returns `false`.

        **QVersionNumber**  v1(5, 3);
            **QVersionNumber**  v2(5, 3, 1);
        bool value = v1.isPrefixOf(v2); // true

        **See also** **commonPrefix** ().
        """
        ...

    def segmentCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#segmentCount

        **int QVersionNumber::segmentCount() const**

        Returns the number of integers stored in **segments** ().

        **See also** **segments** ().
        """
        ...

    def segmentAt(self, index: int) -> int:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#segmentAt

        **int QVersionNumber::segmentAt(int index ) const**

        Returns the segement value at **index**. If the index does not exist,
        returns 0.

        **See also** **segments** () and **segmentCount** ().
        """
        ...

    def segments(self) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#segments

        **QVector<int> QVersionNumber::segments() const**

        Returns all of the numerical segments.

        **See also** **majorVersion** (), **minorVersion** (), and
        **microVersion** ().
        """
        ...

    def normalized(self) -> "QVersionNumber":
        """
        https://doc.qt.io/qt-5/qversionnumber.html#normalized

        **QVersionNumber QVersionNumber::normalized() const**

        Returns an equivalent version number but with all trailing zeros
        removed.

        To check if two numbers are equivalent, use normalized() on both version
        numbers before performing the compare.

        **QVersionNumber**  v1(5, 4);
            **QVersionNumber**  v2(5, 4, 0);
        bool equivalent = v1.normalized() == v2.normalized();
            bool equal =
        v1 == v2;
            // equivalent is true
            // equal is false
        """
        ...

    def microVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#microVersion

        **int QVersionNumber::microVersion() const**

        Returns the micro version number, that is, the third segment. This
        function is equivalent to **segmentAt** (2). If this **QVersionNumber**
        object does not contain a micro number, this function returns 0.

        **See also** **isNull** () and **segmentAt** ().
        """
        ...

    def minorVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#minorVersion

        **int QVersionNumber::minorVersion() const**

        Returns the minor version number, that is, the second segment. This
        function is equivalent to **segmentAt** (1). If this **QVersionNumber**
        object does not contain a minor number, this function returns 0.

        **See also** **isNull** () and **segmentAt** ().
        """
        ...

    def majorVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#majorVersion

        **int QVersionNumber::majorVersion() const**

        Returns the major version number, that is, the first segment. This
        function is equivalent to **segmentAt** (0). If this **QVersionNumber**
        object is null, this function returns 0.

        **See also** **isNull** () and **segmentAt** ().
        """
        ...

    def isNormalized(self) -> bool:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#isNormalized

        **bool QVersionNumber::isNormalized() const**

        Returns `true` if the version number does not contain any trailing
        zeros, otherwise returns `false`.

        **See also** **normalized** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qversionnumber.html#isNull

        **bool QVersionNumber::isNull() const**

        Returns `true` if there are zero numerical segments, otherwise returns
        `false`.

        **See also** **segments** ().
        """
        ...
