"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtCore import *
from PyQt5 import sip


class QTextCodec(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qtextcodec.html

    **Detailed Description**

    Qt uses Unicode to store, draw and manipulate strings. In many situations
    you may wish to deal with data that uses a different encoding. For example,
    most Japanese documents are still stored in Shift-JIS or ISO 2022-JP, while
    Russian users often have their documents in KOI8-R or Windows-1251.

    Qt provides a set of QTextCodec classes to help with converting non-Unicode
    formats to and from Unicode. You can also create your own codec classes.

    The supported encodings are:

    * **Big5**
      * **Big5-HKSCS**
      * CP949
      * **EUC-JP**
      * **EUC-KR**
    * **GB18030**
      * HP-ROMAN8
      * IBM 850
      * IBM 866
      * IBM 874
      * **ISO
    2022-JP**
      * ISO 8859-1 to 10
      * ISO 8859-13 to 16
      * Iscii-Bng, Dev,
    Gjr, Knd, Mlm, Ori, Pnj, Tlg, and Tml
      * KOI8-R
      * KOI8-U
      * Macintosh
    * **Shift-JIS**
      * TIS-620
      * **TSCII**
      * UTF-8
      * UTF-16
      *
    UTF-16BE
      * UTF-16LE
      * UTF-32
      * UTF-32BE
      * UTF-32LE
      * Windows-1250
    to 1258

    If Qt is compiled with ICU support enabled, most codecs supported by ICU
    will also be available to the application.

    **QTextCodec** s can be used as follows to convert some locally encoded
    string to Unicode. Suppose you have some string encoded in Russian KOI8-R
    encoding, and want to convert it to Unicode. The simple way to do it is like
    this:

    **QByteArray**  encodedString = "...";
        QTextCodec *codec =
    QTextCodec::codecForName("KOI8-R");
        **QString**  string =
    codec->toUnicode(encodedString);

    After this, `string` holds the text converted to Unicode. Converting a
    string from Unicode to the local encoding is just as easy:

    **QString**  string = "...";
        QTextCodec *codec =
    QTextCodec::codecForName("KOI8-R");
        **QByteArray**  encodedString =
    codec->fromUnicode(string);

    To read or write files in various encodings, use **QTextStream**  and its
    **setCodec()**  function. See the **Codecs**  example for an application of
    QTextCodec to file I/O.

    Some care must be taken when trying to convert the data in chunks, for
    example, when receiving it over a network. In such cases it is possible that
    a multi-byte character will be split over two chunks. At best this might
    result in the loss of a character and at worst cause the entire conversion
    to fail.

    The approach to use in these situations is to create a **QTextDecoder**
    object for the codec and use this **QTextDecoder**  for the whole decoding
    process, as shown below:

    QTextCodec *codec = QTextCodec::codecForName("Shift-JIS");
    **QTextDecoder**  *decoder = codec->makeDecoder();

        **QString**
    string;
        while (new_data_available()) {
            **QByteArray**  chunk =
    get_new_data();
            string += decoder->toUnicode(chunk);
        }
    delete decoder;

    The **QTextDecoder**  object maintains state between chunks and therefore
    works correctly even if a multi-byte character is split between chunks.

    **Creating Your Own Codec Class**

    Support for new text encodings can be added to Qt by creating QTextCodec
    subclasses.

    The pure virtual functions describe the encoder to the system and the coder
    is used as required in the different text file formats supported by
    **QTextStream** , and under X11, for the locale-specific character input and
    output.

    To add support for another encoding to Qt, make a subclass of QTextCodec and
    implement the functions listed in the table below.

    FunctionDescription
    **name** ()Returns the official name for the encoding.
    If the encoding is listed in the **IANA character-sets encoding file** , the
    name should be the preferred MIME name for the encoding.
    **aliases**
    ()Returns a list of alternative names for the encoding. QTextCodec provides
    a default implementation that returns an empty list. For example,
    "ISO-8859-1" has "latin1", "CP819", "IBM819", and "iso-ir-100" as aliases.
    **mibEnum()** Return the MIB enum for the encoding if it is listed in the
    **IANA character-sets encoding file** .
    **convertToUnicode** ()Converts an
    8-bit character string to Unicode.
    **convertFromUnicode** ()Converts a
    Unicode string to an 8-bit character string.

    **See also** **QTextStream** , **QTextDecoder** , **QTextEncoder** , and
    **Text Codecs Example** .
    """

    class ConversionFlag(int):
        DefaultConversion: QTextCodec = ...
        ConvertInvalidToNull: QTextCodec = ...
        IgnoreHeader: QTextCodec = ...

    class ConversionFlags(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union["QTextCodec.ConversionFlags", "QTextCodec.ConversionFlag"],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QTextCodec.ConversionFlags") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QTextCodec.ConversionFlags":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class ConverterState(sip.simplewrapper):
        def __init__(
            self,
            flags: typing.Union[
                "QTextCodec.ConversionFlags", "QTextCodec.ConversionFlag"
            ] = ...,
        ) -> None:
            ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#QTextCodec-1

        **[protected] QTextCodec::QTextCodec()**

        Constructs a QTextCodec, and gives it the highest precedence. The
        QTextCodec should always be constructed on the heap (i.e. with `new`).
        Qt takes ownership and will delete it when the application terminates.
        """
        ...

    def convertFromUnicode(
        self, in_: str, state: "QTextCodec.ConverterState"
    ) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#convertFromUnicode

        **[pure virtual protected] QByteArray
        QTextCodec::convertFromUnicode(const QChar * input , int number ,
        QTextCodec::ConverterState * state ) const**

        **QTextCodec**  subclasses must reimplement this function.

        Converts the first **number** of characters from the **input** array
        from Unicode to the encoding of the subclass, and returns the result in
        a **QByteArray** .

        **state** can be `nullptr` in which case the conversion is stateless and
        default conversion rules should be used. If state is not 0, the codec
        should save the state after the conversion in **state** , and adjust the
        `remainingChars` and `invalidChars` members of the struct.
        """
        ...

    def convertToUnicode(self, in_: bytes, state: "QTextCodec.ConverterState") -> str:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#convertToUnicode

        **[pure virtual protected] QString QTextCodec::convertToUnicode(const
        char * chars , int len , QTextCodec::ConverterState * state ) const**

        **QTextCodec**  subclasses must reimplement this function.

        Converts the first **len** characters of **chars** from the encoding of
        the subclass to Unicode, and returns the result in a **QString** .

        **state** can be `nullptr`, in which case the conversion is stateless
        and default conversion rules should be used. If state is not 0, the
        codec should save the state after the conversion in **state** , and
        adjust the `remainingChars` and `invalidChars` members of the struct.
        """
        ...

    def mibEnum(self) -> int:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#mibEnum

        **[pure virtual] int QTextCodec::mibEnum() const**

        Subclasses of **QTextCodec**  must reimplement this function. It returns
        the MIBenum (see **IANA character-sets encoding file**  for more
        information). It is important that each **QTextCodec**  subclass returns
        the correct unique value for this function.
        """
        ...

    def aliases(self) -> typing.List[QByteArray]:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#aliases

        **[virtual] QList<QByteArray> QTextCodec::aliases() const**

        Subclasses can return a number of aliases for the codec in question.

        Standard aliases for codecs can be found in the **IANA character-sets
        encoding file** .
        """
        ...

    def name(self) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#name

        **[pure virtual] QByteArray QTextCodec::name() const**

        **QTextCodec**  subclasses must reimplement this function. It returns
        the name of the encoding supported by the subclass.

        If the codec is registered as a character set in the **IANA character-
        sets encoding file**  this method should return the preferred mime name
        for the codec if defined, otherwise its name.
        """
        ...

    def fromUnicode(self, uc: str) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#fromUnicode

        **QByteArray QTextCodec::fromUnicode(const QString & str ) const**

        Converts **str** from Unicode to the encoding of this codec, and returns
        the result in a **QByteArray** .
        """
        ...

    @typing.overload
    def toUnicode(self, a0: typing.Union[QByteArray, bytes, bytearray]) -> str:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#toUnicode

        **QString QTextCodec::toUnicode(const QByteArray & a ) const**

        Converts **a** from the encoding of this codec to Unicode, and returns
        the result in a **QString** .
        """
        ...

    @typing.overload
    def toUnicode(self, chars: bytes) -> str:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#toUnicode-1

        **QString QTextCodec::toUnicode(const char * chars ) const**

        This is an overloaded function.

        **chars** contains the source characters.
        """
        ...

    @typing.overload
    def toUnicode(
        self, in_: bytes, state: typing.Optional["QTextCodec.ConverterState"] = ...
    ) -> str:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#toUnicode-2

        **QString QTextCodec::toUnicode(const char * input , int size ,
        QTextCodec::ConverterState * state = nullptr) const**

        Converts the first **size** characters from the **input** from the
        encoding of this codec to Unicode, and returns the result in a
        **QString** .

        The **state** of the convertor used is updated.
        """
        ...

    def canEncode(self, a0: str) -> bool:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#canEncode

        **bool QTextCodec::canEncode(QChar ch ) const**

        Returns `true` if the Unicode character **ch** can be fully encoded with
        this codec; otherwise returns `false`.
        """
        ...

    def makeEncoder(
        self,
        flags: typing.Union[
            "QTextCodec.ConversionFlags", "QTextCodec.ConversionFlag"
        ] = ...,
    ) -> "QTextEncoder":
        """
        https://doc.qt.io/qt-5/qtextcodec.html#makeEncoder

        **QTextEncoder *QTextCodec::makeEncoder(QTextCodec::ConversionFlags
        flags = DefaultConversion) const**

        Creates a **QTextEncoder**  with a specified **flags** to encode chunks
        of Unicode data as `char *` data.

        The caller is responsible for deleting the returned object.

        This function was introduced in Qt 4.7.
        """
        ...

    def makeDecoder(
        self,
        flags: typing.Union[
            "QTextCodec.ConversionFlags", "QTextCodec.ConversionFlag"
        ] = ...,
    ) -> "QTextDecoder":
        """
        https://doc.qt.io/qt-5/qtextcodec.html#makeDecoder

        **QTextDecoder *QTextCodec::makeDecoder(QTextCodec::ConversionFlags
        flags = DefaultConversion) const**

        Creates a **QTextDecoder**  with a specified **flags** to decode chunks
        of `char *` data to create chunks of Unicode data.

        The caller is responsible for deleting the returned object.

        This function was introduced in Qt 4.7.
        """
        ...

    @staticmethod
    def setCodecForLocale(c: "QTextCodec") -> None:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#setCodecForLocale

        **[static] void QTextCodec::setCodecForLocale(QTextCodec * c )**

        Set the codec to **c** ; this will be returned by **codecForLocale** ().
        If **c** is `nullptr`, the codec is reset to the default.

        This might be needed for some applications that want to use their own
        mechanism for setting the locale.

        **Warning:** This function is not **reentrant** .

        **See also** **codecForLocale** ().
        """
        ...

    @staticmethod
    def codecForLocale() -> "QTextCodec":
        """
        https://doc.qt.io/qt-5/qtextcodec.html#codecForLocale

        **[static] QTextCodec *QTextCodec::codecForLocale()**

        Returns a pointer to the codec most suitable for this locale.

        The codec will be retrieved from ICU where that backend is in use,
        otherwise it may be obtained from an OS-specific API. In the latter
        case, the codec's name may be "System".

        **Note:** This function is **thread-safe** .

        **See also** **setCodecForLocale** ().
        """
        ...

    @staticmethod
    def availableMibs() -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#availableMibs

        **[static] QList<int> QTextCodec::availableMibs()**

        Returns the list of MIBs for all available codecs. Call
        **QTextCodec::codecForMib** () to obtain the **QTextCodec**  for the
        MIB.

        **Note:** This function is **thread-safe** .

        **See also** **availableCodecs** () and **mibEnum** ().
        """
        ...

    @staticmethod
    def availableCodecs() -> typing.List[QByteArray]:
        """
        https://doc.qt.io/qt-5/qtextcodec.html#availableCodecs

        **[static] QList<QByteArray> QTextCodec::availableCodecs()**

        Returns the list of all available codecs, by name. Call
        **QTextCodec::codecForName** () to obtain the **QTextCodec**  for the
        name.

        The list may contain many mentions of the same codec if the codec has
        aliases.

        **Note:** This function is **thread-safe** .

        **See also** **availableMibs** (), **name** (), and **aliases** ().
        """
        ...

    @typing.overload
    @staticmethod
    def codecForUtfText(ba: typing.Union[QByteArray, bytes, bytearray]) -> "QTextCodec":
        """
        https://doc.qt.io/qt-5/qtextcodec.html#codecForUtfText

        **[static] QTextCodec *QTextCodec::codecForUtfText(const QByteArray & ba
        , QTextCodec * defaultCodec )**

        Tries to detect the encoding of the provided snippet **ba** by using the
        BOM (Byte Order Mark) and returns a **QTextCodec**  instance that is
        capable of decoding the text to unicode. This function can detect one of
        the following codecs:

        * UTF-32 Little Endian
          * UTF-32 Big Endian
          * UTF-16 Little Endian
        * UTF-16 Big Endian
          * UTF-8

        If the codec cannot be detected from the content provided,
        **defaultCodec** is returned.

        This function was introduced in Qt 4.6.

        **See also** **codecForHtml** ().
        """
        ...

    @typing.overload
    @staticmethod
    def codecForUtfText(
        ba: typing.Union[QByteArray, bytes, bytearray], defaultCodec: "QTextCodec"
    ) -> "QTextCodec":
        """
        https://doc.qt.io/qt-5/qtextcodec.html#codecForUtfText-1

        **[static] QTextCodec *QTextCodec::codecForUtfText(const QByteArray & ba
        )**

        This is an overloaded function.

        Tries to detect the encoding of the provided snippet **ba** by using the
        BOM (Byte Order Mark) and returns a **QTextCodec**  instance that is
        capable of decoding the text to unicode. This function can detect one of
        the following codecs:

        * UTF-32 Little Endian
          * UTF-32 Big Endian
          * UTF-16 Little Endian
        * UTF-16 Big Endian
          * UTF-8

        If the codec cannot be detected from the content provided, this overload
        returns a Latin-1 **QTextCodec** .

        **See also** **codecForHtml** ().
        """
        ...

    @typing.overload
    @staticmethod
    def codecForHtml(ba: typing.Union[QByteArray, bytes, bytearray]) -> "QTextCodec":
        """
        https://doc.qt.io/qt-5/qtextcodec.html#codecForHtml

        **[static] QTextCodec *QTextCodec::codecForHtml(const QByteArray & ba ,
        QTextCodec * defaultCodec )**

        Tries to detect the encoding of the provided snippet of HTML in the
        given byte array, **ba** , by checking the BOM (Byte Order Mark) and the
        content-type meta header and returns a **QTextCodec**  instance that is
        capable of decoding the html to unicode. If the codec cannot be detected
        from the content provided, **defaultCodec** is returned.

        This function was introduced in Qt 4.4.

        **See also** **codecForUtfText** ().
        """
        ...

    @typing.overload
    @staticmethod
    def codecForHtml(
        ba: typing.Union[QByteArray, bytes, bytearray], defaultCodec: "QTextCodec"
    ) -> "QTextCodec":
        """
        https://doc.qt.io/qt-5/qtextcodec.html#codecForHtml-1

        **[static] QTextCodec *QTextCodec::codecForHtml(const QByteArray & ba
        )**

        This is an overloaded function.

        Tries to detect the encoding of the provided snippet of HTML in the
        given byte array, **ba** , by checking the BOM (Byte Order Mark) and the
        content-type meta header and returns a **QTextCodec**  instance that is
        capable of decoding the html to unicode. If the codec cannot be
        detected, this overload returns a Latin-1 **QTextCodec** .
        """
        ...

    @staticmethod
    def codecForMib(mib: int) -> "QTextCodec":
        """
        https://doc.qt.io/qt-5/qtextcodec.html#codecForMib

        **[static] QTextCodec *QTextCodec::codecForMib(int mib )**

        Returns the **QTextCodec**  which matches the **MIBenum**  **mib**.

        **Note:** This function is **thread-safe** .
        """
        ...

    @typing.overload
    @staticmethod
    def codecForName(name: typing.Union[QByteArray, bytes, bytearray]) -> "QTextCodec":
        """
        https://doc.qt.io/qt-5/qtextcodec.html#codecForName

        **[static] QTextCodec *QTextCodec::codecForName(const QByteArray & name
        )**

        Searches all installed **QTextCodec**  objects and returns the one which
        best matches **name** ; the match is case-insensitive. Returns 0 if no
        codec matching the name **name** could be found.

        **Note:** This function is **thread-safe** .
        """
        ...

    @typing.overload
    @staticmethod
    def codecForName(name: str) -> "QTextCodec":
        """
        https://doc.qt.io/qt-5/qtextcodec.html#codecForName-1

        **[static] QTextCodec *QTextCodec::codecForName(const char * name )**

        Searches all installed **QTextCodec**  objects and returns the one which
        best matches **name** ; the match is case-insensitive. Returns 0 if no
        codec matching the name **name** could be found.
        """
        ...
