"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtCore import *


class QStringListModel(QAbstractListModel):
    """
    https://doc.qt.io/qt-5/qstringlistmodel.html

    **Detailed Description**

    QStringListModel is an editable model that can be used for simple cases
    where you need to display a number of strings in a view widget, such as a
    **QListView**  or a **QComboBox** .

    The model provides all the standard functions of an editable model,
    representing the data in the string list as a model with one column and a
    number of rows equal to the number of items in the list.

    Model indexes corresponding to items are obtained with the **index()**
    function, and item flags are obtained with **flags** (). Item data is read
    with the **data** () function and written with **setData** (). The number of
    rows (and number of items in the string list) can be found with the
    **rowCount** () function.

    The model can be constructed with an existing string list, or strings can be
    set later with the **setStringList** () convenience function. Strings can
    also be inserted in the usual way with the **insertRows** () function, and
    removed with **removeRows** (). The contents of the string list can be
    retrieved with the **stringList** () convenience function.

    An example usage of QStringListModel:

    **QStringListModel**  *model = new **QStringListModel** ();
    **QStringList**  list;
            list << "a" << "b" << "c";
    model->setStringList(list);

    **See also** **QAbstractListModel** , **QAbstractItemModel** , and **Model
    Classes** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#QStringListModel

        **QStringListModel::QStringListModel(QObject * parent = nullptr)**

        Constructs a string list model with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, strings: typing.Iterable[str], parent: typing.Optional[QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#QStringListModel-1

        **QStringListModel::QStringListModel(const QStringList & strings ,
        QObject * parent = nullptr)**

        Constructs a string list model containing the specified **strings** with
        the given **parent**.
        """
        ...

    def setItemData(
        self, index: QModelIndex, roles: typing.Dict[int, typing.Any]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#setItemData

        **[override virtual] bool QStringListModel::setItemData(const
        QModelIndex & index , const QMap<int, QVariant> & roles )**

        Reimplements: **QAbstractItemModel::setItemData** (const QModelIndex
        &index, const QMap<int, QVariant> &roles).

        If **roles** contains both **Qt::DisplayRole**  and **Qt::EditRole** ,
        the latter will take precedence

        This function was introduced in Qt 5.13.

        **See also** **itemData** ().
        """
        ...

    def itemData(self, index: QModelIndex) -> typing.Dict[int, typing.Any]:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#itemData

        **[override virtual] QMap<int, QVariant>
        QStringListModel::itemData(const QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::itemData** (const QModelIndex
        &index) const.

        This function was introduced in Qt 5.13.

        **See also** **setItemData** ().
        """
        ...

    def moveRows(
        self,
        sourceParent: QModelIndex,
        sourceRow: int,
        count: int,
        destinationParent: QModelIndex,
        destinationChild: int,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#moveRows

        **[override virtual] bool QStringListModel::moveRows(const QModelIndex &
        sourceParent , int sourceRow , int count , const QModelIndex &
        destinationParent , int destinationChild )**

        Reimplements: **QAbstractItemModel::moveRows** (const QModelIndex
        &sourceParent, int sourceRow, int count, const QModelIndex
        &destinationParent, int destinationChild).

        This function was introduced in Qt 5.13.
        """
        ...

    def sibling(self, row: int, column: int, idx: QModelIndex) -> QModelIndex:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#sibling

        **[override virtual] QModelIndex QStringListModel::sibling(int row , int
        column , const QModelIndex & idx ) const**

        Reimplements: **QAbstractListModel::sibling** (int row, int column,
        const QModelIndex &idx) const.
        """
        ...

    def supportedDropActions(self) -> Qt.DropActions:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#supportedDropActions

        **[override virtual] Qt::DropActions
        QStringListModel::supportedDropActions() const**

        Reimplements: **QAbstractItemModel::supportedDropActions** () const.
        """
        ...

    def sort(self, column: int, order: Qt.SortOrder = ...) -> None:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#sort

        **[override virtual] void QStringListModel::sort(int column ,
        Qt::SortOrder order = Qt::AscendingOrder)**

        Reimplements: **QAbstractItemModel::sort** (int column, Qt::SortOrder
        order).
        """
        ...

    def setStringList(self, strings: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#setStringList

        **void QStringListModel::setStringList(const QStringList & strings )**

        Sets the model's internal string list to **strings**. The model will
        notify any attached views that its underlying data has changed.

        **See also** **stringList** () and **dataChanged** ().
        """
        ...

    def stringList(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#stringList

        **QStringList QStringListModel::stringList() const**

        Returns the string list used by the model to store data.

        **See also** **setStringList** ().
        """
        ...

    def removeRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#removeRows

        **[override virtual] bool QStringListModel::removeRows(int row , int
        count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::removeRows** (int row, int count,
        const QModelIndex &parent).

        Removes **count** rows from the model, beginning at the given **row**.

        The **parent** index of the rows is optional and is only used for
        consistency with **QAbstractItemModel** . By default, a null index is
        specified, indicating that the rows are removed in the top level of the
        model.

        Returns `true` if the row removal was successful.

        **See also** **QAbstractItemModel::removeRows** ().
        """
        ...

    def insertRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#insertRows

        **[override virtual] bool QStringListModel::insertRows(int row , int
        count , const QModelIndex & parent = QModelIndex())**

        Reimplements: **QAbstractItemModel::insertRows** (int row, int count,
        const QModelIndex &parent).

        Inserts **count** rows into the model, beginning at the given **row**.

        The **parent** index of the rows is optional and is only used for
        consistency with **QAbstractItemModel** . By default, a null index is
        specified, indicating that the rows are inserted in the top level of the
        model.

        Returns `true` if the insertion was successful.

        **See also** **QAbstractItemModel::insertRows** ().
        """
        ...

    def flags(self, index: QModelIndex) -> Qt.ItemFlags:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#flags

        **[override virtual] Qt::ItemFlags QStringListModel::flags(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractListModel::flags** (const QModelIndex &index)
        const.

        Returns the flags for the item with the given **index**.

        Valid items are enabled, selectable, editable, drag enabled and drop
        enabled.

        **See also** **QAbstractItemModel::flags** ().
        """
        ...

    def setData(self, index: QModelIndex, value: typing.Any, role: int = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#setData

        **[override virtual] bool QStringListModel::setData(const QModelIndex &
        index , const QVariant & value , int role = Qt::EditRole)**

        Reimplements: **QAbstractItemModel::setData** (const QModelIndex &index,
        const QVariant &value, int role).

        Sets the data for the specified **role** in the item with the given
        **index** in the model, to the provided **value**.

        The **dataChanged** () signal is emitted if the item is changed. Returns
        `true` after emitting the **dataChanged** () signal.

        **See also** **Qt::ItemDataRole**  and **data** ().
        """
        ...

    def data(self, index: QModelIndex, role: int) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#data

        **[override virtual] QVariant QStringListModel::data(const QModelIndex &
        index , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::data** (const QModelIndex &index,
        int role) const.

        Returns data for the specified **role** , from the item with the given
        **index**.

        If the view requests an invalid index, an invalid variant is returned.

        **See also** **setData** ().
        """
        ...

    def rowCount(self, parent: QModelIndex = ...) -> int:
        """
        https://doc.qt.io/qt-5/qstringlistmodel.html#rowCount

        **[override virtual] int QStringListModel::rowCount(const QModelIndex &
        parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::rowCount** (const QModelIndex
        &parent) const.

        Returns the number of rows in the model. This value corresponds to the
        number of items in the model's internal string list.

        The optional **parent** argument is in most models used to specify the
        parent of the rows to be counted. Because this is a list if a valid
        parent is specified, the result will always be 0.

        **See also** **insertRows** (), **removeRows** (), and
        **QAbstractItemModel::rowCount** ().
        """
        ...
