"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QStorageInfo(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qstorageinfo.html

    **Detailed Description**

    Allows retrieving information about the volume's space, its mount point,
    label, and filesystem name.

    You can create an instance of QStorageInfo by passing the path to the
    volume's mount point as a constructor parameter, or you can set it using the
    **setPath** () method. The static **mountedVolumes** () method can be used
    to get the list of all mounted filesystems.

    QStorageInfo always caches the retrieved information, but you can call
    **refresh** () to invalidate the cache.

    The following example retrieves the most common information about the root
    volume of the system, and prints information about it.

    **QStorageInfo**  storage = **QStorageInfo** ::root();
    **qDebug** () << storage.rootPath();
            if (storage.isReadOnly())
    **qDebug** () << "isReadOnly:" << storage.isReadOnly();
    **qDebug** () << "name:" << storage.name();
            **qDebug** () <<
    "fileSystemType:" << storage.fileSystemType();
            **qDebug** () <<
    "size:" << storage.bytesTotal()/1000/1000 << "MB";
            **qDebug** () <<
    "availableSize:" << storage.bytesAvailable()/1000/1000 << "MB";
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#QStorageInfo

        **QStorageInfo::QStorageInfo()**

        Constructs an empty QStorageInfo object.

        Objects created with the default constructor will be invalid and
        therefore not ready for use.

        **See also** **setPath** (), **isReady** (), and **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, path: str) -> None:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#QStorageInfo-1

        **QStorageInfo::QStorageInfo(const QString & path )**

        Constructs a new QStorageInfo object that gives information about the
        volume mounted at **path**.

        If you pass a directory or file, the QStorageInfo object will refer to
        the volume where this directory or file is located. You can check if the
        created object is correct using the **isValid** () method.

        The following example shows how to get the volume on which the
        application is located. It is recommended to always check that the
        volume is ready and valid.

        **QStorageInfo**  storage(**qApp** ->applicationDirPath());
                if
        (storage.isValid() && storage.isReady()) {
                    // ...
                }

        **See also** **setPath** ().
        """
        ...

    @typing.overload
    def __init__(self, dir: QDir) -> None:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#QStorageInfo-2

        **QStorageInfo::QStorageInfo(const QDir & dir )**

        Constructs a new QStorageInfo object that gives information about the
        volume containing the **dir** folder.
        """
        ...

    @typing.overload
    def __init__(self, other: "QStorageInfo") -> None:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#QStorageInfo-3

        **QStorageInfo::QStorageInfo(const QStorageInfo & other )**

        Constructs a new QStorageInfo object that is a copy of the **other**
        QStorageInfo object.
        """
        ...

    def subvolume(self) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#subvolume

        **QByteArray QStorageInfo::subvolume() const**

        Returns the subvolume name for this volume.

        Some filesystem types allow multiple subvolumes inside one device, which
        may be mounted in different paths. If the subvolume could be detected,
        it is returned here. The format of the subvolume name is specific to
        each filesystem type.

        If this volume was not mounted from a subvolume of a larger filesystem
        or if the subvolume could not be detected, this function returns an
        empty byte array.

        This function was introduced in Qt 5.9.

        **See also** **device** ().
        """
        ...

    def blockSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#blockSize

        **int QStorageInfo::blockSize() const**

        Returns the optimal transfer block size for this filesystem.

        Returns -1 if **QStorageInfo**  could not determine the size or if the
        **QStorageInfo**  object is not valid.

        This function was introduced in Qt 5.6.
        """
        ...

    def isRoot(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#isRoot

        **bool QStorageInfo::isRoot() const**

        Returns true if this **QStorageInfo**  represents the system root
        volume; false otherwise.

        On Unix filesystems, the root volume is a volume mounted on `/`. On
        Windows, the root volume is the volume where the OS is installed.

        **See also** **root** ().
        """
        ...

    @staticmethod
    def root() -> "QStorageInfo":
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#root

        **[static] QStorageInfo QStorageInfo::root()**

        Returns a **QStorageInfo**  object that represents the system root
        volume.

        On Unix systems this call returns the root ('/') volume; in Windows the
        volume where the operating system is installed.

        **See also** **isRoot** ().
        """
        ...

    @staticmethod
    def mountedVolumes() -> typing.List["QStorageInfo"]:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#mountedVolumes

        **[static] QList<QStorageInfo> QStorageInfo::mountedVolumes()**

        Returns the list of **QStorageInfo**  objects that corresponds to the
        list of currently mounted filesystems.

        On Windows, this returns the drives visible in the **My Computer**
        folder. On Unix operating systems, it returns the list of all mounted
        filesystems (except for pseudo filesystems).

        Returns all currently mounted filesystems by default.

        The example shows how to retrieve all available filesystems, skipping
        read-only ones.

        foreach (const **QStorageInfo**  &storage, **QStorageInfo**
        ::mountedVolumes()) {
                    if (storage.isValid() &&
        storage.isReady()) {
                        if (!storage.isReadOnly()) {
        // ...
                        }
                    }
                }

        **See also** **root** ().
        """
        ...

    def refresh(self) -> None:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#refresh

        **void QStorageInfo::refresh()**

        Resets **QStorageInfo** 's internal cache.

        **QStorageInfo**  caches information about storage to speed up
        performance. **QStorageInfo**  retrieves information during object
        construction and/or when calling the **setPath** () method. You have to
        manually reset the cache by calling this function to update storage
        information.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#isValid

        **bool QStorageInfo::isValid() const**

        Returns true if the **QStorageInfo**  specified by **rootPath**  exists
        and is mounted correctly.

        **See also** **isReady** ().
        """
        ...

    def isReady(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#isReady

        **bool QStorageInfo::isReady() const**

        Returns true if the current filesystem is ready to work; false
        otherwise. For example, false is returned if the CD volume is not
        inserted.

        Note that **fileSystemType** (), **name** (), **bytesTotal** (),
        **bytesFree** (), and **bytesAvailable** () will return invalid data
        until the volume is ready.

        **See also** **isValid** ().
        """
        ...

    def isReadOnly(self) -> bool:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#isReadOnly

        **bool QStorageInfo::isReadOnly() const**

        Returns true if the current filesystem is protected from writing; false
        otherwise.
        """
        ...

    def bytesAvailable(self) -> int:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#bytesAvailable

        **qint64 QStorageInfo::bytesAvailable() const**

        Returns the size (in bytes) available for the current user. It returns
        the total size available if the user is the root user or a system
        administrator.

        This size can be less than or equal to the free size returned by
        **bytesFree** () function.

        Returns -1 if **QStorageInfo**  object is not valid.

        **See also** **bytesTotal** () and **bytesFree** ().
        """
        ...

    def bytesFree(self) -> int:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#bytesFree

        **qint64 QStorageInfo::bytesFree() const**

        Returns the number of free bytes in a volume. Note that if there are
        quotas on the filesystem, this value can be larger than the value
        returned by **bytesAvailable** ().

        Returns -1 if **QStorageInfo**  object is not valid.

        **See also** **bytesTotal** () and **bytesAvailable** ().
        """
        ...

    def bytesTotal(self) -> int:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#bytesTotal

        **qint64 QStorageInfo::bytesTotal() const**

        Returns the total volume size in bytes.

        Returns -1 if **QStorageInfo**  object is not valid.

        **See also** **bytesFree** () and **bytesAvailable** ().
        """
        ...

    def displayName(self) -> str:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#displayName

        **QString QStorageInfo::displayName() const**

        Returns the volume's name, if available, or the root path if not.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#name

        **QString QStorageInfo::name() const**

        Returns the human-readable name of a filesystem, usually called `label`.

        Not all filesystems support this feature. In this case, the value
        returned by this method could be empty. An empty string is returned if
        the file system does not support labels, or if no label is set.

        On Linux, retrieving the volume's label requires `udev` to be present in
        the system.

        **See also** **fileSystemType** ().
        """
        ...

    def fileSystemType(self) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#fileSystemType

        **QByteArray QStorageInfo::fileSystemType() const**

        Returns the type name of the filesystem.

        This is a platform-dependent function, and filesystem names can vary
        between different operating systems. For example, on Windows filesystems
        they can be named `NTFS`, and on Linux they can be named `ntfs-3g` or
        `fuseblk`.

        **See also** **name** ().
        """
        ...

    def device(self) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#device

        **QByteArray QStorageInfo::device() const**

        Returns the device for this volume.

        For example, on Unix filesystems (including macOS), this returns the
        devpath like `/dev/sda0` for local storages. On Windows, it returns the
        UNC path starting with `\\\\\\\\?\\\\` for local storages (in other words, the
        volume GUID).

        **See also** **rootPath** () and **subvolume** ().
        """
        ...

    def rootPath(self) -> str:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#rootPath

        **QString QStorageInfo::rootPath() const**

        Returns the mount point of the filesystem this **QStorageInfo**  object
        represents.

        On Windows, it returns the volume letter in case the volume is not
        mounted to a directory.

        Note that the value returned by rootPath() is the real mount point of a
        volume, and may not be equal to the value passed to the constructor or
        **setPath** () method. For example, if you have only the root volume in
        the system, and pass '/directory' to **setPath** (), then this method
        will return '/'.

        **See also** **setPath** () and **device** ().
        """
        ...

    def setPath(self, path: str) -> None:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#setPath

        **void QStorageInfo::setPath(const QString & path )**

        Sets this **QStorageInfo**  object to the filesystem mounted where
        **path** is located.

        **path** can either be a root path of the filesystem, a directory, or a
        file within that filesystem.

        **See also** **rootPath** ().
        """
        ...

    def swap(self, other: "QStorageInfo") -> None:
        """
        https://doc.qt.io/qt-5/qstorageinfo.html#swap

        **void QStorageInfo::swap(QStorageInfo & other )**

        Swaps this volume info with **other**. This function is very fast and
        never fails.
        """
        ...
