"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtCore import *


class QSharedMemory(QObject):
    """
    https://doc.qt.io/qt-5/qsharedmemory.html

    **Detailed Description**

    QSharedMemory provides access to a shared memory segment by multiple threads
    and processes. It also provides a way for a single thread or process to lock
    the memory for exclusive access.

    When using this class, be aware of the following platform differences:

    * Windows: QSharedMemory does not "own" the shared memory segment. When all
    threads or processes that have an instance of QSharedMemory attached to a
    particular shared memory segment have either destroyed their instance of
    QSharedMemory or exited, the Windows kernel releases the shared memory
    segment automatically.
      * Unix: QSharedMemory "owns" the shared memory
    segment. When the last thread or process that has an instance of
    QSharedMemory attached to a particular shared memory segment detaches from
    the segment by destroying its instance of QSharedMemory, the Unix kernel
    release the shared memory segment. But if that last thread or process
    crashes without running the QSharedMemory destructor, the shared memory
    segment survives the crash.
      * HP-UX: Only one attach to a shared memory
    segment is allowed per process. This means that QSharedMemory should not be
    used across multiple threads in the same process in HP-UX.

    Remember to lock the shared memory with **lock** () before reading from or
    writing to the shared memory, and remember to release the lock with
    **unlock** () after you are done.

    QSharedMemory automatically destroys the shared memory segment when the last
    instance of QSharedMemory is detached from the segment, and no references to
    the segment remain.

    **Warning:** QSharedMemory changes the key in a Qt-specific way, unless
    otherwise specified. Interoperation with non-Qt applications is achieved by
    first creating a default shared memory with QSharedMemory() and then setting
    a native key with **setNativeKey** (). When using native keys, shared memory
    is not protected against multiple accesses on it (for example, unable to
    **lock** ()) and a user-defined mechanism should be used to achieve such
    protection.
    """

    class SharedMemoryError(int):
        NoError: QSharedMemory = ...
        PermissionDenied: QSharedMemory = ...
        InvalidSize: QSharedMemory = ...
        KeyError: QSharedMemory = ...
        AlreadyExists: QSharedMemory = ...
        NotFound: QSharedMemory = ...
        LockError: QSharedMemory = ...
        OutOfResources: QSharedMemory = ...
        UnknownError: QSharedMemory = ...

    class AccessMode(int):
        ReadOnly: QSharedMemory = ...
        ReadWrite: QSharedMemory = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#QSharedMemory

        **QSharedMemory::QSharedMemory(const QString & key , QObject * parent =
        nullptr)**

        Constructs a shared memory object with the given **parent** and with its
        key set to **key**. Because its key is set, its **create** () and
        **attach** () functions can be called.

        **See also** **setKey** (), **create** (), and **attach** ().
        """
        ...

    @typing.overload
    def __init__(self, key: str, parent: typing.Optional[QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#QSharedMemory-1

        **QSharedMemory::QSharedMemory(QObject * parent = nullptr)**

        This function overloads QSharedMemory().

        Constructs a shared memory object with the given **parent**. The shared
        memory object's key is not set by the constructor, so the shared memory
        object does not have an underlying shared memory segment attached. The
        key must be set with **setKey** () or **setNativeKey** () before
        **create** () or **attach** () can be used.

        **See also** **setKey** ().
        """
        ...

    def nativeKey(self) -> str:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#nativeKey

        **QString QSharedMemory::nativeKey() const**

        Returns the native, platform specific, key for this shared memory
        object. The native key is the identifier used by the operating system to
        identify the shared memory segment.

        You can use the native key to access shared memory segments that have
        not been created by Qt, or to grant shared memory access to non-Qt
        applications.

        This function was introduced in Qt 4.8.

        **See also** **setKey** () and **setNativeKey** ().
        """
        ...

    def setNativeKey(self, key: str) -> None:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#setNativeKey

        **void QSharedMemory::setNativeKey(const QString & key )**

        Sets the native, platform specific, **key** for this shared memory
        object. If **key** is the same as the current native key, the function
        returns without doing anything. If all you want is to assign a key to a
        segment, you should call **setKey** () instead.

        You can call **nativeKey** () to retrieve the native key. If a native
        key has been assigned, calling **key** () will return a null string.

        If the shared memory object is attached to an underlying shared memory
        segment, it will **detach**  from it before setting the new key. This
        function does not do an **attach** ().

        The application will not be portable if you set a native key.

        This function was introduced in Qt 4.8.

        **See also** **nativeKey** (), **key** (), and **isAttached** ().
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#errorString

        **QString QSharedMemory::errorString() const**

        Returns a text description of the last error that occurred. If **error**
        () returns an **error value** , call this function to get a text string
        that describes the error.

        **See also** **error** ().
        """
        ...

    def error(self) -> "QSharedMemory.SharedMemoryError":
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#error

        **QSharedMemory::SharedMemoryError QSharedMemory::error() const**

        Returns a value indicating whether an error occurred, and, if so, which
        error it was.

        **See also** **errorString** ().
        """
        ...

    def unlock(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#unlock

        **bool QSharedMemory::unlock()**

        Releases the lock on the shared memory segment and returns `true`, if
        the lock is currently held by this process. If the segment is not
        locked, or if the lock is held by another process, nothing happens and
        false is returned.

        **See also** **lock** ().
        """
        ...

    def lock(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#lock

        **bool QSharedMemory::lock()**

        This is a semaphore that locks the shared memory segment for access by
        this process and returns `true`. If another process has locked the
        segment, this function blocks until the lock is released. Then it
        acquires the lock and returns `true`. If this function returns `false`,
        it means that you have ignored a false return from **create** () or
        **attach** (), that you have set the key with **setNativeKey** () or
        that **QSystemSemaphore::acquire** () failed due to an unknown system
        error.

        **See also** **unlock** (), **data** (), and
        **QSystemSemaphore::acquire** ().
        """
        ...

    def constData(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#constData

        **const void *QSharedMemory::constData() const**

        Returns a const pointer to the contents of the shared memory segment, if
        one is attached. Otherwise it returns null. Remember to lock the shared
        memory with **lock** () before reading from or writing to the shared
        memory, and remember to release the lock with **unlock** () after you
        are done.

        **See also** **attach** () and **create** ().
        """
        ...

    def data(self) -> PyQt5.sip.voidptr:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#data

        **void *QSharedMemory::data()**

        Returns a pointer to the contents of the shared memory segment, if one
        is attached. Otherwise it returns null. Remember to lock the shared
        memory with **lock** () before reading from or writing to the shared
        memory, and remember to release the lock with **unlock** () after you
        are done.

        **See also** **attach** ().
        """
        ...

    def detach(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#detach

        **bool QSharedMemory::detach()**

        Detaches the process from the shared memory segment. If this was the
        last process attached to the shared memory segment, then the shared
        memory segment is released by the system, i.e., the contents are
        destroyed. The function returns `true` if it detaches the shared memory
        segment. If it returns `false`, it usually means the segment either
        isn't attached, or it is locked by another process.

        **See also** **attach** () and **isAttached** ().
        """
        ...

    def isAttached(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#isAttached

        **bool QSharedMemory::isAttached() const**

        Returns `true` if this process is attached to the shared memory segment.

        **See also** **attach** () and **detach** ().
        """
        ...

    def attach(self, mode: "QSharedMemory.AccessMode" = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#attach

        **bool QSharedMemory::attach(QSharedMemory::AccessMode mode =
        ReadWrite)**

        Attempts to attach the process to the shared memory segment identified
        by the key that was passed to the constructor or to a call to **setKey**
        () or **setNativeKey** (). The access **mode** is **ReadWrite**  by
        default. It can also be **ReadOnly** . Returns `true` if the attach
        operation is successful. If false is returned, call **error** () to
        determine which error occurred. After attaching the shared memory
        segment, a pointer to the shared memory can be obtained by calling
        **data** ().

        **See also** **isAttached** (), **detach** (), and **create** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#size

        **int QSharedMemory::size() const**

        Returns the size of the attached shared memory segment. If no shared
        memory segment is attached, 0 is returned.

        **Note:** The size of the segment may be larger than the requested size
        that was passed to **create** ().

        **See also** **create** () and **attach** ().
        """
        ...

    def create(self, size: int, mode: "QSharedMemory.AccessMode" = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#create

        **bool QSharedMemory::create(int size , QSharedMemory::AccessMode mode =
        ReadWrite)**

        Creates a shared memory segment of **size** bytes with the key passed to
        the constructor, set with **setKey** () or set with **setNativeKey** (),
        then attaches to the new shared memory segment with the given access
        **mode** and returns `true`. If a shared memory segment identified by
        the key already exists, the attach operation is not performed and
        `false` is returned. When the return value is `false`, call **error** ()
        to determine which error occurred.

        **See also** **error** ().
        """
        ...

    def key(self) -> str:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#key

        **QString QSharedMemory::key() const**

        Returns the key assigned with **setKey** () to this shared memory, or a
        null key if no key has been assigned, or if the segment is using a
        **nativeKey** (). The key is the identifier used by Qt applications to
        identify the shared memory segment.

        You can find the native, platform specific, key used by the operating
        system by calling **nativeKey** ().

        **See also** **setKey** () and **setNativeKey** ().
        """
        ...

    def setKey(self, key: str) -> None:
        """
        https://doc.qt.io/qt-5/qsharedmemory.html#setKey

        **void QSharedMemory::setKey(const QString & key )**

        Sets the platform independent **key** for this shared memory object. If
        **key** is the same as the current key, the function returns without
        doing anything.

        You can call **key** () to retrieve the platform independent key.
        Internally, **QSharedMemory**  converts this key into a platform
        specific key. If you instead call **nativeKey** (), you will get the
        platform specific, converted key.

        If the shared memory object is attached to an underlying shared memory
        segment, it will **detach**  from it before setting the new key. This
        function does not do an **attach** ().

        **See also** **key** (), **nativeKey** (), and **isAttached** ().
        """
        ...
