"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
import PyQt5.sip


class QRunnable(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qrunnable.html

    **Detailed Description**

    The QRunnable class is an interface for representing a task or piece of code
    that needs to be executed, represented by your reimplementation of the
    **run** () function.

    You can use **QThreadPool**  to execute your code in a separate thread.
    **QThreadPool**  deletes the QRunnable automatically if **autoDelete** ()
    returns `true` (the default). Use **setAutoDelete** () to change the auto-
    deletion flag.

    **QThreadPool**  supports executing the same QRunnable more than once by
    calling **QThreadPool::tryStart** (this) from within the **run** ()
    function. If **autoDelete**  is enabled the QRunnable will be deleted when
    the last thread exits the run function. Calling **QThreadPool::start** ()
    multiple times with the same QRunnable when **autoDelete**  is enabled
    creates a race condition and is not recommended.

    **See also** **QThreadPool** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qrunnable.html#QRunnable

        **QRunnable::QRunnable()**

        Constructs a QRunnable. Auto-deletion is enabled by default.

        **See also** **autoDelete** () and **setAutoDelete** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QRunnable") -> None:
        """
        https://doc.qt.io/qt-5/qrunnable.html#QRunnable

        **QRunnable::QRunnable()**

        Constructs a QRunnable. Auto-deletion is enabled by default.

        **See also** **autoDelete** () and **setAutoDelete** ().
        """
        ...

    @staticmethod
    def create(functionToRun: typing.Callable[[], None]) -> "QRunnable":
        """
        https://doc.qt.io/qt-5/qrunnable.html#create

        **[static] QRunnable *QRunnable::create(std::function<void ()>
        functionToRun )**

        Creates a **QRunnable**  that calls **functionToRun** in **run** ().

        Auto-deletion is enabled by default.

        This function was introduced in Qt 5.15.

        **See also** **run** () and **autoDelete** ().
        """
        ...

    def setAutoDelete(self, _autoDelete: bool) -> None:
        """
        https://doc.qt.io/qt-5/qrunnable.html#setAutoDelete

        **void QRunnable::setAutoDelete(bool autoDelete )**

        Enables auto-deletion if **autoDelete** is true; otherwise auto-deletion
        is disabled.

        If auto-deletion is enabled, **QThreadPool**  will automatically delete
        this runnable after calling **run** (); otherwise, ownership remains
        with the application programmer.

        Note that this flag must be set before calling **QThreadPool::start**
        (). Calling this function after **QThreadPool::start** () results in
        undefined behavior.

        **See also** **autoDelete** () and **QThreadPool** .
        """
        ...

    def autoDelete(self) -> bool:
        """
        https://doc.qt.io/qt-5/qrunnable.html#autoDelete

        **bool QRunnable::autoDelete() const**

        Returns `true` is auto-deletion is enabled; false otherwise.

        If auto-deletion is enabled, **QThreadPool**  will automatically delete
        this runnable after calling **run** (); otherwise, ownership remains
        with the application programmer.

        **See also** **setAutoDelete** () and **QThreadPool** .
        """
        ...

    def run(self) -> None:
        """
        https://doc.qt.io/qt-5/qrunnable.html#run

        **[pure virtual] void QRunnable::run()**

        Implement this pure virtual function in your subclass.
        """
        ...
