"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QResource(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qresource.html

    **Detailed Description**

    QResource is an object that represents a set of data (and possibly children)
    relating to a single resource entity. QResource gives direct access to the
    bytes in their raw format. In this way direct access allows reading data
    without buffer copying or indirection. Indirection is often useful when
    interacting with the resource entity as if it is a file, this can be
    achieved with **QFile** . The data and children behind a QResource are
    normally compiled into an application/library, but it is also possible to
    load a resource at runtime. When loaded at run time the resource file will
    be loaded as one big set of data and then given out in pieces via references
    into the resource tree.

    A QResource can either be loaded with an absolute path, either treated as a
    file system rooted with a `/` character, or in resource notation rooted with
    a `:` character. A relative resource can also be opened which will be found
    in the list of paths returned by **QDir::searchPaths** ().

    A QResource that is representing a file will have data backing it, this data
    can possibly be compressed, in which case **qUncompress** () must be used to
    access the real data; this happens implicitly when accessed through a
    **QFile** . A QResource that is representing a directory will have only
    children and no data.

    **Dynamic Resource Loading**

    A resource can be left out of an application's binary and loaded when it is
    needed at run-time by using the **registerResource** () function. The
    resource file passed into **registerResource** () must be a binary resource
    as created by rcc. Further information about binary resources can be found
    in **The Qt Resource System**  documentation.

    This can often be useful when loading a large set of application icons that
    may change based on a setting, or that can be edited by a user and later
    recreated. The resource is immediately loaded into memory, either as a
    result of a single file read operation, or as a memory mapped file.

    This approach can prove to be a significant performance gain as only a
    single file will be loaded, and pieces of data will be given out via the
    path requested in **setFileName** ().

    The **unregisterResource** () function removes a reference to a particular
    file. If there are QResource objects that currently reference resources
    related to the unregistered file, they will continue to be valid but the
    resource file itself will be removed from the resource roots, and thus no
    further QResource can be created pointing into this resource data. The
    resource itself will be unmapped from memory when the last QResource that
    points to it is destroyed.

    **See also** **The Qt Resource System** , **QFile** , **QDir** , and
    **QFileInfo** .
    """

    class Compression(int):
        NoCompression: QResource = ...
        ZlibCompression: QResource = ...
        ZstdCompression: QResource = ...

    def __init__(self, fileName: str = ..., locale: QLocale = ...) -> None:
        """
        https://doc.qt.io/qt-5/qresource.html#QResource

        **QResource::QResource(const QString & file = QString(), const QLocale &
        locale = QLocale())**

        Constructs a QResource pointing to **file**. **locale** is used to load
        a specific localization of a resource data.

        **See also** **QFileInfo** , **QDir::searchPaths** (), **setFileName**
        (), and **setLocale** ().
        """
        ...

    def uncompressedData(self) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qresource.html#uncompressedData

        **QByteArray QResource::uncompressedData() const**

        Returns the resource data, decompressing it first, if the data was
        stored compressed. If the resource is a directory or an error occurs
        while decompressing, a null **QByteArray**  is returned.

        **Note:** If the data was compressed, this function will decompress
        every time it is called. The result is not cached between calls.

        This function was introduced in Qt 5.15.

        **See also** **uncompressedSize** (), **size** (), **isCompressed** (),
        and **isFile** ().
        """
        ...

    def uncompressedSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qresource.html#uncompressedSize

        **qint64 QResource::uncompressedSize() const**

        Returns the size of the data in this resource. If the data was not
        compressed, this function returns the same as **size** (). If it was,
        then this function extracts the size of the original uncompressed data
        from the stored stream.

        This function was introduced in Qt 5.15.

        **See also** **size** (), **uncompressedData** (), and **isFile** ().
        """
        ...

    def compressionAlgorithm(self) -> "QResource.Compression":
        """
        https://doc.qt.io/qt-5/qresource.html#compressionAlgorithm

        **QResource::Compression QResource::compressionAlgorithm() const**

        Returns the compression type that this resource is compressed with, if
        any. If it is not compressed, this function returns
        **QResource::NoCompression** .

        If this function returns **QResource::ZlibCompression** , you may
        decompress the data using the **qUncompress** () function. Up until Qt
        5.13, this was the only possible compression algorithm.

        If this function returns **QResource::ZstdCompression** , you need to
        use the Zstandard library functios (`<zstd.h> header). Qt does not
        provide a wrapper. See
        \\l{http://facebook.github.io/zstd/zstd_manual.html}{Zstandard manual}.
        \\sa data(), isFile()`

        This function was introduced in Qt 5.13.
        """
        ...

    def lastModified(self) -> QDateTime:
        """
        https://doc.qt.io/qt-5/qresource.html#lastModified

        **QDateTime QResource::lastModified() const**

        Returns the date and time when the file was last modified before
        packaging into a resource.

        This function was introduced in Qt 5.8.
        """
        ...

    def isFile(self) -> bool:
        """
        https://doc.qt.io/qt-5/qresource.html#isFile

        **[protected] bool QResource::isFile() const**

        Returns `true` if the resource represents a file and thus has data
        backing it, false if it represents a directory.

        **See also** **isDir** ().
        """
        ...

    def isDir(self) -> bool:
        """
        https://doc.qt.io/qt-5/qresource.html#isDir

        **[protected] bool QResource::isDir() const**

        Returns `true` if the resource represents a directory and thus may have
        **children** () in it, false if it represents a file.

        **See also** **isFile** ().
        """
        ...

    def children(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qresource.html#children

        **[protected] QStringList QResource::children() const**

        Returns a list of all resources in this directory, if the resource
        represents a file the list will be empty.

        **See also** **isDir** ().
        """
        ...

    @staticmethod
    def unregisterResourceData(rccData: bytes, mapRoot: str = ...) -> bool:
        ...

    @staticmethod
    def unregisterResource(rccFileName: str, mapRoot: str = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qresource.html#unregisterResource

        **[static] bool QResource::unregisterResource(const QString &
        rccFileName , const QString & mapRoot = QString())**

        Unregisters the resource with the given **rccFileName** at the location
        in the resource tree specified by **mapRoot** , and returns `true` if
        the resource is successfully unloaded and no references exist for the
        resource; otherwise returns `false`.

        **See also** **registerResource** ().
        """
        ...

    @staticmethod
    def registerResourceData(rccData: bytes, mapRoot: str = ...) -> bool:
        ...

    @staticmethod
    def registerResource(rccFileName: str, mapRoot: str = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qresource.html#registerResource

        **[static] bool QResource::registerResource(const QString & rccFileName
        , const QString & mapRoot = QString())**

        Registers the resource with the given **rccFileName** at the location in
        the resource tree specified by **mapRoot** , and returns `true` if the
        file is successfully opened; otherwise returns `false`.

        **See also** **unregisterResource** ().
        """
        ...

    def size(self) -> int:
        """
        https://doc.qt.io/qt-5/qresource.html#size

        **qint64 QResource::size() const**

        Returns the size of the stored data backing the resource.

        If the resource is compressed, this function returns the size of the
        compressed data. See **uncompressedSize** () for the uncompressed size.

        **See also** **data** (), **uncompressedSize** (), and **isFile** ().
        """
        ...

    def setLocale(self, locale: QLocale) -> None:
        """
        https://doc.qt.io/qt-5/qresource.html#setLocale

        **void QResource::setLocale(const QLocale & locale )**

        Sets a **QResource**  to only load the localization of resource to for
        **locale**. If a resource for the specific locale is not found then the
        C locale is used.

        **See also** **locale** () and **setFileName** ().
        """
        ...

    def setFileName(self, file: str) -> None:
        """
        https://doc.qt.io/qt-5/qresource.html#setFileName

        **void QResource::setFileName(const QString & file )**

        Sets a **QResource**  to point to **file**. **file** can either be
        absolute, in which case it is opened directly, if relative then the file
        will be tried to be found in **QDir::searchPaths** ().

        **See also** **fileName** () and **absoluteFilePath** ().
        """
        ...

    def locale(self) -> QLocale:
        """
        https://doc.qt.io/qt-5/qresource.html#locale

        **QLocale QResource::locale() const**

        Returns the locale used to locate the data for the **QResource** .

        **See also** **setLocale** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qresource.html#isValid

        **bool QResource::isValid() const**

        Returns `true` if the resource really exists in the resource hierarchy,
        false otherwise.
        """
        ...

    def isCompressed(self) -> bool:
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-5/qresource.html#fileName

        **QString QResource::fileName() const**

        Returns the full path to the file that this **QResource**  represents as
        it was passed.

        **See also** **setFileName** () and **absoluteFilePath** ().
        """
        ...

    def data(self) -> bytes:
        """
        https://doc.qt.io/qt-5/qresource.html#data

        **const uchar *QResource::data() const**

        Returns direct access to a segment of read-only data, that this resource
        represents. If the resource is compressed, the data returned is also
        compressed. The caller must then decompress the data or use
        **uncompressedData** (). If the resource is a directory, `nullptr` is
        returned.

        **See also** **uncompressedData** (), **size** (), and **isFile** ().
        """
        ...

    def absoluteFilePath(self) -> str:
        """
        https://doc.qt.io/qt-5/qresource.html#absoluteFilePath

        **QString QResource::absoluteFilePath() const**

        Returns the real path that this **QResource**  represents, if the
        resource was found via the **QDir::searchPaths** () it will be indicated
        in the path.

        **See also** **fileName** ().
        """
        ...
