"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QModelIndex(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmodelindex.html

    **Detailed Description**

    This class is used as an index into item models derived from
    **QAbstractItemModel** . The index is used by item views, delegates, and
    selection models to locate an item in the model.

    New QModelIndex objects are created by the model using the
    **QAbstractItemModel::createIndex** () function. An **invalid** model index
    can be constructed with the QModelIndex constructor. Invalid indexes are
    often used as parent indexes when referring to top-level items in a model.

    Model indexes refer to items in models, and contain all the information
    required to specify their locations in those models. Each index is located
    in a given row and column, and may have a parent index; use **row** (),
    **column** (), and **parent** () to obtain this information. Each top-level
    item in a model is represented by a model index that does not have a parent
    index - in this case, **parent** () will return an invalid model index,
    equivalent to an index constructed with the zero argument form of the
    QModelIndex() constructor.

    To obtain a model index that refers to an existing item in a model, call
    **QAbstractItemModel::index** () with the required row and column values,
    and the model index of the parent. When referring to top-level items in a
    model, supply QModelIndex() as the parent index.

    The **model** () function returns the model that the index references as a
    **QAbstractItemModel** . The child() function is used to examine items held
    under the index in the model. The **sibling** () function allows you to
    traverse items in the model on the same level as the index.

    **Note:** Model indexes should be used immediately and then discarded. You
    should not rely on indexes to remain valid after calling model functions
    that change the structure of the model or delete items. If you need to keep
    a model index over time use a **QPersistentModelIndex** .

    **See also** **Model/View Programming** , **QPersistentModelIndex** , and
    **QAbstractItemModel** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qmodelindex.html#QModelIndex

        **QModelIndex::QModelIndex()**

        Creates a new empty model index. This type of model index is used to
        indicate that the position in the model is invalid.

        **See also** **isValid** () and **QAbstractItemModel** .
        """
        ...

    @typing.overload
    def __init__(self, a0: "QModelIndex") -> None:
        """
        https://doc.qt.io/qt-5/qmodelindex.html#QModelIndex

        **QModelIndex::QModelIndex()**

        Creates a new empty model index. This type of model index is used to
        indicate that the position in the model is invalid.

        **See also** **isValid** () and **QAbstractItemModel** .
        """
        ...

    @typing.overload
    def __init__(self, a0: "QPersistentModelIndex") -> None:
        """
        https://doc.qt.io/qt-5/qmodelindex.html#QModelIndex

        **QModelIndex::QModelIndex()**

        Creates a new empty model index. This type of model index is used to
        indicate that the position in the model is invalid.

        **See also** **isValid** () and **QAbstractItemModel** .
        """
        ...

    def __hash__(self) -> int:
        ...

    def siblingAtRow(self, row: int) -> "QModelIndex":
        """
        https://doc.qt.io/qt-5/qmodelindex.html#siblingAtRow

        **QModelIndex QModelIndex::siblingAtRow(int row ) const**

        Returns the sibling at **row** for the current column. If there is no
        sibling at this position, an invalid **QModelIndex**  is returned.

        This function was introduced in Qt 5.11.

        **See also** **sibling** () and **siblingAtColumn** ().
        """
        ...

    def siblingAtColumn(self, column: int) -> "QModelIndex":
        """
        https://doc.qt.io/qt-5/qmodelindex.html#siblingAtColumn

        **QModelIndex QModelIndex::siblingAtColumn(int column ) const**

        Returns the sibling at **column** for the current row. If there is no
        sibling at this position, an invalid **QModelIndex**  is returned.

        This function was introduced in Qt 5.11.

        **See also** **sibling** () and **siblingAtRow** ().
        """
        ...

    def sibling(self, arow: int, acolumn: int) -> "QModelIndex":
        """
        https://doc.qt.io/qt-5/qmodelindex.html#sibling

        **QModelIndex QModelIndex::sibling(int row , int column ) const**

        Returns the sibling at **row** and **column**. If there is no sibling at
        this position, an invalid **QModelIndex**  is returned.

        **See also** **parent** (), **siblingAtColumn** (), and **siblingAtRow**
        ().
        """
        ...

    def parent(self) -> "QModelIndex":
        """
        https://doc.qt.io/qt-5/qmodelindex.html#parent

        **QModelIndex QModelIndex::parent() const**

        Returns the parent of the model index, or **QModelIndex** () if it has
        no parent.

        **See also** **sibling** () and **model** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmodelindex.html#isValid

        **bool QModelIndex::isValid() const**

        Returns `true` if this model index is valid; otherwise returns `false`.

        A valid index belongs to a model, and has non-negative row and column
        numbers.

        **See also** **model** (), **row** (), and **column** ().
        """
        ...

    def model(self) -> "QAbstractItemModel":
        """
        https://doc.qt.io/qt-5/qmodelindex.html#model

        **const QAbstractItemModel *QModelIndex::model() const**

        Returns a pointer to the model containing the item that this index
        refers to.

        A const pointer to the model is returned because calls to non-const
        functions of the model might invalidate the model index and possibly
        crash your application.
        """
        ...

    def internalId(self) -> int:
        """
        https://doc.qt.io/qt-5/qmodelindex.html#internalId

        **quintptr QModelIndex::internalId() const**

        Returns a `quintptr` used by the model to associate the index with the
        internal data structure.

        **See also** **QAbstractItemModel::createIndex** ().
        """
        ...

    def internalPointer(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmodelindex.html#internalPointer

        **void *QModelIndex::internalPointer() const**

        Returns a `void` `*` pointer used by the model to associate the index
        with the internal data structure.

        **See also** **QAbstractItemModel::createIndex** ().
        """
        ...

    def flags(self) -> Qt.ItemFlags:
        """
        https://doc.qt.io/qt-5/qmodelindex.html#flags

        **Qt::ItemFlags QModelIndex::flags() const**

        Returns the flags for the item referred to by the index.

        This function was introduced in Qt 4.2.
        """
        ...

    def data(self, role: int = ...) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmodelindex.html#data

        **QVariant QModelIndex::data(int role = Qt::DisplayRole) const**

        Returns the data for the given **role** for the item referred to by the
        index.
        """
        ...

    def column(self) -> int:
        """
        https://doc.qt.io/qt-5/qmodelindex.html#column

        **int QModelIndex::column() const**

        Returns the column this model index refers to.
        """
        ...

    def row(self) -> int:
        """
        https://doc.qt.io/qt-5/qmodelindex.html#row

        **int QModelIndex::row() const**

        Returns the row this model index refers to.
        """
        ...

    def child(self, arow: int, acolumn: int) -> "QModelIndex":
        ...
