"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QMetaMethod(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmetamethod.html

    **Detailed Description**

    A QMetaMethod has a **methodType** (), a **methodSignature** (), a list of
    **parameterTypes** () and **parameterNames** (), a return **typeName** (), a
    **tag** (), and an **access** () specifier. You can use **invoke** () to
    invoke the method on an arbitrary **QObject** .

    **See also** **QMetaObject** , **QMetaEnum** , **QMetaProperty** , and
    **Qt's Property System** .
    """

    class MethodType(int):
        Method: QMetaMethod = ...
        Signal: QMetaMethod = ...
        Slot: QMetaMethod = ...
        Constructor: QMetaMethod = ...

    class Access(int):
        Private: QMetaMethod = ...
        Protected: QMetaMethod = ...
        Public: QMetaMethod = ...

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QMetaMethod") -> None:
        ...

    def parameterType(self, index: int) -> int:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#parameterType

        **int QMetaMethod::parameterType(int index ) const**

        Returns the type of the parameter at the given **index**.

        The return value is one of the types that are registered with
        **QMetaType** , or **QMetaType::UnknownType**  if the type is not
        registered.

        This function was introduced in Qt 5.0.

        **See also** **parameterCount** (), **returnType** (), and **QMetaType**
        .
        """
        ...

    def parameterCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#parameterCount

        **int QMetaMethod::parameterCount() const**

        Returns the number of parameters of this method.

        This function was introduced in Qt 5.0.

        **See also** **parameterType** () and **parameterNames** ().
        """
        ...

    def returnType(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#returnType

        **int QMetaMethod::returnType() const**

        Returns the return type of this method.

        The return value is one of the types that are registered with
        **QMetaType** , or **QMetaType::UnknownType**  if the type is not
        registered.

        This function was introduced in Qt 5.0.

        **See also** **parameterType** (), **QMetaType** , and **typeName** ().
        """
        ...

    def name(self) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#name

        **QByteArray QMetaMethod::name() const**

        Returns the name of this method.

        This function was introduced in Qt 5.0.

        **See also** **methodSignature** () and **parameterCount** ().
        """
        ...

    def methodSignature(self) -> QByteArray:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#methodSignature

        **QByteArray QMetaMethod::methodSignature() const**

        Returns the signature of this method (e.g., `setValue(double)`).

        This function was introduced in Qt 5.0.

        **See also** **parameterTypes** () and **parameterNames** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#isValid

        **bool QMetaMethod::isValid() const**

        Returns `true` if this method is valid (can be introspected and
        invoked), otherwise returns `false`.

        This function was introduced in Qt 5.0.
        """
        ...

    def methodIndex(self) -> int:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#methodIndex

        **int QMetaMethod::methodIndex() const**

        Returns this method's index.

        This function was introduced in Qt 4.6.
        """
        ...

    @typing.overload
    def invoke(
        self,
        object: QObject,
        connectionType: Qt.ConnectionType,
        returnValue: "QGenericReturnArgument",
        value0: "QGenericArgument" = ...,
        value1: "QGenericArgument" = ...,
        value2: "QGenericArgument" = ...,
        value3: "QGenericArgument" = ...,
        value4: "QGenericArgument" = ...,
        value5: "QGenericArgument" = ...,
        value6: "QGenericArgument" = ...,
        value7: "QGenericArgument" = ...,
        value8: "QGenericArgument" = ...,
        value9: "QGenericArgument" = ...,
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#invoke

        **bool QMetaMethod::invoke(QObject * object , Qt::ConnectionType
        connectionType , QGenericReturnArgument returnValue , QGenericArgument
        val0 = QGenericArgument(nullptr), QGenericArgument val1 =
        QGenericArgument(), QGenericArgument val2 = QGenericArgument(),
        QGenericArgument val3 = QGenericArgument(), QGenericArgument val4 =
        QGenericArgument(), QGenericArgument val5 = QGenericArgument(),
        QGenericArgument val6 = QGenericArgument(), QGenericArgument val7 =
        QGenericArgument(), QGenericArgument val8 = QGenericArgument(),
        QGenericArgument val9 = QGenericArgument()) const**

        Invokes this method on the object **object**. Returns `true` if the
        member could be invoked. Returns `false` if there is no such member or
        the parameters did not match.

        The invocation can be either synchronous or asynchronous, depending on
        the **connectionType** :

        * If **connectionType** is **Qt::DirectConnection** , the member will be
        invoked immediately.
          * If **connectionType** is
        **Qt::QueuedConnection** , a **QEvent**  will be posted and the member
        is invoked as soon as the application enters the main event loop.
          * If
        **connectionType** is **Qt::AutoConnection** , the member is invoked
        synchronously if **object** lives in the same thread as the caller;
        otherwise it will invoke the member asynchronously.

        The return value of this method call is placed in **returnValue**. If
        the invocation is asynchronous, the return value cannot be evaluated.
        You can pass up to ten arguments ( **val0** , **val1** , **val2** ,
        **val3** , **val4** , **val5** , **val6** , **val7** , **val8** , and
        **val9** ) to this method call.

        **QGenericArgument**  and **QGenericReturnArgument**  are internal
        helper classes. Because signals and slots can be dynamically invoked,
        you must enclose the arguments using the **Q_ARG** () and
        **Q_RETURN_ARG** () macros. **Q_ARG** () takes a type name and a const
        reference of that type; **Q_RETURN_ARG** () takes a type name and a non-
        const reference.

        To asynchronously invoke the **animateClick()**  slot on a
        **QPushButton** :

        int methodIndex =
        pushButton->metaObject()->indexOfMethod("animateClick()");
        QMetaMethod method = metaObject->method(methodIndex);
        method.invoke(pushButton, Qt::QueuedConnection);

        With asynchronous method invocations, the parameters must be of types
        that are known to Qt's meta-object system, because Qt needs to copy the
        arguments to store them in an event behind the scenes. If you try to use
        a queued connection and get the error message

        QMetaMethod::invoke: Unable to handle unregistered datatype 'MyType'

        call **qRegisterMetaType** () to register the data type before you call
        QMetaMethod::invoke().

        To synchronously invoke the `compute(QString, int, double)` slot on some
        arbitrary object `obj` retrieve its return value:

        **QString**  retVal;
            **QByteArray**  normalizedSignature =
        **QMetaObject** ::normalizedSignature("compute(QString, int, double)");
        int methodIndex = obj->metaObject()->indexOfMethod(normalizedSignature);
        QMetaMethod method = obj->metaObject()->method(methodIndex);
        method.invoke(obj,
                          Qt::DirectConnection,
        Q_RETURN_ARG(**QString** , retVal),
                          Q_ARG(**QString**
        , "sqrt"),
                          Q_ARG(int, 42),
        Q_ARG(double, 9.7));

        **QMetaObject::normalizedSignature** () is used here to ensure that the
        format of the signature is what invoke() expects. E.g. extra whitespace
        is removed.

        If the "compute" slot does not take exactly one **QString** , one int
        and one double in the specified order, the call will fail.

        **Warning:** this method will not test the validity of the arguments:
        **object** must be an instance of the class of the **QMetaObject**  of
        which this **QMetaMethod**  has been constructed with. The arguments
        must have the same type as the ones expected by the method, else, the
        behaviour is undefined.

        **See also** **Q_ARG** (), **Q_RETURN_ARG** (), **qRegisterMetaType**
        (), and **QMetaObject::invokeMethod** ().
        """
        ...

    @typing.overload
    def invoke(
        self,
        object: QObject,
        returnValue: "QGenericReturnArgument",
        value0: "QGenericArgument" = ...,
        value1: "QGenericArgument" = ...,
        value2: "QGenericArgument" = ...,
        value3: "QGenericArgument" = ...,
        value4: "QGenericArgument" = ...,
        value5: "QGenericArgument" = ...,
        value6: "QGenericArgument" = ...,
        value7: "QGenericArgument" = ...,
        value8: "QGenericArgument" = ...,
        value9: "QGenericArgument" = ...,
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#invoke-1

        **bool QMetaMethod::invoke(QObject * object , QGenericReturnArgument
        returnValue , QGenericArgument val0 = QGenericArgument(0),
        QGenericArgument val1 = QGenericArgument(), QGenericArgument val2 =
        QGenericArgument(), QGenericArgument val3 = QGenericArgument(),
        QGenericArgument val4 = QGenericArgument(), QGenericArgument val5 =
        QGenericArgument(), QGenericArgument val6 = QGenericArgument(),
        QGenericArgument val7 = QGenericArgument(), QGenericArgument val8 =
        QGenericArgument(), QGenericArgument val9 = QGenericArgument()) const**

        This function overloads invoke().

        This overload always invokes this method using the connection type
        **Qt::AutoConnection** .
        """
        ...

    @typing.overload
    def invoke(
        self,
        object: QObject,
        connectionType: Qt.ConnectionType,
        value0: "QGenericArgument" = ...,
        value1: "QGenericArgument" = ...,
        value2: "QGenericArgument" = ...,
        value3: "QGenericArgument" = ...,
        value4: "QGenericArgument" = ...,
        value5: "QGenericArgument" = ...,
        value6: "QGenericArgument" = ...,
        value7: "QGenericArgument" = ...,
        value8: "QGenericArgument" = ...,
        value9: "QGenericArgument" = ...,
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#invoke-2

        **bool QMetaMethod::invoke(QObject * object , Qt::ConnectionType
        connectionType , QGenericArgument val0 = QGenericArgument(0),
        QGenericArgument val1 = QGenericArgument(), QGenericArgument val2 =
        QGenericArgument(), QGenericArgument val3 = QGenericArgument(),
        QGenericArgument val4 = QGenericArgument(), QGenericArgument val5 =
        QGenericArgument(), QGenericArgument val6 = QGenericArgument(),
        QGenericArgument val7 = QGenericArgument(), QGenericArgument val8 =
        QGenericArgument(), QGenericArgument val9 = QGenericArgument()) const**

        This function overloads invoke().

        This overload can be used if the return value of the member is of no
        interest.
        """
        ...

    @typing.overload
    def invoke(
        self,
        object: QObject,
        value0: "QGenericArgument" = ...,
        value1: "QGenericArgument" = ...,
        value2: "QGenericArgument" = ...,
        value3: "QGenericArgument" = ...,
        value4: "QGenericArgument" = ...,
        value5: "QGenericArgument" = ...,
        value6: "QGenericArgument" = ...,
        value7: "QGenericArgument" = ...,
        value8: "QGenericArgument" = ...,
        value9: "QGenericArgument" = ...,
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#invoke-3

        **bool QMetaMethod::invoke(QObject * object , QGenericArgument val0 =
        QGenericArgument(0), QGenericArgument val1 = QGenericArgument(),
        QGenericArgument val2 = QGenericArgument(), QGenericArgument val3 =
        QGenericArgument(), QGenericArgument val4 = QGenericArgument(),
        QGenericArgument val5 = QGenericArgument(), QGenericArgument val6 =
        QGenericArgument(), QGenericArgument val7 = QGenericArgument(),
        QGenericArgument val8 = QGenericArgument(), QGenericArgument val9 =
        QGenericArgument()) const**

        This function overloads invoke().

        This overload invokes this method using the connection type
        **Qt::AutoConnection**  and ignores return values.
        """
        ...

    def methodType(self) -> "QMetaMethod.MethodType":
        """
        https://doc.qt.io/qt-5/qmetamethod.html#methodType

        **QMetaMethod::MethodType QMetaMethod::methodType() const**

        Returns the type of this method (signal, slot, or method).

        **See also** **access** ().
        """
        ...

    def access(self) -> "QMetaMethod.Access":
        """
        https://doc.qt.io/qt-5/qmetamethod.html#access

        **QMetaMethod::Access QMetaMethod::access() const**

        Returns the access specification of this method (private, protected, or
        public).

        **Note:** Signals are always public, but you should regard that as an
        implementation detail. It is almost always a bad idea to emit a signal
        from outside its class.

        **See also** **methodType** ().
        """
        ...

    def tag(self) -> str:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#tag

        **const char *QMetaMethod::tag() const**

        Returns the tag associated with this method.

        Tags are special macros recognized by `moc` that make it possible to add
        extra information about a method.

        Tag information can be added in the following way in the function
        declaration:

        // In the class MainWindow declaration
                #ifndef Q_MOC_RUN
        // define the tag text as empty, so the compiler doesn't see it
        #  define MY_CUSTOM_TAG
                #endif
                ...
                private
        slots:
                    MY_CUSTOM_TAG void testFunc();

        and the information can be accessed by using:

        MainWindow win;
                win.show();

                int functionIndex =
        win.metaObject()->indexOfSlot("testFunc()");
                QMetaMethod mm =
        win.metaObject()->method(functionIndex);
                **qDebug** () <<
        mm.tag(); // prints MY_CUSTOM_TAG

        For the moment, `moc` will extract and record all tags, but it will not
        handle any of them specially. You can use the tags to annotate your
        methods differently, and treat them according to the specific needs of
        your application.

        **Note:** Since Qt 5.0, `moc` expands preprocessor macros, so it is
        necessary to surround the definition with `#ifndef` `Q_MOC_RUN`, as
        shown in the example above. This was not required in Qt 4. The code as
        shown above works with Qt 4 too.
        """
        ...

    def parameterNames(self) -> typing.List[QByteArray]:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#parameterNames

        **QList<QByteArray> QMetaMethod::parameterNames() const**

        Returns a list of parameter names.

        **See also** **parameterTypes** () and **methodSignature** ().
        """
        ...

    def parameterTypes(self) -> typing.List[QByteArray]:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#parameterTypes

        **QList<QByteArray> QMetaMethod::parameterTypes() const**

        Returns a list of parameter types.

        **See also** **parameterNames** () and **methodSignature** ().
        """
        ...

    def typeName(self) -> str:
        """
        https://doc.qt.io/qt-5/qmetamethod.html#typeName

        **const char *QMetaMethod::typeName() const**

        Returns the return type name of this method.

        **See also** **returnType** () and **QMetaType::type** ().
        """
        ...
