"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5 import sip


class QMessageLogger(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qmessagelogger.html

    **Detailed Description**

    QMessageLogger is used to generate messages for the Qt logging framework.
    Usually one uses it through **qDebug** (), **qInfo** (), **qWarning** (),
    **qCritical** , or **qFatal** () functions, which are actually macros: For
    example **qDebug** () expands to QMessageLogger(__FILE__, __LINE__,
    **Q_FUNC_INFO** ).**debug** () for debug builds, and QMessageLogger(0, 0,
    0).**debug** () for release builds.

    One example of direct use is to forward errors that stem from a scripting
    language, e.g. QML:

    void statusChanged(QDeclarativeComponent::Status status) {
                if
    (status == QDeclarativeComponent::Error) {
                    foreach (const
    QDeclarativeError &error, component->errors()) {
                        const
    **QByteArray**  file = error.url().toEncoded();
    QMessageLogger(file.constData(), error.line(), 0).debug() <<
    error.description();
                    }
                }
            }

    **See also** **QMessageLogContext** , **qDebug** (), **qInfo** (),
    **qWarning** (), **qCritical** (), and **qFatal** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qmessagelogger.html#QMessageLogger-1

        **QMessageLogger::QMessageLogger()**

        Constructs a default QMessageLogger. See the other constructors to
        specify context information.
        """
        ...

    @typing.overload
    def __init__(self, file: str, line: int, function: str) -> None:
        """
        https://doc.qt.io/qt-5/qmessagelogger.html#QMessageLogger-2

        **QMessageLogger::QMessageLogger(const char * file , int line , const
        char * function )**

        Constructs a QMessageLogger to record log messages for **file** at
        **line** in **function**. The is equivalent to QMessageLogger(file,
        line, function, "default")
        """
        ...

    @typing.overload
    def __init__(self, file: str, line: int, function: str, category: str) -> None:
        """
        https://doc.qt.io/qt-5/qmessagelogger.html#QMessageLogger-3

        **QMessageLogger::QMessageLogger(const char * file , int line , const
        char * function , const char * category )**

        Constructs a QMessageLogger to record **category** messages for **file**
        at **line** in **function**.
        """
        ...

    def info(self, msg: str) -> None:
        """
        https://doc.qt.io/qt-5/qmessagelogger.html#info

        **void QMessageLogger::info(const char * msg , ... ) const**

        Logs an informational message specified with format **msg**. Additional
        parameters, specified by **msg** , may be used.

        This function was introduced in Qt 5.5.

        **See also** **qInfo** ().
        """
        ...

    def fatal(self, msg: str) -> None:
        """
        https://doc.qt.io/qt-5/qmessagelogger.html#fatal

        **void QMessageLogger::fatal(const char * msg , ... ) const**

        Logs a fatal message specified with format **msg**. Additional
        parameters, specified by **msg** , may be used.

        **See also** **qFatal** ().
        """
        ...

    def critical(self, msg: str) -> None:
        """
        https://doc.qt.io/qt-5/qmessagelogger.html#critical

        **void QMessageLogger::critical(const char * msg , ... ) const**

        Logs a critical message specified with format **msg**. Additional
        parameters, specified by **msg** , may be used.

        **See also** **qCritical** ().
        """
        ...

    def warning(self, msg: str) -> None:
        """
        https://doc.qt.io/qt-5/qmessagelogger.html#warning

        **void QMessageLogger::warning(const char * msg , ... ) const**

        Logs a warning message specified with format **msg**. Additional
        parameters, specified by **msg** , may be used.

        **See also** **qWarning** ().
        """
        ...

    def debug(self, msg: str) -> None:
        """
        https://doc.qt.io/qt-5/qmessagelogger.html#debug

        **void QMessageLogger::debug(const char * msg , ... ) const**

        Logs a debug message specified with format **msg**. Additional
        parameters, specified by **msg** , may be used.

        **See also** **qDebug** ().
        """
        ...
