"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

License: MIT
"""
import typing
from PyQt5.QtCore import *
from PyQt5 import sip


class QItemSelectionRange(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qitemselectionrange.html

    **Detailed Description**

    A QItemSelectionRange contains information about a range of selected items
    in a model. A range of items is a contiguous array of model items, extending
    to cover a number of adjacent rows and columns with a common parent item;
    this can be visualized as a two-dimensional block of cells in a table. A
    selection range has a **top** (), **left** () a **bottom** (), **right** ()
    and a **parent** ().

    The QItemSelectionRange class is one of the **Model/View Classes**  and is
    part of Qt's **model/view framework** .

    The model items contained in the selection range can be obtained using the
    **indexes** () function. Use **QItemSelectionModel::selectedIndexes** () to
    get a list of all selected items for a view.

    You can determine whether a given model item lies within a particular range
    by using the **contains** () function. Ranges can also be compared using the
    overloaded operators for equality and inequality, and the **intersects** ()
    function allows you to determine whether two ranges overlap.

    **See also** **Model/View Programming** , **QAbstractItemModel** ,
    **QItemSelection** , and **QItemSelectionModel** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#QItemSelectionRange

        **QItemSelectionRange::QItemSelectionRange()**

        Constructs an empty selection range.
        """
        ...

    @typing.overload
    def __init__(self, other: "QItemSelectionRange") -> None:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#QItemSelectionRange-1

        **QItemSelectionRange::QItemSelectionRange(const QItemSelectionRange &
        other )**

        Copy constructor. Constructs a new selection range with the same
        contents as the **other** range given.
        """
        ...

    @typing.overload
    def __init__(self, atopLeft: QModelIndex, abottomRight: QModelIndex) -> None:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#QItemSelectionRange-3

        **QItemSelectionRange::QItemSelectionRange(const QModelIndex & topLeft ,
        const QModelIndex & bottomRight )**

        Constructs a new selection range containing only the index specified by
        the **topLeft** and the index **bottomRight**.
        """
        ...

    @typing.overload
    def __init__(self, index: QModelIndex) -> None:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#QItemSelectionRange-4

        **QItemSelectionRange::QItemSelectionRange(const QModelIndex & index )**

        Constructs a new selection range containing only the model item
        specified by the model index **index**.
        """
        ...

    def swap(self, other: "QItemSelectionRange") -> None:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#swap

        **void QItemSelectionRange::swap(QItemSelectionRange & other )**

        Swaps this selection range's contents with **other**. This function is
        very fast and never fails.

        This function was introduced in Qt 5.6.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#isEmpty

        **bool QItemSelectionRange::isEmpty() const**

        Returns `true` if the selection range contains no selectable item

        This function was introduced in Qt 4.7.
        """
        ...

    def __hash__(self) -> int:
        ...

    def intersected(self, other: "QItemSelectionRange") -> "QItemSelectionRange":
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#intersected

        **QItemSelectionRange QItemSelectionRange::intersected(const
        QItemSelectionRange & other ) const**

        Returns a new selection range containing only the items that are found
        in both the selection range and the **other** selection range.

        This function was introduced in Qt 4.2.
        """
        ...

    def indexes(self) -> typing.List[QModelIndex]:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#indexes

        **QModelIndexList QItemSelectionRange::indexes() const**

        Returns the list of model index items stored in the selection.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#isValid

        **bool QItemSelectionRange::isValid() const**

        Returns `true` if the selection range is valid; otherwise returns
        `false`.
        """
        ...

    def intersects(self, other: "QItemSelectionRange") -> bool:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#intersects

        **bool QItemSelectionRange::intersects(const QItemSelectionRange & other
        ) const**

        Returns `true` if this selection range intersects (overlaps with) the
        **other** range given; otherwise returns `false`.
        """
        ...

    @typing.overload
    def contains(self, index: QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#contains

        **bool QItemSelectionRange::contains(const QModelIndex & index ) const**

        Returns `true` if the model item specified by the **index** lies within
        the range of selected items; otherwise returns `false`.
        """
        ...

    @typing.overload
    def contains(self, row: int, column: int, parentIndex: QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#contains-1

        **bool QItemSelectionRange::contains(int row , int column , const
        QModelIndex & parentIndex ) const**

        This is an overloaded function.

        Returns `true` if the model item specified by ( **row** , **column** )
        and with **parentIndex** as the parent item lies within the range of
        selected items; otherwise returns `false`.
        """
        ...

    def model(self) -> QAbstractItemModel:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#model

        **const QAbstractItemModel *QItemSelectionRange::model() const**

        Returns the model that the items in the selection range belong to.
        """
        ...

    def parent(self) -> QModelIndex:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#parent

        **QModelIndex QItemSelectionRange::parent() const**

        Returns the parent model item index of the items in the selection range.
        """
        ...

    def bottomRight(self) -> QPersistentModelIndex:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#bottomRight

        **const QPersistentModelIndex &QItemSelectionRange::bottomRight()
        const**

        Returns the index for the item located at the bottom-right corner of the
        selection range.

        **See also** **bottom** (), **right** (), and **topLeft** ().
        """
        ...

    def topLeft(self) -> QPersistentModelIndex:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#topLeft

        **const QPersistentModelIndex &QItemSelectionRange::topLeft() const**

        Returns the index for the item located at the top-left corner of the
        selection range.

        **See also** **top** (), **left** (), and **bottomRight** ().
        """
        ...

    def height(self) -> int:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#height

        **int QItemSelectionRange::height() const**

        Returns the number of selected rows in the selection range.
        """
        ...

    def width(self) -> int:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#width

        **int QItemSelectionRange::width() const**

        Returns the number of selected columns in the selection range.
        """
        ...

    def right(self) -> int:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#right

        **int QItemSelectionRange::right() const**

        Returns the column index corresponding to the rightmost selected column
        in the selection range.
        """
        ...

    def bottom(self) -> int:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#bottom

        **int QItemSelectionRange::bottom() const**

        Returns the row index corresponding to the lowermost selected row in the
        selection range.
        """
        ...

    def left(self) -> int:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#left

        **int QItemSelectionRange::left() const**

        Returns the column index corresponding to the leftmost selected column
        in the selection range.
        """
        ...

    def top(self) -> int:
        """
        https://doc.qt.io/qt-5/qitemselectionrange.html#top

        **int QItemSelectionRange::top() const**

        Returns the row index corresponding to the uppermost selected row in the
        selection range.
        """
        ...
